/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.snl;

import com.gluonhq.snl.QuicClientTransport;
import io.privacyresearch.equation.proxystub.SignalRpcMessage;
import io.privacyresearch.equation.proxystub.SignalRpcReply;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QuicSignalLayer {
    private static final Logger LOG = Logger.getLogger(QuicSignalLayer.class.getName());
    private final QuicClientTransport transport;
    private final ExecutorService directExecutorService = Executors.newFixedThreadPool(1);

    public QuicSignalLayer(URI uri) {
        this.transport = new QuicClientTransport(uri);
    }

    public CompletableFuture<SignalRpcReply> sendSignalMessage(SignalRpcMessage msg) {
        Supplier<SignalRpcReply> callable = () -> {
            try {
                LOG.info("Will now execute request with url = " + msg.getUrlfragment());
                byte[] raw = this.transport.sendMessage(msg.toByteArray());
                SignalRpcReply reply = SignalRpcReply.parseFrom(raw);
                LOG.info("Will send reply with statusCode " + reply.getStatuscode());
                return reply;
            }
            catch (IOException ex) {
                Logger.getLogger(QuicClientTransport.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        };
        CompletableFuture<SignalRpcReply> answer = CompletableFuture.supplyAsync(callable, this.directExecutorService);
        return answer;
    }

    public QuicClientTransport.ControlledQuicStream openControlledStream(String baseUrl, Map<String, String> headerMap, Consumer<byte[]> callback) throws IOException {
        return this.transport.openControlledStream(baseUrl, headerMap, callback);
    }

    public void writeMessageToStream(QuicClientTransport.ControlledQuicStream ks, SignalRpcMessage message) throws IOException {
        LOG.info("send sig msg to stream, signalrpcmessage len = " + message.toByteArray().length + ", body len = " + message.getBody().size() + ", headerscount = " + message.getHeaderCount());
        message.getHeaderList().asByteStringList().forEach(hdr -> LOG.finest("-> HEADER = " + String.valueOf(hdr)));
        this.transport.writeMessageToStream(ks, message.toByteArray());
    }

    private void writeMessageToStream(QuicClientTransport.ControlledQuicStream ks, byte[] payload) throws IOException {
        this.transport.writeMessageToStream(ks, payload);
    }
}

