/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.poll;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.poll.PollData;
import io.privacyresearch.clientdata.poll.PollKey;
import io.privacyresearch.clientdata.poll.PollVoteDbRecord;
import io.privacyresearch.clientdata.poll.PollVoteKey;
import io.privacyresearch.clientdata.user.UserData;
import io.privacyresearch.clientdata.user.UserKey;
import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PollVoteData
extends EntityKeyData<PollVoteDbRecord, PollVoteKey> {
    private static final Logger LOG = Logger.getLogger(PollVoteData.class.getName());
    public static final String TABLE_NAME = "poll_vote";
    private final PollData pollData;
    private final UserData userData;

    public PollVoteData(DatabaseLayer databaseLayer, PollData pollData, UserData userData) {
        super(databaseLayer, TABLE_NAME, List.of(Fields.values()), PollVoteKey::new);
        this.pollData = pollData;
        this.userData = userData;
    }

    @Override
    public PollVoteDbRecord construct(ResultSet resultSet) throws SQLException {
        Integer pollId = (Integer)Fields.POLL_ID.getValue(resultSet);
        PollKey pollKey = null;
        if (pollId != null) {
            pollKey = (PollKey)this.pollData.getKeyById(pollId);
        }
        Integer voterId = (Integer)Fields.VOTER_ID.getValue(resultSet);
        UserKey voterKey = null;
        if (voterId != null) {
            voterKey = (UserKey)this.userData.getKeyById(voterId);
        }
        byte[] blobOptions = (byte[])Fields.OPTIONS.getValue(resultSet);
        return new PollVoteDbRecord(new PollVoteKey((byte[])Fields.ENTITY_KEY.getValue(resultSet)), pollKey, voterKey, this.deserializeOptions(blobOptions), (Integer)Fields.VOTE_COUNT.getValue(resultSet));
    }

    public PollVoteDbRecord vote(PollVoteDbRecord record) {
        if (record.key() != null) {
            throw new IllegalArgumentException("Can not add a poll vote that already has a PollVoteKey");
        }
        try {
            Integer voterId = (Integer)this.userData.getIdByKey(record.voterKey());
            Integer pollId = (Integer)this.pollData.getIdByKey(record.pollKey());
            PollVoteKey key = new PollVoteKey();
            HashMap<Field, Object> values = new HashMap<Field, Object>();
            values.put(Fields.ENTITY_KEY, key.getKey());
            values.put(Fields.POLL_ID, pollId);
            values.put(Fields.VOTER_ID, voterId);
            values.put(Fields.OPTIONS, this.serializeOptions(record.selectedOptions()));
            values.put(Fields.VOTE_COUNT, record.voteCount());
            List<Integer> inserted = this.databaseLayer.insert(TABLE_NAME).values(values).execute();
            if (inserted.size() == 1) {
                return (PollVoteDbRecord)this.findByKey(key);
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public List<PollVoteDbRecord> findByPoll(PollKey pollKey) {
        ArrayList<PollVoteDbRecord> arrayList;
        block10: {
            Integer pollId = (Integer)this.pollData.getIdByKey(pollKey);
            if (pollId == null) {
                return new ArrayList<PollVoteDbRecord>();
            }
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.POLL_ID, pollId))).execute();
            try {
                ArrayList<PollVoteDbRecord> records = new ArrayList<PollVoteDbRecord>();
                while (result.next()) {
                    records.add(this.construct(result));
                }
                arrayList = records;
                if (result == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return arrayList;
    }

    private byte[] serializeOptions(List<Integer> selectedOptions) {
        int totalSize = 4 + selectedOptions.size() * 4;
        ByteBuffer buffer = ByteBuffer.allocate(totalSize);
        buffer.putInt(selectedOptions.size());
        for (Integer selectedOption : selectedOptions) {
            buffer.putInt(selectedOption);
        }
        return buffer.array();
    }

    private List<Integer> deserializeOptions(byte[] binaryOptions) {
        ByteBuffer buffer = ByteBuffer.wrap(binaryOptions);
        int count = buffer.getInt();
        ArrayList<Integer> selectedOptions = new ArrayList<Integer>(count);
        for (int i = 0; i < count; ++i) {
            selectedOptions.add(buffer.getInt());
        }
        return selectedOptions;
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        POLL_ID(FieldBuilder.newField("poll_id", FieldType.INT).withNullable(false).withReference("poll", PollData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        VOTER_ID(FieldBuilder.newField("voter_id", FieldType.INT).withReference("users", UserData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        OPTIONS(FieldBuilder.newField("options", FieldType.BLOB)),
        VOTE_COUNT(FieldBuilder.newField("vote_count", FieldType.INT));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return PollVoteData.TABLE_NAME;
        }
    }
}

