/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.poll;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.message.MessageData;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.poll.PollDbRecord;
import io.privacyresearch.clientdata.poll.PollKey;
import io.privacyresearch.clientdata.recipient.RecipientData;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.user.UserData;
import io.privacyresearch.clientdata.user.UserKey;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PollData
extends EntityKeyData<PollDbRecord, PollKey> {
    private static final Logger LOG = Logger.getLogger(PollData.class.getName());
    public static final String TABLE_NAME = "poll";
    private final MessageData messageData;
    private final RecipientData recipientData;
    private final UserData userData;

    public PollData(DatabaseLayer databaseLayer, MessageData messageData, RecipientData recipientData, UserData userData) {
        super(databaseLayer, TABLE_NAME, List.of(Fields.values()), PollKey::new);
        this.messageData = messageData;
        this.recipientData = recipientData;
        this.userData = userData;
    }

    @Override
    public PollDbRecord construct(ResultSet resultSet) throws SQLException {
        Integer creatorId = (Integer)Fields.CREATOR_ID.getValue(resultSet);
        UserKey creatorKey = null;
        if (creatorId != null) {
            creatorKey = (UserKey)this.userData.getKeyById(creatorId);
        }
        Integer targetId = (Integer)Fields.TARGET_ID.getValue(resultSet);
        RecipientKey targetKey = null;
        if (targetId != null) {
            targetKey = (RecipientKey)this.recipientData.getKeyById(targetId);
        }
        Integer messageId = (Integer)Fields.MESSAGE_ID.getValue(resultSet);
        MessageKey messageKey = null;
        if (messageId != null) {
            messageKey = (MessageKey)this.messageData.getKeyById(messageId);
        }
        byte[] blobOptions = (byte[])Fields.OPTIONS.getValue(resultSet);
        return new PollDbRecord(new PollKey((byte[])Fields.ENTITY_KEY.getValue(resultSet)), creatorKey, targetKey, messageKey, (String)Fields.QUESTION.getValue(resultSet), this.deserializeOptions(blobOptions), (Boolean)Fields.ALLOW_MULTIPLE_VOTES.getValue(resultSet), (Long)Fields.TIMESTAMP.getValue(resultSet));
    }

    public PollDbRecord createPoll(PollDbRecord record) {
        if (record.key() != null) {
            throw new IllegalArgumentException("Can not add a poll that already has a PollKey");
        }
        try {
            Integer creatorId = (Integer)this.userData.getIdByKey(record.creatorKey());
            Integer targetId = (Integer)this.recipientData.getIdByKey(record.targetKey());
            Integer messageId = (Integer)this.messageData.getIdByKey(record.messageKey());
            PollKey key = new PollKey();
            HashMap<Field, Object> values = new HashMap<Field, Object>();
            values.put(Fields.ENTITY_KEY, key.getKey());
            values.put(Fields.QUESTION, record.question());
            values.put(Fields.OPTIONS, this.serializeOptions(record.options()));
            values.put(Fields.CREATOR_ID, creatorId);
            values.put(Fields.TARGET_ID, targetId);
            values.put(Fields.MESSAGE_ID, messageId);
            values.put(Fields.TIMESTAMP, record.timestamp());
            values.put(Fields.ALLOW_MULTIPLE_VOTES, record.allowMultipleVotes());
            List<Integer> inserted = this.databaseLayer.insert(TABLE_NAME).values(values).execute();
            if (inserted.size() == 1) {
                return (PollDbRecord)this.findByKey(key);
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public List<PollDbRecord> findByTarget(RecipientKey target) {
        ArrayList<PollDbRecord> arrayList;
        block10: {
            Integer targetId = (Integer)this.recipientData.getIdByKey(target);
            if (targetId == null) {
                return new ArrayList<PollDbRecord>();
            }
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.TARGET_ID, targetId))).orderBy(Fields.TIMESTAMP, DatabaseLayer.Order.DESC).execute();
            try {
                ArrayList<PollDbRecord> records = new ArrayList<PollDbRecord>();
                while (result.next()) {
                    records.add(this.construct(result));
                }
                arrayList = records;
                if (result == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return arrayList;
    }

    private byte[] serializeOptions(List<String> options) {
        int totalSize = 4;
        ArrayList<byte[]> optionsAsBytes = new ArrayList<byte[]>(options.size());
        for (String option : options) {
            byte[] optionAsBytes = option.getBytes(StandardCharsets.UTF_8);
            totalSize += 4 + optionAsBytes.length;
            optionsAsBytes.add(optionAsBytes);
        }
        ByteBuffer buffer = ByteBuffer.allocate(totalSize);
        buffer.putInt(options.size());
        for (byte[] optionAsBytes : optionsAsBytes) {
            buffer.putInt(optionAsBytes.length);
            buffer.put(optionAsBytes);
        }
        return buffer.array();
    }

    private List<String> deserializeOptions(byte[] binaryOptions) {
        ByteBuffer buffer = ByteBuffer.wrap(binaryOptions);
        int count = buffer.getInt();
        ArrayList<String> options = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            int length = buffer.getInt();
            byte[] bytes = new byte[length];
            buffer.get(bytes);
            options.add(new String(bytes, StandardCharsets.UTF_8));
        }
        return options;
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        QUESTION(FieldBuilder.newField("question", FieldType.TEXT)),
        OPTIONS(FieldBuilder.newField("options", FieldType.BLOB)),
        CREATOR_ID(FieldBuilder.newField("creator_id", FieldType.INT).withNullable(false).withReference("users", UserData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        TARGET_ID(FieldBuilder.newField("target_id", FieldType.INT).withNullable(false).withReference("recipient", RecipientData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        MESSAGE_ID(FieldBuilder.newField("message_id", FieldType.INT).withNullable(false).withReference("message", MessageData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        TIMESTAMP(FieldBuilder.newField("timestamp", FieldType.LONG)),
        ALLOW_MULTIPLE_VOTES(FieldBuilder.newField("allow_multiple_votes", FieldType.BOOLEAN));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return PollData.TABLE_NAME;
        }
    }
}

