/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public enum FieldType {
    BOOLEAN("integer"),
    INT("integer"),
    LONG("bigint"),
    SHORT_STRING("varchar(256)"),
    STRING("varchar(1024)"),
    TEXT("text"),
    BLOB("blob");

    private final String columnType;

    private FieldType(String columnType) {
        this.columnType = columnType;
    }

    public String getColumnType() {
        return this.columnType;
    }

    public <T> T get(ResultSet resultSet, String columnName) throws SQLException {
        return (T)(switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 6 -> resultSet.getBytes(columnName);
            case 0 -> (Object)resultSet.getBoolean(columnName);
            case 1 -> (Object)resultSet.getInt(columnName);
            case 2 -> (Object)resultSet.getLong(columnName);
            case 3 -> (Object)resultSet.getString(columnName);
            case 4 -> (Object)resultSet.getString(columnName);
            case 5 -> (Object)resultSet.getString(columnName);
        });
    }

    public void set(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (value == null) {
            switch (this.ordinal()) {
                case 6: {
                    pstmt.setNull(index, 2004);
                    break;
                }
                case 0: {
                    pstmt.setNull(index, 16);
                    break;
                }
                case 1: {
                    pstmt.setNull(index, 4);
                    break;
                }
                case 2: {
                    pstmt.setNull(index, 4);
                    break;
                }
                case 3: {
                    pstmt.setNull(index, 12);
                    break;
                }
                case 4: {
                    pstmt.setNull(index, 12);
                    break;
                }
                case 5: {
                    pstmt.setNull(index, 12);
                }
            }
        } else {
            switch (this.ordinal()) {
                case 6: {
                    pstmt.setBytes(index, (byte[])value);
                    break;
                }
                case 0: {
                    pstmt.setBoolean(index, (Boolean)value);
                    break;
                }
                case 1: {
                    pstmt.setInt(index, (Integer)value);
                    break;
                }
                case 2: {
                    pstmt.setLong(index, (Long)value);
                    break;
                }
                case 3: {
                    pstmt.setString(index, (String)value);
                    break;
                }
                case 4: {
                    pstmt.setString(index, (String)value);
                    break;
                }
                case 5: {
                    pstmt.setString(index, (String)value);
                }
            }
        }
    }
}

