/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata;

import io.privacyresearch.clientdata.FieldType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public interface Field {
    public Field getFieldImpl();

    default public int ordinal() {
        return this.getFieldImpl().ordinal();
    }

    default public String getTableName() {
        return this.getFieldImpl().getTableName();
    }

    default public String getColumnName() {
        return this.getFieldImpl().getColumnName();
    }

    default public String getFullName() {
        String tableName = this.getTableName();
        if (tableName == null || tableName.trim().isEmpty()) {
            return this.getColumnName();
        }
        return String.format("%s.%s", this.getTableName(), this.getColumnName());
    }

    default public FieldType getType() {
        return this.getFieldImpl().getType();
    }

    default public String getDefaultValue() {
        return this.getFieldImpl().getDefaultValue();
    }

    default public boolean isAutoincrement() {
        return this.getFieldImpl().isAutoincrement();
    }

    default public boolean isEntityKey() {
        return this.getFieldImpl().isEntityKey();
    }

    default public boolean isNullable() {
        return this.getFieldImpl().isNullable();
    }

    default public boolean isPrimaryKey() {
        return this.getFieldImpl().isPrimaryKey();
    }

    default public boolean isUnique() {
        return this.getFieldImpl().isUnique();
    }

    default public boolean includeInCreateTable() {
        return this.getFieldImpl().includeInCreateTable();
    }

    default public <T> T getValue(ResultSet resultSet) throws SQLException {
        return this.getFieldImpl().getValue(resultSet);
    }

    default public void setValue(PreparedStatement pstmt, int index, Object value) throws SQLException {
        this.getFieldImpl().setValue(pstmt, index, value);
    }

    default public String createColumnDefinition() {
        return this.getFieldImpl().createColumnDefinition(false);
    }

    default public String createColumnDefinition(boolean forAlterTable) {
        return this.getFieldImpl().createColumnDefinition(forAlterTable);
    }

    public static enum Flag {
        AUTOINCREMENT,
        ENTITY_KEY,
        NOT_NULL,
        PRIMARY_KEY,
        UNIQUE;

    }
}

