/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.group;

import io.privacyresearch.clientdata.group.GroupKey;
import io.privacyresearch.clientdata.group.MembershipRecord;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.clientdata.user.UserKey;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupIdentifier;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.signal.storageservice.protos.groups.Member;

public record GroupRecord(GroupKey key, RecipientRecord recipient, String title, String description, int disappearingTimer, boolean active, byte[] masterKeyBytes, String inviteLinkUrl, int revision, UUID distributionId, boolean whitelisted, boolean archive, boolean markedUnread, long mutedUntil, boolean dontNotifyForMentionsIfMuted, boolean hideStory, String avatarFile, Set<MembershipRecord> members) {
    private static final Logger LOG = Logger.getLogger(GroupRecord.class.getName());

    public GroupIdentifier getGroupIdentifier() {
        GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)this.getMasterKey());
        return groupSecretParams.getPublicParams().getGroupIdentifier();
    }

    public GroupMasterKey getMasterKey() {
        try {
            return new GroupMasterKey(this.masterKeyBytes());
        }
        catch (InvalidInputException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException("Invalid masterkeybytes in GroupRecord!", ex);
        }
    }

    public List<UserKey> getAdminUserKeys() {
        return this.members.stream().filter(member -> member.role().equals((Object)Member.Role.ADMINISTRATOR)).map(MembershipRecord::userKey).toList();
    }

    public boolean canLeaveGroup(UserKey userKey) {
        if (userKey == null) {
            return true;
        }
        List<UserKey> adminKeys = this.getAdminUserKeys();
        if (adminKeys.size() == 1 && userKey.equals(adminKeys.get(0))) {
            long count = this.members.stream().filter(member -> !member.userKey().equals(userKey)).count();
            return count == 0L;
        }
        return true;
    }

    public boolean isMemberOf(UserKey candidate) {
        return this.members.stream().map(MembershipRecord::userKey).anyMatch(userKey -> userKey.equals(candidate));
    }

    public boolean isUnknown() {
        if (this.title != null && !this.title.isEmpty()) {
            return false;
        }
        return this.members.isEmpty();
    }

    public String getGroupLink() {
        return "TODO";
    }

    public static class Builder {
        GroupKey key = new GroupKey();
        RecipientRecord recipient = new RecipientRecord.Builder().build();
        String title;
        String description;
        int disappearingTimer;
        boolean active;
        byte[] masterKeyBytes;
        String inviteLinkUrl;
        int revision;
        UUID distributionId;
        boolean whitelisted;
        boolean archive;
        boolean markedUnread;
        long mutedUntil;
        boolean dontNotifyForMentionsIfMuted;
        boolean hideStory;
        String avatarFile;
        Set<MembershipRecord> members = new HashSet<MembershipRecord>();

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public Builder avatarFile(String avatarFile) {
            this.avatarFile = avatarFile;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder distributionId(UUID distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public Builder inviteLinkUrl(String inviteLinkUrl) {
            this.inviteLinkUrl = inviteLinkUrl;
            return this;
        }

        public Builder key(GroupKey key) {
            this.key = key;
            return this;
        }

        public Builder masterKeyBytes(byte[] masterKeyBytes) {
            this.masterKeyBytes = masterKeyBytes;
            return this;
        }

        public Builder members(Set<MembershipRecord> members) {
            this.members = members;
            return this;
        }

        public Builder recipient(RecipientRecord recipient) {
            this.recipient = recipient;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder whitelisted(boolean whitelisted) {
            this.whitelisted = whitelisted;
            return this;
        }

        public GroupRecord build() {
            if (this.key == null) {
                throw new IllegalStateException("A GroupKey must be set.");
            }
            return new GroupRecord(this.key, this.recipient, this.title, this.description, this.disappearingTimer, this.active, this.masterKeyBytes, this.inviteLinkUrl, this.revision, this.distributionId, this.whitelisted, this.archive, this.markedUnread, this.mutedUntil, this.dontNotifyForMentionsIfMuted, this.hideStory, this.avatarFile, this.members);
        }
    }
}

