/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.distributionlist;

import io.privacyresearch.clientdata.distributionlist.DistributionListDbRecord;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import java.util.HashSet;
import java.util.Set;

public record CreateDistributionListRequest(String name, boolean allowReplies, DistributionListDbRecord.PrivacyMode privacyMode, Set<RecipientKey> recipients) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private boolean allowReplies;
        private DistributionListDbRecord.PrivacyMode privacyMode;
        private Set<RecipientKey> recipients = new HashSet<RecipientKey>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder allowReplies(boolean allowReplies) {
            this.allowReplies = allowReplies;
            return this;
        }

        public Builder privacyMode(DistributionListDbRecord.PrivacyMode privacyMode) {
            this.privacyMode = privacyMode;
            return this;
        }

        public Builder recipients(Set<RecipientKey> recipients) {
            this.recipients = recipients;
            return this;
        }

        public Builder addRecipient(RecipientKey recipient) {
            this.recipients.add(recipient);
            return this;
        }

        public CreateDistributionListRequest build() {
            return new CreateDistributionListRequest(this.name, this.allowReplies, this.privacyMode, this.recipients);
        }
    }
}

