/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.call;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.call.CallDbRecord;
import io.privacyresearch.clientdata.call.CallKey;
import io.privacyresearch.clientdata.recipient.RecipientData;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CallData
extends EntityKeyData<CallDbRecord, CallKey> {
    private static final Logger LOG = Logger.getLogger(CallData.class.getName());
    public static final String TABLE_NAME = "call";
    private final RecipientData recipientData;

    public CallData(DatabaseLayer databaseLayer, RecipientData recipientData) {
        super(databaseLayer, TABLE_NAME, List.of(Fields.values()), CallKey::new);
        this.recipientData = recipientData;
    }

    @Override
    public CallDbRecord construct(ResultSet resultSet) throws SQLException {
        RecipientRecord conversationRecipientRecord = (RecipientRecord)this.recipientData.findById(Fields.CONVERSATION_RECIPIENT_ID.getValue(resultSet));
        RecipientRecord ringerRecipientRecord = (RecipientRecord)this.recipientData.findById(Fields.RINGER_RECIPIENT_ID.getValue(resultSet));
        return new CallDbRecord(new CallKey((byte[])Fields.ENTITY_KEY.getValue(resultSet)), (Long)Fields.CALLID.getValue(resultSet), CallDbRecord.Type.fromValue((Integer)Fields.TYPE.getValue(resultSet)), CallDbRecord.State.fromValue((Integer)Fields.STATE.getValue(resultSet)), (Boolean)Fields.OUTGOING.getValue(resultSet), conversationRecipientRecord, ringerRecipientRecord, (Long)Fields.TIMESTAMP.getValue(resultSet));
    }

    public CallKey findByCallId(long callId) throws SQLException {
        return this.getByColumn(Fields.CALLID, callId).orElse(null);
    }

    @Override
    public List<CallDbRecord> findAll() throws SQLException {
        ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).orderBy(Fields.TIMESTAMP, DatabaseLayer.Order.DESC).execute();
        ArrayList<CallDbRecord> data = new ArrayList<CallDbRecord>();
        while (result.next()) {
            data.add(this.construct(result));
        }
        return data;
    }

    public CallKey createIncomingCall(long callId, RecipientKey conversationRecipientKey, RecipientKey ringerRecipientKey, CallDbRecord.Type type) {
        return this.createCall(callId, conversationRecipientKey, ringerRecipientKey, type, false);
    }

    public CallKey createOutgoingCall(long callId, RecipientKey conversationRecipientKey, RecipientKey ringerRecipientKey, CallDbRecord.Type type) {
        return this.createCall(callId, conversationRecipientKey, ringerRecipientKey, type, true);
    }

    private CallKey createCall(long callId, RecipientKey conversationRecipientKey, RecipientKey ringerRecipientKey, CallDbRecord.Type type, boolean outgoing) {
        try {
            Integer conversationRecipientId = (Integer)this.recipientData.getIdByKey(conversationRecipientKey);
            if (conversationRecipientId == null) {
                throw new IllegalArgumentException("A conversation recipient with key " + String.valueOf(conversationRecipientKey) + " should exist!");
            }
            Integer ringerRecipientId = (Integer)this.recipientData.getIdByKey(ringerRecipientKey);
            if (ringerRecipientId == null) {
                throw new IllegalArgumentException("A ringer recipient with key " + String.valueOf(ringerRecipientKey) + " should exist!");
            }
            CallKey callKey = new CallKey();
            long timestamp = System.currentTimeMillis();
            Map<Field, Object> values = Map.ofEntries(Map.entry(Fields.ENTITY_KEY, callKey.getKey()), Map.entry(Fields.CALLID, callId), Map.entry(Fields.TYPE, type.type), Map.entry(Fields.TIMESTAMP, timestamp), Map.entry(Fields.CONVERSATION_RECIPIENT_ID, conversationRecipientId), Map.entry(Fields.RINGER_RECIPIENT_ID, ringerRecipientId), Map.entry(Fields.OUTGOING, outgoing));
            List<Integer> inserted = this.databaseLayer.insert(this.getTableName()).values(values).execute();
            if (inserted.size() == 1) {
                return callKey;
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void updateState(CallKey callKey, CallDbRecord.State state) {
        try {
            this.databaseLayer.update(this.getTableName()).values(Map.ofEntries(Map.entry(Fields.STATE, state.state))).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, callKey.getKey()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        CALLID(FieldBuilder.newField("callid", FieldType.LONG).withNullable(false)),
        TYPE(FieldBuilder.newField("type", FieldType.INT).withDefaultValue(0)),
        STATE(FieldBuilder.newField("state", FieldType.INT).withDefaultValue(0)),
        OUTGOING(FieldBuilder.newField("outgoing", FieldType.BOOLEAN).withDefaultValue(false)),
        TIMESTAMP(FieldBuilder.newField("timestamp", FieldType.LONG).withDefaultValue(0)),
        CONVERSATION_RECIPIENT_ID(FieldBuilder.newField("conversation_recipient_id", FieldType.INT).withNullable(false).withReference("recipient", RecipientData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        RINGER_RECIPIENT_ID(FieldBuilder.newField("ringer_recipient_id", FieldType.INT).withNullable(false).withReference("recipient", RecipientData.Fields.ID, FieldReference.OnDelete.CASCADE));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return CallData.TABLE_NAME;
        }
    }
}

