/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.user.color;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum AvatarColor {
    A100("A100", -1842178),
    A110("A110", -2234372),
    A120("A120", -2561808),
    A130("A130", -3283763),
    A140("A140", -1384200),
    A150("A150", -662530),
    A160("A160", -599828),
    A170("A170", -665641),
    A180("A180", -68144),
    A190("A190", -1382699),
    A200("A200", -2960676),
    A210("A210", -2631719),
    UNKNOWN("UNKNOWN", 0),
    ON_SURFACE_VARIANT("ON_SURFACE_VARIANT", 0);

    private static final Map<String, AvatarColor> NAME_MAP;
    static final AvatarColor[] RANDOM_OPTIONS;
    private final String name;
    private final int color;

    private AvatarColor(String name, int color) {
        this.name = name;
        this.color = color;
    }

    public int colorInt() {
        return this.color;
    }

    public static AvatarColor random() {
        int position = (int)Math.floor(Math.random() * (double)RANDOM_OPTIONS.length);
        return RANDOM_OPTIONS[position];
    }

    public String serialize() {
        return this.name;
    }

    public static AvatarColor deserialize(String name) {
        return Objects.requireNonNull(NAME_MAP.getOrDefault(name, A210));
    }

    static {
        NAME_MAP = new HashMap<String, AvatarColor>();
        for (AvatarColor color : AvatarColor.values()) {
            NAME_MAP.put(color.serialize(), color);
        }
        NAME_MAP.put("C020", A170);
        NAME_MAP.put("C030", A170);
        NAME_MAP.put("C040", A180);
        NAME_MAP.put("C050", A180);
        NAME_MAP.put("C000", A190);
        NAME_MAP.put("C060", A190);
        NAME_MAP.put("C070", A190);
        NAME_MAP.put("C080", A130);
        NAME_MAP.put("C090", A130);
        NAME_MAP.put("C100", A130);
        NAME_MAP.put("C110", A130);
        NAME_MAP.put("C120", A130);
        NAME_MAP.put("C130", A130);
        NAME_MAP.put("C140", A130);
        NAME_MAP.put("C150", A130);
        NAME_MAP.put("C160", A130);
        NAME_MAP.put("C170", A120);
        NAME_MAP.put("C180", A120);
        NAME_MAP.put("C190", A120);
        NAME_MAP.put("C200", A110);
        NAME_MAP.put("C210", A110);
        NAME_MAP.put("C220", A110);
        NAME_MAP.put("C230", A100);
        NAME_MAP.put("C240", A100);
        NAME_MAP.put("C250", A100);
        NAME_MAP.put("C260", A100);
        NAME_MAP.put("C270", A140);
        NAME_MAP.put("C280", A140);
        NAME_MAP.put("C290", A140);
        NAME_MAP.put("C300", A150);
        NAME_MAP.put("C010", A170);
        NAME_MAP.put("C310", A150);
        NAME_MAP.put("C320", A150);
        NAME_MAP.put("C330", A160);
        NAME_MAP.put("C340", A160);
        NAME_MAP.put("C350", A160);
        NAME_MAP.put("crimson", A170);
        NAME_MAP.put("vermillion", A170);
        NAME_MAP.put("burlap", A190);
        NAME_MAP.put("forest", A130);
        NAME_MAP.put("wintergreen", A130);
        NAME_MAP.put("teal", A120);
        NAME_MAP.put("blue", A110);
        NAME_MAP.put("indigo", A100);
        NAME_MAP.put("violet", A140);
        NAME_MAP.put("plum", A150);
        NAME_MAP.put("taupe", A190);
        NAME_MAP.put("steel", A210);
        NAME_MAP.put("ultramarine", A100);
        NAME_MAP.put("unknown", A210);
        NAME_MAP.put("red", A170);
        NAME_MAP.put("orange", A170);
        NAME_MAP.put("deep_orange", A170);
        NAME_MAP.put("brown", A190);
        NAME_MAP.put("green", A130);
        NAME_MAP.put("light_green", A130);
        NAME_MAP.put("purple", A140);
        NAME_MAP.put("deep_purple", A140);
        NAME_MAP.put("pink", A150);
        NAME_MAP.put("blue_grey", A190);
        NAME_MAP.put("grey", A210);
        RANDOM_OPTIONS = new AvatarColor[]{A100, A110, A120, A130, A140, A150, A160, A170, A180, A190, A200, A210};
    }
}

