/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.message;

public record InfoMessage(Type type, String[] args) {
    public boolean hasValidInfo() {
        return Type.INFO_NONE != this.type;
    }

    public static String[] parseArgs(String args) {
        if (args == null) {
            return null;
        }
        if (args.isEmpty()) {
            return new String[0];
        }
        return args.split(";");
    }

    public static String combineArgs(String[] args) {
        if (args == null) {
            return null;
        }
        return String.join((CharSequence)";", args);
    }

    public static enum Type {
        INFO_NONE(0),
        INFO_TIMER_ME(1),
        INFO_TIMER_OTHER(2),
        INFO_MEMBER_NEW(3),
        INFO_MEMBER_REMOVE(4),
        INFO_GROUP_DESCRIPTION(5),
        INFO_GROUP_TITLE(6),
        INFO_GROUP_NEW_ME(7),
        INFO_GROUP_NEW_OTHER(8),
        INFO_ROLE_ME(9),
        INFO_TIMER_DISABLED_ME(10),
        INFO_TIMER_DISABLED_OTHER(11),
        INFO_CALL_DECLINED_INCOMING_AUDIO_CALL(12),
        INFO_CALL_DECLINED_INCOMING_VIDEO_CALL(13),
        INFO_CALL_ACCEPTED_INCOMING_AUDIO_CALL(14),
        INFO_CALL_ACCEPTED_INCOMING_VIDEO_CALL(15),
        INFO_CALL_MISSED_INCOMING_AUDIO_CALL(16),
        INFO_CALL_MISSED_INCOMING_VIDEO_CALL(17),
        INFO_CALL_ACCEPTED_OUTGOING_AUDIO_CALL(18),
        INFO_CALL_ACCEPTED_OUTGOING_VIDEO_CALL(19),
        INFO_CALL_MISSED_OR_DECLINED_OUTGOING_AUDIO_CALL(20),
        INFO_CALL_MISSED_OR_DECLINED_OUTGOING_VIDEO_CALL(21),
        INFO_GROUP_DESCRIPTION_ME(22),
        INFO_GROUP_TITLE_ME(23),
        INFO_GROUP_DESCRIPTION_OTHER(24),
        INFO_GROUP_TITLE_OTHER(25);

        int val;

        private Type(int v) {
            this.val = v;
        }

        public int val() {
            return this.val;
        }

        public static Type from(int v) {
            for (Type candidate : Type.values()) {
                if (candidate.val != v) continue;
                return candidate;
            }
            throw new IllegalArgumentException("Type with value " + v + " does not exist.");
        }
    }
}

