/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata;

import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;

public class FieldImpl
implements Field {
    private final String tableName;
    private final String columnName;
    private final String defaultValue;
    private final FieldType type;
    private final Set<Field.Flag> flags;
    private final boolean includeInCreateTable;
    private final FieldReference reference;

    public FieldImpl(String tableName, String columnName, FieldType type, String defaultValue, Set<Field.Flag> flags, boolean includeInCreateTable, FieldReference reference) {
        this.tableName = tableName;
        this.columnName = columnName;
        this.type = type;
        this.defaultValue = defaultValue;
        this.flags = flags;
        this.includeInCreateTable = includeInCreateTable;
        this.reference = reference;
    }

    @Override
    public Field getFieldImpl() {
        return this;
    }

    @Override
    public int ordinal() {
        return 0;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isAutoincrement() {
        return this.flags.contains((Object)Field.Flag.AUTOINCREMENT);
    }

    @Override
    public boolean isEntityKey() {
        return this.flags.contains((Object)Field.Flag.ENTITY_KEY);
    }

    @Override
    public boolean isNullable() {
        return !this.flags.contains((Object)Field.Flag.NOT_NULL);
    }

    @Override
    public boolean isPrimaryKey() {
        return this.flags.contains((Object)Field.Flag.PRIMARY_KEY);
    }

    @Override
    public FieldType getType() {
        return this.type;
    }

    @Override
    public boolean isUnique() {
        return this.flags.contains((Object)Field.Flag.UNIQUE);
    }

    @Override
    public boolean includeInCreateTable() {
        return this.includeInCreateTable;
    }

    @Override
    public <T> T getValue(ResultSet resultSet) throws SQLException {
        return this.type.get(resultSet, this.columnName);
    }

    @Override
    public void setValue(PreparedStatement pstmt, int index, Object value) throws SQLException {
        this.type.set(pstmt, index, value);
    }

    @Override
    public String createColumnDefinition(boolean forAlterTable) {
        Object definition = String.format("%s %s", this.columnName, this.type.getColumnType());
        if (!forAlterTable) {
            if (this.isPrimaryKey()) {
                definition = (String)definition + " PRIMARY KEY";
            }
            if (this.isAutoincrement()) {
                definition = (String)definition + " AUTOINCREMENT";
            }
            if (this.isUnique()) {
                definition = (String)definition + " UNIQUE";
            }
        }
        if (!this.isNullable()) {
            definition = (String)definition + " NOT NULL";
        }
        if (this.defaultValue != null) {
            definition = (String)definition + " DEFAULT " + this.defaultValue;
        }
        if (this.reference != null) {
            definition = (String)definition + " REFERENCES " + this.reference.getTable() + " (" + this.reference.getField().getColumnName() + ")";
            if (this.reference.getOnDelete() != null) {
                definition = (String)definition + " ON DELETE " + this.reference.getOnDelete().getDefinition();
            }
        }
        return definition;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldImpl other = (FieldImpl)obj;
        return !(this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName));
    }

    public String toString() {
        return "FieldImpl[columnName=" + this.columnName + "; type=" + this.type.name() + "; defaultValue=" + this.defaultValue + "; flags=" + String.valueOf(this.flags) + "]";
    }
}

