/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HexFormat;

public abstract class EntityKey
implements Comparable<EntityKey> {
    private static final int KEY_SIZE = 16;
    private static final SecureRandom rand = new SecureRandom();
    private final byte[] key;

    public EntityKey() {
        this.key = new byte[16];
        rand.nextBytes(this.key);
    }

    public EntityKey(byte[] key) {
        if (key.length != 16) {
            throw new IllegalArgumentException("Key must be exactly 16 bytes long.");
        }
        this.key = key;
    }

    public byte[] getKey() {
        return this.key;
    }

    public String serialize() {
        return HexFormat.of().formatHex(this.key);
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + Arrays.hashCode(this.key);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            throw new IllegalArgumentException("Cannot compare keys of different types: " + String.valueOf(this.getClass()) + " <> " + String.valueOf(obj.getClass()));
        }
        EntityKey other = (EntityKey)obj;
        return Arrays.equals(this.key, other.key);
    }

    @Override
    public int compareTo(EntityKey o) {
        return this.toString().compareTo(o.toString());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.serialize() + "]";
    }
}

