/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.user.color;

import io.privacyresearch.clientdata.distributionlist.DistributionListKey;
import io.privacyresearch.clientdata.group.GroupKey;
import io.privacyresearch.clientdata.user.color.AvatarColor;
import java.nio.charset.Charset;

public class AvatarColorHash {
    public static AvatarColor forAddress(String serviceId, String e164) {
        if (serviceId != null && !serviceId.isEmpty()) {
            return AvatarColorHash.forSeed(serviceId.toUpperCase());
        }
        if (e164 != null && !e164.isEmpty()) {
            return AvatarColorHash.forSeed(e164);
        }
        return AvatarColor.A100;
    }

    public static AvatarColor forDistributionListKey(DistributionListKey distributionListKey) {
        return AvatarColorHash.forData(distributionListKey.getKey());
    }

    public static AvatarColor forGroupKey(GroupKey groupKey) {
        return AvatarColorHash.forData(groupKey.getKey());
    }

    private static AvatarColor forSeed(String seed) {
        return AvatarColorHash.forData(seed.getBytes(Charset.defaultCharset()));
    }

    private static AvatarColor forData(byte[] data) {
        int hash = 0;
        for (byte b : data) {
            hash = Integer.rotateLeft(hash, 4) ^ Byte.toUnsignedInt(b);
        }
        return AvatarColorHash.forIndex(hash);
    }

    private static AvatarColor forIndex(int idx) {
        long uidx = Integer.toUnsignedLong(idx);
        int arrSize = AvatarColor.RANDOM_OPTIONS.length;
        int cidx = (int)(uidx % Integer.toUnsignedLong(arrSize));
        return AvatarColor.RANDOM_OPTIONS[cidx];
    }
}

