/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.reaction;

import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.recipient.RecipientKey;

public record CreateReactionRequest(MessageKey messageKey, RecipientKey authorRecipientKey, String emoji, long dateSent, long dateReceived) {
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private MessageKey messageKey;
        private RecipientKey authorRecipientKey;
        private String emoji;
        private long dateSent;
        private long dateReceived;

        public Builder authorRecipientKey(RecipientKey authorRecipientKey) {
            this.authorRecipientKey = authorRecipientKey;
            return this;
        }

        public Builder dateReceived(long dateReceived) {
            this.dateReceived = dateReceived;
            return this;
        }

        public Builder dateSent(long dateSent) {
            this.dateSent = dateSent;
            return this;
        }

        public Builder emoji(String emoji) {
            this.emoji = emoji;
            return this;
        }

        public Builder messageKey(MessageKey messageKey) {
            this.messageKey = messageKey;
            return this;
        }

        public CreateReactionRequest build() {
            return new CreateReactionRequest(this.messageKey, this.authorRecipientKey, this.emoji, this.dateSent, this.dateReceived);
        }
    }
}

