/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.keys;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.IdData;
import io.privacyresearch.clientdata.user.UserData;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.clientdata.user.UserKey;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.SignalProtocolAddress;

public class SenderKeySharedWithData
extends IdData<SignalProtocolAddress> {
    private static final Logger LOG = Logger.getLogger(SenderKeySharedWithData.class.getName());
    public static final String TABLE_NAME = "sender_key_shared";
    private UserData userData;

    public SenderKeySharedWithData(DatabaseLayer databaseLayer, UserData userData) {
        super(databaseLayer, TABLE_NAME, List.of(Fields.values()));
        this.userData = userData;
    }

    @Override
    public SignalProtocolAddress construct(ResultSet resultSet) throws SQLException {
        int device = (Integer)Fields.DEVICE.getValue(resultSet);
        String address = (String)Fields.ADDRESS.getValue(resultSet);
        return new SignalProtocolAddress(address, device);
    }

    public void markAsShared(UUID distributionId, Collection<SignalProtocolAddress> addresses) {
        for (SignalProtocolAddress address : addresses) {
            this.add(distributionId, address);
        }
    }

    public void deleteAllFor(SignalProtocolAddress address) {
        try {
            List<DatabaseLayer.BinaryOperandField> where = List.of(new DatabaseLayer.BinaryOperandField(Fields.ADDRESS, address.getName()), new DatabaseLayer.BinaryOperandField(Fields.DEVICE, address.getDeviceId()));
            this.databaseLayer.delete(this.getTableName()).where(where).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public void deleteAllFor(UserKey userKey) {
        try {
            UserDbRecord user = (UserDbRecord)this.userData.findByKey(userKey);
            String address = user.aci().toString();
            List<DatabaseLayer.BinaryOperandField> where = List.of(new DatabaseLayer.BinaryOperandField(Fields.ADDRESS, address));
            this.databaseLayer.delete(this.getTableName()).where(where).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public Set<SignalProtocolAddress> getSharedWith(UUID distributionId) {
        HashSet<SignalProtocolAddress> answer = new HashSet<SignalProtocolAddress>();
        try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.DISTRIBUTION_ID, distributionId.toString()))).execute();){
            while (result.next()) {
                answer.add(this.construct(result));
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return answer;
    }

    private void add(UUID distributionId, SignalProtocolAddress address) {
        Map<Field, Object> values = Map.ofEntries(Map.entry(Fields.DISTRIBUTION_ID, distributionId.toString()), Map.entry(Fields.ADDRESS, address.getName()), Map.entry(Fields.DEVICE, address.getDeviceId()));
        try {
            this.databaseLayer.insert(this.getTableName()).values(values).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public static enum Fields implements Field
    {
        DISTRIBUTION_ID(FieldBuilder.newField("distribution_id", FieldType.SHORT_STRING)),
        ADDRESS(FieldBuilder.newField("address", FieldType.SHORT_STRING)),
        DEVICE(FieldBuilder.newField("device", FieldType.INT));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return SenderKeySharedWithData.TABLE_NAME;
        }
    }
}

