/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.reaction;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.message.MessageData;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.reaction.CreateInternalReactionRequest;
import io.privacyresearch.clientdata.reaction.CreateReactionRequest;
import io.privacyresearch.clientdata.reaction.InternalReactionKey;
import io.privacyresearch.clientdata.reaction.ReactionDbRecord;
import io.privacyresearch.clientdata.reaction.ReactionKey;
import io.privacyresearch.clientdata.recipient.RecipientData;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReactionData
extends EntityKeyData<ReactionDbRecord, ReactionKey> {
    private static final Logger LOG = Logger.getLogger(ReactionData.class.getName());
    public static final String TABLE_NAME = "reaction";
    private final MessageData messageData;
    private final RecipientData recipientData;

    public ReactionData(Connection connection, MessageData messageData, RecipientData recipientData) {
        super(connection, TABLE_NAME, List.of(Fields.values()), ReactionKey::new);
        this.messageData = messageData;
        this.recipientData = recipientData;
    }

    @Override
    public ReactionDbRecord construct(ResultSet resultSet) throws SQLException {
        MessageKey messageKey = (MessageKey)this.messageData.getKeyById(Fields.MESSAGE_ID.getValue(resultSet));
        RecipientKey authorRecipientKey = (RecipientKey)this.recipientData.getKeyById(Fields.RECIPIENT_ID.getValue(resultSet));
        return new ReactionDbRecord(new ReactionKey((byte[])Fields.ENTITY_KEY.getValue(resultSet)), messageKey, authorRecipientKey, (Long)Fields.DATE_SENT.getValue(resultSet), (Long)Fields.DATE_RECEIVED.getValue(resultSet), (String)Fields.EMOJI.getValue(resultSet));
    }

    public InternalReactionKey addReactionInternal(CreateInternalReactionRequest request) {
        try {
            ReactionKey key = new ReactionKey();
            Map<Field, Object> values = Map.ofEntries(Map.entry(Fields.ENTITY_KEY, key.getKey()), Map.entry(Fields.MESSAGE_ID, request.messageId()), Map.entry(Fields.RECIPIENT_ID, request.authorRecipientId()), Map.entry(Fields.DATE_SENT, request.dateSent()), Map.entry(Fields.DATE_RECEIVED, request.dateReceived()), Map.entry(Fields.EMOJI, request.emoji()));
            List<Integer> inserted = this.databaseLayer.insert(this.getTableName()).values(values).returningId().execute();
            if (inserted.size() == 1) {
                return new InternalReactionKey(inserted.get(0), key);
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public ReactionKey addReaction(CreateReactionRequest request) {
        try {
            Integer messageId = (Integer)this.messageData.getIdByKey(request.messageKey());
            if (messageId == null) {
                throw new IllegalStateException("A message with key " + String.valueOf(request.messageKey()) + " should exist!");
            }
            Integer authorRecipientId = (Integer)this.recipientData.getIdByKey(request.authorRecipientKey());
            if (authorRecipientId == null) {
                throw new IllegalStateException("A recipient with key " + String.valueOf(request.authorRecipientKey()) + " should exist!");
            }
            return this.addReactionInternal(new CreateInternalReactionRequest(messageId, authorRecipientId, request.emoji(), request.dateSent(), request.dateReceived())).reactionKey();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public List<ReactionDbRecord> findByMessageKey(MessageKey messageKey) {
        LinkedList<ReactionDbRecord> linkedList;
        block10: {
            Integer messageId = (Integer)this.messageData.getIdByKey(messageKey);
            if (messageId == null) {
                return new LinkedList<ReactionDbRecord>();
            }
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.MESSAGE_ID, messageId))).execute();
            try {
                LinkedList<ReactionDbRecord> reactions = new LinkedList<ReactionDbRecord>();
                while (result.next()) {
                    reactions.add(this.construct(result));
                }
                linkedList = reactions;
                if (result == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return linkedList;
    }

    public void removeReaction(MessageKey messageKey, RecipientKey authorRecipientKey) {
        try {
            Integer messageId = (Integer)this.messageData.getIdByKey(messageKey);
            if (messageId == null) {
                return;
            }
            Integer authorRecipientId = (Integer)this.recipientData.getIdByKey(authorRecipientKey);
            if (authorRecipientId == null) {
                return;
            }
            this.databaseLayer.delete(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.MESSAGE_ID, messageId), new DatabaseLayer.BinaryOperandField(Fields.RECIPIENT_ID, authorRecipientId))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        MESSAGE_ID(FieldBuilder.newField("message_id", FieldType.INT).withNullable(false).withReference("message", MessageData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        RECIPIENT_ID(FieldBuilder.newField("recipient_id", FieldType.INT).withNullable(false).withReference("recipient", RecipientData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        DATE_SENT(FieldBuilder.newField("date_sent", FieldType.LONG).withNullable(false)),
        DATE_RECEIVED(FieldBuilder.newField("date_received", FieldType.LONG).withNullable(false)),
        EMOJI(FieldBuilder.newField("emoji", FieldType.TEXT).withNullable(false));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return ReactionData.TABLE_NAME;
        }
    }
}

