/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.message;

import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.message.BodyRange;
import io.privacyresearch.clientdata.message.InsertMessageRequest;
import io.privacyresearch.clientdata.message.StoryType;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.user.UserKey;
import java.util.List;

public class InsertMessageRequestBuilder {
    private String content;
    private List<BodyRange> bodyRanges;
    private UserKey senderKey;
    private RecipientKey receiverKey;
    private int expiration;
    private long timestamp = System.currentTimeMillis();
    private long receivedTimestamp = System.currentTimeMillis();
    private StoryType storyType = StoryType.NONE;
    private boolean viewOnce;

    private InsertMessageRequestBuilder() {
    }

    public static InsertMessageRequestBuilder anInsertMessageRequest() {
        return new InsertMessageRequestBuilder();
    }

    public static InsertMessageRequestBuilder anInsertMessageRequest(SqliteStorageBean sqliteStorageBean) {
        return new InsertMessageRequestBuilder().receiverKey(sqliteStorageBean.getUserCache().getSelf().recipientKey());
    }

    public InsertMessageRequestBuilder bodyRanges(List<BodyRange> bodyRanges) {
        this.bodyRanges = bodyRanges;
        return this;
    }

    public InsertMessageRequestBuilder content(String content) {
        this.content = content;
        return this;
    }

    public InsertMessageRequestBuilder expiration(int expiration) {
        this.expiration = expiration;
        return this;
    }

    public InsertMessageRequestBuilder senderKey(UserKey senderKey) {
        this.senderKey = senderKey;
        return this;
    }

    public InsertMessageRequestBuilder receiverKey(RecipientKey receiverKey) {
        this.receiverKey = receiverKey;
        return this;
    }

    public InsertMessageRequestBuilder storyType(StoryType storyType) {
        this.storyType = storyType;
        return this;
    }

    public InsertMessageRequestBuilder timestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public InsertMessageRequestBuilder viewOnce(boolean v) {
        this.viewOnce = v;
        return this;
    }

    public InsertMessageRequest build() {
        InsertMessageRequest request = new InsertMessageRequest();
        request.setContent(this.content);
        request.setExpiration(this.expiration);
        request.setSenderKey(this.senderKey);
        request.setReceiverKey(this.receiverKey);
        request.setTimestamp(this.timestamp);
        request.setReceivedTimestamp(this.receivedTimestamp);
        request.setBodyRanges(this.bodyRanges);
        request.setStoryType(this.storyType);
        request.setViewOnce(this.viewOnce);
        return request;
    }
}

