/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.draft;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.channel.ChannelData;
import io.privacyresearch.clientdata.channel.ChannelKey;
import io.privacyresearch.clientdata.channel.ChannelRecord;
import io.privacyresearch.clientdata.draft.DraftKey;
import io.privacyresearch.clientdata.draft.DraftRecord;
import io.privacyresearch.clientdata.draft.UpdateDraftRequest;
import io.privacyresearch.clientdata.util.BodyRangeUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DraftData
extends EntityKeyData<DraftRecord, DraftKey> {
    private static final Logger LOG = Logger.getLogger(DraftData.class.getName());
    public static final String TABLE_NAME = "draft";
    private final ChannelData channelData;

    public DraftData(Connection connection, ChannelData channelData) {
        super(connection, TABLE_NAME, List.of(Fields.values()), DraftKey::new);
        this.channelData = channelData;
    }

    @Override
    public DraftRecord construct(ResultSet resultSet) throws SQLException {
        ChannelRecord channel = (ChannelRecord)this.channelData.findById(Fields.CHANNEL_ID.getValue(resultSet));
        return new DraftRecord(new DraftKey((byte[])Fields.ENTITY_KEY.getValue(resultSet)), channel.key(), (Long)Fields.UPDATE_TIME.getValue(resultSet), (String)Fields.BODY.getValue(resultSet), BodyRangeUtil.rawToBodyRanges((String)Fields.BODY_RANGES.getValue(resultSet)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<DraftRecord> findDraftForChannel(ChannelKey channelKey) {
        try {
            Integer channelId = (Integer)this.channelData.getIdByKey(channelKey);
            if (channelId == null) {
                return Optional.empty();
            }
            try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.CHANNEL_ID, channelId))).execute();){
                if (result.next()) {
                    Optional<DraftRecord> optional2 = Optional.of(this.construct(result));
                    return optional2;
                }
                Optional<DraftRecord> optional = Optional.empty();
                return optional;
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public DraftKey updateDraft(ChannelKey channelKey, UpdateDraftRequest request) {
        try {
            Integer channelId = (Integer)this.channelData.getIdByKey(channelKey);
            if (channelId == null) {
                throw new IllegalStateException("A channel with key " + String.valueOf(channelKey) + " should exist!");
            }
            Optional<DraftRecord> existingDraft = this.findDraftForChannel(channelKey);
            if (existingDraft.isPresent()) {
                this.doUpdateDraft(channelId, request);
                return existingDraft.get().key();
            }
            return this.doInsertDraft(channelId, request);
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private void doUpdateDraft(int channelId, UpdateDraftRequest request) throws SQLException {
        Map<Field, Object> values = Map.ofEntries(Map.entry(Fields.UPDATE_TIME, System.currentTimeMillis()), Map.entry(Fields.BODY, request.getBody()), Map.entry(Fields.BODY_RANGES, BodyRangeUtil.bodyRangesToRaw(request.getBodyRanges())));
        this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.CHANNEL_ID, channelId))).execute();
    }

    private DraftKey doInsertDraft(int channelId, UpdateDraftRequest request) throws SQLException {
        DraftKey draftKey = new DraftKey();
        Map<Field, Object> values = Map.ofEntries(Map.entry(Fields.ENTITY_KEY, draftKey.getKey()), Map.entry(Fields.CHANNEL_ID, channelId), Map.entry(Fields.UPDATE_TIME, System.currentTimeMillis()), Map.entry(Fields.BODY, request.getBody()), Map.entry(Fields.BODY_RANGES, BodyRangeUtil.bodyRangesToRaw(request.getBodyRanges())));
        List<Integer> inserted = this.databaseLayer.insert(this.getTableName()).values(values).execute();
        if (inserted.size() == 1) {
            return draftKey;
        }
        return null;
    }

    public void clearDraft(ChannelKey channelKey) {
        try {
            Integer channelId = (Integer)this.channelData.getIdByKey(channelKey);
            this.databaseLayer.delete(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.CHANNEL_ID, channelId))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        CHANNEL_ID(FieldBuilder.newField("channel_id", FieldType.INT).withNullable(false).withReference("channel", ChannelData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        UPDATE_TIME(FieldBuilder.newField("update_time", FieldType.LONG).withNullable(false)),
        BODY(FieldBuilder.newField("body", FieldType.TEXT)),
        BODY_RANGES(FieldBuilder.newField("body_ranges", FieldType.TEXT));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return DraftData.TABLE_NAME;
        }
    }
}

