/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.cache;

import io.privacyresearch.clientdata.keyvalue.AccountStorage;
import io.privacyresearch.clientdata.user.UserData;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.clientdata.user.UserKey;
import io.privacyresearch.clientdata.util.LRUCache;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.ServiceId;

public class UserCache {
    private static final Logger LOG = Logger.getLogger(UserCache.class.getName());
    private static final int CACHE_MAX = 1000;
    private final AccountStorage accountStorage;
    private final UserData userData;
    private final AtomicReference<UserKey> localUserKey;
    private final Map<UserKey, UserDbRecord> users;

    public UserCache(AccountStorage accountStorage, UserData userData) {
        this.accountStorage = accountStorage;
        this.userData = userData;
        this.localUserKey = new AtomicReference<Object>(null);
        this.users = new LRUCache<UserKey, UserDbRecord>(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserDbRecord getSelf() {
        UserKey selfKey;
        AtomicReference<UserKey> atomicReference = this.localUserKey;
        synchronized (atomicReference) {
            selfKey = this.localUserKey.get();
        }
        if (selfKey == null) {
            ServiceId.Aci localAci = this.accountStorage.getAci();
            String localE164 = this.accountStorage.getE164();
            if (localAci == null && localE164 == null) {
                throw new IllegalStateException("Tried to call getSelf() before local data was set!");
            }
            if (localAci != null) {
                selfKey = this.userData.getByAci(localAci);
            }
            if (selfKey == null && localE164 != null) {
                selfKey = this.userData.getByE164(localE164);
            }
            if (selfKey == null) {
                LOG.log(Level.INFO, "Creating self for the first time.");
                selfKey = this.userData.store((ServiceId)localAci, localE164, true);
            }
            AtomicReference<UserKey> atomicReference2 = this.localUserKey;
            synchronized (atomicReference2) {
                if (this.localUserKey.get() == null) {
                    this.localUserKey.set(selfKey);
                }
            }
        }
        return this.get(selfKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserDbRecord get(UserKey key) {
        UserDbRecord user;
        if (key.equals(UserKey.UNKNOWN)) {
            return null;
        }
        Map<UserKey, UserDbRecord> map = this.users;
        synchronized (map) {
            user = this.users.get(key);
            if (user == null && (user = (UserDbRecord)this.userData.findByKey(key)) != null) {
                this.users.put(key, user);
            }
        }
        return user;
    }
}

