/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata;

import io.privacyresearch.clientdata.PatchTablesBean;
import io.privacyresearch.clientdata.attachment.AttachmentData;
import io.privacyresearch.clientdata.badge.BadgeData;
import io.privacyresearch.clientdata.cache.UserCache;
import io.privacyresearch.clientdata.call.CallData;
import io.privacyresearch.clientdata.canvas.CanvasData;
import io.privacyresearch.clientdata.channel.ChannelData;
import io.privacyresearch.clientdata.distributionlist.DistributionListData;
import io.privacyresearch.clientdata.draft.DraftData;
import io.privacyresearch.clientdata.group.GroupData;
import io.privacyresearch.clientdata.keys.IdentityData;
import io.privacyresearch.clientdata.keys.KyberPreKeyData;
import io.privacyresearch.clientdata.keys.PreKeyData;
import io.privacyresearch.clientdata.keys.SenderKeyData;
import io.privacyresearch.clientdata.keys.SenderKeySharedWithData;
import io.privacyresearch.clientdata.keys.SessionData;
import io.privacyresearch.clientdata.keys.SignedPreKeyData;
import io.privacyresearch.clientdata.keyvalue.AccountStorage;
import io.privacyresearch.clientdata.keyvalue.KeyValueData;
import io.privacyresearch.clientdata.keyvalue.PreferenceStorage;
import io.privacyresearch.clientdata.keyvalue.StorageStorage;
import io.privacyresearch.clientdata.message.MessageData;
import io.privacyresearch.clientdata.message.ReceiptData;
import io.privacyresearch.clientdata.proxy.ProxyData;
import io.privacyresearch.clientdata.quote.QuoteData;
import io.privacyresearch.clientdata.reaction.ReactionData;
import io.privacyresearch.clientdata.recipient.RecipientData;
import io.privacyresearch.clientdata.search.SearchMessageData;
import io.privacyresearch.clientdata.sticker.StickerData;
import io.privacyresearch.clientdata.sticker.StickerPackData;
import io.privacyresearch.clientdata.user.UserData;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sqlite.mc.SQLiteMCSqlCipherConfig;

public class SqliteStorageBean {
    public static final String DB_NAME = "wavefx.sqlite.db";
    private Connection connection;
    Path storageRoot;
    private KeyValueData keyValueData;
    private AccountStorage accountStorage;
    private PreferenceStorage preferenceStorage;
    private StorageStorage storageStorage;
    private PreKeyData preKeyData;
    private KyberPreKeyData kyberPreKeyData;
    private SignedPreKeyData signedPreKeyData;
    private SenderKeyData senderKeyData;
    private SenderKeySharedWithData senderKeySharedWithData;
    private SessionData sessionData;
    private IdentityData identityData;
    private RecipientData recipientData;
    private UserData userData;
    private GroupData groupData;
    private DistributionListData distributionListData;
    private BadgeData badgeData;
    private CallData callData;
    private ChannelData channelData;
    private CanvasData canvasData;
    private MessageData messageData;
    private DraftData draftData;
    private ReactionData reactionData;
    private QuoteData quoteData;
    private AttachmentData attachmentData;
    private ReceiptData receiptData;
    private ProxyData proxyData;
    private SearchMessageData searchMessageData;
    private StickerData stickerData;
    private StickerPackData stickerPackData;
    private UserCache userCache;
    private static final Logger LOG = Logger.getLogger(SqliteStorageBean.class.getName());
    private static final String STORAGEDIR_DEFAULTROOT = ".signalfx";

    public SqliteStorageBean() {
        this(Path.of(System.getProperty("equation.root", STORAGEDIR_DEFAULTROOT), new String[0]));
    }

    public SqliteStorageBean(Path storageRoot) {
        System.err.println("STORAGEROOT = " + String.valueOf(storageRoot));
        this.storageRoot = storageRoot.isAbsolute() ? storageRoot : Path.of(System.getProperty("user.home"), new String[0]).resolve(storageRoot.toString());
        this.storageRoot.toFile().mkdirs();
        LOG.log(Level.INFO, "StorageRoot set to: {0}", this.storageRoot);
        boolean databaseExists = Files.exists(this.storageRoot.resolve(DB_NAME), new LinkOption[0]);
        this.createConnection();
        this.keyValueData = new KeyValueData(this.connection);
        this.accountStorage = new AccountStorage(this.keyValueData);
        this.preferenceStorage = new PreferenceStorage(this.keyValueData);
        this.storageStorage = new StorageStorage(this.keyValueData);
        this.preKeyData = new PreKeyData(this.connection);
        this.kyberPreKeyData = new KyberPreKeyData(this.connection);
        this.signedPreKeyData = new SignedPreKeyData(this.connection);
        this.senderKeyData = new SenderKeyData(this.connection);
        this.identityData = new IdentityData(this.connection);
        this.sessionData = new SessionData(this.connection);
        this.recipientData = new RecipientData(this.connection);
        this.channelData = new ChannelData(this.connection, this.recipientData);
        this.userData = new UserData(this.connection, this.channelData, this.recipientData);
        this.canvasData = new CanvasData(this.connection, this.channelData, this.recipientData, this.userData);
        this.senderKeySharedWithData = new SenderKeySharedWithData(this.connection, this.userData);
        this.groupData = new GroupData(this.connection, this.channelData, this.recipientData, this.userData, this.accountStorage);
        this.distributionListData = new DistributionListData(this.connection, this.recipientData);
        this.badgeData = new BadgeData(this.connection, this.userData);
        this.callData = new CallData(this.connection, this.recipientData);
        this.messageData = new MessageData(this.connection, this.recipientData, this.userData);
        this.draftData = new DraftData(this.connection, this.channelData);
        this.reactionData = new ReactionData(this.connection, this.messageData, this.recipientData);
        this.quoteData = new QuoteData(this.connection, this.messageData);
        this.attachmentData = new AttachmentData(this.connection, this.messageData);
        this.receiptData = new ReceiptData(this.connection, this.messageData, this.userData);
        this.proxyData = new ProxyData(this.connection);
        this.searchMessageData = new SearchMessageData(this.connection, this.messageData, this.recipientData);
        this.stickerPackData = new StickerPackData(this.connection);
        this.stickerData = new StickerData(this.connection, this.stickerPackData);
        this.userCache = new UserCache(this.accountStorage, this.userData);
        if (!databaseExists) {
            this.createTables();
        } else {
            this.patchTables();
        }
    }

    public Path getStorageRoot() {
        return this.storageRoot;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public AccountStorage account() {
        return this.accountStorage;
    }

    public PreferenceStorage preference() {
        return this.preferenceStorage;
    }

    public StorageStorage storage() {
        return this.storageStorage;
    }

    public PreKeyData getPreKeyData() {
        return this.preKeyData;
    }

    public KyberPreKeyData getKyberPreKeyData() {
        return this.kyberPreKeyData;
    }

    public SignedPreKeyData getSignedPreKeyData() {
        return this.signedPreKeyData;
    }

    public SenderKeyData getSenderKeyData() {
        return this.senderKeyData;
    }

    public SenderKeySharedWithData getSenderKeySharedWithData() {
        return this.senderKeySharedWithData;
    }

    public IdentityData getIdentityData() {
        return this.identityData;
    }

    public SessionData getSessionData() {
        return this.sessionData;
    }

    public RecipientData getRecipientData() {
        return this.recipientData;
    }

    public UserData getUserData() {
        return this.userData;
    }

    public GroupData getGroupData() {
        return this.groupData;
    }

    public DistributionListData getDistributionListData() {
        return this.distributionListData;
    }

    public UserCache getUserCache() {
        return this.userCache;
    }

    public BadgeData getBadgeData() {
        return this.badgeData;
    }

    public CallData getCallData() {
        return this.callData;
    }

    public ChannelData getChannelData() {
        return this.channelData;
    }

    public CanvasData getCanvasData() {
        return this.canvasData;
    }

    public MessageData getMessageData() {
        return this.messageData;
    }

    public DraftData getDraftData() {
        return this.draftData;
    }

    public ReactionData getReactionData() {
        return this.reactionData;
    }

    public QuoteData getQuoteData() {
        return this.quoteData;
    }

    public AttachmentData getAttachmentData() {
        return this.attachmentData;
    }

    public ReceiptData getReceiptData() {
        return this.receiptData;
    }

    public SearchMessageData getSearchMessageData() {
        return this.searchMessageData;
    }

    public StickerData getStickerData() {
        return this.stickerData;
    }

    public StickerPackData getStickerPackData() {
        return this.stickerPackData;
    }

    public ProxyData getProxyData() {
        return this.proxyData;
    }

    public void createIndexes() {
        try {
            this.getMessageData().createIndexes();
        }
        catch (SQLException ex) {
            LOG.log(Level.WARNING, "Something went wrong while creating indexes.", ex);
        }
    }

    private void createConnection() {
        try {
            String enableDatabaseEncryption = System.getenv().getOrDefault("SQLITE_DB_ENCRYPTION", "on");
            String url = String.format("jdbc:sqlite:%s/%s", this.storageRoot.toString(), DB_NAME);
            LOG.info("URL: " + url);
            if ("off".equalsIgnoreCase(enableDatabaseEncryption)) {
                LOG.info("Using plain db");
                this.connection = DriverManager.getConnection(url);
            } else {
                LOG.info("Using encrypted db");
                this.connection = SQLiteMCSqlCipherConfig.getV4Defaults().withHexKey("736F796C656E74677265656E697370656F706C65".getBytes()).build().createConnection(url);
            }
            LOG.info("Connection to SQLite has been established: " + String.valueOf(this.connection));
        }
        catch (SQLException ex) {
            LOG.log(Level.WARNING, "Something went wrong while creating database connection.", ex);
        }
    }

    private void createTables() {
        LOG.info("Creating tables");
        try {
            this.keyValueData.createTable();
            this.preKeyData.createTable();
            this.kyberPreKeyData.createTable();
            this.signedPreKeyData.createTable();
            this.senderKeyData.createTable();
            this.senderKeySharedWithData.createTable();
            this.sessionData.createTable();
            this.identityData.createTable();
            this.recipientData.createTable();
            this.userData.createTable();
            this.groupData.createTable();
            this.distributionListData.createTable();
            this.badgeData.createTable();
            this.callData.createTable();
            this.channelData.createTable();
            this.canvasData.createTable();
            this.messageData.createTable();
            this.draftData.createTable();
            this.reactionData.createTable();
            this.quoteData.createTable();
            this.attachmentData.createTable();
            this.receiptData.createTable();
            this.searchMessageData.createTable();
            this.stickerData.createTable();
            this.stickerPackData.createTable();
            this.proxyData.createTable();
        }
        catch (SQLException ex) {
            LOG.log(Level.WARNING, "Something went wrong while creating tables.", ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private void patchTables() {
        LOG.info("Patching tables");
        try {
            PatchTablesBean patchTablesBean = new PatchTablesBean(this);
            patchTablesBean.patchTables();
        }
        catch (SQLException ex) {
            LOG.log(Level.WARNING, "Something went wrong while patching tables.", ex);
            throw new IllegalArgumentException(ex);
        }
    }
}

