/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata;

import io.privacyresearch.clientdata.BaseData;
import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class EntityKeyData<T, K extends EntityKey>
extends BaseData<T> {
    private static final Logger LOG = Logger.getLogger(EntityKeyData.class.getName());
    private final Function<byte[], K> entityKeySupplier;

    public EntityKeyData(Connection connection, String tableName, List<Field> fields, Function<byte[], K> entityKeySupplier) {
        super(connection, tableName, fields);
        this.entityKeySupplier = entityKeySupplier;
    }

    public <P> P getIdByKey(K entityKey) throws SQLException {
        Field primaryKeyField = this.getPrimaryKeyField();
        try (ResultSet result = this.databaseLayer.select(List.of(primaryKeyField)).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(this.getEntityKeyField(), ((EntityKey)entityKey).getKey()))).execute();){
            if (result.next()) {
                Object t = primaryKeyField.getValue(result);
                return (P)t;
            }
            P p = null;
            return p;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T findByKey(K entityKey) {
        if (entityKey == null) {
            return null;
        }
        try (ResultSet result = this.getByKey(entityKey);){
            if (result.next()) {
                Object t = this.construct(result);
                return t;
            }
            T t = null;
            return t;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private ResultSet getByKey(K entityKey) throws SQLException {
        return this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(this.getEntityKeyField(), ((EntityKey)entityKey).getKey()))).execute();
    }

    public K getKeyById(Object primaryKey) throws SQLException {
        Field entityKeyField = this.getEntityKeyField();
        try (ResultSet result = this.databaseLayer.select(List.of(entityKeyField)).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(this.getPrimaryKeyField(), primaryKey))).execute();){
            if (result.next()) {
                EntityKey entityKey = (EntityKey)this.entityKeySupplier.apply(result.getBytes(1));
                return (K)entityKey;
            }
            K k = null;
            return k;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> Optional<K> getByColumn(Field column, T value) {
        try (ResultSet result = this.databaseLayer.select(List.of(this.getEntityKeyField())).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(column, value))).execute();){
            if (!result.next()) return Optional.empty();
            Optional<EntityKey> optional = Optional.of((EntityKey)this.entityKeySupplier.apply(result.getBytes(1)));
            return optional;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    protected Field getEntityKeyField() {
        return this.getFields().stream().filter(Field::isEntityKey).findFirst().orElse(null);
    }
}

