/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata;

import io.privacyresearch.clientdata.ColumnInfo;
import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class BaseData<T> {
    private static final Logger LOG = Logger.getLogger(BaseData.class.getName());
    protected final DatabaseLayer databaseLayer;
    private final String tableName;
    private final List<Field> fields;

    public BaseData(Connection connection, String tableName, List<Field> fields) {
        this.databaseLayer = new DatabaseLayer(connection);
        this.tableName = tableName;
        this.fields = fields;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void createTable() throws SQLException {
        this.databaseLayer.createTable(this.tableName).fields(this.getFields().stream().filter(Field::includeInCreateTable).collect(Collectors.toList())).execute();
    }

    public void createIndexes() throws SQLException {
    }

    public void dropTable() throws SQLException {
        this.databaseLayer.dropTable(this.tableName).execute();
    }

    public ColumnInfo getColumnInfo(Field field) throws SQLException {
        List<String> uniqueColumns = this.getUniqueColumns();
        boolean withAutoincrement = this.hasPrimaryKeyWithAutoincrement();
        String query = String.format("SELECT c.name, c.type, c.\"notnull\", c.dflt_value, c.pk FROM pragma_table_info(('%s')) c WHERE c.name = '%s'", this.tableName, field.getColumnName());
        try (Statement stmt = this.databaseLayer.getConnection().createStatement();
             ResultSet resultSet = stmt.executeQuery(query);){
            if (resultSet.next()) {
                String columnName = resultSet.getString(1);
                int primaryKeyIndex = resultSet.getInt(5);
                ColumnInfo columnInfo = new ColumnInfo(columnName, resultSet.getString(2), resultSet.getInt(3) == 1, uniqueColumns.contains(columnName), resultSet.getString(4), primaryKeyIndex, primaryKeyIndex > 0 && withAutoincrement);
                return columnInfo;
            }
        }
        return null;
    }

    public List<ColumnInfo> getColumnsInfo() throws SQLException {
        List<String> uniqueColumns = this.getUniqueColumns();
        boolean withAutoincrement = this.hasPrimaryKeyWithAutoincrement();
        String tableInfoQuery = String.format("SELECT c.name, c.type, c.\"notnull\", c.dflt_value, c.pk FROM pragma_table_info(('%s')) c", this.tableName);
        ArrayList<ColumnInfo> info = new ArrayList<ColumnInfo>();
        try (Statement stmt = this.databaseLayer.getConnection().createStatement();
             ResultSet resultSet = stmt.executeQuery(tableInfoQuery);){
            while (resultSet.next()) {
                String columnName = resultSet.getString(1);
                int primaryKeyIndex = resultSet.getInt(5);
                info.add(new ColumnInfo(columnName, resultSet.getString(2), resultSet.getInt(3) == 1, uniqueColumns.contains(columnName), resultSet.getString(4), primaryKeyIndex, primaryKeyIndex > 0 && withAutoincrement));
            }
        }
        return info;
    }

    public List<String> getColumnNames() throws SQLException {
        String query = String.format("SELECT c.name FROM main.sqlite_schema t LEFT OUTER JOIN pragma_table_info((t.name)) c ON t.name <> c.name WHERE t.name = '%s' AND t.type = 'table'", this.tableName);
        ArrayList<String> columnNames = new ArrayList<String>();
        try (Statement stmt = this.databaseLayer.getConnection().createStatement();
             ResultSet resultSet = stmt.executeQuery(query);){
            while (resultSet.next()) {
                columnNames.add(resultSet.getString("name").toLowerCase(Locale.ROOT));
            }
        }
        return columnNames;
    }

    private List<String> getUniqueColumns() throws SQLException {
        String uniqueColumnsQuery = String.format("SELECT ii.name FROM pragma_index_list('%s') il, pragma_index_info(il.name) ii WHERE il.[unique] = 1", this.tableName);
        ArrayList<String> uniqueColumns = new ArrayList<String>();
        try (Statement stmt = this.databaseLayer.getConnection().createStatement();
             ResultSet resultSet = stmt.executeQuery(uniqueColumnsQuery);){
            while (resultSet.next()) {
                uniqueColumns.add(resultSet.getString(1));
            }
        }
        return uniqueColumns;
    }

    private boolean hasPrimaryKeyWithAutoincrement() throws SQLException {
        String detectAutoincrementQuery = String.format("SELECT COUNT(*) FROM sqlite_master m WHERE m.type = 'table' AND m.name = '%s' AND m.sql LIKE '%%AUTOINCREMENT%%'", this.tableName);
        try (Statement stmt = this.databaseLayer.getConnection().createStatement();
             ResultSet resultSet = stmt.executeQuery(detectAutoincrementQuery);){
            if (resultSet.next()) {
                boolean bl = resultSet.getInt(1) > 0;
                return bl;
            }
        }
        return false;
    }

    public void addColumn(Field field) throws SQLException {
        List<String> columnNames = this.getColumnNames();
        if (!columnNames.contains(field.getColumnName().toLowerCase(Locale.ROOT))) {
            LOG.info(String.format("Patching table '%s' to add column '%s'", this.tableName, field.getColumnName()));
            this.databaseLayer.alterTable(this.getTableName()).addColumn(field).execute();
        }
    }

    public void dropColumn(String columnName) throws SQLException {
        List<String> columnNames = this.getColumnNames();
        if (columnNames.contains(columnName)) {
            LOG.info(String.format("Patching table '%s' to drop column '%s'", this.tableName, columnName));
            this.databaseLayer.alterTable(this.getTableName()).dropColumn(columnName).execute();
        }
    }

    public int count() throws SQLException {
        try (ResultSet result = this.databaseLayer.selectRaw(List.of("COUNT(*)")).from(this.tableName).execute();){
            if (result.next()) {
                int n = result.getInt(1);
                return n;
            }
        }
        return -1;
    }

    public List<T> findAll() throws SQLException {
        try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.tableName).execute();){
            ArrayList<T> data = new ArrayList<T>();
            while (result.next()) {
                data.add(this.construct(result));
            }
            ArrayList<T> arrayList = data;
            return arrayList;
        }
    }

    public boolean existsById(Object primaryKey) throws SQLException {
        try (ResultSet result = this.getById(primaryKey);){
            boolean bl = result.next();
            return bl;
        }
    }

    public T findById(Object primaryKey) throws SQLException {
        try (ResultSet result = this.getById(primaryKey);){
            if (result.next()) {
                T t = this.construct(result);
                return t;
            }
            T t = null;
            return t;
        }
    }

    private ResultSet getById(Object primaryKey) throws SQLException {
        return this.databaseLayer.select(this.getFields()).from(this.tableName).where(List.of(new DatabaseLayer.BinaryOperandField(this.getPrimaryKeyField(), primaryKey))).execute();
    }

    public abstract T construct(ResultSet var1) throws SQLException;

    protected List<Field> getFields() {
        return this.fields;
    }

    protected void setNullableString(PreparedStatement stmt, int idx, String value) throws SQLException {
        if (value == null) {
            stmt.setNull(idx, 12);
        } else {
            stmt.setString(idx, value);
        }
    }

    protected Field getPrimaryKeyField() {
        return this.fields.stream().filter(Field::isPrimaryKey).findFirst().orElse(null);
    }
}

