/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.user;

import com.google.protobuf.ByteString;
import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.channel.ChannelData;
import io.privacyresearch.clientdata.recipient.RecipientData;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.clientdata.user.AccountPart;
import io.privacyresearch.clientdata.user.PhoneNumberSharingMode;
import io.privacyresearch.clientdata.user.RegisteredState;
import io.privacyresearch.clientdata.user.UnidentifiedAccessMode;
import io.privacyresearch.clientdata.user.UnidentifiedAccessUtil;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.clientdata.user.UserKey;
import io.privacyresearch.clientdata.user.color.AvatarColor;
import io.privacyresearch.clientdata.user.color.AvatarColorHash;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.thoughtcrime.securesms.backup.v2.proto.Backup;
import org.whispersystems.signalservice.api.crypto.InvalidCiphertextException;
import org.whispersystems.signalservice.api.crypto.ProfileCipher;
import org.whispersystems.signalservice.api.profiles.SignalServiceProfile;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.storage.SignalAccountRecord;
import org.whispersystems.signalservice.api.storage.SignalContactRecord;
import org.whispersystems.signalservice.api.util.UuidUtil;

public class UserData
extends EntityKeyData<UserDbRecord, UserKey> {
    private static final Logger LOG = Logger.getLogger(UserData.class.getName());
    public static final String TABLE_NAME = "users";
    Map<Integer, SoftReference<UserDbRecord>> recipientIdMap = new HashMap<Integer, SoftReference<UserDbRecord>>();
    private final ChannelData channelData;
    private final RecipientData recipientData;

    public UserData(Connection connection, ChannelData channelData, RecipientData recipientData) {
        super(connection, TABLE_NAME, List.of(Fields.values()), UserKey::new);
        this.channelData = channelData;
        this.recipientData = recipientData;
    }

    @Override
    public UserDbRecord construct(ResultSet resultSet) throws SQLException {
        Integer recipientId = (Integer)Fields.RECIPIENT_ID.getValue(resultSet);
        RecipientKey recipientKey = null;
        if (recipientId != null) {
            recipientKey = (RecipientKey)this.recipientData.getKeyById(recipientId);
        }
        UnidentifiedAccessMode sealedSenderMode = UnidentifiedAccessMode.fromMode((Integer)Fields.SEALED_SENDER_MODE.getValue(resultSet));
        PhoneNumberSharingMode phoneNumberSharing = PhoneNumberSharingMode.fromId((Integer)Fields.PHONE_NUMBER_SHARING.getValue(resultSet));
        return new UserDbRecord(new UserKey((byte[])Fields.ENTITY_KEY.getValue(resultSet)), recipientKey, ServiceId.ACI.parseOrNull((String)((String)Fields.ACI.getValue(resultSet))), ServiceId.PNI.parseOrNull((String)((String)Fields.PNI.getValue(resultSet))), (String)Fields.E164.getValue(resultSet), (byte[])Fields.PROFILE_KEY.getValue(resultSet), (String)Fields.PROFILE_GIVEN_NAME.getValue(resultSet), (String)Fields.PROFILE_FAMILY_NAME.getValue(resultSet), (String)Fields.USERNAME.getValue(resultSet), (String)Fields.SYSTEM_GIVEN_NAME.getValue(resultSet), (String)Fields.SYSTEM_FAMILY_NAME.getValue(resultSet), (String)Fields.ABOUT.getValue(resultSet), (String)Fields.ABOUT_EMOJI.getValue(resultSet), (String)Fields.NICK_GIVEN_NAME.getValue(resultSet), (String)Fields.NICK_FAMILY_NAME.getValue(resultSet), (String)Fields.NICK_NOTE.getValue(resultSet), (String)Fields.PROFILE_AVATAR_URL.getValue(resultSet), sealedSenderMode, phoneNumberSharing);
    }

    public List<UserDbRecord> findByRecipientType(RecipientRecord.Type type) {
        ArrayList<UserDbRecord> arrayList;
        block9: {
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).join(DatabaseLayer.Join.inner((Field)RecipientData.Fields.ID, Fields.RECIPIENT_ID)).where(List.of(new DatabaseLayer.BinaryOperandField(RecipientData.Fields.TYPE, type.type))).execute();
            try {
                ArrayList<UserDbRecord> users = new ArrayList<UserDbRecord>();
                while (result.next()) {
                    users.add(this.construct(result));
                }
                arrayList = users;
                if (result == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserDbRecord findByRecipientId(Integer recipientId) {
        UserDbRecord cached;
        if (recipientId == null) {
            return null;
        }
        SoftReference<UserDbRecord> reference = this.recipientIdMap.get(recipientId);
        if (reference != null && (cached = reference.get()) != null) {
            return cached;
        }
        try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.RECIPIENT_ID, recipientId))).execute();){
            if (result.next()) {
                UserDbRecord answer = this.construct(result);
                reference = new SoftReference<UserDbRecord>(answer);
                this.recipientIdMap.put(recipientId, reference);
                UserDbRecord userDbRecord2 = answer;
                return userDbRecord2;
            }
            UserDbRecord userDbRecord = null;
            return userDbRecord;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public UserDbRecord findByRecipientKey(RecipientKey recipientKey) {
        try {
            return this.findByRecipientId((Integer)this.recipientData.getIdByKey(recipientKey));
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserDbRecord findByAci(ServiceId.ACI aci) {
        try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ACI, aci.toString()))).execute();){
            if (result.next()) {
                UserDbRecord userDbRecord2 = this.construct(result);
                return userDbRecord2;
            }
            UserDbRecord userDbRecord = null;
            return userDbRecord;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public UserKey getByServiceId(ServiceId serviceId) {
        if (serviceId instanceof ServiceId.ACI) {
            ServiceId.ACI aci = (ServiceId.ACI)serviceId;
            return this.getByAci(aci);
        }
        if (serviceId instanceof ServiceId.PNI) {
            ServiceId.PNI pni = (ServiceId.PNI)serviceId;
            return this.getByPni(pni);
        }
        LOG.warning("Need to retrieve a user but serviceId is not a PNI or ACI.");
        return null;
    }

    public UserKey getByE164(String number) {
        return this.getByColumn(Fields.E164, number).orElse(null);
    }

    public UserKey getByAci(ServiceId.ACI aci) {
        return this.getByColumn(Fields.ACI, aci.toString()).orElse(null);
    }

    public UserKey getByPni(ServiceId.PNI pni) {
        return this.getByColumn(Fields.PNI, pni.toString()).orElse(null);
    }

    public UserDbRecord getUserForServiceId(ServiceId serviceId) {
        UserKey userKey = this.getByServiceId(serviceId);
        if (userKey == null) {
            return null;
        }
        return (UserDbRecord)this.findByKey(userKey);
    }

    public UserKey getOrCreateUserKeyForServiceId(ServiceId serviceId) {
        UserKey userKey = this.getByServiceId(serviceId);
        if (userKey != null) {
            return userKey;
        }
        return this.store(serviceId, null);
    }

    public UserKey storeContactRecord(SignalContactRecord record) {
        LOG.info("Store ContactRecord " + String.valueOf(record));
        Optional<UserKey> userKey = record.getAci().map(this::getByAci);
        if (userKey.isEmpty() && record.getNumber().isPresent()) {
            userKey = record.getNumber().map(this::getByE164);
        }
        if (userKey.isEmpty() && record.getPni().isPresent()) {
            userKey = record.getPni().map(this::getByPni);
        }
        RecipientKey recipientKey = null;
        if (userKey.isEmpty()) {
            LOG.info("Still no key, search for possible recipient");
            RecipientRecord recipientRecord = this.recipientData.getByStorageId(record.getId().getRaw());
            if (recipientRecord != null) {
                LOG.info("But we have a recipient");
                UserDbRecord existing = this.findByRecipientKey(recipientRecord.key());
                if (existing != null) {
                    LOG.info("With a user!");
                    userKey = Optional.of(existing.key());
                } else {
                    LOG.info("No user found that matches the recipient, create new user with this recipient");
                    recipientKey = recipientRecord.key();
                }
            } else {
                LOG.info("No recipient for given storageId");
            }
        }
        LOG.info("User = " + String.valueOf(userKey));
        if (userKey.isPresent()) {
            this.update(userKey.get(), record);
            return userKey.get();
        }
        return this.store(record, recipientKey);
    }

    public UserKey storeContactFromBackup(Backup.Contact backup) {
        return this.store(backup);
    }

    public void storeAccountRecord(ServiceId.ACI aci, SignalAccountRecord record) {
        LOG.info("Store AccountRecord " + String.valueOf(record));
        UserKey userKey = this.getByAci(aci);
        if (userKey == null) {
            throw new IllegalArgumentException("Our ACI does not exist!");
        }
        this.update(userKey, record);
    }

    public void storeProfile(ServiceId serviceId, SignalServiceProfile profile, byte[] profileKeyBytes) {
        ProfileKey profileKey;
        LOG.info("Store profile for " + String.valueOf(serviceId));
        UserKey key = this.getByServiceId(serviceId);
        if (key == null) {
            LOG.severe("No user for serviceId " + String.valueOf(serviceId));
            throw new IllegalArgumentException("Can't store profile for unknown serviceId " + String.valueOf(serviceId));
        }
        try {
            profileKey = new ProfileKey(profileKeyBytes);
        }
        catch (InvalidInputException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException("Wrong profilekeybytes passed");
        }
        ProfileCipher pc = new ProfileCipher(profileKey);
        HashMap<Field, Object> values = new HashMap<Field, Object>();
        try {
            values.put(Fields.PROFILE_KEY, profileKeyBytes);
            if (profile.getName() != null) {
                String pname = pc.decryptString(Base64.getDecoder().decode(profile.getName()));
                int sep = pname.indexOf(0);
                if (sep > -1) {
                    String first = pname.substring(0, sep);
                    String last = pname.substring(sep + 1);
                    values.put(Fields.PROFILE_GIVEN_NAME, first);
                    values.put(Fields.PROFILE_FAMILY_NAME, last);
                } else {
                    values.put(Fields.PROFILE_GIVEN_NAME, pname);
                }
            }
            if (profile.getAbout() != null) {
                values.put(Fields.ABOUT, pc.decryptString(Base64.getDecoder().decode(profile.getAbout())));
            }
            if (profile.getAboutEmoji() != null) {
                values.put(Fields.ABOUT_EMOJI, pc.decryptString(Base64.getDecoder().decode(profile.getAboutEmoji())));
            }
            if (profile.getPhoneNumberSharing() != null) {
                Optional val = pc.decryptBoolean(Base64.getDecoder().decode(profile.getPhoneNumberSharing()));
                if (val.isPresent()) {
                    values.put(Fields.PHONE_NUMBER_SHARING, (Boolean)val.get() != false ? PhoneNumberSharingMode.EVERYBODY.id : PhoneNumberSharingMode.NOBODY.id);
                } else {
                    values.put(Fields.PHONE_NUMBER_SHARING, PhoneNumberSharingMode.UNKNOWN.id);
                }
            } else {
                values.put(Fields.PHONE_NUMBER_SHARING, PhoneNumberSharingMode.UNKNOWN.id);
            }
            if (profile.getAvatar() != null) {
                values.put(Fields.PROFILE_AVATAR_URL, profile.getAvatar());
            }
        }
        catch (InvalidCiphertextException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException("Wrong about field");
        }
        try {
            UserDbRecord record = (UserDbRecord)this.findByKey(key);
            UnidentifiedAccessMode accessMode = UnidentifiedAccessUtil.getUnidentifiedAccessMode(record.profileKey(), profile);
            if (record.sealedSenderMode() != accessMode) {
                values.put(Fields.SEALED_SENDER_MODE, accessMode.mode);
            }
            if (values.isEmpty()) {
                LOG.info("No values to be updated");
                return;
            }
            LOG.info("And now update");
            this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, key.getKey()))).execute();
            LOG.info("did update");
        }
        catch (SQLException ex) {
            LOG.severe("Can't update table");
            throw new IllegalArgumentException(ex);
        }
    }

    public UserKey store(ServiceId serviceId, String e164) {
        return this.store(serviceId, e164, false);
    }

    public UserKey store(ServiceId serviceId, String e164, boolean isAccount) {
        if (serviceId == null && e164 == null) {
            throw new IllegalArgumentException("Must provide a ServiceId or E164!");
        }
        if (serviceId instanceof ServiceId.ACI) {
            ServiceId.ACI aci = (ServiceId.ACI)serviceId;
            if (this.getByAci(aci) != null) {
                throw new IllegalArgumentException("ACI already used by existing user");
            }
            return this.store(aci, null, e164, false, isAccount);
        }
        if (serviceId instanceof ServiceId.PNI) {
            return this.store(null, (ServiceId.PNI)serviceId, e164, false, isAccount);
        }
        return this.store(null, null, e164, false, isAccount);
    }

    public UserKey storePniVerified(ServiceId.ACI aci, ServiceId.PNI pni, String e164) {
        return this.store(aci, pni, e164, true, true);
    }

    private UserKey store(ServiceId.ACI aci, ServiceId.PNI pni, String e164, boolean pniVerified, boolean isAccount) {
        UserKey byPNI;
        if (aci == null && pni == null && e164 == null) {
            throw new IllegalArgumentException("Must provide an ACI, PNI, or E164!");
        }
        UserKey singleMatch = this.getUserKeyIfAllFieldsMatch(aci, pni, e164);
        if (singleMatch != null) {
            return singleMatch;
        }
        UserKey byE164 = e164 != null ? this.getByE164(e164) : null;
        UserKey byACI = aci != null ? this.getByAci(aci) : null;
        UserKey userKey = byPNI = pni != null ? this.getByPni(pni) : null;
        if (byE164 == null && byPNI == null && byACI == null) {
            UserKey userKey2 = new UserKey();
            try {
                int inserted;
                RecipientRecord.Type recipientType;
                RecipientRecord.Type type = recipientType = isAccount ? RecipientRecord.Type.ACCOUNT : RecipientRecord.Type.CONTACT;
                AvatarColor avatarColor = AvatarColorHash.forAddress(aci != null ? aci.toString() : (pni != null ? pni.toString() : null), e164);
                RecipientKey userRecipientKey = this.recipientData.createUserRecipient(null, recipientType, avatarColor);
                this.channelData.createForRecipient(userRecipientKey);
                HashMap<Field, Object> values = new HashMap<Field, Object>();
                values.put(Fields.ENTITY_KEY, userKey2.getKey());
                values.put(Fields.RECIPIENT_ID, this.recipientData.getIdByKey(userRecipientKey));
                if (e164 != null) {
                    values.put(Fields.E164, e164);
                }
                if (aci != null) {
                    values.put(Fields.ACI, aci.toString());
                }
                if (pni != null) {
                    values.put(Fields.PNI, pni.toString());
                }
                if (pni != null || aci != null) {
                    values.put(Fields.REGISTERED, RegisteredState.REGISTERED.id);
                    values.put(Fields.UNREGISTERED_TIMESTAMP, 0L);
                }
                if ((inserted = this.databaseLayer.insert(this.getTableName()).values(values).execute()) == 1) {
                    return userKey2;
                }
                return null;
            }
            catch (SQLException ex) {
                LOG.log(Level.SEVERE, null, ex);
                throw new IllegalArgumentException(ex);
            }
        }
        throw new UnsupportedOperationException("We are in a merge case. Not yet implemented.");
    }

    public AccountPart getAccountPart(ServiceId.ACI aci) {
        UserDbRecord userRecord = this.findByAci(aci);
        return new AccountPart(userRecord.recipientKey(), userRecord.profileKey(), userRecord.username(), userRecord.profileGivenName(), userRecord.profileFamilyName(), userRecord.about(), userRecord.aboutEmoji());
    }

    public boolean setProfileKey(UserKey userKey, ProfileKey profileKey) {
        byte[] serializedProfileKey = profileKey.serialize();
        LOG.info("Set ProfileKey for " + String.valueOf(userKey) + " to (first byte) " + serializedProfileKey[0]);
        try {
            List<DatabaseLayer.InsertableField> values = List.of(new DatabaseLayer.InsertableField(Fields.PROFILE_KEY, serializedProfileKey), new DatabaseLayer.InsertableField(Fields.EXPIRING_PROFILE_KEY_CREDENTIAL, null), new DatabaseLayer.InsertableField(Fields.SEALED_SENDER_MODE, UnidentifiedAccessMode.UNKNOWN.mode));
            String whereClause = String.format("(%s = ?) AND (%s != ? OR %s IS NULL)", Fields.ENTITY_KEY.getColumnName(), Fields.PROFILE_KEY.getColumnName(), Fields.PROFILE_KEY.getColumnName());
            int updatedRows = this.databaseLayer.update(this.getTableName()).values(values).where(whereClause, stmt -> {
                stmt.setBytes(values.size() + 1, userKey.getKey());
                stmt.setBytes(values.size() + 2, serializedProfileKey);
            }).execute();
            return updatedRows > 0;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private UserKey getUserKeyIfAllFieldsMatch(ServiceId.ACI aci, ServiceId.PNI pni, String e164) {
        UserKey userKey;
        block13: {
            if (aci == null && pni == null && e164 == null) {
                return null;
            }
            ArrayList<DatabaseLayer.BinaryOperandField> where = new ArrayList<DatabaseLayer.BinaryOperandField>();
            if (aci != null) {
                where.add(new DatabaseLayer.BinaryOperandField(Fields.ACI, aci.toString()));
            }
            if (pni != null) {
                where.add(new DatabaseLayer.BinaryOperandField(Fields.PNI, pni.toString()));
            }
            if (e164 != null) {
                where.add(new DatabaseLayer.BinaryOperandField(Fields.E164, e164));
            }
            ResultSet result = this.databaseLayer.select(List.of(Fields.ENTITY_KEY)).from(this.getTableName()).where(where).execute();
            try {
                ArrayList<UserKey> keys = new ArrayList<UserKey>();
                while (result.next()) {
                    keys.add(new UserKey(result.getBytes(1)));
                }
                UserKey userKey2 = userKey = keys.size() == 1 ? (UserKey)keys.get(0) : null;
                if (result == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return userKey;
    }

    private UserKey store(SignalContactRecord record, RecipientKey userRecipientKey) {
        try {
            String e164 = record.getNumber().orElse(null);
            ServiceId.ACI aci = record.getAci().orElse(null);
            ServiceId.PNI pni = record.getPni().orElse(null);
            AvatarColor avatarColor = AvatarColorHash.forAddress(aci != null ? aci.toString() : (pni != null ? pni.toString() : null), e164);
            if (userRecipientKey == null) {
                userRecipientKey = this.recipientData.createUserRecipient(record.getId().getRaw(), RecipientRecord.Type.CONTACT, avatarColor);
            }
            this.channelData.createForRecipient(userRecipientKey);
            UserKey userKey = new UserKey();
            Map<Field, Object> values = this.getValuesForContactRecord(record);
            values.put(Fields.ENTITY_KEY, userKey.getKey());
            values.put(Fields.RECIPIENT_ID, this.recipientData.getIdByKey(userRecipientKey));
            this.databaseLayer.insert(this.getTableName()).values(values).execute();
            return userKey;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private UserKey store(Backup.Contact backup) {
        try {
            String e164;
            ServiceId.ACI aci = ServiceId.ACI.parseOrNull((ByteString)backup.getAci());
            ServiceId.PNI pni = ServiceId.PNI.parseOrNull((byte[])backup.getPni().toByteArray());
            long e164l = backup.getE164();
            String string = e164 = e164l == 0L ? null : Long.toString(e164l);
            AvatarColor avatarColor = AvatarColorHash.forAddress(aci != null ? aci.toString() : (pni != null ? pni.toString() : null), e164);
            RecipientKey userRecipientKey = this.recipientData.createUserRecipient(null, RecipientRecord.Type.CONTACT, avatarColor);
            this.channelData.createForRecipient(userRecipientKey);
            UserKey userKey = new UserKey();
            Map<Field, Object> values = this.getValuesForContactBackup(backup);
            values.put(Fields.ENTITY_KEY, userKey.getKey());
            values.put(Fields.RECIPIENT_ID, this.recipientData.getIdByKey(userRecipientKey));
            this.databaseLayer.insert(this.getTableName()).values(values).execute();
            return userKey;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private void update(UserKey userKey, SignalContactRecord record) {
        try {
            UserDbRecord user = (UserDbRecord)this.findByKey(userKey);
            this.invalidateCache(user.recipientKey());
            this.recipientData.updateUserRecipient(user.recipientKey(), record.getId().getRaw(), RecipientRecord.Type.CONTACT);
            this.recipientData.setMuteUntil(user.recipientKey(), record.getMuteUntil());
            Map<Field, Object> values = this.getValuesForContactRecord(record);
            this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, userKey.getKey()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private Map<Field, Object> getValuesForContactRecord(SignalContactRecord record) {
        HashMap<Field, Object> values = new HashMap<Field, Object>();
        record.getAci().ifPresent(aci -> values.put(Fields.ACI, aci.toString()));
        record.getPni().ifPresent(pni -> values.put(Fields.PNI, pni.toString()));
        values.put(Fields.E164, record.getNumber().orElse(null));
        values.put(Fields.PROFILE_GIVEN_NAME, record.getProfileGivenName().orElse(null));
        values.put(Fields.PROFILE_FAMILY_NAME, record.getProfileFamilyName().orElse(null));
        values.put(Fields.SYSTEM_GIVEN_NAME, record.getSystemGivenName().orElse(null));
        values.put(Fields.SYSTEM_FAMILY_NAME, record.getSystemFamilyName().orElse(null));
        values.put(Fields.PROFILE_KEY, record.getProfileKey().orElse(null));
        values.put(Fields.USERNAME, record.getUsername().orElse(null));
        values.put(Fields.NICK_GIVEN_NAME, record.getNickGivenName().orElse(null));
        values.put(Fields.NICK_FAMILY_NAME, record.getNickFamilyName().orElse(null));
        values.put(Fields.NICK_NOTE, record.getNickNote().orElse(null));
        return values;
    }

    private Map<Field, Object> getValuesForContactBackup(Backup.Contact backup) {
        HashMap<Field, Object> values = new HashMap<Field, Object>();
        if (backup.hasAci()) {
            values.put(Fields.ACI, UuidUtil.fromByteString((ByteString)backup.getAci()).toString());
        }
        if (backup.hasPni()) {
            values.put(Fields.PNI, UuidUtil.fromByteString((ByteString)backup.getPni()).toString());
        }
        if (backup.hasUsername()) {
            values.put(Fields.USERNAME, backup.getUsername());
        }
        if (backup.getE164() > 0L) {
            values.put(Fields.E164, Long.toString(backup.getE164()));
        }
        if (backup.getProfileKey() != null) {
            values.put(Fields.PROFILE_KEY, backup.getProfileKey().toByteArray());
        }
        if (backup.hasProfileFamilyName()) {
            values.put(Fields.PROFILE_FAMILY_NAME, backup.getProfileFamilyName());
        }
        if (backup.hasProfileGivenName()) {
            values.put(Fields.PROFILE_GIVEN_NAME, backup.getProfileGivenName());
        }
        return values;
    }

    private void update(UserKey userKey, SignalAccountRecord record) {
        try {
            UserDbRecord user = (UserDbRecord)this.findByKey(userKey);
            this.invalidateCache(user.recipientKey());
            this.recipientData.updateUserRecipient(user.recipientKey(), record.getId().getRaw(), RecipientRecord.Type.ACCOUNT);
            Map<Field, Object> values = this.getValuesForAccountRecord(record);
            this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, userKey.getKey()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private void invalidateCache(RecipientKey recipientKey) {
        try {
            Integer recipientId = (Integer)this.recipientData.getIdByKey(recipientKey);
            this.recipientIdMap.remove(recipientId);
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    private Map<Field, Object> getValuesForAccountRecord(SignalAccountRecord record) {
        HashMap<Field, Object> values = new HashMap<Field, Object>();
        record.getGivenName().ifPresent(name -> values.put(Fields.PROFILE_GIVEN_NAME, name));
        record.getFamilyName().ifPresent(name -> values.put(Fields.PROFILE_FAMILY_NAME, name));
        record.getProfileKey().ifPresent(profileKey -> values.put(Fields.PROFILE_KEY, profileKey));
        record.getAvatarUrlPath().ifPresent(url -> values.put(Fields.PROFILE_AVATAR_URL, url));
        values.put(Fields.USERNAME, record.getUsername());
        return values;
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        RECIPIENT_ID(FieldBuilder.newField("recipient_id", FieldType.INT).withNullable(false).withUnique(true).withReference("recipient", RecipientData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        E164(FieldBuilder.newField("e164", FieldType.SHORT_STRING).withUnique(true).withDefaultNull()),
        ACI(FieldBuilder.newField("aci", FieldType.SHORT_STRING).withUnique(true).withDefaultNull()),
        PNI(FieldBuilder.newField("pni", FieldType.SHORT_STRING).withUnique(true).withDefaultNull()),
        PROFILE_KEY(FieldBuilder.newField("profile_key", FieldType.BLOB).withDefaultNull()),
        EXPIRING_PROFILE_KEY_CREDENTIAL(FieldBuilder.newField("profile_key_credential", FieldType.SHORT_STRING).withDefaultNull()),
        SEALED_SENDER_MODE(FieldBuilder.newField("sealed_sender_mode", FieldType.INT).withDefaultValue(0)),
        ABOUT(FieldBuilder.newField("about", FieldType.SHORT_STRING).withDefaultNull()),
        ABOUT_EMOJI(FieldBuilder.newField("about_emoji", FieldType.SHORT_STRING).withDefaultNull()),
        REGISTERED(FieldBuilder.newField("registered", FieldType.INT).withDefaultValue(RegisteredState.UNKNOWN.id)),
        UNREGISTERED_TIMESTAMP(FieldBuilder.newField("unregistered_timestamp", FieldType.LONG).withDefaultValue(0)),
        PROFILE_AVATAR_URL(FieldBuilder.newField("profile_avatar_url", FieldType.SHORT_STRING).withDefaultNull()),
        PROFILE_AVATAR_FILE(FieldBuilder.newField("profile_avatar_file", FieldType.SHORT_STRING).withDefaultNull()),
        PROFILE_GIVEN_NAME(FieldBuilder.newField("profile_given_name", FieldType.SHORT_STRING).withDefaultNull()),
        PROFILE_FAMILY_NAME(FieldBuilder.newField("profile_family_name", FieldType.SHORT_STRING).withDefaultNull()),
        SYSTEM_GIVEN_NAME(FieldBuilder.newField("system_given_name", FieldType.SHORT_STRING).withDefaultNull()),
        SYSTEM_FAMILY_NAME(FieldBuilder.newField("system_family_name", FieldType.SHORT_STRING).withDefaultNull()),
        USERNAME(FieldBuilder.newField("username", FieldType.SHORT_STRING).withUnique(true).withDefaultNull()),
        NICK_GIVEN_NAME(FieldBuilder.newField("nick_given_name", FieldType.SHORT_STRING).withDefaultNull()),
        NICK_FAMILY_NAME(FieldBuilder.newField("nick_familty_name", FieldType.SHORT_STRING).withDefaultNull()),
        NICK_NOTE(FieldBuilder.newField("nick_notes", FieldType.SHORT_STRING).withDefaultNull()),
        PHONE_NUMBER_SHARING(FieldBuilder.newField("phone_number_sharing", FieldType.INT).withDefaultValue(PhoneNumberSharingMode.UNKNOWN.id)),
        PHONE_NUMBER_DISCOVERABLE(FieldBuilder.newField("phone_number_discoverable", FieldType.BOOLEAN).withDefaultValue(false));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return UserData.TABLE_NAME;
        }
    }
}

