/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.recipient;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.distributionlist.DistributionListKey;
import io.privacyresearch.clientdata.group.GroupKey;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.clientdata.user.color.AvatarColor;
import io.privacyresearch.clientdata.user.color.AvatarColorHash;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecipientData
extends EntityKeyData<RecipientRecord, RecipientKey> {
    private static final Logger LOG = Logger.getLogger(RecipientData.class.getName());
    public static final String TABLE_NAME = "recipient";

    public RecipientData(Connection connection) {
        super(connection, TABLE_NAME, List.of(Fields.values()), RecipientKey::new);
    }

    @Override
    public RecipientRecord construct(ResultSet resultSet) throws SQLException {
        return new RecipientRecord(new RecipientKey((byte[])Fields.ENTITY_KEY.getValue(resultSet)), RecipientRecord.Type.fromValue((Integer)Fields.TYPE.getValue(resultSet)), (Boolean)Fields.BLOCKED.getValue(resultSet), (Integer)Fields.MESSAGE_EXPIRATION_TIME.getValue(resultSet), (Integer)Fields.EXPIRE_TIMER_VERSION.getValue(resultSet), (Long)Fields.MUTE_UNTIL.getValue(resultSet), (Long)Fields.UNREGISTERED_TIMESTAMP.getValue(resultSet), AvatarColor.deserialize((String)Fields.AVATAR_COLOR.getValue(resultSet)));
    }

    public RecipientKey createDistributionListRecipient(DistributionListKey distributionListKey) {
        RecipientKey recipientKey = new RecipientKey();
        HashMap<Field, Object> values = new HashMap<Field, Object>();
        values.put(Fields.ENTITY_KEY, recipientKey.getKey());
        values.put(Fields.AVATAR_COLOR, AvatarColorHash.forDistributionListKey(distributionListKey).serialize());
        values.put(Fields.TYPE, RecipientRecord.Type.DISTRIBUTION_LIST.type);
        values.put(Fields.BLOCKED, false);
        try {
            int inserted = this.databaseLayer.insert(this.getTableName()).values(values).execute();
            if (inserted == 1) {
                return recipientKey;
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public RecipientKey createGroupRecipient(GroupKey groupKey, byte[] storageId, boolean blocked) {
        RecipientKey recipientKey = new RecipientKey();
        HashMap<Field, Object> values = new HashMap<Field, Object>();
        values.put(Fields.ENTITY_KEY, recipientKey.getKey());
        values.put(Fields.AVATAR_COLOR, AvatarColorHash.forGroupKey(groupKey).serialize());
        values.put(Fields.TYPE, RecipientRecord.Type.GV2.type);
        values.put(Fields.STORAGE_SERVICE_ID, storageId);
        values.put(Fields.BLOCKED, blocked);
        try {
            int inserted = this.databaseLayer.insert(this.getTableName()).values(values).execute();
            if (inserted == 1) {
                return recipientKey;
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public RecipientKey createUserRecipient(byte[] storageId, RecipientRecord.Type type, AvatarColor avatarColor) {
        RecipientKey recipientKey = new RecipientKey();
        HashMap<Field, Object> values = new HashMap<Field, Object>();
        values.put(Fields.ENTITY_KEY, recipientKey.getKey());
        values.put(Fields.AVATAR_COLOR, avatarColor.serialize());
        values.put(Fields.TYPE, type.type);
        if (storageId != null) {
            values.put(Fields.STORAGE_SERVICE_ID, storageId);
        }
        try {
            int inserted = this.databaseLayer.insert(this.getTableName()).values(values).execute();
            if (inserted == 1) {
                return recipientKey;
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void updateUserRecipient(RecipientKey recipientKey, byte[] storageId, RecipientRecord.Type type) {
        HashMap<Field, Object> values = new HashMap<Field, Object>();
        values.put(Fields.TYPE, type.type);
        values.put(Fields.STORAGE_SERVICE_ID, storageId);
        try {
            this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, recipientKey.getKey()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void updateGroupRecipient(RecipientKey recipientKey, byte[] storageId, RecipientRecord.Type type) {
        HashMap<Field, Object> values = new HashMap<Field, Object>();
        values.put(Fields.TYPE, type.type);
        values.put(Fields.STORAGE_SERVICE_ID, storageId);
        try {
            this.databaseLayer.update(this.getTableName()).values(values).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, recipientKey.getKey()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void setExpireMessages(RecipientKey recipientKey, int expiration) {
        try {
            this.databaseLayer.update(this.getTableName()).values(Map.of(Fields.MESSAGE_EXPIRATION_TIME, expiration)).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, recipientKey.getKey()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void setExpireTimerVersion(RecipientKey recipientKey, int version) {
        try {
            this.databaseLayer.update(this.getTableName()).values(Map.of(Fields.EXPIRE_TIMER_VERSION, version)).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, recipientKey.getKey()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void setMuteUntil(RecipientKey recipientKey, long muteUntil) {
        try {
            this.databaseLayer.update(this.getTableName()).values(Map.of(Fields.MUTE_UNTIL, muteUntil)).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, recipientKey.getKey()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void setBlocked(RecipientKey recipientKey, boolean blocked) {
        try {
            this.databaseLayer.update(this.getTableName()).values(Map.of(Fields.BLOCKED, blocked)).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, recipientKey.getKey()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void unregister(RecipientKey recipientKey, long unregisteredTimestamp) {
        try {
            this.databaseLayer.update(this.getTableName()).values(Map.of(Fields.UNREGISTERED_TIMESTAMP, unregisteredTimestamp)).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, recipientKey.getKey()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public List<RecipientRecord> getByType(RecipientRecord.Type type) {
        ArrayList<RecipientRecord> arrayList;
        block9: {
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.TYPE, type.type))).execute();
            try {
                ArrayList<RecipientRecord> records = new ArrayList<RecipientRecord>();
                while (result.next()) {
                    records.add(this.construct(result));
                }
                arrayList = records;
                if (result == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RecipientRecord getByStorageId(byte[] storageId) {
        try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.STORAGE_SERVICE_ID, storageId))).execute();){
            ArrayList records = new ArrayList();
            if (result.next()) {
                RecipientRecord recipientRecord2 = this.construct(result);
                return recipientRecord2;
            }
            RecipientRecord recipientRecord = null;
            return recipientRecord;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public List<byte[]> getAccountStorageId() {
        return this.getStorageIdsByType(RecipientRecord.Type.ACCOUNT);
    }

    public List<byte[]> getContactStorageIds() {
        return this.getStorageIdsByType(RecipientRecord.Type.CONTACT);
    }

    public List<byte[]> getGroupV2StorageIds() {
        return this.getStorageIdsByType(RecipientRecord.Type.GV2);
    }

    private List<byte[]> getStorageIdsByType(RecipientRecord.Type type) {
        ArrayList<byte[]> arrayList;
        block9: {
            ResultSet result = this.databaseLayer.select(List.of(Fields.STORAGE_SERVICE_ID)).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.TYPE, type.type))).execute();
            try {
                ArrayList<byte[]> entries = new ArrayList<byte[]>();
                while (result.next()) {
                    entries.add((byte[])Fields.STORAGE_SERVICE_ID.getValue(result));
                }
                arrayList = entries;
                if (result == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getStorageIdByRecipientKey(RecipientKey key) {
        try (ResultSet result = this.databaseLayer.select(List.of(Fields.STORAGE_SERVICE_ID)).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, key.getKey()))).execute();){
            if (result.next()) {
                byte[] byArray2 = (byte[])Fields.STORAGE_SERVICE_ID.getValue(result);
                return byArray2;
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        TYPE(FieldBuilder.newField("type", FieldType.INT).withDefaultValue(RecipientRecord.Type.CONTACT.type)),
        BLOCKED(FieldBuilder.newField("blocked", FieldType.BOOLEAN).withDefaultValue(false)),
        STORAGE_SERVICE_ID(FieldBuilder.newField("storage_service_id", FieldType.BLOB).withUnique(true).withDefaultNull()),
        AVATAR_COLOR(FieldBuilder.newField("avatar_color", FieldType.SHORT_STRING).withDefaultNull()),
        MUTE_UNTIL(FieldBuilder.newField("mute_until", FieldType.LONG).withDefaultValue(-1)),
        UNREGISTERED_TIMESTAMP(FieldBuilder.newField("unregistered_timestamp", FieldType.LONG).withDefaultValue(0)),
        MESSAGE_EXPIRATION_TIME(FieldBuilder.newField("message_expiration_time", FieldType.INT).withDefaultValue(0)),
        EXPIRE_TIMER_VERSION(FieldBuilder.newField("expire_timer_version", FieldType.INT).withDefaultValue(1));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return RecipientData.TABLE_NAME;
        }
    }
}

