/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.quote;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.message.MessageData;
import io.privacyresearch.clientdata.message.MessageDbRecord;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.quote.QuoteKey;
import io.privacyresearch.clientdata.quote.QuoteRecord;
import io.privacyresearch.clientdata.util.BodyRangeUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QuoteData
extends EntityKeyData<QuoteRecord, QuoteKey> {
    private static final Logger LOG = Logger.getLogger(QuoteData.class.getName());
    public static final String TABLE_NAME = "quote";
    private final MessageData messageData;

    public QuoteData(Connection connection, MessageData messageData) {
        super(connection, TABLE_NAME, List.of(Fields.values()), QuoteKey::new);
        this.messageData = messageData;
    }

    @Override
    public QuoteRecord construct(ResultSet resultSet) throws SQLException {
        MessageKey messageKey = (MessageKey)this.messageData.getKeyById(Fields.MESSAGE_ID.getValue(resultSet));
        MessageDbRecord quotedMessage = (MessageDbRecord)this.messageData.findById(Fields.QUOTED_MESSAGE_ID.getValue(resultSet));
        MessageKey quotedMessageKey = quotedMessage == null ? null : quotedMessage.key();
        return new QuoteRecord(new QuoteKey((byte[])Fields.ENTITY_KEY.getValue(resultSet)), messageKey, quotedMessageKey, (String)Fields.BODY.getValue(resultSet), BodyRangeUtil.rawToBodyRanges((String)Fields.MENTIONS.getValue(resultSet)), QuoteRecord.Type.fromCode((Integer)Fields.TYPE.getValue(resultSet)));
    }

    public QuoteKey addQuote(QuoteRecord quote) {
        try {
            Integer messageId = (Integer)this.messageData.getIdByKey(quote.messageKey());
            if (messageId == null) {
                throw new IllegalStateException("A message with key " + String.valueOf(quote.messageKey()) + " should exist!");
            }
            Integer quotedMessageId = null;
            if (quote.quotedMessageKey() != null) {
                quotedMessageId = (Integer)this.messageData.getIdByKey(quote.quotedMessageKey());
            }
            if (quotedMessageId == null) {
                LOG.info("Original of quote not found -- could be expired or deleted");
            }
            HashMap<Field, Object> values = new HashMap<Field, Object>();
            values.put(Fields.ENTITY_KEY, quote.key().getKey());
            values.put(Fields.MESSAGE_ID, messageId);
            values.put(Fields.QUOTED_MESSAGE_ID, quotedMessageId);
            values.put(Fields.BODY, quote.body());
            values.put(Fields.MENTIONS, BodyRangeUtil.bodyRangesToRaw(quote.mentions()));
            values.put(Fields.TYPE, quote.type().code);
            int inserted = this.databaseLayer.insert(this.getTableName()).values(values).execute();
            if (inserted == 1) {
                return quote.key();
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QuoteRecord findQuoteByMessageKey(MessageKey messageKey) {
        try {
            Integer messageId = (Integer)this.messageData.getIdByKey(messageKey);
            if (messageId == null) {
                return null;
            }
            try (ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.MESSAGE_ID, messageId))).execute();){
                if (result.next()) {
                    QuoteRecord quoteRecord2 = this.construct(result);
                    return quoteRecord2;
                }
                QuoteRecord quoteRecord = null;
                return quoteRecord;
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        MESSAGE_ID(FieldBuilder.newField("message_id", FieldType.INT).withNullable(false).withReference("message", MessageData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        QUOTED_MESSAGE_ID(FieldBuilder.newField("quoted_message_id", FieldType.INT).withNullable(true).withReference("message", MessageData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        BODY(FieldBuilder.newField("body", FieldType.TEXT).withNullable(false)),
        MENTIONS(FieldBuilder.newField("mentions", FieldType.TEXT)),
        TYPE(FieldBuilder.newField("type", FieldType.INT).withNullable(false).withDefaultValue(QuoteRecord.Type.NORMAL.code));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return QuoteData.TABLE_NAME;
        }
    }
}

