/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.keyvalue;

import io.privacyresearch.clientdata.util.UUIDUtil;
import java.util.Base64;
import java.util.UUID;
import org.whispersystems.signalservice.internal.storage.protos.AccountRecord;

public class UsernameLink {
    final byte[] entropy;
    final byte[] serverId;
    int color = -1;

    public UsernameLink(byte[] entropy, byte[] serverId, int color) {
        this.entropy = entropy;
        this.serverId = serverId;
        this.color = color;
    }

    public UsernameLink(byte[] entropy, UUID serverId) {
        this.entropy = entropy;
        this.serverId = UUIDUtil.toByteArray(serverId);
    }

    public UsernameLink(AccountRecord.UsernameLink ulink) {
        this.entropy = ulink.getEntropy().toByteArray();
        this.serverId = ulink.getServerId().toByteArray();
        this.color = ulink.getColor().getNumber();
    }

    public byte[] getEntropy() {
        return this.entropy;
    }

    public byte[] getServerId() {
        return this.serverId;
    }

    public int getColor() {
        return this.color;
    }

    public String getLink() {
        byte[] buffer = new byte[48];
        System.arraycopy(this.entropy, 0, buffer, 0, 32);
        System.arraycopy(this.serverId, 0, buffer, 32, 16);
        return Base64.getEncoder().encodeToString(buffer);
    }
}

