/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.keys;

import io.privacyresearch.clientdata.BaseData;
import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ecc.Curve;
import org.signal.libsignal.protocol.ecc.ECKeyPair;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.state.SignedPreKeyRecord;
import org.whispersystems.signalservice.api.push.ServiceId;

public class SignedPreKeyData
extends BaseData<SignedPreKeyRecord> {
    private static final Logger LOG = Logger.getLogger(SignedPreKeyData.class.getName());
    public static final String TABLE_NAME = "signed_prekeys";

    public SignedPreKeyData(Connection connection) {
        super(connection, TABLE_NAME, List.of(Fields.values()));
    }

    @Override
    public SignedPreKeyRecord construct(ResultSet resultSet) throws SQLException {
        try {
            int id = (Integer)Fields.KEY_ID.getValue(resultSet);
            byte[] publicBytes = (byte[])Fields.PUBLIC_KEY.getValue(resultSet);
            byte[] privateBytes = (byte[])Fields.PRIVATE_KEY.getValue(resultSet);
            byte[] sig = (byte[])Fields.SIGNATURE.getValue(resultSet);
            long timestamp = (Long)Fields.TIMESTAMP.getValue(resultSet);
            ECPublicKey publicKey = new ECPublicKey(publicBytes);
            ECPrivateKey privateKey = Curve.decodePrivatePoint((byte[])privateBytes);
            ECKeyPair ecKeyPair = new ECKeyPair(publicKey, privateKey);
            SignedPreKeyRecord answer = new SignedPreKeyRecord(id, timestamp, ecKeyPair, sig);
            return answer;
        }
        catch (InvalidKeyException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void add(ServiceId serviceId, SignedPreKeyRecord signedPreKeyRecord) throws SQLException {
        LOG.info("Add a prekey for serviceid " + serviceId.toString());
        try {
            ECKeyPair signedPreKeyKeyPair = signedPreKeyRecord.getKeyPair();
            Map<Field, Object> values = Map.ofEntries(Map.entry(Fields.ACCOUNT_ID, serviceId.toString()), Map.entry(Fields.KEY_ID, signedPreKeyRecord.getId()), Map.entry(Fields.PUBLIC_KEY, signedPreKeyKeyPair.getPublicKey().serialize()), Map.entry(Fields.PRIVATE_KEY, signedPreKeyKeyPair.getPrivateKey().serialize()), Map.entry(Fields.TIMESTAMP, signedPreKeyRecord.getTimestamp()), Map.entry(Fields.SIGNATURE, signedPreKeyRecord.getSignature()));
            this.databaseLayer.insert(this.getTableName()).values(values).execute();
        }
        catch (SQLException | InvalidKeyException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public List<SignedPreKeyRecord> getAllSignedPreKeys() throws SQLException {
        return this.findAll();
    }

    public SignedPreKeyRecord findById(ServiceId serviceId, int id) {
        try {
            SignedPreKeyRecord answer = (SignedPreKeyRecord)super.findById(id);
            return answer;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void deleteByKeyId(int keyId) {
        try {
            List<DatabaseLayer.BinaryOperandField> where = List.of(new DatabaseLayer.BinaryOperandField(Fields.KEY_ID, keyId));
            this.databaseLayer.delete(this.getTableName()).where(where).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public static enum Fields implements Field
    {
        ACCOUNT_ID(FieldBuilder.newField("account_id", FieldType.SHORT_STRING)),
        KEY_ID(FieldBuilder.newField("key_id", FieldType.INT).withPrimaryKey(true)),
        PUBLIC_KEY(FieldBuilder.newField("public_key", FieldType.BLOB)),
        PRIVATE_KEY(FieldBuilder.newField("private_key", FieldType.BLOB)),
        SIGNATURE(FieldBuilder.newField("signature", FieldType.BLOB)),
        TIMESTAMP(FieldBuilder.newField("timestamp", FieldType.LONG));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return SignedPreKeyData.TABLE_NAME;
        }
    }
}

