/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.keys;

import io.privacyresearch.clientdata.BaseData;
import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.groups.state.SenderKeyRecord;
import org.whispersystems.signalservice.api.push.DistributionId;

public class SenderKeyData
extends BaseData<SenderKeyRecord> {
    private static final Logger LOG = Logger.getLogger(SenderKeyData.class.getName());
    public static final String TABLE_NAME = "sender_keys";

    public SenderKeyData(Connection connection) {
        super(connection, TABLE_NAME, List.of(Fields.values()));
    }

    @Override
    public SenderKeyRecord construct(ResultSet resultSet) throws SQLException {
        byte[] record = (byte[])Fields.RECORD.getValue(resultSet);
        try {
            return new SenderKeyRecord(record);
        }
        catch (InvalidMessageException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void add(SignalProtocolAddress address, DistributionId distributionId, SenderKeyRecord record) {
        try {
            int updateCount = this.databaseLayer.update(this.getTableName()).values(Map.of(Fields.RECORD, record.serialize())).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ADDRESS, address.getName()), new DatabaseLayer.BinaryOperandField(Fields.DEVICE, address.getDeviceId()), new DatabaseLayer.BinaryOperandField(Fields.DISTRIBUTION_ID, distributionId.toString()))).execute();
            if (updateCount <= 0) {
                this.databaseLayer.insert(this.getTableName()).values(Map.ofEntries(Map.entry(Fields.ADDRESS, address.getName()), Map.entry(Fields.DEVICE, address.getDeviceId()), Map.entry(Fields.DISTRIBUTION_ID, distributionId.toString()), Map.entry(Fields.RECORD, record.serialize()), Map.entry(Fields.CREATED_AT, System.currentTimeMillis()))).onConflict(DatabaseLayer.ConflictMode.REPLACE).execute();
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public SenderKeyRecord load(SignalProtocolAddress address, DistributionId distributionId) {
        try {
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ADDRESS, address.getName()), new DatabaseLayer.BinaryOperandField(Fields.DEVICE, address.getDeviceId()), new DatabaseLayer.BinaryOperandField(Fields.DISTRIBUTION_ID, distributionId.toString()))).execute();
            if (result.next()) {
                return this.construct(result);
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public long getCreatedTime(SignalProtocolAddress address, DistributionId distributionId) {
        try {
            ResultSet result = this.databaseLayer.select(List.of(Fields.CREATED_AT)).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ADDRESS, address.getName()), new DatabaseLayer.BinaryOperandField(Fields.DEVICE, address.getDeviceId()), new DatabaseLayer.BinaryOperandField(Fields.DISTRIBUTION_ID, distributionId.toString()))).execute();
            if (result.next()) {
                return result.getLong(1);
            }
            return -1L;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void deleteAllFor(SignalProtocolAddress address, DistributionId distributionId) {
        try {
            this.databaseLayer.delete(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ADDRESS, address.getName()), new DatabaseLayer.BinaryOperandField(Fields.DEVICE, address.getDeviceId()), new DatabaseLayer.BinaryOperandField(Fields.DISTRIBUTION_ID, distributionId.toString()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void deleteAll() {
        try {
            this.databaseLayer.delete(this.getTableName()).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static enum Fields implements Field
    {
        ADDRESS(FieldBuilder.newField("address", FieldType.SHORT_STRING).withNullable(false)),
        DEVICE(FieldBuilder.newField("device", FieldType.INT).withNullable(false)),
        DISTRIBUTION_ID(FieldBuilder.newField("distribution_id", FieldType.SHORT_STRING).withNullable(false)),
        RECORD(FieldBuilder.newField("record", FieldType.BLOB).withNullable(false)),
        CREATED_AT(FieldBuilder.newField("created_at", FieldType.LONG).withNullable(false));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return SenderKeyData.TABLE_NAME;
        }
    }
}

