/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.channel;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.channel.ChannelKey;
import io.privacyresearch.clientdata.channel.ChannelRecord;
import io.privacyresearch.clientdata.group.GroupData;
import io.privacyresearch.clientdata.recipient.RecipientData;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.clientdata.user.UserData;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChannelData
extends EntityKeyData<ChannelRecord, ChannelKey> {
    private static final Logger LOG = Logger.getLogger(ChannelData.class.getName());
    public static final String TABLE_NAME = "channel";
    private final RecipientData recipientData;

    public ChannelData(Connection connection, RecipientData recipientData) {
        super(connection, TABLE_NAME, List.of(Fields.values()), ChannelKey::new);
        this.recipientData = recipientData;
    }

    @Override
    public ChannelRecord construct(ResultSet resultSet) throws SQLException {
        RecipientRecord recipientRecord = (RecipientRecord)this.recipientData.findById(Fields.RECIPIENT_ID.getValue(resultSet));
        return new ChannelRecord(new ChannelKey((byte[])Fields.ENTITY_KEY.getValue(resultSet)), recipientRecord, (Integer)Fields.TYPE.getValue(resultSet), (Long)Fields.DATE.getValue(resultSet), (Boolean)Fields.ARCHIVED.getValue(resultSet), (Long)Fields.LAST_SEEN.getValue(resultSet), (Boolean)Fields.HAS_SENT.getValue(resultSet), (Boolean)Fields.LAST_SCROLLED.getValue(resultSet), (Boolean)Fields.PINNED.getValue(resultSet), (Boolean)Fields.ACTIVE.getValue(resultSet), (Long)Fields.LAST_READ.getValue(resultSet));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChannelKey findByRecipientKey(RecipientKey recipientKey) {
        try {
            Integer recipientId = (Integer)this.recipientData.getIdByKey(recipientKey);
            if (recipientId == null) {
                return null;
            }
            try (ResultSet result = this.databaseLayer.select(List.of(Fields.ENTITY_KEY)).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.RECIPIENT_ID, recipientId))).execute();){
                if (result.next()) {
                    ChannelKey channelKey2 = new ChannelKey(result.getBytes(1));
                    return channelKey2;
                }
                ChannelKey channelKey = null;
                return channelKey;
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public List<ChannelRecord> queryChannels(String query, int limit, int offset) {
        ArrayList<ChannelRecord> arrayList;
        block10: {
            if (query == null || query.isEmpty()) {
                return List.of();
            }
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).join(DatabaseLayer.Join.left(UserData.Fields.RECIPIENT_ID, Fields.RECIPIENT_ID)).join(DatabaseLayer.Join.left(GroupData.Fields.RECIPIENT_ID, Fields.RECIPIENT_ID)).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ARCHIVED, false), DatabaseLayer.OperandField.or(List.of(new DatabaseLayer.BinaryOperandField((Field)GroupData.Fields.TITLE, "LIKE", "%" + query + "%"), new DatabaseLayer.BinaryOperandField((Field)UserData.Fields.E164, "LIKE", "%" + query + "%"), new DatabaseLayer.BinaryOperandField((Field)UserData.Fields.USERNAME, "LIKE", "%" + query + "%"), new DatabaseLayer.BinaryOperandField((Field)UserData.Fields.PROFILE_GIVEN_NAME, "LIKE", "%" + query + "%"), new DatabaseLayer.BinaryOperandField((Field)UserData.Fields.PROFILE_FAMILY_NAME, "LIKE", "%" + query + "%"), new DatabaseLayer.BinaryOperandField((Field)UserData.Fields.SYSTEM_GIVEN_NAME, "LIKE", "%" + query + "%"), new DatabaseLayer.BinaryOperandField((Field)UserData.Fields.SYSTEM_FAMILY_NAME, "LIKE", "%" + query + "%"))))).orderBy(Fields.LAST_SEEN, DatabaseLayer.Order.DESC).orderBy(Fields.ID, DatabaseLayer.Order.DESC).limit(limit).offset(offset).execute();
            try {
                ArrayList<ChannelRecord> channels = new ArrayList<ChannelRecord>();
                while (result.next()) {
                    channels.add(this.construct(result));
                }
                arrayList = channels;
                if (result == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return arrayList;
    }

    public void updateLastRead(ChannelKey channelKey, long lastRead) {
        try {
            this.databaseLayer.update(this.getTableName()).values(Map.ofEntries(Map.entry(Fields.LAST_READ, lastRead))).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.ENTITY_KEY, channelKey.getKey()))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public ChannelKey createForRecipient(RecipientKey recipientKey) {
        return this.createForRecipient(recipientKey, DistributionType.DEFAULT);
    }

    private ChannelKey createForRecipient(RecipientKey recipientKey, DistributionType distributionType) {
        try {
            int inserted;
            Integer recipientId = (Integer)this.recipientData.getIdByKey(recipientKey);
            if (recipientId == null) {
                throw new IllegalArgumentException("A recipient with key " + String.valueOf(recipientKey) + " should exist!");
            }
            ChannelKey channelKey = new ChannelKey();
            long date = System.currentTimeMillis();
            HashMap<Field, Object> values = new HashMap<Field, Object>(Map.ofEntries(Map.entry(Fields.ENTITY_KEY, channelKey.getKey()), Map.entry(Fields.DATE, date - date % 1000L), Map.entry(Fields.RECIPIENT_ID, recipientId)));
            RecipientRecord recipient = (RecipientRecord)this.recipientData.findById(recipientId);
            if (recipient.isGroup()) {
                values.put(Fields.TYPE, distributionType.type);
            }
            if ((inserted = this.databaseLayer.insert(this.getTableName()).values(values).execute()) == 1) {
                return channelKey;
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        DATE(FieldBuilder.newField("date", FieldType.LONG).withDefaultValue(0)),
        RECIPIENT_ID(FieldBuilder.newField("recipient_id", FieldType.INT).withNullable(false).withReference("recipient", RecipientData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        TYPE(FieldBuilder.newField("type", FieldType.INT).withDefaultValue(0)),
        ARCHIVED(FieldBuilder.newField("archived", FieldType.BOOLEAN).withDefaultValue(false)),
        LAST_READ(FieldBuilder.newField("last_read", FieldType.LONG).withDefaultValue(0)),
        LAST_SEEN(FieldBuilder.newField("last_seen", FieldType.LONG).withDefaultValue(0)),
        HAS_SENT(FieldBuilder.newField("has_sent", FieldType.BOOLEAN).withDefaultValue(false)),
        LAST_SCROLLED(FieldBuilder.newField("last_scrolled", FieldType.BOOLEAN).withDefaultValue(false)),
        PINNED(FieldBuilder.newField("pinned", FieldType.BOOLEAN).withDefaultValue(false)),
        ACTIVE(FieldBuilder.newField("active", FieldType.BOOLEAN).withDefaultValue(false));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return ChannelData.TABLE_NAME;
        }
    }

    public static enum DistributionType {
        DEFAULT(2),
        BROADCAST(1),
        CONVERSATION(2),
        ARCHIVE(3),
        INBOX_ZERO(4);

        public final int type;

        private DistributionType(int type) {
            this.type = type;
        }
    }
}

