/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata.badge;

import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.badge.BadgeDbRecord;
import io.privacyresearch.clientdata.badge.BadgeKey;
import io.privacyresearch.clientdata.user.UserData;
import io.privacyresearch.clientdata.user.UserKey;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.whispersystems.signalservice.api.profiles.SignalServiceProfile;

public class BadgeData
extends EntityKeyData<BadgeDbRecord, BadgeKey> {
    private static final Logger LOG = Logger.getLogger(BadgeData.class.getName());
    public static final String TABLE_NAME = "badge";
    private final UserData userData;

    public BadgeData(Connection connection, UserData userData) {
        super(connection, TABLE_NAME, List.of(Fields.values()), BadgeKey::new);
        this.userData = userData;
    }

    @Override
    public BadgeDbRecord construct(ResultSet resultSet) throws SQLException {
        UserKey userKey = (UserKey)this.userData.getKeyById(Fields.USER_ID.getValue(resultSet));
        return new BadgeDbRecord(new BadgeKey((byte[])Fields.ENTITY_KEY.getValue(resultSet)), userKey, (String)Fields.BADGEID.getValue(resultSet), (String)Fields.CATEGORY.getValue(resultSet), (String)Fields.NAME.getValue(resultSet), (String)Fields.DESCRIPTION.getValue(resultSet), (Long)Fields.DURATION.getValue(resultSet), (Long)Fields.EXPIRATION.getValue(resultSet), (Boolean)Fields.VISIBLE.getValue(resultSet));
    }

    public BadgeKey createBadge(UserKey userKey, SignalServiceProfile.Badge signalBadge) {
        try {
            Integer userId = (Integer)this.userData.getIdByKey(userKey);
            if (userId == null) {
                throw new IllegalStateException("A user with key " + String.valueOf(userKey) + " should exist!");
            }
            BadgeKey badgeKey = new BadgeKey();
            HashMap<Field, Object> values = new HashMap<Field, Object>();
            values.put(Fields.ENTITY_KEY, badgeKey.getKey());
            values.put(Fields.USER_ID, userId);
            values.put(Fields.BADGEID, signalBadge.getId());
            values.put(Fields.CATEGORY, signalBadge.getCategory());
            values.put(Fields.NAME, signalBadge.getName());
            values.put(Fields.DESCRIPTION, signalBadge.getDescription());
            values.put(Fields.DURATION, signalBadge.getDuration());
            values.put(Fields.EXPIRATION, signalBadge.getExpiration() == null ? 0L : signalBadge.getExpiration().longValue());
            values.put(Fields.VISIBLE, signalBadge.isVisible());
            int inserted = this.databaseLayer.insert(this.getTableName()).values(values).execute();
            if (inserted == 1) {
                return badgeKey;
            }
            return null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public void deleteByUserKey(UserKey userKey) {
        try {
            Integer userId = (Integer)this.userData.getIdByKey(userKey);
            if (userId == null) {
                return;
            }
            this.databaseLayer.delete(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.USER_ID, userId))).execute();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public List<BadgeDbRecord> getByUserKey(UserKey userKey) {
        ArrayList<BadgeDbRecord> arrayList;
        block10: {
            Integer userId = (Integer)this.userData.getIdByKey(userKey);
            if (userId == null) {
                return new ArrayList<BadgeDbRecord>();
            }
            ResultSet result = this.databaseLayer.select(this.getFields()).from(this.getTableName()).where(List.of(new DatabaseLayer.BinaryOperandField(Fields.USER_ID, userId))).execute();
            try {
                ArrayList<BadgeDbRecord> records = new ArrayList<BadgeDbRecord>();
                while (result.next()) {
                    records.add(this.construct(result));
                }
                arrayList = records;
                if (result == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }
            result.close();
        }
        return arrayList;
    }

    public static enum Fields implements Field
    {
        ID(FieldBuilder.newField("_id", FieldType.INT).withPrimaryKey(true).withAutoincrement(true)),
        ENTITY_KEY(FieldBuilder.newField("entity_key", FieldType.BLOB).withEntityKey(true).withNullable(false).withDefaultValue(0)),
        USER_ID(FieldBuilder.newField("user_id", FieldType.INT).withNullable(false).withDefaultValue(0).withReference("users", UserData.Fields.ID, FieldReference.OnDelete.CASCADE)),
        BADGEID(FieldBuilder.newField("badgeid", FieldType.SHORT_STRING).withNullable(false)),
        CATEGORY(FieldBuilder.newField("category", FieldType.SHORT_STRING)),
        NAME(FieldBuilder.newField("name", FieldType.SHORT_STRING)),
        DESCRIPTION(FieldBuilder.newField("description", FieldType.SHORT_STRING)),
        DURATION(FieldBuilder.newField("duration", FieldType.LONG)),
        EXPIRATION(FieldBuilder.newField("expiration", FieldType.LONG)),
        VISIBLE(FieldBuilder.newField("visible", FieldType.BOOLEAN));

        public final Field field;

        private Fields(FieldBuilder builder) {
            this.field = builder.build();
        }

        @Override
        public Field getFieldImpl() {
            return this.field;
        }

        @Override
        public String getTableName() {
            return BadgeData.TABLE_NAME;
        }
    }
}

