/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata;

import io.privacyresearch.clientdata.BaseData;
import io.privacyresearch.clientdata.ColumnInfo;
import io.privacyresearch.clientdata.DatabaseLayer;
import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.EntityKeyData;
import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldBuilder;
import io.privacyresearch.clientdata.FieldReference;
import io.privacyresearch.clientdata.FieldType;
import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.attachment.AttachmentData;
import io.privacyresearch.clientdata.attachment.AttachmentKey;
import io.privacyresearch.clientdata.canvas.CanvasData;
import io.privacyresearch.clientdata.channel.ChannelData;
import io.privacyresearch.clientdata.channel.ChannelKey;
import io.privacyresearch.clientdata.draft.DraftData;
import io.privacyresearch.clientdata.draft.DraftKey;
import io.privacyresearch.clientdata.group.GroupData;
import io.privacyresearch.clientdata.group.GroupKey;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.group.MembershipData;
import io.privacyresearch.clientdata.message.MessageData;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.message.ReceiptData;
import io.privacyresearch.clientdata.quote.QuoteData;
import io.privacyresearch.clientdata.quote.QuoteKey;
import io.privacyresearch.clientdata.reaction.ReactionData;
import io.privacyresearch.clientdata.reaction.ReactionKey;
import io.privacyresearch.clientdata.recipient.RecipientData;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.clientdata.sticker.StickerData;
import io.privacyresearch.clientdata.sticker.StickerKey;
import io.privacyresearch.clientdata.sticker.StickerPackData;
import io.privacyresearch.clientdata.sticker.StickerPackKey;
import io.privacyresearch.clientdata.user.UserData;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.clientdata.user.UserKey;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupIdentifier;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;

public class PatchTablesBean {
    private static final Logger LOG = Logger.getLogger(PatchTablesBean.class.getName());
    private final SqliteStorageBean storageBean;
    private final DatabaseLayer databaseLayer;

    public PatchTablesBean(SqliteStorageBean storageBean) {
        this.storageBean = storageBean;
        this.databaseLayer = new DatabaseLayer(storageBean.getConnection());
    }

    public void patchTables() throws SQLException {
        this.channelData_lastRead();
        this.messageData_mergeMentionIntoBodyRange();
        this.stickers_createTables();
        this.recipientData_phonePrivacy();
        this.draftData_createTable();
        this.channelData_entityKey();
        this.stickerPackData_entityKey();
        this.stickerData_entityKey();
        this.quoteData_entityKey();
        this.reactionData_entityKey();
        this.attachmentData_entityKey();
        this.draftData_entityKey();
        this.messageData_entityKey();
        this.recipientData_entityKey();
        this.groupData_entityKey();
        this.userData_createTable();
        this.membershipData_useUserIds();
        this.searchRecipientData_dropOldTriggers();
        this.groupData_removeBlockedColumn();
        this.stickers_switchPrimaryKey();
        this.channel_switchPrimaryKey();
        this.message_switchPrimaryKey();
        this.recipient_switchPrimaryKey();
        this.quoteData_quotedMessageIdNullable();
        this.messageData_removeTypeColumn();
        this.searchRecipientData_dropTables();
        this.callData_createTable();
        this.badgeData_createTable();
        this.messageData_addFlagsColumn();
        this.userData_addNickColumns();
        this.recipientData_addMuteUntil();
        this.receiptData_createTable();
        this.messageData_removeChannelIdColumn();
        this.distributionListData_createTable();
        this.groupData_addAvatarColumns();
        this.recipientData_addUnregisteredTimestampColumn();
        this.channelData_createForAllUsers();
        this.addMessageFieldIndices();
        this.addMessageEntityIndex();
        this.attachmentData_addEncryptedSize();
        this.recipientData_addExpireTimerVersionColumn();
        this.messageData_addViewOnceColumn();
        this.canvasData_createTable();
        this.canvasData_addUuidColumn();
    }

    private void channelData_lastRead() throws SQLException {
        this.storageBean.getChannelData().addColumn(ChannelData.Fields.LAST_READ);
    }

    private void messageData_mergeMentionIntoBodyRange() throws SQLException {
        List<String> columnNames = this.storageBean.getMessageData().getColumnNames();
        if (columnNames.contains("mentions")) {
            this.databaseLayer.update("message").values(List.of(new DatabaseLayer.RawInsertableField((Field)MessageData.Fields.BODY_RANGES, String.format("%s || ';' || %s", MessageData.Fields.BODY_RANGES.getColumnName(), "mentions")))).where(String.format("mentions IS NOT NULL AND %s IS NOT NULL", MessageData.Fields.BODY_RANGES.getColumnName())).execute();
            this.databaseLayer.update("message").values(List.of(new DatabaseLayer.RawInsertableField((Field)MessageData.Fields.BODY_RANGES, "mentions"))).where(String.format("mentions IS NOT NULL AND %s IS NULL", MessageData.Fields.BODY_RANGES.getColumnName())).execute();
            this.storageBean.getMessageData().dropColumn("mentions");
        }
    }

    private void stickers_createTables() throws SQLException {
        List<String> tableNames = this.databaseLayer.getTableNames();
        if (!tableNames.contains(this.storageBean.getStickerPackData().getTableName())) {
            this.storageBean.getStickerPackData().createTable();
        }
        if (!tableNames.contains(this.storageBean.getStickerData().getTableName())) {
            this.storageBean.getStickerData().createTable();
        }
    }

    private void recipientData_phonePrivacy() throws SQLException {
        this.storageBean.getRecipientData().addColumn(FieldBuilder.newField("phone_number_sharing", FieldType.BOOLEAN).withDefaultValue(false).build());
        this.storageBean.getRecipientData().addColumn(FieldBuilder.newField("phone_number_discoverable", FieldType.BOOLEAN).withDefaultValue(false).build());
    }

    private void draftData_createTable() throws SQLException {
        List<String> tableNames = this.databaseLayer.getTableNames();
        if (!tableNames.contains(this.storageBean.getDraftData().getTableName())) {
            this.storageBean.getDraftData().createTable();
        }
    }

    private void channelData_entityKey() throws SQLException {
        this.addEntityKeyColumn(this.storageBean.getChannelData(), ChannelData.Fields.ENTITY_KEY, ChannelKey::new);
    }

    private void stickerPackData_entityKey() throws SQLException {
        this.addEntityKeyColumn(this.storageBean.getStickerPackData(), StickerPackData.Fields.ENTITY_KEY, StickerPackKey::new);
    }

    private void stickerData_entityKey() throws SQLException {
        this.addEntityKeyColumn(this.storageBean.getStickerData(), StickerData.Fields.ENTITY_KEY, StickerKey::new);
    }

    private void quoteData_entityKey() throws SQLException {
        this.addEntityKeyColumn(this.storageBean.getQuoteData(), QuoteData.Fields.ENTITY_KEY, QuoteKey::new);
    }

    private void reactionData_entityKey() throws SQLException {
        this.addEntityKeyColumn(this.storageBean.getReactionData(), ReactionData.Fields.ENTITY_KEY, ReactionKey::new);
    }

    private void attachmentData_entityKey() throws SQLException {
        this.addEntityKeyColumn(this.storageBean.getAttachmentData(), AttachmentData.Fields.ENTITY_KEY, AttachmentKey::new);
    }

    private void draftData_entityKey() throws SQLException {
        this.addEntityKeyColumn(this.storageBean.getDraftData(), DraftData.Fields.ENTITY_KEY, DraftKey::new);
    }

    private void messageData_entityKey() throws SQLException {
        this.addEntityKeyColumn(this.storageBean.getMessageData(), MessageData.Fields.ENTITY_KEY, MessageKey::new);
    }

    private void recipientData_entityKey() throws SQLException {
        this.storageBean.getRecipientData().addColumn(RecipientData.Fields.BLOCKED);
        this.addEntityKeyColumn(this.storageBean.getRecipientData(), RecipientData.Fields.ENTITY_KEY, RecipientKey::new);
    }

    private void groupData_entityKey() throws SQLException {
        block11: {
            List<String> columnNames = this.storageBean.getGroupData().getColumnNames();
            this.addEntityKeyColumn(this.storageBean.getGroupData(), GroupData.Fields.ENTITY_KEY, GroupKey::new);
            if (columnNames.contains("group_id")) {
                List<String> columnsToExclude = List.of("group_id", "storage_service_id");
                List fields = this.storageBean.getGroupData().getColumnsInfo().stream().filter(columnInfo -> !columnsToExclude.contains(columnInfo.name())).map(ColumnInfo::createField).collect(Collectors.toCollection(ArrayList::new));
                fields.add(GroupData.Fields.GROUP_IDENTIFIER);
                this.databaseLayer.dropTable("groups_tmp").execute();
                this.databaseLayer.createTable("groups_tmp").fields(fields).execute();
                String fieldsForInsert = fields.stream().filter(field -> field != GroupData.Fields.GROUP_IDENTIFIER).map(Field::getColumnName).collect(Collectors.joining(", "));
                this.databaseLayer.executeQuery(String.format("INSERT INTO %s (%s) SELECT %s FROM %s", "groups_tmp", fieldsForInsert, fieldsForInsert, "groups"));
                this.storageBean.getGroupData().dropTable();
                this.databaseLayer.alterTable("groups_tmp").renameTo("groups").execute();
                Field groupIdField = FieldBuilder.newField("group_id", FieldType.LONG).build();
                ResultSet result = this.databaseLayer.selectRaw(List.of("ROWID", GroupData.Fields.ENTITY_KEY.getColumnName(), GroupData.Fields.MASTER_KEY.getColumnName())).from("groups").execute();
                block7: while (true) {
                    while (result.next()) {
                        long groupId = result.getLong(1);
                        GroupKey groupKey = new GroupKey(result.getBytes(2));
                        byte[] masterKeyBytes = result.getBytes(3);
                        try {
                            GroupMasterKey masterKey = new GroupMasterKey(masterKeyBytes);
                            GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)masterKey);
                            GroupIdentifier groupIdentifier = groupSecretParams.getPublicParams().getGroupIdentifier();
                            byte[] serializedGroupIdentifier = groupIdentifier.serialize();
                            this.databaseLayer.update("groups").values(Map.of(GroupData.Fields.GROUP_IDENTIFIER, serializedGroupIdentifier)).where(List.of(new DatabaseLayer.BinaryOperandField(GroupData.Fields.ENTITY_KEY, groupKey.getKey()))).execute();
                            String groupIdentifierHexString = HexFormat.of().formatHex(serializedGroupIdentifier);
                            this.databaseLayer.update("group_membership").values(Map.of(groupIdField, groupId)).where(MembershipData.Fields.GROUP_ID.getColumnName() + " = '__signal_group__v2__!" + groupIdentifierHexString + "'").execute();
                            continue block7;
                        }
                        catch (InvalidInputException ex) {
                            LOG.log(Level.SEVERE, "Invalid masterkeybytes in GroupRecord!", ex);
                        }
                    }
                    break block11;
                    {
                        continue block7;
                        break;
                    }
                    break;
                }
                finally {
                    if (result != null) {
                        result.close();
                    }
                }
            }
        }
    }

    private void userData_createTable() throws SQLException {
        List<String> recipientColumnNames = this.storageBean.getRecipientData().getColumnNames();
        List userFields = this.storageBean.getUserData().getFields().stream().filter(field -> field != UserData.Fields.ID && field != UserData.Fields.RECIPIENT_ID).collect(Collectors.toCollection(ArrayList::new));
        userFields.add(FieldBuilder.newField("recipient_id", FieldType.LONG).withNullable(false).withUnique(true).build());
        this.databaseLayer.createTable("users").fields(userFields.stream().filter(Field::includeInCreateTable).toList()).execute();
        if (recipientColumnNames.contains("aci")) {
            DatabaseLayer.ExecutableSelect selectRecipient;
            ArrayList<String> selectFields;
            UserKey userKey;
            ArrayList<RecipientKey> accountRecipients = new ArrayList<RecipientKey>();
            try (ResultSet result = this.databaseLayer.select(List.of(RecipientData.Fields.ENTITY_KEY)).from("recipient").where(List.of(new DatabaseLayer.BinaryOperandField(RecipientData.Fields.TYPE, RecipientRecord.Type.ACCOUNT.type))).execute();){
                while (result.next()) {
                    accountRecipients.add(new RecipientKey(result.getBytes(1)));
                }
            }
            ArrayList<RecipientKey> contactRecipients = new ArrayList<RecipientKey>();
            try (ResultSet result = this.databaseLayer.select(List.of(RecipientData.Fields.ENTITY_KEY)).from("recipient").where(List.of(new DatabaseLayer.BinaryOperandField(RecipientData.Fields.TYPE, RecipientRecord.Type.CONTACT.type))).execute();){
                while (result.next()) {
                    contactRecipients.add(new RecipientKey(result.getBytes(1)));
                }
            }
            List<Field> recipientFields = List.of(FieldBuilder.newField("ROWID", FieldType.LONG).withIncludeInCreateTable(false).withPrimaryKey(true).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.E164.getColumnName(), FieldType.SHORT_STRING).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.ACI.getColumnName(), FieldType.SHORT_STRING).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.PNI.getColumnName(), FieldType.SHORT_STRING).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.PROFILE_KEY.getColumnName(), FieldType.BLOB).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.EXPIRING_PROFILE_KEY_CREDENTIAL.getColumnName(), FieldType.SHORT_STRING).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.SEALED_SENDER_MODE.getColumnName(), FieldType.INT).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.ABOUT.getColumnName(), FieldType.SHORT_STRING).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.ABOUT_EMOJI.getColumnName(), FieldType.SHORT_STRING).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.REGISTERED.getColumnName(), FieldType.INT).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.UNREGISTERED_TIMESTAMP.getColumnName(), FieldType.LONG).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.PROFILE_AVATAR_URL.getColumnName(), FieldType.SHORT_STRING).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.PROFILE_AVATAR_FILE.getColumnName(), FieldType.SHORT_STRING).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.PROFILE_GIVEN_NAME.getColumnName(), FieldType.SHORT_STRING).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.PROFILE_FAMILY_NAME.getColumnName(), FieldType.SHORT_STRING).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.SYSTEM_GIVEN_NAME.getColumnName(), FieldType.SHORT_STRING).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.SYSTEM_FAMILY_NAME.getColumnName(), FieldType.SHORT_STRING).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.USERNAME.getColumnName(), FieldType.SHORT_STRING).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.PHONE_NUMBER_SHARING.getColumnName(), FieldType.BOOLEAN).withTableName("recipient").build(), FieldBuilder.newField(UserData.Fields.PHONE_NUMBER_DISCOVERABLE.getColumnName(), FieldType.BOOLEAN).withTableName("recipient").build());
            for (RecipientKey recipientKey : accountRecipients) {
                userKey = new UserKey();
                selectFields = new ArrayList<String>();
                selectFields.add(this.toSqliteHex(userKey.getKey()));
                selectFields.addAll(recipientFields.stream().map(field -> field.getTableName() + "." + field.getColumnName()).toList());
                selectRecipient = this.databaseLayer.selectRaw(selectFields).from("recipient").where(List.of(new DatabaseLayer.BinaryOperandField(RecipientData.Fields.ENTITY_KEY, recipientKey.getKey())));
                this.databaseLayer.insert("users").select(selectRecipient).columns(List.of(UserData.Fields.ENTITY_KEY, UserData.Fields.RECIPIENT_ID, UserData.Fields.E164, UserData.Fields.ACI, UserData.Fields.PNI, UserData.Fields.PROFILE_KEY, UserData.Fields.EXPIRING_PROFILE_KEY_CREDENTIAL, UserData.Fields.SEALED_SENDER_MODE, UserData.Fields.ABOUT, UserData.Fields.ABOUT_EMOJI, UserData.Fields.REGISTERED, UserData.Fields.UNREGISTERED_TIMESTAMP, UserData.Fields.PROFILE_AVATAR_URL, UserData.Fields.PROFILE_AVATAR_FILE, UserData.Fields.PROFILE_GIVEN_NAME, UserData.Fields.PROFILE_FAMILY_NAME, UserData.Fields.SYSTEM_GIVEN_NAME, UserData.Fields.SYSTEM_FAMILY_NAME, UserData.Fields.USERNAME, UserData.Fields.PHONE_NUMBER_SHARING, UserData.Fields.PHONE_NUMBER_DISCOVERABLE)).execute();
            }
            for (RecipientKey recipientKey : contactRecipients) {
                userKey = new UserKey();
                selectFields = new ArrayList();
                selectFields.add(this.toSqliteHex(userKey.getKey()));
                selectFields.addAll(recipientFields.stream().map(field -> field.getTableName() + "." + field.getColumnName()).toList());
                selectRecipient = this.databaseLayer.selectRaw(selectFields).from("recipient").where(List.of(new DatabaseLayer.BinaryOperandField(RecipientData.Fields.ENTITY_KEY, recipientKey.getKey())));
                this.databaseLayer.insert("users").select(selectRecipient).columns(List.of(UserData.Fields.ENTITY_KEY, UserData.Fields.RECIPIENT_ID, UserData.Fields.E164, UserData.Fields.ACI, UserData.Fields.PNI, UserData.Fields.PROFILE_KEY, UserData.Fields.EXPIRING_PROFILE_KEY_CREDENTIAL, UserData.Fields.SEALED_SENDER_MODE, UserData.Fields.ABOUT, UserData.Fields.ABOUT_EMOJI, UserData.Fields.REGISTERED, UserData.Fields.UNREGISTERED_TIMESTAMP, UserData.Fields.PROFILE_AVATAR_URL, UserData.Fields.PROFILE_AVATAR_FILE, UserData.Fields.PROFILE_GIVEN_NAME, UserData.Fields.PROFILE_FAMILY_NAME, UserData.Fields.SYSTEM_GIVEN_NAME, UserData.Fields.SYSTEM_FAMILY_NAME, UserData.Fields.USERNAME, UserData.Fields.PHONE_NUMBER_SHARING, UserData.Fields.PHONE_NUMBER_DISCOVERABLE)).execute();
            }
            List<String> columnsToExclude = List.of("_id", "e164", "aci", "pni", "profile_key", "profile_key_credential", "about", "about_emoji", "sealed_sender_mode", "registered", "unregistered_timestamp", "profile_avatar_url", "profile_avatar_file", "profile_given_name", "profile_family_name", "system_given_name", "system_family_name", "username", "phone_number_sharing", "phone_number_discoverable");
            List newRecipientFields = this.storageBean.getRecipientData().getColumnsInfo().stream().filter(columnInfo -> !columnsToExclude.contains(columnInfo.name())).map(ColumnInfo::createField).collect(Collectors.toCollection(ArrayList::new));
            this.databaseLayer.createTable("recipient_tmp").fields(newRecipientFields).execute();
            String fieldsForInsert = newRecipientFields.stream().map(Field::getColumnName).collect(Collectors.joining(", "));
            this.databaseLayer.executeQuery(String.format("INSERT INTO %s (%s) SELECT %s FROM %s", "recipient_tmp", fieldsForInsert, fieldsForInsert, "recipient"));
            this.storageBean.getRecipientData().dropTable();
            this.databaseLayer.alterTable("recipient_tmp").renameTo("recipient").execute();
        }
    }

    private void searchRecipientData_dropOldTriggers() throws SQLException {
        this.databaseLayer.executeQuery("DROP TRIGGER IF EXISTS recipient_ai");
        this.databaseLayer.executeQuery("DROP TRIGGER IF EXISTS recipient_au");
        this.databaseLayer.executeQuery("DROP TRIGGER IF EXISTS recipient_ad");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void membershipData_useUserIds() throws SQLException {
        MembershipData membershipData = this.storageBean.getGroupData().getMembershipData();
        List<String> membershipColumnNames = membershipData.getColumnNames();
        if (membershipColumnNames.contains("recipient_id")) {
            membershipData.addColumn(MembershipData.Fields.USER_ID);
            Field membershipDataRowID = FieldBuilder.newField("ROWID", FieldType.LONG).withTableName("group_membership").build();
            Field membershipDataRecipientId = FieldBuilder.newField("recipient_id", FieldType.LONG).withTableName("group_membership").build();
            Field membershipDataUserId = FieldBuilder.newField("user_id", FieldType.LONG).withTableName("group_membership").build();
            Field userDataRecipientId = FieldBuilder.newField("recipient_id", FieldType.LONG).withTableName("users").build();
            try (ResultSet result = this.databaseLayer.select(List.of(membershipDataRowID, membershipDataRecipientId)).from("group_membership").execute();){
                while (result.next()) {
                    Long membershipId = result.getLong(1);
                    Long recipientId = result.getLong(2);
                    ResultSet result2 = this.databaseLayer.selectRaw(List.of("ROWID")).from("users").where(List.of(new DatabaseLayer.BinaryOperandField(userDataRecipientId, recipientId))).execute();
                    try {
                        if (!result2.next()) continue;
                        Long userId = result2.getLong(1);
                        this.databaseLayer.update("group_membership").values(Map.of(membershipDataUserId, userId)).where(List.of(new DatabaseLayer.BinaryOperandField(membershipDataRowID, membershipId))).execute();
                    }
                    finally {
                        if (result2 == null) continue;
                        result2.close();
                    }
                }
            }
            membershipData.dropColumn("recipient_id");
        }
    }

    private void groupData_removeBlockedColumn() throws SQLException {
        GroupData groupData = this.storageBean.getGroupData();
        List<String> groupColumnNames = groupData.getColumnNames();
        if (groupColumnNames.contains("blocked")) {
            groupData.dropColumn("blocked");
        }
    }

    private void stickers_switchPrimaryKey() throws SQLException {
        LOG.info("Executing patch");
        StickerData stickerData = this.storageBean.getStickerData();
        StickerPackData stickerPackData = this.storageBean.getStickerPackData();
        List<String> stickerColumnNames = stickerData.getColumnNames();
        boolean idColumnExists = stickerColumnNames.contains(StickerData.Fields.ID.getColumnName());
        LOG.info("Column '" + StickerData.Fields.ID.getColumnName() + "' exists? " + idColumnExists);
        if (!idColumnExists) {
            LOG.info("Updating sticker table");
            List<String> stickerColumnsToExclude = List.of(StickerData.Fields.PACK_ID.getColumnName());
            List stickerFields = stickerData.getColumnsInfo().stream().filter(columnInfo -> !stickerColumnsToExclude.contains(columnInfo.name())).map(ColumnInfo::createField).collect(Collectors.toCollection(ArrayList::new));
            stickerFields.add(StickerData.Fields.ID);
            stickerFields.add(StickerData.Fields.PACK_ID);
            this.databaseLayer.createTable("sticker_tmp").fields(stickerFields).execute();
            String stickerFieldsForInsert = stickerFields.stream().filter(field -> field != StickerData.Fields.ID).map(Field::getColumnName).collect(Collectors.joining(", "));
            this.databaseLayer.executeQuery(String.format("INSERT INTO %s (%s) SELECT %s FROM %s", "sticker_tmp", stickerFieldsForInsert, stickerFieldsForInsert, "sticker"));
            stickerData.dropTable();
            this.databaseLayer.alterTable("sticker_tmp").renameTo("sticker").execute();
            LOG.info("Creating mapping for sticker pack ROWID's");
            HashMap<Long, StickerPackKey> stickerPackKeysByRowId = new HashMap<Long, StickerPackKey>();
            try (ResultSet result = this.databaseLayer.selectRaw(List.of("ROWID", StickerPackData.Fields.ENTITY_KEY.getColumnName())).from("sticker_pack").execute();){
                while (result.next()) {
                    stickerPackKeysByRowId.put(result.getLong(1), new StickerPackKey(result.getBytes(2)));
                }
            }
            LOG.info("Updating sticker pack table");
            List stickerPackFields = stickerPackData.getColumnsInfo().stream().map(ColumnInfo::createField).collect(Collectors.toCollection(ArrayList::new));
            stickerPackFields.add(StickerPackData.Fields.ID);
            this.databaseLayer.createTable("sticker_pack_tmp").fields(stickerPackFields).execute();
            String stickerPackFieldsForInsert = stickerPackFields.stream().filter(field -> field != StickerPackData.Fields.ID).map(Field::getColumnName).collect(Collectors.joining(", "));
            this.databaseLayer.executeQuery(String.format("INSERT INTO %s (%s) SELECT %s FROM %s", "sticker_pack_tmp", stickerPackFieldsForInsert, stickerPackFieldsForInsert, "sticker_pack"));
            stickerPackData.dropTable();
            this.databaseLayer.alterTable("sticker_pack_tmp").renameTo("sticker_pack").execute();
            LOG.info("Creating mapping for sticker pack _id's");
            HashMap<StickerPackKey, Integer> idsByStickerPackKey = new HashMap<StickerPackKey, Integer>();
            try (ResultSet result = this.databaseLayer.select(List.of(StickerPackData.Fields.ID, StickerPackData.Fields.ENTITY_KEY)).from("sticker_pack").execute();){
                while (result.next()) {
                    idsByStickerPackKey.put(new StickerPackKey(result.getBytes(2)), result.getInt(1));
                }
            }
            LOG.info("Updating mapping for sticker.pack_id with new sticker pack _id's");
            for (Map.Entry rowidEntry : stickerPackKeysByRowId.entrySet()) {
                this.databaseLayer.update("sticker").values(Map.of(StickerData.Fields.PACK_ID, idsByStickerPackKey.get(rowidEntry.getValue()))).where(List.of(new DatabaseLayer.BinaryOperandField(StickerData.Fields.PACK_ID, ((Long)rowidEntry.getKey()).intValue()))).execute();
            }
        }
        LOG.info("Patch completed");
    }

    private void channel_switchPrimaryKey() throws SQLException {
        LOG.info("Executing patch");
        ChannelData channelData = this.storageBean.getChannelData();
        DraftData draftData = this.storageBean.getDraftData();
        MessageData messageData = this.storageBean.getMessageData();
        List<String> channelColumnNames = channelData.getColumnNames();
        boolean idColumnExists = channelColumnNames.contains(ChannelData.Fields.ID.getColumnName());
        LOG.info("Column '" + ChannelData.Fields.ID.getColumnName() + "' exists? " + idColumnExists);
        if (!idColumnExists) {
            LOG.info("Updating draft table");
            List<String> draftColumnsToExclude = List.of(DraftData.Fields.CHANNEL_ID.getColumnName());
            List draftFields = draftData.getColumnsInfo().stream().filter(columnInfo -> !draftColumnsToExclude.contains(columnInfo.name())).map(ColumnInfo::createField).collect(Collectors.toCollection(ArrayList::new));
            draftFields.add(DraftData.Fields.ID);
            draftFields.add(DraftData.Fields.CHANNEL_ID);
            this.databaseLayer.createTable("draft_tmp").fields(draftFields).execute();
            String draftFieldsForInsert = draftFields.stream().filter(field -> field != DraftData.Fields.ID).map(Field::getColumnName).collect(Collectors.joining(", "));
            this.databaseLayer.executeQuery(String.format("INSERT INTO %s (%s) SELECT %s FROM %s", "draft_tmp", draftFieldsForInsert, draftFieldsForInsert, "draft"));
            draftData.dropTable();
            this.databaseLayer.alterTable("draft_tmp").renameTo("draft").execute();
            LOG.info("Creating mapping for channel ROWID's");
            HashMap<Long, ChannelKey> channelKeysByRowId = new HashMap<Long, ChannelKey>();
            try (ResultSet result = this.databaseLayer.selectRaw(List.of("ROWID", ChannelData.Fields.ENTITY_KEY.getColumnName())).from("channel").execute();){
                while (result.next()) {
                    channelKeysByRowId.put(result.getLong(1), new ChannelKey(result.getBytes(2)));
                }
            }
            LOG.info("Updating channel table");
            List<String> channelColumnsToExclude = List.of(ChannelData.Fields.RECIPIENT_ID.getColumnName());
            List channelFields = channelData.getColumnsInfo().stream().filter(columnInfo -> !channelColumnsToExclude.contains(columnInfo.name())).map(ColumnInfo::createField).collect(Collectors.toCollection(ArrayList::new));
            channelFields.add(ChannelData.Fields.ID);
            channelFields.add(ChannelData.Fields.RECIPIENT_ID);
            this.databaseLayer.createTable("channel_tmp").fields(channelFields).execute();
            String channelFieldsForInsert = channelFields.stream().filter(field -> field != ChannelData.Fields.ID).map(Field::getColumnName).collect(Collectors.joining(", "));
            this.databaseLayer.executeQuery(String.format("INSERT INTO %s (%s) SELECT %s FROM %s", "channel_tmp", channelFieldsForInsert, channelFieldsForInsert, "channel"));
            channelData.dropTable();
            this.databaseLayer.alterTable("channel_tmp").renameTo("channel").execute();
            LOG.info("Creating mapping for channel _id's");
            HashMap<ChannelKey, Integer> idsByChannelKey = new HashMap<ChannelKey, Integer>();
            try (ResultSet result = this.databaseLayer.select(List.of(ChannelData.Fields.ID, ChannelData.Fields.ENTITY_KEY)).from("channel").execute();){
                while (result.next()) {
                    idsByChannelKey.put(new ChannelKey(result.getBytes(2)), result.getInt(1));
                }
            }
            LOG.info("Updating mapping for draft.channel_id with new channel _id's");
            for (Map.Entry entry : channelKeysByRowId.entrySet()) {
                this.databaseLayer.update("draft").values(Map.of(DraftData.Fields.CHANNEL_ID, idsByChannelKey.get(entry.getValue()))).where(List.of(new DatabaseLayer.BinaryOperandField(DraftData.Fields.CHANNEL_ID, ((Long)entry.getKey()).intValue()))).execute();
            }
            LOG.info("Updating mapping for message.channel_id with new channel _id's");
            Field messageData_ChannelId = FieldBuilder.newField("channel_id", FieldType.INT).build();
            for (Map.Entry rowidEntry : channelKeysByRowId.entrySet()) {
                this.databaseLayer.update("message").values(Map.of(messageData_ChannelId, idsByChannelKey.get(rowidEntry.getValue()))).where(List.of(new DatabaseLayer.BinaryOperandField(messageData_ChannelId, ((Long)rowidEntry.getKey()).intValue()))).execute();
            }
        }
        LOG.info("Patch completed");
    }

    private void message_switchPrimaryKey() throws SQLException {
        LOG.info("Executing patch");
        AttachmentData attachmentData = this.storageBean.getAttachmentData();
        MessageData messageData = this.storageBean.getMessageData();
        QuoteData quoteData = this.storageBean.getQuoteData();
        ReactionData reactionData = this.storageBean.getReactionData();
        List<String> messageColumnNames = messageData.getColumnNames();
        boolean idColumnExists = messageColumnNames.contains(MessageData.Fields.ID.getColumnName());
        LOG.info("Column '" + MessageData.Fields.ID.getColumnName() + "' exists? " + idColumnExists);
        if (!idColumnExists) {
            LOG.info("Updating attachment table");
            List<String> attachmentColumnsToExclude = List.of(AttachmentData.Fields.MESSAGE_ID.getColumnName());
            List attachmentFields = attachmentData.getColumnsInfo().stream().filter(columnInfo -> !attachmentColumnsToExclude.contains(columnInfo.name())).map(ColumnInfo::createField).collect(Collectors.toCollection(ArrayList::new));
            attachmentFields.add(AttachmentData.Fields.ID);
            attachmentFields.add(AttachmentData.Fields.MESSAGE_ID);
            this.databaseLayer.createTable("attachment_tmp").fields(attachmentFields).execute();
            String attachmentFieldsForInsert = attachmentFields.stream().filter(field -> field != AttachmentData.Fields.ID).map(Field::getColumnName).collect(Collectors.joining(", "));
            this.databaseLayer.executeQuery(String.format("INSERT INTO %s (%s) SELECT %s FROM %s", "attachment_tmp", attachmentFieldsForInsert, attachmentFieldsForInsert, "attachment"));
            attachmentData.dropTable();
            this.databaseLayer.alterTable("attachment_tmp").renameTo("attachment").execute();
            LOG.info("Updating quote table");
            List<String> quoteColumnsToExclude = List.of(QuoteData.Fields.MESSAGE_ID.getColumnName(), QuoteData.Fields.QUOTED_MESSAGE_ID.getColumnName());
            List quoteFields = quoteData.getColumnsInfo().stream().filter(columnInfo -> !quoteColumnsToExclude.contains(columnInfo.name())).map(ColumnInfo::createField).collect(Collectors.toCollection(ArrayList::new));
            quoteFields.add(QuoteData.Fields.ID);
            quoteFields.add(QuoteData.Fields.MESSAGE_ID);
            quoteFields.add(QuoteData.Fields.QUOTED_MESSAGE_ID);
            this.databaseLayer.createTable("quote_tmp").fields(quoteFields).execute();
            String quoteFieldsForInsert = quoteFields.stream().filter(field -> field != QuoteData.Fields.ID).map(Field::getColumnName).collect(Collectors.joining(", "));
            this.databaseLayer.executeQuery(String.format("INSERT INTO %s (%s) SELECT %s FROM %s", "quote_tmp", quoteFieldsForInsert, quoteFieldsForInsert, "quote"));
            quoteData.dropTable();
            this.databaseLayer.alterTable("quote_tmp").renameTo("quote").execute();
            LOG.info("Updating reaction table");
            List<String> reactionColumnsToExclude = List.of(ReactionData.Fields.MESSAGE_ID.getColumnName(), ReactionData.Fields.RECIPIENT_ID.getColumnName());
            List reactionFields = reactionData.getColumnsInfo().stream().filter(columnInfo -> !reactionColumnsToExclude.contains(columnInfo.name())).map(ColumnInfo::createField).collect(Collectors.toCollection(ArrayList::new));
            reactionFields.add(ReactionData.Fields.ID);
            reactionFields.add(ReactionData.Fields.MESSAGE_ID);
            reactionFields.add(ReactionData.Fields.RECIPIENT_ID);
            this.databaseLayer.createTable("reaction_tmp").fields(reactionFields).execute();
            String reactionFieldsForInsert = reactionFields.stream().filter(field -> field != ReactionData.Fields.ID).map(Field::getColumnName).collect(Collectors.joining(", "));
            this.databaseLayer.executeQuery(String.format("INSERT INTO %s (%s) SELECT %s FROM %s", "reaction_tmp", reactionFieldsForInsert, reactionFieldsForInsert, "reaction"));
            reactionData.dropTable();
            this.databaseLayer.alterTable("reaction_tmp").renameTo("reaction").execute();
            LOG.info("Creating mapping for message ROWID's");
            HashMap<Long, MessageKey> messageKeysByRowId = new HashMap<Long, MessageKey>();
            try (ResultSet result = this.databaseLayer.selectRaw(List.of("ROWID", MessageData.Fields.ENTITY_KEY.getColumnName())).from("message").execute();){
                while (result.next()) {
                    messageKeysByRowId.put(result.getLong(1), new MessageKey(result.getBytes(2)));
                }
            }
            LOG.info("Updating message table");
            Field messageData_ChannelId = FieldBuilder.newField("channel_id", FieldType.INT).withNullable(false).withReference("channel", ChannelData.Fields.ID, FieldReference.OnDelete.CASCADE).build();
            List<String> messageColumnsToExclude = List.of(messageData_ChannelId.getColumnName(), MessageData.Fields.FROM_RECIPIENT_ID.getColumnName(), MessageData.Fields.TO_RECIPIENT_ID.getColumnName(), MessageData.Fields.LATEST_REVISION_ID.getColumnName(), MessageData.Fields.ORIGINAL_MESSAGE_ID.getColumnName());
            List messageFields = messageData.getColumnsInfo().stream().filter(columnInfo -> !messageColumnsToExclude.contains(columnInfo.name())).map(ColumnInfo::createField).collect(Collectors.toCollection(ArrayList::new));
            messageFields.add(MessageData.Fields.ID);
            messageFields.add(messageData_ChannelId);
            messageFields.add(MessageData.Fields.FROM_RECIPIENT_ID);
            messageFields.add(MessageData.Fields.TO_RECIPIENT_ID);
            messageFields.add(MessageData.Fields.LATEST_REVISION_ID);
            messageFields.add(MessageData.Fields.ORIGINAL_MESSAGE_ID);
            this.databaseLayer.createTable("message_tmp").fields(messageFields).execute();
            String messageFieldsForInsert = messageFields.stream().filter(field -> field != MessageData.Fields.ID).map(Field::getColumnName).collect(Collectors.joining(", "));
            this.databaseLayer.executeQuery(String.format("INSERT INTO %s (%s) SELECT %s FROM %s", "message_tmp", messageFieldsForInsert, messageFieldsForInsert, "message"));
            messageData.dropTable();
            this.databaseLayer.alterTable("message_tmp").renameTo("message").execute();
            LOG.info("Creating mapping for message _id's");
            HashMap<MessageKey, Integer> idsByMessageKey = new HashMap<MessageKey, Integer>();
            try (ResultSet result = this.databaseLayer.select(List.of(MessageData.Fields.ID, MessageData.Fields.ENTITY_KEY)).from("message").execute();){
                while (result.next()) {
                    idsByMessageKey.put(new MessageKey(result.getBytes(2)), result.getInt(1));
                }
            }
            LOG.info("Updating mapping for message.latest_revision_id with new message _id's");
            for (Map.Entry rowidEntry : messageKeysByRowId.entrySet()) {
                this.databaseLayer.update("message").values(Map.of(MessageData.Fields.LATEST_REVISION_ID, idsByMessageKey.get(rowidEntry.getValue()))).where(List.of(new DatabaseLayer.BinaryOperandField(MessageData.Fields.LATEST_REVISION_ID, ((Long)rowidEntry.getKey()).intValue()))).execute();
            }
            LOG.info("Updating mapping for message.original_message_id with new message _id's");
            for (Map.Entry rowidEntry : messageKeysByRowId.entrySet()) {
                this.databaseLayer.update("message").values(Map.of(MessageData.Fields.ORIGINAL_MESSAGE_ID, idsByMessageKey.get(rowidEntry.getValue()))).where(List.of(new DatabaseLayer.BinaryOperandField(MessageData.Fields.ORIGINAL_MESSAGE_ID, ((Long)rowidEntry.getKey()).intValue()))).execute();
            }
            LOG.info("Updating mapping for attachment.message_id with new message _id's");
            for (Map.Entry rowidEntry : messageKeysByRowId.entrySet()) {
                this.databaseLayer.update("attachment").values(Map.of(AttachmentData.Fields.MESSAGE_ID, idsByMessageKey.get(rowidEntry.getValue()))).where(List.of(new DatabaseLayer.BinaryOperandField(AttachmentData.Fields.MESSAGE_ID, ((Long)rowidEntry.getKey()).intValue()))).execute();
            }
            LOG.info("Updating mapping for quote.message_id with new message _id's");
            for (Map.Entry rowidEntry : messageKeysByRowId.entrySet()) {
                this.databaseLayer.update("quote").values(Map.of(QuoteData.Fields.MESSAGE_ID, idsByMessageKey.get(rowidEntry.getValue()))).where(List.of(new DatabaseLayer.BinaryOperandField(QuoteData.Fields.MESSAGE_ID, ((Long)rowidEntry.getKey()).intValue()))).execute();
            }
            LOG.info("Updating mapping for quote.quoted_message_id with new message _id's");
            for (Map.Entry rowidEntry : messageKeysByRowId.entrySet()) {
                this.databaseLayer.update("quote").values(Map.of(QuoteData.Fields.QUOTED_MESSAGE_ID, idsByMessageKey.get(rowidEntry.getValue()))).where(List.of(new DatabaseLayer.BinaryOperandField(QuoteData.Fields.QUOTED_MESSAGE_ID, ((Long)rowidEntry.getKey()).intValue()))).execute();
            }
            LOG.info("Updating mapping for reaction.message_id with new message _id's");
            for (Map.Entry rowidEntry : messageKeysByRowId.entrySet()) {
                this.databaseLayer.update("reaction").values(Map.of(ReactionData.Fields.MESSAGE_ID, idsByMessageKey.get(rowidEntry.getValue()))).where(List.of(new DatabaseLayer.BinaryOperandField(ReactionData.Fields.MESSAGE_ID, ((Long)rowidEntry.getKey()).intValue()))).execute();
            }
            LOG.info("Recreating search message FTS table");
            this.databaseLayer.dropTable(this.storageBean.getSearchMessageData().getTableName()).execute();
            this.storageBean.getSearchMessageData().createTable();
            this.databaseLayer.executeQuery(String.format("INSERT INTO %s(%s) VALUES ('rebuild')", "search_fts", "search_fts"));
        }
        LOG.info("Patch completed");
    }

    private void recipient_switchPrimaryKey() throws SQLException {
        LOG.info("Executing patch");
        ChannelData channelData = this.storageBean.getChannelData();
        GroupData groupData = this.storageBean.getGroupData();
        MembershipData membershipData = groupData.getMembershipData();
        MessageData messageData = this.storageBean.getMessageData();
        ReactionData reactionData = this.storageBean.getReactionData();
        RecipientData recipientData = this.storageBean.getRecipientData();
        UserData userData = this.storageBean.getUserData();
        List<String> recipientColumnNames = recipientData.getColumnNames();
        boolean idColumnExists = recipientColumnNames.contains(RecipientData.Fields.ID.getColumnName());
        LOG.info("Column '" + RecipientData.Fields.ID.getColumnName() + "' exists? " + idColumnExists);
        if (!idColumnExists) {
            LOG.info("Updating membership table");
            List<String> membershipColumnsToExclude = List.of(MembershipData.Fields.GROUP_ID.getColumnName(), MembershipData.Fields.USER_ID.getColumnName());
            List membershipFields = membershipData.getColumnsInfo().stream().filter(columnInfo -> !membershipColumnsToExclude.contains(columnInfo.name())).map(ColumnInfo::createField).collect(Collectors.toCollection(ArrayList::new));
            membershipFields.add(MembershipData.Fields.ID);
            membershipFields.add(MembershipData.Fields.GROUP_ID);
            membershipFields.add(MembershipData.Fields.USER_ID);
            this.databaseLayer.createTable("group_membership_tmp").fields(membershipFields).execute();
            String membershipFieldsForInsert = membershipFields.stream().filter(field -> field != MembershipData.Fields.ID).map(Field::getColumnName).collect(Collectors.joining(", "));
            this.databaseLayer.executeQuery(String.format("INSERT INTO %s (%s) SELECT %s FROM %s", "group_membership_tmp", membershipFieldsForInsert, membershipFieldsForInsert, "group_membership"));
            membershipData.dropTable();
            this.databaseLayer.alterTable("group_membership_tmp").renameTo("group_membership").execute();
            LOG.info("Creating mapping for group ROWID's");
            HashMap<Long, GroupKey> groupKeysByRowId = new HashMap<Long, GroupKey>();
            try (ResultSet result = this.databaseLayer.selectRaw(List.of("ROWID", GroupData.Fields.ENTITY_KEY.getColumnName())).from("groups").execute();){
                while (result.next()) {
                    groupKeysByRowId.put(result.getLong(1), new GroupKey(result.getBytes(2)));
                }
            }
            LOG.info("Updating group table");
            List<String> groupColumnsToExclude = List.of(GroupData.Fields.RECIPIENT_ID.getColumnName());
            List groupFields = groupData.getColumnsInfo().stream().filter(columnInfo -> !groupColumnsToExclude.contains(columnInfo.name())).map(ColumnInfo::createField).collect(Collectors.toCollection(ArrayList::new));
            groupFields.add(GroupData.Fields.ID);
            groupFields.add(GroupData.Fields.RECIPIENT_ID);
            this.databaseLayer.createTable("groups_tmp").fields(groupFields).execute();
            String groupFieldsForInsert = groupFields.stream().filter(field -> field != GroupData.Fields.ID).map(Field::getColumnName).collect(Collectors.joining(", "));
            this.databaseLayer.executeQuery(String.format("INSERT INTO %s (%s) SELECT %s FROM %s", "groups_tmp", groupFieldsForInsert, groupFieldsForInsert, "groups"));
            groupData.dropTable();
            this.databaseLayer.alterTable("groups_tmp").renameTo("groups").execute();
            LOG.info("Creating mapping for group _id's");
            HashMap<GroupKey, Integer> idsByGroupKey = new HashMap<GroupKey, Integer>();
            try (ResultSet result = this.databaseLayer.select(List.of(GroupData.Fields.ID, GroupData.Fields.ENTITY_KEY)).from("groups").execute();){
                while (result.next()) {
                    idsByGroupKey.put(new GroupKey(result.getBytes(2)), result.getInt(1));
                }
            }
            LOG.info("Creating mapping for user ROWID's");
            HashMap<Long, UserKey> userKeysByRowId = new HashMap<Long, UserKey>();
            try (ResultSet result = this.databaseLayer.selectRaw(List.of("ROWID", UserData.Fields.ENTITY_KEY.getColumnName())).from("users").execute();){
                while (result.next()) {
                    userKeysByRowId.put(result.getLong(1), new UserKey(result.getBytes(2)));
                }
            }
            LOG.info("Updating user table");
            List<String> userColumnsToExclude = List.of(UserData.Fields.RECIPIENT_ID.getColumnName());
            List userFields = userData.getColumnsInfo().stream().filter(columnInfo -> !userColumnsToExclude.contains(columnInfo.name())).map(ColumnInfo::createField).collect(Collectors.toCollection(ArrayList::new));
            userFields.add(UserData.Fields.ID);
            userFields.add(UserData.Fields.RECIPIENT_ID);
            this.databaseLayer.createTable("users_tmp").fields(userFields).execute();
            String userFieldsForInsert = userFields.stream().filter(field -> field != UserData.Fields.ID).map(Field::getColumnName).collect(Collectors.joining(", "));
            this.databaseLayer.executeQuery(String.format("INSERT INTO %s (%s) SELECT %s FROM %s", "users_tmp", userFieldsForInsert, userFieldsForInsert, "users"));
            userData.dropTable();
            this.databaseLayer.alterTable("users_tmp").renameTo("users").execute();
            LOG.info("Creating mapping for user _id's");
            HashMap<UserKey, Integer> idsByUserKey = new HashMap<UserKey, Integer>();
            try (Iterator result = this.databaseLayer.select(List.of(UserData.Fields.ID, UserData.Fields.ENTITY_KEY)).from("users").execute();){
                while (result.next()) {
                    idsByUserKey.put(new UserKey(result.getBytes(2)), result.getInt(1));
                }
            }
            LOG.info("Updating mapping for membership.group_id with new group _id's");
            for (Map.Entry rowidEntry : groupKeysByRowId.entrySet()) {
                this.databaseLayer.update("group_membership").values(Map.of(MembershipData.Fields.GROUP_ID, idsByGroupKey.get(rowidEntry.getValue()))).where(List.of(new DatabaseLayer.BinaryOperandField(MembershipData.Fields.GROUP_ID, ((Long)rowidEntry.getKey()).intValue()))).execute();
            }
            LOG.info("Updating mapping for membership.user_id with new user _id's");
            for (Map.Entry rowidEntry : userKeysByRowId.entrySet()) {
                this.databaseLayer.update("group_membership").values(Map.of(MembershipData.Fields.USER_ID, idsByUserKey.get(rowidEntry.getValue()))).where(List.of(new DatabaseLayer.BinaryOperandField(MembershipData.Fields.USER_ID, ((Long)rowidEntry.getKey()).intValue()))).execute();
            }
            LOG.info("Creating mapping for recipient ROWID's");
            HashMap<Long, RecipientKey> recipientKeysByRowId = new HashMap<Long, RecipientKey>();
            try (ResultSet result = this.databaseLayer.selectRaw(List.of("ROWID", RecipientData.Fields.ENTITY_KEY.getColumnName())).from("recipient").execute();){
                while (result.next()) {
                    recipientKeysByRowId.put(result.getLong(1), new RecipientKey(result.getBytes(2)));
                }
            }
            LOG.info("Updating recipient table");
            List recipientFields = recipientData.getColumnsInfo().stream().map(ColumnInfo::createField).collect(Collectors.toCollection(ArrayList::new));
            recipientFields.add(RecipientData.Fields.ID);
            this.databaseLayer.createTable("recipient_tmp").fields(recipientFields).execute();
            String recipientFieldsForInsert = recipientFields.stream().filter(field -> field != RecipientData.Fields.ID).map(Field::getColumnName).collect(Collectors.joining(", "));
            this.databaseLayer.executeQuery(String.format("INSERT INTO %s (%s) SELECT %s FROM %s", "recipient_tmp", recipientFieldsForInsert, recipientFieldsForInsert, "recipient"));
            recipientData.dropTable();
            this.databaseLayer.alterTable("recipient_tmp").renameTo("recipient").execute();
            LOG.info("Creating mapping for recipient _id's");
            HashMap<RecipientKey, Integer> idsByRecipientKey = new HashMap<RecipientKey, Integer>();
            try (ResultSet result = this.databaseLayer.select(List.of(RecipientData.Fields.ID, RecipientData.Fields.ENTITY_KEY)).from("recipient").execute();){
                while (result.next()) {
                    idsByRecipientKey.put(new RecipientKey(result.getBytes(2)), result.getInt(1));
                }
            }
            LOG.info("Updating mapping for channel.recipient_id with new recipient _id's");
            for (Map.Entry rowidEntry : recipientKeysByRowId.entrySet()) {
                this.databaseLayer.update("channel").values(Map.of(ChannelData.Fields.RECIPIENT_ID, idsByRecipientKey.get(rowidEntry.getValue()))).where(List.of(new DatabaseLayer.BinaryOperandField(ChannelData.Fields.RECIPIENT_ID, ((Long)rowidEntry.getKey()).intValue()))).execute();
            }
            LOG.info("Updating mapping for group.recipient_id with new recipient _id's");
            for (Map.Entry rowidEntry : recipientKeysByRowId.entrySet()) {
                this.databaseLayer.update("groups").values(Map.of(GroupData.Fields.RECIPIENT_ID, idsByRecipientKey.get(rowidEntry.getValue()))).where(List.of(new DatabaseLayer.BinaryOperandField(GroupData.Fields.RECIPIENT_ID, ((Long)rowidEntry.getKey()).intValue()))).execute();
            }
            LOG.info("Updating mapping for message.from_recipient_id with new recipient _id's");
            for (Map.Entry rowidEntry : recipientKeysByRowId.entrySet()) {
                this.databaseLayer.update("message").values(Map.of(MessageData.Fields.FROM_RECIPIENT_ID, idsByRecipientKey.get(rowidEntry.getValue()))).where(List.of(new DatabaseLayer.BinaryOperandField(MessageData.Fields.FROM_RECIPIENT_ID, ((Long)rowidEntry.getKey()).intValue()))).execute();
            }
            LOG.info("Updating mapping for message.to_recipient_id with new recipient _id's");
            for (Map.Entry rowidEntry : recipientKeysByRowId.entrySet()) {
                this.databaseLayer.update("message").values(Map.of(MessageData.Fields.TO_RECIPIENT_ID, idsByRecipientKey.get(rowidEntry.getValue()))).where(List.of(new DatabaseLayer.BinaryOperandField(MessageData.Fields.TO_RECIPIENT_ID, ((Long)rowidEntry.getKey()).intValue()))).execute();
            }
            LOG.info("Updating mapping for reaction.recipient_id with new recipient _id's");
            for (Map.Entry rowidEntry : recipientKeysByRowId.entrySet()) {
                this.databaseLayer.update("reaction").values(Map.of(ReactionData.Fields.RECIPIENT_ID, idsByRecipientKey.get(rowidEntry.getValue()))).where(List.of(new DatabaseLayer.BinaryOperandField(ReactionData.Fields.RECIPIENT_ID, ((Long)rowidEntry.getKey()).intValue()))).execute();
            }
            LOG.info("Updating mapping for user.recipient_id with new recipient _id's");
            for (Map.Entry rowidEntry : recipientKeysByRowId.entrySet()) {
                this.databaseLayer.update("users").values(Map.of(UserData.Fields.RECIPIENT_ID, idsByRecipientKey.get(rowidEntry.getValue()))).where(List.of(new DatabaseLayer.BinaryOperandField(UserData.Fields.RECIPIENT_ID, ((Long)rowidEntry.getKey()).intValue()))).execute();
            }
        }
        LOG.info("Patch completed");
    }

    private void quoteData_quotedMessageIdNullable() throws SQLException {
        LOG.info("Executing patch");
        QuoteData quoteData = this.storageBean.getQuoteData();
        ColumnInfo columnInfoForQuotedMessageId = quoteData.getColumnInfo(QuoteData.Fields.QUOTED_MESSAGE_ID);
        if (columnInfoForQuotedMessageId != null && columnInfoForQuotedMessageId.notnull()) {
            LOG.info("Updating quote table");
            List<String> columnsToExclude = List.of(QuoteData.Fields.QUOTED_MESSAGE_ID.getColumnName());
            List<Field> quoteFields = quoteData.getColumnsInfo().stream().filter(columnInfo -> !columnsToExclude.contains(columnInfo.name())).map(ColumnInfo::createField).toList();
            quoteFields.add(QuoteData.Fields.QUOTED_MESSAGE_ID);
            this.databaseLayer.createTable("quote_tmp").fields(quoteFields).execute();
            String quoteFieldsForInsert = quoteFields.stream().map(Field::getColumnName).collect(Collectors.joining(", "));
            this.databaseLayer.executeQuery(String.format("INSERT INTO %s (%s) SELECT %s FROM %s", "quote_tmp", quoteFieldsForInsert, quoteFieldsForInsert, "quote"));
            quoteData.dropTable();
            this.databaseLayer.alterTable("quote_tmp").renameTo("quote").execute();
        }
        LOG.info("Patch completed");
    }

    private void messageData_removeTypeColumn() throws SQLException {
        MessageData messageData = this.storageBean.getMessageData();
        List<String> messageColumnNames = messageData.getColumnNames();
        if (messageColumnNames.contains("type")) {
            messageData.dropColumn("type");
        }
    }

    private void searchRecipientData_dropTables() throws SQLException {
        List<String> tableNames = this.databaseLayer.getTableNames();
        if (tableNames.contains("search_recipient_fts")) {
            this.databaseLayer.executeQuery("DROP TRIGGER IF EXISTS user_ai");
            this.databaseLayer.executeQuery("DROP TRIGGER IF EXISTS user_au");
            this.databaseLayer.executeQuery("DROP TRIGGER IF EXISTS user_ad");
            this.databaseLayer.dropTable("search_recipient_fts");
            this.databaseLayer.dropTable("search_recipient_fts_config");
            this.databaseLayer.dropTable("search_recipient_fts_content");
            this.databaseLayer.dropTable("search_recipient_fts_data");
            this.databaseLayer.dropTable("search_recipient_fts_docsize");
            this.databaseLayer.dropTable("search_recipient_fts_idx");
        }
    }

    private void callData_createTable() throws SQLException {
        List<String> tableNames = this.databaseLayer.getTableNames();
        if (!tableNames.contains(this.storageBean.getCallData().getTableName())) {
            this.storageBean.getCallData().createTable();
        }
    }

    private void badgeData_createTable() throws SQLException {
        List<String> tableNames = this.databaseLayer.getTableNames();
        if (!tableNames.contains(this.storageBean.getBadgeData().getTableName())) {
            this.storageBean.getBadgeData().createTable();
        }
    }

    private void messageData_addFlagsColumn() throws SQLException {
        this.storageBean.getMessageData().addColumn(MessageData.Fields.FLAGS);
    }

    private void userData_addNickColumns() throws SQLException {
        this.storageBean.getUserData().addColumn(UserData.Fields.NICK_GIVEN_NAME);
        this.storageBean.getUserData().addColumn(UserData.Fields.NICK_FAMILY_NAME);
        this.storageBean.getUserData().addColumn(UserData.Fields.NICK_NOTE);
    }

    private void recipientData_addMuteUntil() throws SQLException {
        this.storageBean.getRecipientData().addColumn(RecipientData.Fields.MUTE_UNTIL);
    }

    private void receiptData_createTable() throws SQLException {
        List<String> tableNames = this.databaseLayer.getTableNames();
        if (!tableNames.contains(this.storageBean.getReceiptData().getTableName())) {
            this.storageBean.getReceiptData().createTable();
        }
    }

    private void messageData_removeChannelIdColumn() throws SQLException {
        MessageData messageData = this.storageBean.getMessageData();
        List<String> messageColumnNames = messageData.getColumnNames();
        if (messageColumnNames.contains("channel_id")) {
            this.storageBean.getSearchMessageData().dropTable();
            messageData.dropColumn("channel_id");
            LOG.info("Recreating search message FTS table");
            this.storageBean.getSearchMessageData().createTable();
            this.databaseLayer.executeQuery(String.format("INSERT INTO %s(%s) VALUES ('rebuild')", "search_fts", "search_fts"));
        }
    }

    private void distributionListData_createTable() throws SQLException {
        List<String> tableNames = this.databaseLayer.getTableNames();
        if (!tableNames.contains(this.storageBean.getDistributionListData().getTableName())) {
            this.storageBean.getDistributionListData().createTable();
        }
    }

    private void groupData_addAvatarColumns() throws SQLException {
        this.storageBean.getGroupData().addColumn(GroupData.Fields.PROFILE_AVATAR_FILE);
        this.storageBean.getGroupData().addColumn(GroupData.Fields.PROFILE_AVATAR_URL);
    }

    private void recipientData_addUnregisteredTimestampColumn() throws SQLException {
        this.storageBean.getRecipientData().addColumn(RecipientData.Fields.UNREGISTERED_TIMESTAMP);
    }

    private void channelData_createForAllUsers() throws SQLException {
        int userCount;
        int groupCount;
        int channelCount = this.storageBean.getChannelData().count();
        if (channelCount < (groupCount = this.storageBean.getGroupData().count()) + (userCount = this.storageBean.getUserData().count())) {
            List channels = this.storageBean.getChannelData().findAll();
            for (GroupRecord group : this.storageBean.getGroupData().findAll()) {
                if (!channels.stream().noneMatch(channel -> channel.recipient().key().equals(group.recipient().key()))) continue;
                this.storageBean.getChannelData().createForRecipient(group.recipient().key());
            }
            for (UserDbRecord user : this.storageBean.getUserData().findAll()) {
                if (!channels.stream().noneMatch(channel -> channel.recipient().key().equals(user.recipientKey()))) continue;
                this.storageBean.getChannelData().createForRecipient(user.recipientKey());
            }
        }
    }

    private void addMessageFieldIndices() throws SQLException {
        this.addIndexOnMessageField(this.storageBean.getReactionData(), ReactionData.Fields.MESSAGE_ID);
        this.addIndexOnMessageField(this.storageBean.getReceiptData(), ReceiptData.Fields.MESSAGE_ID);
        this.addIndexOnMessageField(this.storageBean.getAttachmentData(), AttachmentData.Fields.MESSAGE_ID);
        this.addIndexOnMessageField(this.storageBean.getQuoteData(), QuoteData.Fields.MESSAGE_ID);
    }

    private void addIndexOnMessageField(EntityKeyData data, Field messageField) throws SQLException {
        String tableName = data.getTableName();
        this.databaseLayer.createIndex(tableName).withUnique(false).withName(String.format("idx_%s_%s", tableName, messageField.getColumnName())).addColumn(messageField).execute();
    }

    private void addMessageEntityIndex() throws SQLException {
        MessageData messageData = this.storageBean.getMessageData();
        this.databaseLayer.createIndex(messageData.getTableName()).withUnique(true).withName(String.format("idx_%s_%s", messageData.getTableName(), MessageData.Fields.ENTITY_KEY.getColumnName())).addColumn(MessageData.Fields.ENTITY_KEY).execute();
    }

    private void attachmentData_addEncryptedSize() throws SQLException {
        this.storageBean.getAttachmentData().addColumn(AttachmentData.Fields.ENCRYPTED_SIZE);
    }

    private void recipientData_addExpireTimerVersionColumn() throws SQLException {
        this.storageBean.getRecipientData().addColumn(RecipientData.Fields.EXPIRE_TIMER_VERSION);
    }

    private void messageData_addViewOnceColumn() throws SQLException {
        this.storageBean.getMessageData().addColumn(MessageData.Fields.VIEW_ONCE);
    }

    private void canvasData_addUuidColumn() throws SQLException {
        this.storageBean.getCanvasData().addColumn(CanvasData.Fields.UUID);
    }

    private void canvasData_createTable() throws SQLException {
        List<String> tableNames = this.databaseLayer.getTableNames();
        if (!tableNames.contains(this.storageBean.getCanvasData().getTableName())) {
            this.storageBean.getCanvasData().createTable();
        }
    }

    private void addEntityKeyColumn(BaseData<?> data, Field entityKeyField, Supplier<? extends EntityKey> entityKeySupplier) throws SQLException {
        List<String> columnNames = data.getColumnNames();
        if (!columnNames.contains(entityKeyField.getColumnName())) {
            Field primaryKeyField = FieldBuilder.newField("ROWID", FieldType.LONG).build();
            data.addColumn(entityKeyField);
            try (ResultSet result = this.databaseLayer.select(List.of(primaryKeyField)).from(data.getTableName()).execute();){
                while (result.next()) {
                    Long id = result.getLong(1);
                    this.databaseLayer.update(data.getTableName()).values(Map.of(entityKeyField, entityKeySupplier.get().getKey())).where(List.of(new DatabaseLayer.BinaryOperandField(primaryKeyField, id))).execute();
                }
            }
            this.databaseLayer.createIndex(data.getTableName()).withUnique(true).withName(String.format("idx_%s_%s", data.getTableName(), entityKeyField.getColumnName())).addColumn(entityKeyField).execute();
        }
    }

    private String toSqliteHex(byte[] bytes) {
        return "x'" + HexFormat.of().formatHex(bytes) + "'";
    }
}

