/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.clientdata;

import io.privacyresearch.clientdata.Field;
import io.privacyresearch.clientdata.FieldType;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DatabaseLayer {
    private static final boolean DEBUG = Boolean.getBoolean("storage.debug");
    private static PrintStream DEBUG_STREAM = System.err;
    private final Connection connection;

    public DatabaseLayer(Connection connection) {
        this.connection = connection;
    }

    public static void setDebugStream(PrintStream debugStream) {
        DEBUG_STREAM = debugStream;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void beginTransaction() throws SQLException {
        this.connection.setAutoCommit(false);
    }

    public void closeTransaction() throws SQLException {
        this.connection.commit();
    }

    public void endTransaction() throws SQLException {
        this.connection.setAutoCommit(true);
    }

    public List<String> getTableNames() throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        try (ResultSet result = this.selectRaw(List.of("name")).from("sqlite_schema").where("type = 'table' AND name NOT LIKE 'sqlite_%'").execute();){
            while (result.next()) {
                tableNames.add(result.getString(1));
            }
        }
        return tableNames;
    }

    public CreateTable createTable(String tableName) {
        return new CreateTable(this, tableName);
    }

    public CreateIndex createIndex(String tableName) {
        return new CreateIndex(this, tableName);
    }

    public CreateVirtualTable createVirtualTable(String tableName) {
        return new CreateVirtualTable(this, tableName);
    }

    public DropTable dropTable(String tableName) {
        return new DropTable(this, tableName);
    }

    public DropIndex dropIndex(String tableName) {
        return new DropIndex(this, tableName);
    }

    public AlterTable alterTable(String tableName) {
        return new AlterTable(this, tableName);
    }

    public Select select(List<Field> fields) {
        return new Select(this, fields.stream().map(Field::getFullName).collect(Collectors.toList()));
    }

    public Select selectRaw(List<String> fields) {
        return new Select(this, fields);
    }

    public Insert insert(String tableName) {
        return new Insert(this, tableName);
    }

    public Update update(String tableName) {
        return new Update(this, tableName);
    }

    public ExecutableDelete delete(String tableName) {
        Delete delete = new Delete(this);
        return delete.from(tableName);
    }

    public void executeQuery(String query) throws SQLException {
        try (Statement stmt = this.connection.createStatement();){
            if (DEBUG) {
                DEBUG_STREAM.println(query);
            }
            stmt.execute(query);
        }
    }

    public static class Select
    extends SqlStatement {
        private final List<String> fields;

        public Select(DatabaseLayer databaseLayer, List<String> fields) {
            super(databaseLayer);
            this.fields = fields;
        }

        public ExecutableSelect from(String tableName) {
            return new ExecutableSelect(this, tableName);
        }

        public String createQueryPart() {
            return this.fields.stream().collect(Collectors.joining(", "));
        }
    }

    public static class ExecutableSelect {
        private final Select select;
        private final String tableName;
        private List<Join> joins = new ArrayList<Join>();
        private WhereClause whereClause;
        private List<OrderBy> orderBys = new ArrayList<OrderBy>();
        private int limit = -1;
        private int offset = -1;

        public ExecutableSelect(Select select, String tableName) {
            this.select = select;
            this.tableName = tableName;
        }

        public ExecutableSelect join(Join join) {
            this.joins.add(join);
            return this;
        }

        public ExecutableSelect where(String where) {
            this.whereClause = new WhereClause(where);
            return this;
        }

        public ExecutableSelect where(String where, TryConsumer<PreparedStatement> statementConsumer) {
            this.whereClause = new WhereClause(where, statementConsumer);
            return this;
        }

        public ExecutableSelect where(List<? extends OperandField> whereFields) {
            this.whereClause = new WhereClause(whereFields);
            return this;
        }

        public ExecutableSelect orderBy(String column, Order order) {
            this.orderBys.add(new OrderBy(this.tableName + "." + column, order));
            return this;
        }

        public ExecutableSelect orderBy(Field field, Order order) {
            this.orderBys.add(new OrderBy(field.getTableName() + "." + field.getColumnName(), order));
            return this;
        }

        public ExecutableSelect limit(int limit) {
            this.limit = limit;
            return this;
        }

        public ExecutableSelect offset(int offset) {
            this.offset = offset;
            return this;
        }

        public WhereClause getWhereClause() {
            return this.whereClause;
        }

        public String generateQuery() {
            Object query = String.format("SELECT %s FROM %s", this.select.createQueryPart(), this.tableName);
            for (Join join : this.joins) {
                query = (String)query + " " + join.createStatement();
            }
            if (this.whereClause != null) {
                query = (String)query + this.whereClause.getClause();
            }
            if (!this.orderBys.isEmpty()) {
                query = (String)query + " ORDER BY";
                query = (String)query + " " + this.orderBys.stream().map(OrderBy::createStatement).collect(Collectors.joining(", "));
            }
            if (this.limit >= 0) {
                query = (String)query + " LIMIT " + this.limit;
            }
            if (this.offset >= 0) {
                query = (String)query + " OFFSET " + this.offset;
            }
            return query;
        }

        public ResultSet execute() throws SQLException {
            String query = this.generateQuery();
            if (DEBUG) {
                DEBUG_STREAM.println(query);
            }
            PreparedStatement stmt = this.select.getConnection().prepareStatement(query);
            if (this.whereClause != null) {
                this.whereClause.applyStatement(stmt, 0);
            }
            return stmt.executeQuery();
        }
    }

    public static class CreateTable
    extends SqlStatement {
        private final String tableName;

        public CreateTable(DatabaseLayer databaseLayer, String tableName) {
            super(databaseLayer);
            this.tableName = tableName;
        }

        public ExecutableCreateTable fields(List<Field> fields) {
            return new ExecutableCreateTable(this, fields);
        }

        public String getTableName() {
            return this.tableName;
        }
    }

    public static class CreateIndex
    extends SqlStatement {
        private final String tableName;
        private boolean unique = false;

        public CreateIndex(DatabaseLayer databaseLayer, String tableName) {
            super(databaseLayer);
            this.tableName = tableName;
        }

        public CreateIndex withUnique(boolean unique) {
            this.unique = unique;
            return this;
        }

        public CreateIndexWithName withName(String name) {
            return new CreateIndexWithName(this, name);
        }

        public String getTableName() {
            return this.tableName;
        }

        public boolean isUnique() {
            return this.unique;
        }
    }

    public static class CreateVirtualTable
    extends SqlStatement {
        private final String tableName;
        private String moduleName;

        public CreateVirtualTable(DatabaseLayer databaseLayer, String tableName) {
            super(databaseLayer);
            this.tableName = tableName;
        }

        public CreateVirtualTable using(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public CreateVirtualTableWithContent content(String content, String contentRowId) {
            return new CreateVirtualTableWithContent(this, content, contentRowId);
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getModuleName() {
            return this.moduleName;
        }
    }

    public static class DropTable
    extends SqlStatement {
        private final String tableName;

        public DropTable(DatabaseLayer databaseLayer, String tableName) {
            super(databaseLayer);
            this.tableName = tableName;
        }

        public void execute() throws SQLException {
            String query = String.format("DROP TABLE IF EXISTS %s", this.tableName);
            try (Statement stmt = this.getConnection().createStatement();){
                if (DEBUG) {
                    DEBUG_STREAM.println(query);
                }
                stmt.execute(query);
            }
        }
    }

    public static class DropIndex
    extends SqlStatement {
        private final String tableName;

        public DropIndex(DatabaseLayer databaseLayer, String tableName) {
            super(databaseLayer);
            this.tableName = tableName;
        }

        public DropIndexWithName withName(String name) {
            return new DropIndexWithName(this, name);
        }

        public String getTableName() {
            return this.tableName;
        }
    }

    public static class AlterTable
    extends SqlStatement {
        private final String tableName;

        public AlterTable(DatabaseLayer databaseLayer, String tableName) {
            super(databaseLayer);
            this.tableName = tableName;
        }

        public AlterTableWithAddColumn addColumn(Field newField) {
            return new AlterTableWithAddColumn(this, newField);
        }

        public AlterTableWithDropColumn dropColumn(String columnName) {
            return new AlterTableWithDropColumn(this, columnName);
        }

        public AlterTableWithRenameTo renameTo(String newTableName) {
            return new AlterTableWithRenameTo(this, newTableName);
        }

        public String getTableName() {
            return this.tableName;
        }
    }

    public static class Insert
    extends SqlStatement {
        private final String tableName;

        public Insert(DatabaseLayer databaseLayer, String tableName) {
            super(databaseLayer);
            this.tableName = tableName;
        }

        public ValuesInsert values(List<InsertableField> values) {
            return new ValuesInsert(this, List.of(values));
        }

        public ValuesInsert values(Map<Field, Object> values) {
            List insertableValues = values.entrySet().stream().map(entry -> new InsertableField((Field)entry.getKey(), entry.getValue())).sorted().collect(Collectors.toList());
            return new ValuesInsert(this, List.of(insertableValues));
        }

        public ValuesInsert bulkValues(List<List<InsertableField>> bulkValues) {
            return new ValuesInsert(this, bulkValues);
        }

        public SelectInsert select(ExecutableSelect select) {
            return new SelectInsert(this, select);
        }

        public String getTableName() {
            return this.tableName;
        }
    }

    public static class Update
    extends SqlStatement {
        private final String tableName;

        public Update(DatabaseLayer databaseLayer, String tableName) {
            super(databaseLayer);
            this.tableName = tableName;
        }

        public ExecutableUpdate values(List<InsertableField> values) {
            return new ExecutableUpdate(this, values);
        }

        public ExecutableUpdate values(Map<Field, Object> values) {
            List<InsertableField> insertableValues = values.entrySet().stream().map(entry -> new InsertableField((Field)entry.getKey(), entry.getValue())).sorted().collect(Collectors.toList());
            return new ExecutableUpdate(this, insertableValues);
        }

        public String getTableName() {
            return this.tableName;
        }
    }

    public static class Delete
    extends SqlStatement {
        public Delete(DatabaseLayer databaseLayer) {
            super(databaseLayer);
        }

        public ExecutableDelete from(String tableName) {
            return new ExecutableDelete(this, tableName);
        }
    }

    public static class ExecutableDelete {
        private final Delete delete;
        private final String tableName;
        private WhereClause whereClause;

        public ExecutableDelete(Delete delete, String tableName) {
            this.delete = delete;
            this.tableName = tableName;
        }

        public ExecutableDelete where(String where) {
            this.whereClause = new WhereClause(where);
            return this;
        }

        public ExecutableDelete where(String where, TryConsumer<PreparedStatement> statementConsumer) {
            this.whereClause = new WhereClause(where, statementConsumer);
            return this;
        }

        public ExecutableDelete where(List<? extends OperandField> whereFields) {
            this.whereClause = new WhereClause(whereFields);
            return this;
        }

        public int execute() throws SQLException {
            Object query = String.format("DELETE FROM %s", this.tableName);
            if (this.whereClause != null) {
                query = (String)query + this.whereClause.getClause();
            }
            try (PreparedStatement stmt = this.delete.getConnection().prepareStatement((String)query);){
                if (this.whereClause != null) {
                    this.whereClause.applyStatement(stmt, 0);
                }
                if (DEBUG) {
                    DEBUG_STREAM.println((String)query);
                }
                int n = stmt.executeUpdate();
                return n;
            }
        }
    }

    public static enum ConflictMode {
        ABORT("OR ABORT"),
        FAIL("OR FAIL"),
        IGNORE("OR IGNORE"),
        NONE(""),
        REPLACE("OR REPLACE"),
        ROLLBACK("OR ROLLBACK");

        private final String value;

        private ConflictMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @FunctionalInterface
    public static interface TryConsumer<T> {
        public void accept(T var1) throws SQLException;
    }

    public static class CombinedOperandField
    implements OperandField {
        private Combinator combinator;
        private List<OperandField> operands;

        public CombinedOperandField(Combinator combinator, List<OperandField> operands) {
            this.combinator = combinator;
            this.operands = operands;
        }

        @Override
        public String createStatement() {
            return this.operands.stream().map(OperandField::createStatement).collect(Collectors.joining(" " + this.combinator.name() + " "));
        }

        @Override
        public int applyStatement(PreparedStatement pstmt, int baseIndex) throws SQLException {
            int totalIndices = 0;
            for (int i = 0; i < this.operands.size(); ++i) {
                OperandField operand = this.operands.get(i);
                totalIndices += operand.applyStatement(pstmt, baseIndex + totalIndices);
            }
            return totalIndices;
        }

        @Override
        public FieldType getType() {
            return null;
        }
    }

    public static enum Combinator {
        AND,
        OR;

    }

    public static class BinaryOperandField
    implements OperandField {
        private final OperandField left;
        private final String operator;
        private final OperandField right;
        private final Field rightField;
        private final Object rightValue;
        private final FieldType rightType;

        public BinaryOperandField(Field leftField, String operator, OperandField right) {
            this((OperandField)new UnaryOperandField(leftField), operator, right);
        }

        public BinaryOperandField(Field leftField, String operator, Field rightField) {
            this((OperandField)new UnaryOperandField(leftField), operator, rightField);
        }

        public BinaryOperandField(Field leftField, Object rightValue) {
            this(new UnaryOperandField(leftField), "=", rightValue, leftField.getType());
        }

        public BinaryOperandField(Field leftField, String operator, Object rightValue) {
            this(new UnaryOperandField(leftField), operator, rightValue, leftField.getType());
        }

        public BinaryOperandField(Field leftField, String operator, Object rightValue, FieldType rightType) {
            this(new UnaryOperandField(leftField), operator, rightValue, rightType);
        }

        public BinaryOperandField(OperandField left, String operator, OperandField right) {
            this.left = left;
            this.right = right;
            this.rightField = null;
            this.rightValue = null;
            this.rightType = null;
            this.operator = operator;
        }

        public BinaryOperandField(OperandField left, String operator, Field rightField) {
            this.left = left;
            this.right = null;
            this.rightField = rightField;
            this.rightValue = null;
            this.rightType = rightField.getType();
            this.operator = operator;
        }

        public BinaryOperandField(OperandField left, String operator, Object rightValue, FieldType rightType) {
            this.left = left;
            this.right = null;
            this.rightField = null;
            this.rightValue = rightValue;
            this.rightType = rightType;
            this.operator = operator;
        }

        @Override
        public String createStatement() {
            if (this.right != null) {
                return String.format("(%s %s %s)", this.left.createStatement(), this.operator, this.right.createStatement());
            }
            if (this.rightField != null) {
                return String.format("(%s %s %s)", this.left.createStatement(), this.operator, this.rightField.getFullName());
            }
            return String.format("(%s %s ?)", this.left.createStatement(), this.operator);
        }

        @Override
        public int applyStatement(PreparedStatement pstmt, int baseIndex) throws SQLException {
            int totalIndices = this.left.applyStatement(pstmt, baseIndex);
            if (this.right != null) {
                totalIndices += this.right.applyStatement(pstmt, baseIndex + totalIndices);
            } else if (this.rightValue != null) {
                this.rightType.set(pstmt, baseIndex + totalIndices, this.rightValue);
                ++totalIndices;
            }
            return totalIndices;
        }

        @Override
        public FieldType getType() {
            return this.left.getType();
        }
    }

    public static class UnaryOperandField
    implements OperandField {
        private final Field field;

        public UnaryOperandField(Field field) {
            this.field = field;
        }

        @Override
        public String createStatement() {
            return this.field.getFullName();
        }

        @Override
        public int applyStatement(PreparedStatement pstmt, int baseIndex) throws SQLException {
            return 0;
        }

        @Override
        public FieldType getType() {
            return this.field.getType();
        }
    }

    public static interface OperandField {
        public String createStatement();

        public int applyStatement(PreparedStatement var1, int var2) throws SQLException;

        public FieldType getType();

        public static OperandField or(List<OperandField> operands) {
            return new CombinedOperandField(Combinator.OR, operands);
        }
    }

    public static class RawInsertableField
    extends InsertableField {
        public RawInsertableField(Field field, String rawValue) {
            super(field, rawValue);
        }

        public String getRawValue() {
            return (String)this.getValue();
        }

        @Override
        public String createStatement() {
            return String.format("%s = %s", this.getField().getColumnName(), this.getRawValue());
        }

        @Override
        public void applyStatement(PreparedStatement pstmt, int index) throws SQLException {
        }
    }

    public static class InsertableField
    implements Comparable<InsertableField> {
        private final Field field;
        private final Object value;

        public InsertableField(Field field, Object value) {
            this.field = field;
            this.value = value;
        }

        public Field getField() {
            return this.field;
        }

        public Object getValue() {
            return this.value;
        }

        public String createStatement() {
            return String.format("%s = ?", this.getField().getColumnName());
        }

        public void applyStatement(PreparedStatement pstmt, int index) throws SQLException {
            this.getField().setValue(pstmt, index, this.getValue());
        }

        @Override
        public int compareTo(InsertableField other) {
            return Comparator.comparingInt(field -> field.getField().ordinal()).thenComparing(field -> field.getField().getColumnName()).compare(this, other);
        }
    }

    public static class ExecutableUpdate {
        private final Update update;
        private final List<InsertableField> values;
        private WhereClause whereClause;

        public ExecutableUpdate(Update update, List<InsertableField> values) {
            this.update = update;
            this.values = values;
        }

        public ExecutableUpdate where(String where) {
            this.whereClause = new WhereClause(where);
            return this;
        }

        public ExecutableUpdate where(String where, TryConsumer<PreparedStatement> statementConsumer) {
            this.whereClause = new WhereClause(where, statementConsumer);
            return this;
        }

        public ExecutableUpdate where(List<? extends OperandField> whereFields) {
            this.whereClause = new WhereClause(whereFields);
            return this;
        }

        public int execute() throws SQLException {
            String values = this.values.stream().map(InsertableField::createStatement).collect(Collectors.joining(", "));
            Object query = String.format("UPDATE %s SET %s", this.update.getTableName(), values);
            if (this.whereClause != null) {
                query = (String)query + this.whereClause.getClause();
            }
            try (PreparedStatement stmt = this.update.getConnection().prepareStatement((String)query);){
                for (int i = 0; i < this.values.size(); ++i) {
                    InsertableField field = this.values.get(i);
                    field.applyStatement(stmt, i + 1);
                }
                if (this.whereClause != null) {
                    this.whereClause.applyStatement(stmt, this.values.size());
                }
                if (DEBUG) {
                    DEBUG_STREAM.println((String)query);
                }
                int n = stmt.executeUpdate();
                return n;
            }
        }
    }

    public static class ExecutableSelectInsert {
        private final SelectInsert selectInsert;
        private final List<Field> columns;
        private ConflictMode conflictMode = ConflictMode.NONE;

        public ExecutableSelectInsert(SelectInsert selectInsert, List<Field> columns) {
            this.selectInsert = selectInsert;
            this.columns = columns;
        }

        public ExecutableSelectInsert onConflict(ConflictMode conflictMode) {
            this.conflictMode = conflictMode == null ? ConflictMode.NONE : conflictMode;
            return this;
        }

        public int execute() throws SQLException {
            String fields = this.columns.stream().map(field -> field.getColumnName()).collect(Collectors.joining(", "));
            String selectQuery = this.selectInsert.getSelect().generateQuery();
            String query = String.format("INSERT %s INTO %s (%s) %s", this.conflictMode.getValue(), this.selectInsert.getInsert().getTableName(), fields, selectQuery);
            try (PreparedStatement stmt = this.selectInsert.getInsert().getConnection().prepareStatement(query);){
                if (this.selectInsert.getSelect().getWhereClause() != null) {
                    this.selectInsert.getSelect().getWhereClause().applyStatement(stmt, 0);
                }
                if (DEBUG) {
                    DEBUG_STREAM.println(query);
                }
                int n = stmt.executeUpdate();
                return n;
            }
        }
    }

    public static class SelectInsert {
        private final Insert insert;
        private final ExecutableSelect select;

        public SelectInsert(Insert insert, ExecutableSelect select) {
            this.insert = insert;
            this.select = select;
        }

        public ExecutableSelectInsert columns(List<Field> columns) {
            return new ExecutableSelectInsert(this, columns);
        }

        public Insert getInsert() {
            return this.insert;
        }

        public ExecutableSelect getSelect() {
            return this.select;
        }
    }

    public static class ValuesInsert {
        private final Insert insert;
        private final List<List<InsertableField>> bulkValues;
        private ConflictMode conflictMode = ConflictMode.NONE;

        public ValuesInsert(Insert insert, List<List<InsertableField>> bulkValues) {
            this.insert = insert;
            this.bulkValues = bulkValues;
        }

        public ValuesInsert onConflict(ConflictMode conflictMode) {
            this.conflictMode = conflictMode == null ? ConflictMode.NONE : conflictMode;
            return this;
        }

        public int execute() throws SQLException {
            String insertKeyword = "INSERT" + (String)(this.conflictMode.getValue().isEmpty() ? "" : " " + this.conflictMode.getValue()) + " INTO";
            String fields = this.bulkValues.get(0).stream().map(value -> value.getField().getColumnName()).collect(Collectors.joining(", "));
            String bulkValues = this.bulkValues.stream().map(values -> values.stream().map(value -> "?").collect(Collectors.joining(", ", "(", ")"))).collect(Collectors.joining(", "));
            String query = String.format("%s %s (%s) VALUES %s", insertKeyword, this.insert.getTableName(), fields, bulkValues);
            int columnSize = this.bulkValues.get(0).size();
            try (PreparedStatement stmt = this.insert.getConnection().prepareStatement(query);){
                for (int i = 0; i < this.bulkValues.size(); ++i) {
                    List<InsertableField> values2 = this.bulkValues.get(i);
                    for (int j = 0; j < values2.size(); ++j) {
                        InsertableField field = values2.get(j);
                        field.applyStatement(stmt, i * columnSize + (j + 1));
                    }
                }
                if (DEBUG) {
                    DEBUG_STREAM.println(query);
                }
                int n = stmt.executeUpdate();
                return n;
            }
        }
    }

    public static enum Order {
        ASC,
        DESC;

    }

    private record OrderBy(String column, Order order) {
        public String createStatement() {
            return String.format("%s %s", this.column, this.order.name());
        }
    }

    public record Join(JoinType joinType, Field joinField, String rightField) {
        public static Join inner(Field joinField, Field rightField) {
            return new Join(JoinType.INNER, joinField, rightField.getFullName());
        }

        public static Join inner(Field joinField, String rightField) {
            return new Join(JoinType.INNER, joinField, rightField);
        }

        public static Join left(Field joinField, Field rightField) {
            return new Join(JoinType.LEFT, joinField, rightField.getFullName());
        }

        public String createStatement() {
            return String.format("%s JOIN %s ON %s = %s", this.joinType.name(), this.joinField.getTableName(), this.joinField.getFullName(), this.rightField);
        }
    }

    public static enum JoinType {
        INNER,
        LEFT;

    }

    public static class WhereClause {
        private String where;
        private TryConsumer<PreparedStatement> statementConsumer;
        private List<? extends OperandField> whereFields;

        public WhereClause(String where) {
            this.where = where;
        }

        public WhereClause(String where, TryConsumer<PreparedStatement> statementConsumer) {
            this.where = where;
            this.statementConsumer = statementConsumer;
        }

        public WhereClause(List<? extends OperandField> whereFields) {
            this.whereFields = whereFields;
            this.where = this.whereFields.stream().map(OperandField::createStatement).collect(Collectors.joining(" AND "));
        }

        public String getClause() {
            return " WHERE " + this.where;
        }

        public void applyStatement(PreparedStatement pstmt, int baseIndex) throws SQLException {
            if (this.whereFields != null) {
                int index = baseIndex;
                for (int i = 0; i < this.whereFields.size(); ++i) {
                    OperandField field = this.whereFields.get(i);
                    index += field.applyStatement(pstmt, index + 1);
                }
            }
            if (this.statementConsumer != null) {
                this.statementConsumer.accept(pstmt);
            }
        }
    }

    public static class CreateIndexWithName {
        private final CreateIndex createIndex;
        private final String name;
        private final List<Field> columns = new ArrayList<Field>();

        public CreateIndexWithName(CreateIndex createIndex, String name) {
            this.createIndex = createIndex;
            this.name = name;
        }

        public CreateIndexWithName addColumn(Field column) {
            this.columns.add(column);
            return this;
        }

        public void execute() throws SQLException {
            String columnNames = this.columns.stream().map(Field::getColumnName).collect(Collectors.joining(", "));
            String query = String.format("CREATE %s IF NOT EXISTS %s ON %s (%s)", this.createIndex.isUnique() ? "UNIQUE INDEX" : "INDEX", this.name, this.createIndex.getTableName(), columnNames);
            try (Statement stmt = this.createIndex.getConnection().createStatement();){
                if (DEBUG) {
                    DEBUG_STREAM.println(query);
                }
                stmt.execute(query);
            }
        }
    }

    public static class AlterTableWithRenameTo {
        private final AlterTable alterTable;
        private final String newTableName;

        public AlterTableWithRenameTo(AlterTable alterTable, String newTableName) {
            this.alterTable = alterTable;
            this.newTableName = newTableName;
        }

        public void execute() throws SQLException {
            String query = String.format("ALTER TABLE %s RENAME TO %s", this.alterTable.getTableName(), this.newTableName);
            try (Statement stmt = this.alterTable.getConnection().createStatement();){
                if (DEBUG) {
                    DEBUG_STREAM.println(query);
                }
                stmt.execute(query);
            }
        }
    }

    public static class AlterTableWithDropColumn {
        private final AlterTable alterTable;
        private final String columnName;

        public AlterTableWithDropColumn(AlterTable alterTable, String columnName) {
            this.alterTable = alterTable;
            this.columnName = columnName;
        }

        public void execute() throws SQLException {
            String query = String.format("ALTER TABLE %s DROP COLUMN %s", this.alterTable.getTableName(), this.columnName);
            try (Statement stmt = this.alterTable.getConnection().createStatement();){
                if (DEBUG) {
                    DEBUG_STREAM.println(query);
                }
                stmt.execute(query);
            }
        }
    }

    public static class AlterTableWithAddColumn {
        private final AlterTable alterTable;
        private final Field newField;

        public AlterTableWithAddColumn(AlterTable alterTable, Field newField) {
            this.alterTable = alterTable;
            this.newField = newField;
        }

        public void execute() throws SQLException {
            String query = String.format("ALTER TABLE %s ADD COLUMN %s", this.alterTable.getTableName(), this.newField.createColumnDefinition(true));
            try (Statement stmt = this.alterTable.getConnection().createStatement();){
                if (DEBUG) {
                    DEBUG_STREAM.println(query);
                }
                stmt.execute(query);
            }
            if (this.newField.isUnique()) {
                this.alterTable.getDatabaseLayer().createIndex(this.alterTable.getTableName()).withUnique(true).withName(String.format("idx_%s_%s", this.alterTable.getTableName(), this.newField.getColumnName())).addColumn(this.newField).execute();
            }
        }
    }

    public static class DropIndexWithName {
        private final DropIndex dropIndex;
        private final String name;

        public DropIndexWithName(DropIndex dropIndex, String name) {
            this.dropIndex = dropIndex;
            this.name = name;
        }

        public void execute() throws SQLException {
            String query = String.format("DROP INDEX IF EXISTS %s", this.name);
            try (Statement stmt = this.dropIndex.getConnection().createStatement();){
                if (DEBUG) {
                    DEBUG_STREAM.println(query);
                }
                stmt.execute(query);
            }
        }
    }

    public static class ExecutableCreateVirtualTable {
        private final CreateVirtualTableWithContent createVirtualTableWithContent;
        private final List<Field> fields;

        public ExecutableCreateVirtualTable(CreateVirtualTableWithContent createVirtualTableWithContent, List<Field> fields) {
            this.createVirtualTableWithContent = createVirtualTableWithContent;
            this.fields = fields;
        }

        public void execute() throws SQLException {
            Object fields = this.fields.stream().map(Field::getColumnName).collect(Collectors.joining(", "));
            fields = (String)fields + ", content=" + this.createVirtualTableWithContent.getContent();
            fields = (String)fields + ", content_rowid=" + this.createVirtualTableWithContent.getContentRowId();
            String query = String.format("CREATE VIRTUAL TABLE IF NOT EXISTS %s USING %s (%s)", this.createVirtualTableWithContent.getCreateVirtualTable().getTableName(), this.createVirtualTableWithContent.getCreateVirtualTable().getModuleName(), fields);
            try (Statement stmt = this.createVirtualTableWithContent.getCreateVirtualTable().getConnection().createStatement();){
                if (DEBUG) {
                    DEBUG_STREAM.println(query);
                }
                stmt.execute(query);
            }
        }
    }

    public static class CreateVirtualTableWithContent {
        private final CreateVirtualTable createVirtualTable;
        private final String content;
        private final String contentRowId;

        public CreateVirtualTableWithContent(CreateVirtualTable createVirtualTable, String content, String contentRowId) {
            this.createVirtualTable = createVirtualTable;
            this.content = content;
            this.contentRowId = contentRowId;
        }

        public CreateVirtualTable getCreateVirtualTable() {
            return this.createVirtualTable;
        }

        public String getContent() {
            return this.content;
        }

        public String getContentRowId() {
            return this.contentRowId;
        }

        public ExecutableCreateVirtualTable fields(List<Field> fields) {
            return new ExecutableCreateVirtualTable(this, fields);
        }
    }

    public static class ExecutableCreateTable {
        private final CreateTable createTable;
        private final List<Field> fields;

        public ExecutableCreateTable(CreateTable createTable, List<Field> fields) {
            this.createTable = createTable;
            this.fields = fields;
        }

        public void execute() throws SQLException {
            String fields = this.fields.stream().map(Field::createColumnDefinition).collect(Collectors.joining(", "));
            String query = String.format("CREATE TABLE IF NOT EXISTS %s (%s)", this.createTable.getTableName(), fields);
            try (Statement stmt = this.createTable.getConnection().createStatement();){
                if (DEBUG) {
                    DEBUG_STREAM.println(query);
                }
                stmt.execute(query);
            }
        }
    }

    public static abstract class SqlStatement {
        private final DatabaseLayer databaseLayer;

        public SqlStatement(DatabaseLayer databaseLayer) {
            this.databaseLayer = databaseLayer;
        }

        public DatabaseLayer getDatabaseLayer() {
            return this.databaseLayer;
        }

        public Connection getConnection() {
            return this.databaseLayer.getConnection();
        }
    }
}

