/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.framework.junit5.utils;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.application.Platform;

public final class FXUtils {
    public static void assertJavaFxThread() {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("access JavaFX from non-JavaFX thread - please fix");
        }
    }

    public static void keepJavaFxAlive() {
        Platform.setImplicitExit((boolean)false);
    }

    public static void runAndWait(Runnable function) throws Exception {
        FXUtils.runAndWait("runAndWait(Runnable)", t -> {
            function.run();
            return "FXUtils::runAndWait - null Runnable return";
        });
    }

    public static <R> R runAndWait(Supplier<R> function) throws Exception {
        return (R)FXUtils.runAndWait("runAndWait(Supplier<R>)", t -> function.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> R runAndWait(T argument, Function<T, R> function) throws Exception {
        if (Platform.isFxApplicationThread()) {
            return function.apply(argument);
        }
        AtomicBoolean runCondition = new AtomicBoolean(true);
        ReentrantLock lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        ExceptionWrapper throwableWrapper = new ExceptionWrapper();
        RunnableWithReturn<Object> run = new RunnableWithReturn<Object>(() -> {
            Object returnValue = null;
            lock.lock();
            try {
                returnValue = function.apply(argument);
            }
            catch (Exception e) {
                throwableWrapper.t = e;
            }
            finally {
                try {
                    runCondition.set(false);
                    condition.signal();
                }
                finally {
                    runCondition.set(false);
                    lock.unlock();
                }
            }
            return returnValue;
        });
        lock.lock();
        try {
            Platform.runLater(run);
            while (runCondition.get()) {
                condition.await();
            }
            if (throwableWrapper.t != null) {
                throw throwableWrapper.t;
            }
        }
        finally {
            lock.unlock();
        }
        return (R)run.getReturnValue();
    }

    public static void runFX(Runnable run) {
        FXUtils.keepJavaFxAlive();
        if (Platform.isFxApplicationThread()) {
            run.run();
        } else {
            Platform.runLater((Runnable)run);
        }
    }

    private static class ExceptionWrapper {
        private Exception t;

        private ExceptionWrapper() {
        }
    }

    private static class RunnableWithReturn<R>
    implements Runnable {
        private final Supplier<R> internalRunnable;
        private final Object lock = new Object();
        private R returnValue;

        public RunnableWithReturn(Supplier<R> run) {
            this.internalRunnable = run;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public R getReturnValue() {
            Object object = this.lock;
            synchronized (object) {
                return this.returnValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                this.returnValue = this.internalRunnable.get();
            }
        }
    }
}

