/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.tring;

import io.privacyresearch.tring.JArrayByte;
import io.privacyresearch.tring.JByteArray;
import io.privacyresearch.tring.JByteArray2D;
import io.privacyresearch.tring.JPString;
import io.privacyresearch.tring.NativeLibLoader;
import io.privacyresearch.tring.RString;
import io.privacyresearch.tring.TringDevice;
import io.privacyresearch.tring.createCallEndpoint$answerCallback;
import io.privacyresearch.tring.createCallEndpoint$genericCallback;
import io.privacyresearch.tring.createCallEndpoint$iceUpdateCallback;
import io.privacyresearch.tring.createCallEndpoint$offerCallback;
import io.privacyresearch.tring.createCallEndpoint$statusCallback;
import io.privacyresearch.tring.createCallEndpoint$videoFrameCallback;
import io.privacyresearch.tring.rtc_Bytes;
import io.privacyresearch.tring.rtc_calllinks_CallLinkRootKey_parse$callback;
import io.privacyresearch.tring.tringlib_h;
import io.privacyresearch.tringapi.PeekInfo;
import io.privacyresearch.tringapi.TringApi;
import io.privacyresearch.tringapi.TringFrame;
import io.privacyresearch.tringapi.TringService;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TringServiceImpl
implements TringService {
    static final int BANDWIDTH_QUALITY_HIGH = 2;
    private static final TringService instance = new TringServiceImpl();
    private static boolean nativeSupport = false;
    private static long nativeVersion = 0L;
    private Arena scope;
    private long callEndpoint;
    private TringApi api;
    private long activeCallId;
    static String libName = "unknown";
    BlockingQueue<TringFrame> frameQueue = new LinkedBlockingQueue<TringFrame>();
    private int clientId = -1;
    private byte[] localGroupId;
    private static final Logger LOG = Logger.getLogger(TringServiceImpl.class.getName());
    ExecutorService executor = Executors.newFixedThreadPool(1);

    public String getVersionInfo() {
        return "TringServiceImpl using " + libName;
    }

    public static long getNativeVersion() {
        return nativeVersion;
    }

    public void setApi(TringApi api) {
        this.api = api;
        this.initiate();
    }

    private void initiate() {
        this.createScope();
        tringlib_h.initRingRTC(TringServiceImpl.toJString(this.scope, "Hello from Java"));
        this.callEndpoint = tringlib_h.createCallEndpoint(this.createStatusCallback(), this.createAnswerCallback(), this.createOfferCallback(), this.createIceUpdateCallback(), this.createGenericCallback(), this.createVideoFrameCallback());
        this.initializeNative(this.callEndpoint);
    }

    void createScope() {
        this.scope = Arena.ofShared();
    }

    private void processAudioInputs() {
        LOG.warning("Process Audio Inputs asked, not supported!");
        MemorySegment audioInputs = tringlib_h.getAudioInputs(this.scope, this.callEndpoint, 0);
        MemorySegment name = TringDevice.name(audioInputs);
        int namelen = (int)RString.len(name);
        MemorySegment namebuff = RString.buff(name);
    }

    public void receivedOffer(String peerId, long callId, int senderDeviceId, int receiverDeviceId, byte[] senderKey, byte[] receiverKey, byte[] opaque) {
        int mediaType = 0;
        long ageSec = 0L;
        this.activeCallId = callId;
        LOG.info("Pass received offer to tringlib");
        tringlib_h.receivedOffer(this.callEndpoint, TringServiceImpl.toJString(this.scope, peerId), callId, mediaType, senderDeviceId, receiverDeviceId, TringServiceImpl.toJByteArray(this.scope, senderKey), TringServiceImpl.toJByteArray(this.scope, receiverKey), TringServiceImpl.toJByteArray(this.scope, opaque), ageSec);
    }

    public void receivedOpaqueMessage(byte[] senderUuid, int senderDeviceId, int localDeviceId, byte[] opaque, long age) {
        tringlib_h.receivedOpaqueMessage(this.callEndpoint, TringServiceImpl.toJByteArray(this.scope, senderUuid), senderDeviceId, localDeviceId, TringServiceImpl.toJByteArray(this.scope, opaque), age);
    }

    public void receivedAnswer(String peerId, long callId, int senderDeviceId, byte[] senderKey, byte[] receiverKey, byte[] opaque) {
        boolean mediaType = false;
        long ageSec = 0L;
        this.activeCallId = callId;
        LOG.info("Pass received answer to tringlib");
        tringlib_h.receivedAnswer(this.callEndpoint, TringServiceImpl.toJString(this.scope, peerId), callId, senderDeviceId, TringServiceImpl.toJByteArray(this.scope, senderKey), TringServiceImpl.toJByteArray(this.scope, receiverKey), TringServiceImpl.toJByteArray(this.scope, opaque));
    }

    public void setSelfUuid(byte[] uuid) {
        LOG.info("Pass our uuid to tring: " + String.valueOf(uuid));
        tringlib_h.setSelfUuid(this.callEndpoint, TringServiceImpl.toJByteArray(this.scope, uuid));
    }

    public void proceed(long callId, String iceUser, String icePwd, String hostName, List<byte[]> ice) {
        MemorySegment icePack = TringServiceImpl.toJByteArray2D(this.scope, ice);
        tringlib_h.setOutgoingAudioEnabled(this.callEndpoint, true);
        LOG.info("Proceeding call now...");
        tringlib_h.proceedCall(this.callEndpoint, callId, 2, 0, TringServiceImpl.toJString(this.scope, iceUser), TringServiceImpl.toJString(this.scope, icePwd), TringServiceImpl.toJString(this.scope, hostName), icePack);
        LOG.info("Proceeded call");
    }

    public void receivedIce(long callId, int senderDeviceId, List<byte[]> ice) {
        MemorySegment icePack = TringServiceImpl.toJByteArray2D(this.scope, ice);
        tringlib_h.receivedIce(this.callEndpoint, callId, senderDeviceId, icePack);
    }

    public void acceptCall() {
        LOG.info("Set audioInput to 0");
        tringlib_h.setAudioInput(this.callEndpoint, (short)0);
        LOG.info("Set audiorecording");
        tringlib_h.setOutgoingAudioEnabled(this.callEndpoint, true);
        LOG.info("And now accept the call");
        tringlib_h.acceptCall(this.callEndpoint, this.activeCallId);
        LOG.info("Accepted the call");
    }

    public void ignoreCall() {
        LOG.info("Ignore the call");
        tringlib_h.ignoreCall(this.callEndpoint, this.activeCallId);
    }

    public void hangupCall() {
        LOG.info("Hangup the call");
        if (this.clientId < 0) {
            tringlib_h.hangupCall(this.callEndpoint);
        } else {
            tringlib_h.disconnect(this.callEndpoint, this.clientId);
        }
    }

    public long startOutgoingCall(long callId, String peerId, int localDeviceId, boolean enableVideo) {
        LOG.info("Tring will start outgoing call to " + peerId + " with localDevice " + localDeviceId + " and enableVideo = " + enableVideo);
        tringlib_h.setAudioInput(this.callEndpoint, (short)0);
        tringlib_h.setAudioOutput(this.callEndpoint, (short)0);
        tringlib_h.createOutgoingCall(this.callEndpoint, TringServiceImpl.toJString(this.scope, peerId), enableVideo, localDeviceId, callId);
        return callId;
    }

    public void peekGroupCall(byte[] membershipProof, byte[] members) {
        LOG.info("Need to peek groupcall, memberslength = " + members.length);
        tringlib_h.peekGroupCall(this.callEndpoint, TringServiceImpl.toJByteArray(this.scope, membershipProof), TringServiceImpl.toJByteArray(this.scope, members));
    }

    public long createGroupCallClient(byte[] nogroupId, String sfu, byte[] hkdf) {
        LOG.info("delegate creategroupcallclient to rust, groupId = " + Arrays.toString(this.localGroupId));
        long myclientId = tringlib_h.createGroupCallClient(this.callEndpoint, TringServiceImpl.toJByteArray(this.scope, this.localGroupId), TringServiceImpl.toJString(this.scope, sfu), TringServiceImpl.toJByteArray(this.scope, hkdf));
        this.clientId = (int)myclientId;
        LOG.info("Created client, id = " + this.clientId + ". Will connect now");
        tringlib_h.setOutgoingAudioMuted(this.callEndpoint, this.clientId, true);
        tringlib_h.setOutgoingVideoMuted(this.callEndpoint, this.clientId, true);
        this.setGroupBandWidth(this.clientId, 2);
        tringlib_h.group_connect(this.callEndpoint, this.clientId);
        LOG.info("Connected, id = " + this.clientId);
        LOG.info("Ask for video");
        this.requestVideo(this.callEndpoint, this.clientId, 1);
        LOG.info("Asked for video");
        tringlib_h.setOutgoingAudioMuted(this.callEndpoint, this.clientId, false);
        tringlib_h.setOutgoingVideoMuted(this.callEndpoint, this.clientId, false);
        this.setGroupBandWidth(this.clientId, 2);
        tringlib_h.join(this.callEndpoint, this.clientId);
        return this.clientId;
    }

    public void setGroupBandWidth(int groupId, int bandwidthMode) {
        tringlib_h.setDataMode(this.callEndpoint, groupId, bandwidthMode);
    }

    public void setArray() {
        LOG.info("SET ARRAY");
        int CAP = 1000000;
        for (int i = 0; i < 1000; ++i) {
            try (Arena rscope = Arena.ofShared();){
                MemorySegment segment = rscope.allocate(CAP);
                tringlib_h.fillLargeArray(123L, segment);
                ByteBuffer bb = segment.asByteBuffer();
                byte[] bar = new byte[CAP];
                bb.get(bar, 0, CAP);
                LOG.info("Got Array " + i + " sized " + bar.length);
                continue;
            }
        }
        LOG.info("DONE");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TringFrame getRemoteVideoFrame(int demuxId, boolean skip) {
        int CAP = 5000000;
        try (Arena rscope = Arena.ofShared();){
            TringFrame answer;
            MemorySegment segment = rscope.allocate(CAP);
            long res = tringlib_h.fillRemoteVideoFrame(this.callEndpoint, demuxId, segment, CAP);
            if (res == 0L) return null;
            int w = (int)(res >> 16);
            int h = (int)(res % 65536L);
            byte[] raw = new byte[w * h * 4];
            ByteBuffer bb = segment.asByteBuffer();
            bb.get(raw);
            TringFrame tringFrame = answer = new TringFrame(w, h, -1, raw);
            return tringFrame;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public void enableOutgoingAudio(boolean enable) {
        LOG.info("Toggle own audio to " + enable + ", for clientid = " + this.clientId);
        if (this.clientId < 0) {
            tringlib_h.setOutgoingAudioEnabled(this.callEndpoint, enable);
        } else {
            tringlib_h.setOutgoingAudioMuted(this.callEndpoint, this.clientId, !enable);
        }
    }

    public void enableOutgoingVideo(boolean enable) {
        LOG.info("Toggle own video to " + enable + ", for clientid = " + this.clientId);
        if (this.clientId < 0) {
            tringlib_h.setOutgoingVideoEnabled(this.callEndpoint, enable);
        } else {
            tringlib_h.setOutgoingVideoMuted(this.callEndpoint, this.clientId, !enable);
        }
    }

    public void sendVideoFrame(int w, int h, int pixelFormat, byte[] raw) {
        try (Arena session = Arena.ofConfined();){
            int size = raw.length;
            MemorySegment rawSegment = MemorySegment.ofArray(raw);
            MemorySegment buff = session.allocate(MemoryLayout.sequenceLayout(size, ValueLayout.JAVA_BYTE));
            buff.copyFrom(rawSegment);
            tringlib_h.sendVideoFrame(this.callEndpoint, w, h, pixelFormat, buff);
        }
    }

    static MemorySegment toJByteArray2D(Arena ms, List<byte[]> rows) {
        LOG.info("Create JB2 with " + rows.size() + " rows: ");
        MemorySegment answer = JByteArray2D.allocate(ms);
        JByteArray2D.len(answer, rows.size());
        MemorySegment bufferSegment = JByteArray2D.buff(answer);
        LOG.info("Prep JB2D, length = " + JByteArray2D.len(answer));
        for (int i = 0; i < rows.size(); ++i) {
            MemorySegment singleRowSegment = TringServiceImpl.toJByteArray(ms, rows.get(i));
            JByteArray2D.buff(bufferSegment, i, singleRowSegment);
        }
        LOG.info("Size of memory segment = " + answer.byteSize());
        LOG.info("Return JB2D, length = " + JByteArray2D.len(answer));
        return answer;
    }

    static MemorySegment toJByteArray(Arena arena, byte[] raw) {
        MemorySegment answer = JByteArray.allocate(arena);
        int size = raw.length;
        MemorySegment rawSegment = MemorySegment.ofArray(raw);
        MemorySegment transfer = arena.allocate(size);
        transfer.copyFrom(rawSegment);
        JByteArray.len(answer, size);
        JByteArray.buff(answer, transfer);
        return answer;
    }

    static byte[] fromJArrayByte(MemorySegment jArrayByte) {
        int len = (int)JArrayByte.len(jArrayByte);
        MemorySegment dataSegment = JArrayByte.data(jArrayByte).asSlice(0L, len);
        byte[] destArr = new byte[len];
        MemorySegment dstSeq = MemorySegment.ofArray(destArr);
        dstSeq.copyFrom(dataSegment);
        return destArr;
    }

    static MemorySegment toJString(Arena arena, String src) {
        MemorySegment answer = JPString.allocate(arena);
        byte[] bytes = src.getBytes();
        JPString.len(answer, bytes.length);
        MemorySegment byteBuffer = MemorySegment.ofArray(bytes);
        MemorySegment pass = arena.allocate(bytes.length);
        pass.copyFrom(byteBuffer);
        JPString.buff(answer, pass);
        return answer;
    }

    private List<UUID> getUUIDs(List joined) {
        ArrayList<UUID> joinedMembers = new ArrayList<UUID>();
        for (Object entry : joined) {
            ByteBuffer bb = ByteBuffer.wrap((byte[])entry);
            joinedMembers.add(new UUID(bb.getLong(), bb.getLong()));
        }
        return joinedMembers;
    }

    public void handlePeekChanged(List joined, byte[] creator, String era, long maxDevices, long deviceCount) {
        LOG.info("In java: GOT PEEK CHANGED");
        List<UUID> joinedMembers = this.getUUIDs(joined);
        UUID creatorId = null;
        if (creator != null) {
            ByteBuffer bb = ByteBuffer.wrap(creator);
            creatorId = new UUID(bb.getLong(), bb.getLong());
        }
        LOG.info("Joined: " + String.valueOf(joinedMembers));
        LOG.info("Creator: " + String.valueOf(creatorId));
        PeekInfo peekInfo = new PeekInfo(joinedMembers, creatorId, era, Long.valueOf(maxDevices), deviceCount);
    }

    public void handlePeekResponse(List joined, byte[] creator, String era, long maxDevices, long deviceCount) {
        LOG.info("JAVA: GOT PEEK RESULT");
        List<UUID> joinedMembers = this.getUUIDs(joined);
        ByteBuffer bb = ByteBuffer.wrap(creator);
        UUID creatorId = new UUID(bb.getLong(), bb.getLong());
        PeekInfo peekInfo = new PeekInfo(joinedMembers, creatorId, era, Long.valueOf(maxDevices), deviceCount);
        this.api.receivedGroupCallPeekForRingingCheck(peekInfo);
    }

    public void handleRemoteDevicesChanged(List devices) {
        LOG.info("Devices changed into " + String.valueOf(devices));
        LinkedList<Integer> demuxIds = new LinkedList<Integer>();
        for (Object entry : devices) {
            ByteBuffer bb = ByteBuffer.wrap((byte[])entry);
            int demuxId = bb.getInt();
            demuxIds.add(demuxId);
            LOG.info("Schedule call to request video from " + demuxId);
            Runnable r = () -> this.requestVideo(this.callEndpoint, this.clientId, demuxId);
            this.executeRequest(r);
        }
        this.api.updateRemoteDevices(demuxIds);
    }

    public void makeHttpRequest(String uri, byte m, int reqid, byte[] headers, byte[] body) {
        try {
            LOG.info("MAKE REQUEST:" + uri + " and method = " + m + ", reqid = " + reqid + "and body has size " + body.length);
            ByteBuffer bb = ByteBuffer.wrap(headers);
            HashMap<String, Object> headerMap = new HashMap<String, Object>();
            while (bb.hasRemaining()) {
                byte[] b = new byte[bb.getInt()];
                bb.get(b);
                String key = new String(b);
                b = new byte[bb.getInt()];
                bb.get(b);
                String val = new String(b);
                headerMap.put(key, val);
            }
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(uri));
            for (Map.Entry entry : headerMap.entrySet()) {
                builder.header((String)entry.getKey(), (String)entry.getValue());
            }
            if (m == 1) {
                ByteBuffer bodybb = ByteBuffer.wrap(body);
                long bs = bodybb.getLong();
                byte[] bd = new byte[(int)bs];
                bodybb.get(bd);
                LOG.info("We need to PUT");
                builder.PUT(HttpRequest.BodyPublishers.ofByteArray(bd));
            }
            HttpRequest request = builder.build();
            try {
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                tringlib_h.panamaReceivedHttpResponse(this.callEndpoint, reqid, response.statusCode(), TringServiceImpl.toJByteArray(this.scope, response.body().getBytes()));
            }
            catch (IOException | InterruptedException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
        catch (Throwable t) {
            LOG.severe("Whoops! " + String.valueOf(t));
            t.printStackTrace();
        }
    }

    private native void initializeNative(long var1);

    private native void requestVideo(long var1, int var3, int var4);

    MemorySegment createStatusCallback() {
        StatusCallbackImpl sci = new StatusCallbackImpl();
        MemorySegment seg = createCallEndpoint$statusCallback.allocate(sci, this.scope);
        return seg;
    }

    MemorySegment createAnswerCallback() {
        AnswerCallbackImpl sci = new AnswerCallbackImpl();
        MemorySegment seg = createCallEndpoint$answerCallback.allocate(sci, this.scope);
        return seg;
    }

    MemorySegment createOfferCallback() {
        OfferCallbackImpl sci = new OfferCallbackImpl();
        MemorySegment seg = createCallEndpoint$offerCallback.allocate(sci, this.scope);
        return seg;
    }

    MemorySegment createIceUpdateCallback() {
        IceUpdateCallbackImpl sci = new IceUpdateCallbackImpl();
        MemorySegment seg = createCallEndpoint$iceUpdateCallback.allocate(sci, this.scope);
        return seg;
    }

    MemorySegment createGenericCallback() {
        GenericCallbackImpl sci = new GenericCallbackImpl();
        MemorySegment seg = createCallEndpoint$genericCallback.allocate(sci, this.scope);
        return seg;
    }

    MemorySegment createVideoFrameCallback() {
        VideoFrameCallbackImpl sci = new VideoFrameCallbackImpl();
        MemorySegment seg = createCallEndpoint$videoFrameCallback.allocate(sci, this.scope);
        return seg;
    }

    void sendAck() {
        LOG.info("Send Ack");
        try (Arena arena = Arena.ofConfined();){
            MemorySegment callid = arena.allocateFrom(ValueLayout.JAVA_LONG, this.activeCallId);
            tringlib_h.signalMessageSent(this.callEndpoint, callid);
        }
        LOG.info("Send Ack done");
    }

    private void executeRequest(Runnable r) {
        LOG.info("Executing request " + String.valueOf(r));
        Future<?> submit = this.executor.submit(r);
        LOG.info("Execution state = " + String.valueOf((Object)submit.state()));
    }

    public byte[] getCallLinkBytes(String link) {
        try {
            MemorySegment cString = this.scope.allocateFrom(link);
            CountDownLatch cdl = new CountDownLatch(1);
            CallLinkCallbackImpl callback2 = new CallLinkCallbackImpl(this, cdl);
            MemorySegment callbackSegment = rtc_calllinks_CallLinkRootKey_parse$callback.allocate(callback2, this.scope);
            tringlib_h.rtc_calllinks_CallLinkRootKey_parse(cString, MemorySegment.NULL, callbackSegment);
            boolean result = cdl.await(2L, TimeUnit.SECONDS);
            LOG.info("Got calllinkbytes within 2 seconds? " + result);
            return callback2.resultBytes;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    static {
        try {
            libName = NativeLibLoader.loadLibrary();
            nativeSupport = true;
            nativeVersion = tringlib_h.getVersion();
        }
        catch (Throwable ex) {
            System.err.println("No native RingRTC support: ");
            ex.printStackTrace();
        }
    }

    class StatusCallbackImpl
    implements createCallEndpoint$statusCallback.Function {
        StatusCallbackImpl() {
        }

        @Override
        public void apply(long id, long _x1, int direction, int type) {
            LOG.info("Got new status from ringrtc, id = " + id + ", x1 = " + _x1 + ", dir = " + direction + ", type = " + type);
            TringServiceImpl.this.api.statusCallback(id, _x1, direction, type);
            TringServiceImpl.this.sendAck();
        }
    }

    class AnswerCallbackImpl
    implements createCallEndpoint$answerCallback.Function {
        AnswerCallbackImpl() {
        }

        @Override
        public void apply(MemorySegment opaque) {
            System.err.println("TRINGBRIDGE, send answer!");
            byte[] bytes = TringServiceImpl.fromJArrayByte(opaque);
            System.err.println("TRING, bytes to send = " + Arrays.toString(bytes));
            TringServiceImpl.this.api.answerCallback(bytes);
            System.err.println("TRING, answer sent");
            TringServiceImpl.this.sendAck();
            System.err.println("TRING, ack sent");
        }
    }

    class OfferCallbackImpl
    implements createCallEndpoint$offerCallback.Function {
        OfferCallbackImpl() {
        }

        @Override
        public void apply(MemorySegment opaque) {
            byte[] bytes = TringServiceImpl.fromJArrayByte(opaque);
            TringServiceImpl.this.api.offerCallback(bytes);
            System.err.println("TRING, offer sent");
            TringServiceImpl.this.sendAck();
            System.err.println("TRING, ack sent");
        }
    }

    class IceUpdateCallbackImpl
    implements createCallEndpoint$iceUpdateCallback.Function {
        IceUpdateCallbackImpl() {
        }

        @Override
        public void apply(MemorySegment icePack) {
            byte[] bytes = TringServiceImpl.fromJArrayByte(icePack);
            ArrayList<byte[]> iceCandidates = new ArrayList<byte[]>();
            iceCandidates.add(bytes);
            TringServiceImpl.this.api.iceUpdateCallback(iceCandidates);
            TringServiceImpl.this.sendAck();
            LOG.info("iceUpdate done!");
        }
    }

    class GenericCallbackImpl
    implements createCallEndpoint$genericCallback.Function {
        GenericCallbackImpl() {
        }

        @Override
        public void apply(int opcode, MemorySegment data) {
            int clientId;
            ByteBuffer bb;
            byte[] bytes = TringServiceImpl.fromJArrayByte(data);
            LOG.info("Got generic  callback, opcode = " + opcode + " and data = " + Arrays.toString(bytes));
            if (opcode == 1) {
                LOG.info("This will lead to a groupCallUpdateRing");
                bb = ByteBuffer.wrap(bytes);
                int groupIdLen = bb.getInt();
                byte[] groupId = new byte[groupIdLen];
                bb.get(groupId);
                TringServiceImpl.this.localGroupId = groupId;
                long ringId = bb.getLong();
                byte[] senderBytes = new byte[bb.remaining() - 1];
                bb.get(senderBytes);
                byte status = bb.get();
                TringServiceImpl.this.api.groupCallUpdateRing(groupId, ringId, senderBytes, status);
            }
            if (opcode == 2) {
                bb = ByteBuffer.wrap(bytes);
                clientId = bb.getInt();
                int connectionStatus = bb.getInt();
                LOG.info("ConnectionState for " + clientId + " changed to " + connectionStatus);
            }
            if (opcode == 3) {
                LOG.info("Handling requestMembershipProof");
                bb = ByteBuffer.wrap(bytes);
                clientId = bb.getInt();
                Runnable r = () -> {
                    byte[] token = TringServiceImpl.this.api.requestGroupMembershipToken(TringServiceImpl.this.localGroupId);
                    tringlib_h.setMembershipProof(TringServiceImpl.this.callEndpoint, clientId, TringServiceImpl.toJByteArray(TringServiceImpl.this.scope, token));
                };
                TringServiceImpl.this.executeRequest(r);
                LOG.info("Handled requestMembershipProof");
            }
            if (opcode == 4) {
                bb = ByteBuffer.wrap(bytes);
                clientId = bb.getInt();
                byte[] memberinfo = TringServiceImpl.this.api.requestGroupMemberInfo(TringServiceImpl.this.localGroupId);
                tringlib_h.setGroupMembers(TringServiceImpl.this.callEndpoint, clientId, TringServiceImpl.toJByteArray(TringServiceImpl.this.scope, memberinfo));
            }
            if (opcode == 5) {
                bb = ByteBuffer.wrap(bytes);
                UUID recipient = new UUID(bb.getLong(), bb.getLong());
                int mlen = bb.getInt();
                byte[] messageb = new byte[mlen];
                LOG.info("Will send opaquecallmessage to " + String.valueOf(recipient) + " with byte len = " + mlen);
                bb.get(messageb);
                TringServiceImpl.this.api.sendOpaqueCallMessage(recipient, messageb, 0);
            }
        }
    }

    @Deprecated
    class VideoFrameCallbackImpl
    implements createCallEndpoint$videoFrameCallback.Function {
        VideoFrameCallbackImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply(MemorySegment opaque, int w, int h, long size) {
            LOG.info("Got incoming video frame in Java layer, w = " + w + ", h = " + h + ", size = " + size);
            System.err.println("Opaque = " + String.valueOf(opaque));
            MemorySegment segment = opaque.asSlice(0L, size);
            byte[] raw = segment.toArray(ValueLayout.JAVA_BYTE);
            BlockingQueue<TringFrame> blockingQueue = TringServiceImpl.this.frameQueue;
            synchronized (blockingQueue) {
                LOG.info("Add frame to queue");
                TringServiceImpl.this.frameQueue.add(new TringFrame(w, h, -1, raw));
                TringServiceImpl.this.frameQueue.notifyAll();
            }
            LOG.info("Processed incoming video frame in Java layer");
            TringServiceImpl.this.sendAck();
        }
    }

    class CallLinkCallbackImpl
    implements rtc_calllinks_CallLinkRootKey_parse$callback.Function {
        CountDownLatch cdl;
        byte[] resultBytes = new byte[0];

        CallLinkCallbackImpl(TringServiceImpl this$0, CountDownLatch cdl) {
            this.cdl = cdl;
        }

        @Override
        public void apply(MemorySegment context, MemorySegment resultPtr) {
            MemorySegment ptr2 = rtc_Bytes.ptr(resultPtr);
            long count = rtc_Bytes.count(resultPtr);
            this.resultBytes = new byte[(int)count];
            MemorySegment byteArraySegment = MemorySegment.ofArray(this.resultBytes);
            MemorySegment.copy(ptr2, 0L, byteArraySegment, 0L, count);
            this.cdl.countDown();
        }
    }
}

