/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtcrime.securesms.groups.v2.processing;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class StateChain<State, Delta> {
    private final AddDelta<State, Delta> add;
    private final SubtractStates<State, Delta> subtract;
    private final StateEquality<State> stateEquality;
    private final List<Pair<State, Delta>> pairs = new LinkedList<Pair<State, Delta>>();

    public StateChain(AddDelta<State, Delta> add, SubtractStates<State, Delta> subtract, StateEquality<State> stateEquality) {
        this.add = add;
        this.subtract = subtract;
        this.stateEquality = stateEquality;
    }

    public void push(State state, Delta delta) {
        if (delta == null && state == null) {
            return;
        }
        boolean bothSupplied = state != null && delta != null;
        State latestState = this.getLatestState();
        if (latestState == null && state == null) {
            return;
        }
        if (latestState != null) {
            if (delta == null) {
                delta = this.subtract.subtract(state, latestState);
            }
            if (state == null && (state = this.add.add(latestState, delta)) == null) {
                return;
            }
            if (bothSupplied) {
                State calculatedState = this.add.add(latestState, delta);
                if (calculatedState == null) {
                    this.push(state, null);
                    return;
                }
                if (!this.stateEquality.equals(state, calculatedState)) {
                    this.push(null, delta);
                    this.push(state, null);
                    return;
                }
            }
        }
        if (latestState == null || !this.stateEquality.equals(latestState, state)) {
            this.pairs.add(new Pair<State, Delta>(state, delta));
        }
    }

    public State getLatestState() {
        int size = this.pairs.size();
        return size == 0 ? null : (State)this.pairs.get(size - 1).getState();
    }

    public List<Pair<State, Delta>> getList() {
        return new ArrayList<Pair<State, Delta>>(this.pairs);
    }

    static interface AddDelta<State, Delta> {
        public State add(State var1, Delta var2);
    }

    static interface SubtractStates<State, Delta> {
        public Delta subtract(State var1, State var2);
    }

    static interface StateEquality<State> {
        public boolean equals(State var1, State var2);
    }

    public static final class Pair<State, Delta> {
        private final State state;
        private final Delta delta;

        Pair(State state, Delta delta) {
            this.state = state;
            this.delta = delta;
        }

        public State getState() {
            return this.state;
        }

        public Delta getDelta() {
            return this.delta;
        }

        public String toString() {
            return String.format("(%s, %s)", this.state, this.delta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair other = (Pair)o;
            return this.state.equals(other.state) && Objects.equals(this.delta, other.delta);
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + (this.delta != null ? this.delta.hashCode() : 0);
            return result;
        }
    }
}

