/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtcrime.securesms.groups.v2.processing;

import java.util.logging.Logger;
import org.signal.storageservice.protos.groups.local.DecryptedGroup;
import org.signal.storageservice.protos.groups.local.DecryptedGroupChange;

final class ServerGroupLogEntry {
    private static final Logger LOG = Logger.getLogger(ServerGroupLogEntry.class.getName());
    private final DecryptedGroup group;
    private final DecryptedGroupChange change;

    ServerGroupLogEntry(DecryptedGroup group, DecryptedGroupChange change) {
        if (change != null && group != null && group.getRevision() != change.getRevision()) {
            LOG.warning("Ignoring change with revision number not matching group");
            change = null;
        }
        if (change == null && group == null) {
            throw new AssertionError();
        }
        this.group = group;
        this.change = change;
    }

    DecryptedGroup getGroup() {
        return this.group;
    }

    DecryptedGroupChange getChange() {
        return this.change;
    }

    int getRevision() {
        if (this.group != null) {
            return this.group.getRevision();
        }
        if (this.change != null) {
            return this.change.getRevision();
        }
        throw new AssertionError();
    }
}

