/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class StreamUtil {
    private static final Logger LOG = Logger.getLogger(StreamUtil.class.getName());

    private StreamUtil() {
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, null, e);
        }
    }

    public static long getStreamLength(InputStream in) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        int totalSize = 0;
        while ((read = in.read(buffer)) != -1) {
            totalSize += read;
        }
        return totalSize;
    }

    public static void readFully(InputStream in, byte[] buffer) throws IOException {
        StreamUtil.readFully(in, buffer, buffer.length);
    }

    public static void readFully(InputStream in, byte[] buffer, int len) throws IOException {
        int offset = 0;
        while (true) {
            int read;
            if ((read = in.read(buffer, offset, len - offset)) == -1) {
                throw new EOFException("Stream ended early");
            }
            if (read + offset >= len) break;
            offset += read;
        }
    }

    public static byte[] readFully(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((read = in.read(buffer)) != -1) {
            bout.write(buffer, 0, read);
        }
        in.close();
        return bout.toByteArray();
    }

    public static String readFullyAsString(InputStream in) throws IOException {
        return new String(StreamUtil.readFully(in));
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[65536];
        long total = 0L;
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
            total += (long)read;
        }
        in.close();
        out.close();
        return total;
    }
}

