/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.storage;

import io.privacyresearch.equation.storage.SignalStorageRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.whispersystems.signalservice.api.storage.SignalStorageCipher;
import org.whispersystems.signalservice.api.storage.SignalStorageManifest;
import org.whispersystems.signalservice.api.storage.StorageCipherKey;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.api.storage.StorageKey;
import org.whispersystems.signalservice.internal.storage.ManifestRecord;
import org.whispersystems.signalservice.internal.storage.StorageItem;
import org.whispersystems.signalservice.internal.storage.StorageManifest;
import org.whispersystems.signalservice.internal.storage.StorageRecord;

public final class SignalStorageModels {
    private static final Logger LOG = Logger.getLogger(SignalStorageModels.class.getName());

    public static SignalStorageManifest remoteToLocalStorageManifest(StorageManifest manifest, StorageKey storageKey) throws IOException, InvalidKeyException {
        byte[] rawRecord = SignalStorageCipher.decrypt((StorageCipherKey)storageKey.deriveManifestKey(manifest.getVersion()), (byte[])manifest.getValue().toByteArray());
        ManifestRecord manifestRecord = ManifestRecord.parseFrom((byte[])rawRecord);
        ArrayList<StorageId> ids = new ArrayList<StorageId>(manifestRecord.getIdentifiersCount());
        for (ManifestRecord.Identifier id : manifestRecord.getIdentifiersList()) {
            ids.add(StorageId.forType((byte[])id.getRaw().toByteArray(), (int)id.getTypeValue()));
        }
        return new SignalStorageManifest(manifestRecord.getVersion(), manifestRecord.getSourceDevice(), ids);
    }

    public static SignalStorageRecord remoteToLocalStorageRecord(StorageItem item, int type, StorageKey storageKey) throws IOException, InvalidKeyException {
        byte[] key = item.getKey().toByteArray();
        byte[] rawRecord = SignalStorageCipher.decrypt((StorageCipherKey)storageKey.deriveItemKey(key), (byte[])item.getValue().toByteArray());
        StorageRecord record = StorageRecord.parseFrom((byte[])rawRecord);
        StorageId id = StorageId.forType((byte[])key, (int)type);
        return new SignalStorageRecord(id, record, type);
    }

    private static class InvalidStorageWriteError
    extends Error {
        private InvalidStorageWriteError() {
        }
    }
}

