/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.model;

import io.privacyresearch.clientdata.keyvalue.Preferences;
import io.privacyresearch.clientdata.keyvalue.UsernameLink;
import io.privacyresearch.clientdata.user.AccountPart;
import io.privacyresearch.equation.model.Someone;
import java.util.Optional;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.ServiceId;

public class Account
extends Someone {
    private ServiceId.Aci aci;
    private ServiceId.Pni pni;
    private String e164;
    private byte[] profileKey;
    private String username;
    private UsernameLink usernameLink;
    private String givenName;
    private String familyName;
    private String about;
    private String aboutEmoji;
    private boolean readReceiptsEnabled;
    private boolean typingIndicatorsEnabled;
    private boolean storiesEnabled;
    private static final Logger LOG = Logger.getLogger(Account.class.getName());

    public Account() {
    }

    public Account(ServiceId.Aci aci, ServiceId.Pni pni) {
        this.aci = aci;
        this.pni = pni;
    }

    public void setAci(ServiceId.Aci aci) {
        this.aci = aci;
    }

    public void setPni(ServiceId.Pni pni) {
        this.pni = pni;
    }

    public void setE164(String nr) {
        this.e164 = nr;
    }

    public Optional<ServiceId.Aci> getAci() {
        return Optional.ofNullable(this.aci);
    }

    public Optional<ServiceId.Pni> getPni() {
        return Optional.ofNullable(this.pni);
    }

    public Optional<String> getE164() {
        return Optional.ofNullable(this.e164);
    }

    public String getUuid() {
        if (this.aci != null) {
            return this.aci.toString();
        }
        if (this.pni != null) {
            return this.pni.toString();
        }
        throw new RuntimeException("Asked for a UUID but we don't have an ACI or PNI");
    }

    public void setProfileKey(byte[] b) {
        this.profileKey = b;
    }

    public byte[] getProfileKey() {
        return this.profileKey;
    }

    public void setUsername(String v) {
        this.username = v;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsernameLink(UsernameLink v) {
        this.usernameLink = v;
    }

    public UsernameLink getUsernameLink() {
        return this.usernameLink;
    }

    public void setGivenName(String v) {
        this.givenName = v;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setFamilyName(String v) {
        this.familyName = v;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getName() {
        return (this.givenName + (String)(this.familyName == null ? "" : " " + this.familyName)).trim();
    }

    public String getAbout() {
        return this.about;
    }

    public String getAboutEmoji() {
        return this.aboutEmoji;
    }

    public boolean isReadReceiptsEnabled() {
        return this.readReceiptsEnabled;
    }

    public boolean isTypingIndicatorsEnabled() {
        return this.typingIndicatorsEnabled;
    }

    public boolean isStoriesEnabled() {
        return this.storiesEnabled;
    }

    public void fillFromAccountPart(AccountPart part) {
        this.profileKey = part.profileKey();
        this.username = part.username();
        this.givenName = part.givenName();
        this.familyName = part.familyName();
        this.about = part.about();
        this.aboutEmoji = part.aboutEmoji();
    }

    public void fillFromPreferences(Preferences preferences) {
        this.readReceiptsEnabled = preferences.readReceipts();
        this.typingIndicatorsEnabled = preferences.typingIndicators();
        this.storiesEnabled = preferences.storiesEnabled();
    }
}

