/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.groups;

import io.privacyresearch.equation.groups.GroupsV2AuthorizationString;
import io.privacyresearch.equation.groups.GroupsV2Operations;
import io.privacyresearch.equation.groups.PartialDecryptedGroup;
import io.privacyresearch.equation.model.json.CredentialResponse;
import io.privacyresearch.equation.model.json.TemporalCredential;
import io.privacyresearch.equation.net.NetworkAPI;
import io.privacyresearch.equation.signal.todo.GroupHistoryPage;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.auth.AuthCredentialPresentation;
import org.signal.libsignal.zkgroup.auth.AuthCredentialWithPni;
import org.signal.libsignal.zkgroup.auth.AuthCredentialWithPniResponse;
import org.signal.libsignal.zkgroup.auth.ClientZkAuthOperations;
import org.signal.libsignal.zkgroup.calllinks.CallLinkAuthCredentialResponse;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.signal.storageservice.protos.groups.Group;
import org.signal.storageservice.protos.groups.GroupChange;
import org.signal.storageservice.protos.groups.GroupExternalCredential;
import org.signal.storageservice.protos.groups.local.DecryptedGroup;
import org.signal.storageservice.protos.groups.local.DecryptedGroupJoinInfo;
import org.whispersystems.signalservice.api.groupsv2.GroupLinkNotActiveException;
import org.whispersystems.signalservice.api.groupsv2.InvalidGroupStateException;

public class GroupsV2Api {
    private static final Logger LOG = Logger.getLogger(GroupsV2Api.class.getName());
    private final NetworkAPI networkApi;
    private final GroupsV2Operations groupsOperations;

    public GroupsV2Api(NetworkAPI networkApi, GroupsV2Operations groupsOperations) {
        this.networkApi = networkApi;
        this.groupsOperations = groupsOperations;
    }

    public CredentialResponseMaps getCredentials(long todaySeconds) throws IOException {
        return GroupsV2Api.parseCredentialResponse(this.networkApi.retrieveGroupsV2Credentials(todaySeconds));
    }

    public GroupsV2AuthorizationString getGroupsV2AuthorizationString(ServiceId.Aci aci, ServiceId.Pni pni, long redemptionTimeSeconds, GroupSecretParams groupSecretParams, AuthCredentialWithPniResponse authCredentialWithPniResponse) throws VerificationFailedException {
        AuthCredentialWithPni authCredentialWithPni;
        ClientZkAuthOperations authOperations = this.groupsOperations.getAuthOperations();
        try {
            LOG.info("Will invoke acwp with aci = " + String.valueOf(aci) + " and pni = " + String.valueOf(pni) + " rds = " + redemptionTimeSeconds);
            authCredentialWithPni = authOperations.receiveAuthCredentialWithPniAsServiceId(aci, pni, redemptionTimeSeconds, authCredentialWithPniResponse);
        }
        catch (VerificationFailedException ex) {
            LOG.log(Level.SEVERE, null, ex);
            ex.printStackTrace();
            throw ex;
        }
        AuthCredentialPresentation authCredentialPresentation = authOperations.createAuthCredentialPresentation(new SecureRandom(), groupSecretParams, authCredentialWithPni);
        return new GroupsV2AuthorizationString(groupSecretParams, authCredentialPresentation);
    }

    public void putNewGroup(GroupsV2Operations.NewGroup newGroup, GroupsV2AuthorizationString authorization) throws IOException {
        Group group = newGroup.getNewGroupMessage();
        if (newGroup.getAvatar().isPresent()) {
            String cdnKey = this.uploadAvatar(newGroup.getAvatar().get(), newGroup.getGroupSecretParams(), authorization);
            group = Group.newBuilder((Group)group).setAvatar(cdnKey).build();
        }
        throw new RuntimeException("NYI");
    }

    public PartialDecryptedGroup getPartialDecryptedGroup(GroupSecretParams groupSecretParams, GroupsV2AuthorizationString authorization) throws IOException, InvalidGroupStateException, VerificationFailedException {
        throw new RuntimeException("NYI");
    }

    public DecryptedGroup getGroup(GroupSecretParams groupSecretParams, GroupsV2AuthorizationString authorization) throws IOException, InvalidGroupStateException, VerificationFailedException {
        Group group = this.networkApi.getGroupsV2Group(authorization);
        return this.groupsOperations.forGroup(groupSecretParams).decryptGroup(group);
    }

    public GroupHistoryPage getGroupHistoryPage(GroupSecretParams groupSecretParams, int fromRevision, GroupsV2AuthorizationString authorization, boolean includeFirstState) throws IOException, InvalidGroupStateException, VerificationFailedException {
        throw new RuntimeException("NYI");
    }

    public DecryptedGroupJoinInfo getGroupJoinInfo(GroupSecretParams groupSecretParams, Optional<byte[]> password, GroupsV2AuthorizationString authorization) throws IOException, GroupLinkNotActiveException {
        throw new RuntimeException("NYI");
    }

    public String uploadAvatar(byte[] avatar, GroupSecretParams groupSecretParams, GroupsV2AuthorizationString authorization) throws IOException {
        throw new RuntimeException("NYI");
    }

    public GroupChange patchGroup(GroupChange.Actions groupChange, GroupsV2AuthorizationString authorization, Optional<byte[]> groupLinkPassword) throws IOException {
        throw new RuntimeException("NYI");
    }

    public GroupExternalCredential getGroupExternalCredential(GroupsV2AuthorizationString authorization) throws IOException {
        throw new RuntimeException("NYI");
    }

    private static CredentialResponseMaps parseCredentialResponse(CredentialResponse credentialResponse) throws IOException {
        HashMap<Long, AuthCredentialWithPniResponse> credentials = new HashMap<Long, AuthCredentialWithPniResponse>();
        HashMap<Long, CallLinkAuthCredentialResponse> callLinkCredentials = new HashMap<Long, CallLinkAuthCredentialResponse>();
        LOG.info("Will process " + String.valueOf(credentialResponse));
        for (TemporalCredential credential : credentialResponse.getCredentials()) {
            AuthCredentialWithPniResponse authCredentialWithPniResponse;
            try {
                authCredentialWithPniResponse = new AuthCredentialWithPniResponse(credential.getCredential());
            }
            catch (InvalidInputException e) {
                throw new IOException(e);
            }
            LOG.info("Store credentials for " + credential.getRedemptionTime() + " and obj = " + String.valueOf(authCredentialWithPniResponse));
            credentials.put(credential.getRedemptionTime(), authCredentialWithPniResponse);
        }
        for (TemporalCredential credential : credentialResponse.getCallLinkAuthCredentials()) {
            CallLinkAuthCredentialResponse callLinkAuthCredentialResponse;
            try {
                callLinkAuthCredentialResponse = new CallLinkAuthCredentialResponse(credential.getCredential());
            }
            catch (InvalidInputException e) {
                throw new IOException(e);
            }
            callLinkCredentials.put(credential.getRedemptionTime(), callLinkAuthCredentialResponse);
        }
        return new CredentialResponseMaps(credentials, callLinkCredentials);
    }

    public static class CredentialResponseMaps {
        private final Map<Long, AuthCredentialWithPniResponse> authCredentialWithPniResponseHashMap;
        private final Map<Long, CallLinkAuthCredentialResponse> callLinkAuthCredentialResponseHashMap;

        public CredentialResponseMaps(Map<Long, AuthCredentialWithPniResponse> authCredentialWithPniResponseHashMap, Map<Long, CallLinkAuthCredentialResponse> callLinkAuthCredentialResponseHashMap) {
            this.authCredentialWithPniResponseHashMap = authCredentialWithPniResponseHashMap;
            this.callLinkAuthCredentialResponseHashMap = callLinkAuthCredentialResponseHashMap;
        }

        public Map<Long, AuthCredentialWithPniResponse> getAuthCredentialWithPniResponseHashMap() {
            return this.authCredentialWithPniResponseHashMap;
        }

        public Map<Long, CallLinkAuthCredentialResponse> getCallLinkAuthCredentialResponseHashMap() {
            return this.callLinkAuthCredentialResponseHashMap;
        }

        public CredentialResponseMaps createUnmodifiableCopy() {
            return new CredentialResponseMaps(Map.copyOf(this.authCredentialWithPniResponseHashMap), Map.copyOf(this.callLinkAuthCredentialResponseHashMap));
        }
    }
}

