/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import com.google.protobuf.ByteString;
import io.privacyresearch.clientdata.call.CallData;
import io.privacyresearch.clientdata.call.CallDbRecord;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.clientdata.util.UUIDUtil;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.call.CallRecord;
import io.privacyresearch.equation.model.Call;
import io.privacyresearch.equation.ring.AttachCameraManager;
import io.privacyresearch.equation.ring.CameraManager;
import io.privacyresearch.equation.signal.SignalBridge;
import io.privacyresearch.equation.user.UserRecord;
import io.privacyresearch.equation.user.UserService;
import io.privacyresearch.tringapi.PeekInfo;
import io.privacyresearch.tringapi.TringApi;
import io.privacyresearch.tringapi.TringBridge;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.ServiceId;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public class WaveCallManager
implements TringApi {
    private static final Logger LOG = Logger.getLogger(WaveCallManager.class.getName());
    private final EquationManager waveManager;
    private final CallData callDb;
    private final UserService userService;
    private final SignalBridge signalBridge;
    private final CameraManager cameraManager;
    TringBridge tringBridge;

    public void statusCallback(long callId, long peerId, int dir, int type) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void answerCallback(byte[] opaque) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void offerCallback(byte[] opaque) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void iceUpdateCallback(List<byte[]> iceCandidates) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void groupCallUpdateRing(byte[] groupId, long ringId, byte[] senderBytes, byte status) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void receivedGroupCallPeekForRingingCheck(PeekInfo peekInfo) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public byte[] requestGroupMembershipToken(byte[] groupId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public byte[] requestGroupMemberInfo(byte[] groupId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void sendOpaqueCallMessage(UUID recipient, byte[] opaque, int urgency) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateRemoteDevices(List<Integer> demuxIds) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public WaveCallManager(EquationManager waveManager, CallData callDb, UserService userService, SignalBridge signalBridge) {
        this.waveManager = waveManager;
        this.userService = userService;
        this.signalBridge = signalBridge;
        this.callDb = callDb;
        this.cameraManager = new AttachCameraManager();
    }

    void acceptCall() {
        Thread.dumpStack();
        throw new RuntimeException();
    }

    void ignoreCall() {
        this.ensureTringBridge();
        this.tringBridge.ignoreCall();
    }

    void hangupCall(Call call) {
        Thread.dumpStack();
        throw new RuntimeException();
    }

    public void enableVideoCall(Call call, boolean enableVideo) {
        Thread.dumpStack();
        throw new RuntimeException();
    }

    public Call startOutgoingCall(RecipientKey recipientKey, boolean enableVideo) {
        Thread.dumpStack();
        throw new RuntimeException();
    }

    void ensureTringBridge() {
        if (this.tringBridge == null) {
            byte[] me = UUIDUtil.toByteArray((UUID)this.waveManager.getSelf().aci().getRawUUID());
            this.tringBridge = new TringBridge((TringApi)this, me);
        }
    }

    public void processCallEvent(SignalServiceProtos.SyncMessage.CallEvent callEvent) {
        if (this.dbHasCallId(callEvent.getId())) {
            LOG.info("We already have a call in db with this id, don't store again.");
            return;
        }
        ByteString bs = callEvent.getConversationId();
        UUID uuid = UUIDUtil.bytesToUuid((byte[])bs.toByteArray());
        ServiceId.Aci aci = new ServiceId.Aci(uuid);
        if (aci != null) {
            Optional<UserDbRecord> dbUser = this.userService.getDbUserByAci(aci);
            dbUser.ifPresent(userdb -> {
                long callId = callEvent.getId();
                RecipientKey recipientKey = userdb.recipientKey();
                CallDbRecord.Type callType = switch (callEvent.getType()) {
                    case SignalServiceProtos.SyncMessage.CallEvent.Type.AUDIO_CALL -> CallDbRecord.Type.AUDIO_CALL;
                    case SignalServiceProtos.SyncMessage.CallEvent.Type.VIDEO_CALL -> CallDbRecord.Type.VIDEO_CALL;
                    default -> CallDbRecord.Type.UNKNOWN;
                };
                this.callDb.createIncomingCall(callId, recipientKey, recipientKey, callType);
            });
        }
    }

    public void processCallLogEvent(SignalServiceProtos.SyncMessage.CallLogEvent callLogEvent) {
        LOG.info("Process callLogEvent " + String.valueOf(callLogEvent));
        LOG.log(Level.SEVERE, "CallLogEvent not yet supported");
    }

    boolean dbHasCallId(long callId) {
        try {
            if (this.callDb.findByCallId(callId) != null) {
                LOG.info("We already have a call in db with this id, don't store again.");
                return true;
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return false;
    }

    public List<CallRecord> getAllCalls() {
        try {
            return this.callDb.findAll().stream().map(this::getCallRecordFromDb).toList();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public CallRecord getCallRecordFromDb(CallDbRecord db) {
        UserRecord userRecord = this.userService.getUserByRecipientKey(db.ringerRecipient().key());
        return new CallRecord(db.key(), db.outgoing(), db.conversationRecipient(), userRecord, db.type(), db.state(), db.timestamp());
    }
}

