/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.message.MessageData;
import io.privacyresearch.clientdata.message.MessageDbRecord;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.message.StoryType;
import io.privacyresearch.equation.StoryService;
import io.privacyresearch.equation.message.MessagingClient;
import io.privacyresearch.equation.model.MessageRecord;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageCollector {
    private final Thread runThread;
    private static final Logger LOG = Logger.getLogger(MessageCollector.class.getName());
    private final MessagingClient client;
    private final StoryService storyService;
    private final Function<MessageDbRecord, MessageRecord> messageFromDb;
    private final MessageData messageData;
    private CountDownLatch triggerLatch = new CountDownLatch(1);
    private CountDownLatch startLatch = new CountDownLatch(1);
    private CountDownLatch stopLatch = new CountDownLatch(1);
    private volatile boolean go = false;
    private Status status = Status.NEW;

    public MessageCollector(MessagingClient client, MessageData messageData, StoryService storyService, Function<MessageDbRecord, MessageRecord> messageFromDb) {
        this.client = client;
        this.messageFromDb = messageFromDb;
        this.messageData = messageData;
        this.storyService = storyService;
        this.runThread = this.createRunThread();
    }

    public void trigger() {
        this.triggerLatch.countDown();
    }

    public void start() {
        try {
            this.asyncStart().get();
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalStateException("Could not start messageCollector");
        }
    }

    public CompletableFuture<Void> asyncStart() {
        if (this.startLatch.getCount() == 0L) {
            throw new IllegalStateException("MessageCollector already started");
        }
        CompletableFuture<Void> answer = CompletableFuture.runAsync(() -> {
            this.runThread.start();
            try {
                this.startLatch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                LOG.log(Level.SEVERE, null, ex);
                throw new IllegalStateException(ex);
            }
        });
        return answer;
    }

    public CompletableFuture shutdown() {
        this.go = false;
        return CompletableFuture.runAsync(() -> {
            LOG.info("triggering a countdown");
            this.triggerLatch.countDown();
            try {
                this.stopLatch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                LOG.log(Level.SEVERE, null, ex);
                throw new IllegalStateException(ex);
            }
        });
    }

    public final boolean isRunning() {
        return Status.RUNNING == this.status;
    }

    public final boolean isStopped() {
        return Status.STOPPED == this.status;
    }

    private Thread createRunThread() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                MessageCollector.this.go = true;
                MessageCollector.this.setStatus(Status.RUNNING);
                MessageCollector.this.startLatch.countDown();
                while (MessageCollector.this.go) {
                    MessageCollector.this.triggerLatch = new CountDownLatch(1);
                    try {
                        List messageKeys = MessageCollector.this.messageData.getExpired();
                        LOG.info("Need to remove " + messageKeys.size() + " items");
                        for (MessageKey messageKey : messageKeys) {
                            MessageDbRecord dbRecord = (MessageDbRecord)MessageCollector.this.messageData.findByKey((EntityKey)messageKey);
                            MessageCollector.this.messageData.deleteByKey(messageKey);
                            if (dbRecord.storyType() != StoryType.NONE) {
                                MessageCollector.this.storyService.deleteStoryContents(dbRecord);
                                continue;
                            }
                            MessageCollector.this.client.messageExpired(MessageCollector.this.messageFromDb.apply(dbRecord));
                        }
                        LOG.info("Removed " + messageKeys.size() + " items");
                        long timeoutInMillis = 30000L;
                        MessageDbRecord nextExpiring = MessageCollector.this.messageData.getNextExpiring();
                        if (nextExpiring != null) {
                            LOG.info("expstarted = " + nextExpiring.expireStarted() + ", expin = " + nextExpiring.expiresIn());
                            timeoutInMillis = nextExpiring.expireStarted() + (long)nextExpiring.expiresIn() * 1000L - System.currentTimeMillis();
                            LOG.info("hence tl = " + timeoutInMillis);
                            timeoutInMillis = Math.max(0L, timeoutInMillis);
                        }
                        LOG.info("Ready to wait at most " + timeoutInMillis);
                        boolean normal = MessageCollector.this.triggerLatch.await(timeoutInMillis, TimeUnit.MILLISECONDS);
                        if (normal) {
                            LOG.info("Interrupted while waiting for next expiration cycle");
                            continue;
                        }
                        LOG.info("Waited for next expiration cycle");
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (Throwable t2) {
                            t2.printStackTrace();
                            MessageCollector.this.go = false;
                        }
                    }
                }
                MessageCollector.this.setStatus(Status.STOPPED);
                MessageCollector.this.stopLatch.countDown();
                LOG.info("Done running " + String.valueOf(this) + ", status = " + String.valueOf((Object)MessageCollector.this.status));
            }
        };
        thread.setName("MessageCollector");
        return thread;
    }

    private void setStatus(Status s) {
        LOG.info("Changing status from " + String.valueOf((Object)this.status) + " to " + String.valueOf((Object)s) + " for " + String.valueOf(this));
        this.status = s;
    }

    static enum Status {
        NEW,
        RUNNING,
        STOPPED;

    }
}

