/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import com.google.protobuf.ByteString;
import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.attachment.AttachmentKey;
import io.privacyresearch.clientdata.attachment.AttachmentRecord;
import io.privacyresearch.clientdata.canvas.CanvasDbRecord;
import io.privacyresearch.clientdata.channel.ChannelKey;
import io.privacyresearch.clientdata.channel.ChannelRecord;
import io.privacyresearch.clientdata.distributionlist.DistributionListDbRecord;
import io.privacyresearch.clientdata.draft.DraftRecord;
import io.privacyresearch.clientdata.draft.UpdateDraftRequest;
import io.privacyresearch.clientdata.group.GroupKey;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.group.MembershipRecord;
import io.privacyresearch.clientdata.keys.IdentityStoreRecord;
import io.privacyresearch.clientdata.keyvalue.Preferences;
import io.privacyresearch.clientdata.keyvalue.UsernameLink;
import io.privacyresearch.clientdata.message.BodyRange;
import io.privacyresearch.clientdata.message.InsertMessageRequest;
import io.privacyresearch.clientdata.message.MessageDbRecord;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.message.ReceiptDbRecord;
import io.privacyresearch.clientdata.message.StoryType;
import io.privacyresearch.clientdata.quote.QuoteKey;
import io.privacyresearch.clientdata.quote.QuoteRecord;
import io.privacyresearch.clientdata.reaction.CreateReactionRequest;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.clientdata.search.SearchMessageRecord;
import io.privacyresearch.clientdata.sticker.StickerPackRecord;
import io.privacyresearch.clientdata.sticker.StickerRecord;
import io.privacyresearch.clientdata.user.AccountPart;
import io.privacyresearch.clientdata.user.UnidentifiedAccessUtil;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.clientdata.user.UserKey;
import io.privacyresearch.equation.AccountManager;
import io.privacyresearch.equation.AttachmentUtil;
import io.privacyresearch.equation.CanvasService;
import io.privacyresearch.equation.CheatManager;
import io.privacyresearch.equation.EquationAPI;
import io.privacyresearch.equation.IncomingSignalAPI;
import io.privacyresearch.equation.MessageCollector;
import io.privacyresearch.equation.MessageContentProcessor;
import io.privacyresearch.equation.NetworkMonitor;
import io.privacyresearch.equation.ProfileManager;
import io.privacyresearch.equation.ReactionService;
import io.privacyresearch.equation.SignalServiceDataStoreImpl;
import io.privacyresearch.equation.StorageManager;
import io.privacyresearch.equation.StoryService;
import io.privacyresearch.equation.UsernameService;
import io.privacyresearch.equation.WaveCallManager;
import io.privacyresearch.equation.WaveStore;
import io.privacyresearch.equation.backup.BackupStatus;
import io.privacyresearch.equation.call.CallRecord;
import io.privacyresearch.equation.groups.GroupsV2AuthorizationString;
import io.privacyresearch.equation.incoming.SyncMessageProcessor;
import io.privacyresearch.equation.internal.KeyUtil;
import io.privacyresearch.equation.internal.LockImpl;
import io.privacyresearch.equation.mediaserver.LocalMediaServer;
import io.privacyresearch.equation.message.MessagingClient;
import io.privacyresearch.equation.model.Account;
import io.privacyresearch.equation.model.Attachment;
import io.privacyresearch.equation.model.Call;
import io.privacyresearch.equation.model.DeviceLinkOptions;
import io.privacyresearch.equation.model.FullQuoteRecord;
import io.privacyresearch.equation.model.Message;
import io.privacyresearch.equation.model.MessageRecord;
import io.privacyresearch.equation.model.ReactionRecord;
import io.privacyresearch.equation.model.RegistrationResponse;
import io.privacyresearch.equation.model.SendStickerRequest;
import io.privacyresearch.equation.net.ProfileCipherInputStream;
import io.privacyresearch.equation.provision.ProvisioningClient;
import io.privacyresearch.equation.provision.ProvisioningManager;
import io.privacyresearch.equation.signal.DummySignalBridge;
import io.privacyresearch.equation.signal.SignalBridge;
import io.privacyresearch.equation.storage.SignalStorageRecord;
import io.privacyresearch.equation.user.UserRecord;
import io.privacyresearch.equation.user.UserService;
import io.privacyresearch.equation.util.AvatarHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.signal.libsignal.metadata.ProtocolDuplicateMessageException;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.InvalidRegistrationIdException;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.groups.GroupSessionBuilder;
import org.signal.libsignal.protocol.groups.state.SenderKeyStore;
import org.signal.libsignal.protocol.message.SenderKeyDistributionMessage;
import org.signal.libsignal.protocol.state.KyberPreKeyRecord;
import org.signal.libsignal.protocol.state.SignedPreKeyRecord;
import org.signal.libsignal.usernames.Username;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.groups.GroupIdentifier;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.signal.storageservice.protos.groups.local.DecryptedGroup;
import org.whispersystems.signalservice.api.SignalServiceAccountDataStore;
import org.whispersystems.signalservice.api.SignalServiceDataStore;
import org.whispersystems.signalservice.api.SignalSessionLock;
import org.whispersystems.signalservice.api.crypto.SignalGroupSessionBuilder;
import org.whispersystems.signalservice.api.crypto.SignalServiceCipher;
import org.whispersystems.signalservice.api.crypto.SignalServiceCipherResult;
import org.whispersystems.signalservice.api.crypto.UntrustedIdentityException;
import org.whispersystems.signalservice.api.groupsv2.InvalidGroupStateException;
import org.whispersystems.signalservice.api.messages.SignalServiceEnvelope;
import org.whispersystems.signalservice.api.profiles.SignalServiceProfile;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.storage.SignalStorageManifest;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.api.storage.StorageKey;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.internal.ProvisioningProtos;
import org.whispersystems.signalservice.internal.SignalServiceProtos;
import org.whispersystems.signalservice.internal.storage.AccountRecord;
import org.whispersystems.signalservice.internal.storage.ContactRecord;
import org.whispersystems.signalservice.internal.storage.GroupV2Record;
import org.whispersystems.signalservice.internal.storage.StorageRecord;

public class EquationManager
implements EquationAPI,
IncomingSignalAPI {
    private static final Logger LOG = Logger.getLogger(EquationManager.class.getName());
    public Path SIGNAL_FX_ATTACHMENT_DIR;
    public ProfileManager profileManager;
    private final StoryService storyService;
    private final SqliteStorageBean sqliteStorageBean;
    private final Path storageRoot;
    private final NetworkMonitor networkMonitor;
    private final UserService userService;
    private SignalBridge signalBridge;
    private final WaveCallManager waveCallManager;
    private final AvatarHelper avatarHelper;
    private final StorageManager storageManager;
    private final CheatManager cheatManager;
    private AccountManager accountManager;
    private final CanvasService canvasService;
    private MessagingClient messageListener;
    private LocalMediaServer lms;
    private final LockImpl lock;
    private ServiceId.Aci myAci;
    private UserRecord myUser;
    private Account account;
    private CredentialsProvider credentialsProvider;
    private int localDeviceId;
    private SignalServiceAddress mySignalServiceAddress;
    private final WaveStore aciStore;
    private final WaveStore pniStore;
    private final SignalServiceDataStore signalServiceDataStore;
    private ProvisioningManager provisioningManager;
    private SyncMessageProcessor syncMessageProcessor;
    private final ExecutorService internalExecutor = Executors.newCachedThreadPool();
    private final Map<String, Object> config;
    private StorageKey storageKey;
    private MessageCollector messageCollector;

    public EquationManager() {
        this(new SqliteStorageBean(), Map.of());
    }

    public EquationManager(SqliteStorageBean sqliteStorageBean) {
        this(sqliteStorageBean, Map.of());
    }

    public EquationManager(Map<String, Object> config) {
        this(new SqliteStorageBean(), config);
    }

    public EquationManager(SqliteStorageBean sqliteStorageBean, Map<String, Object> config) {
        this.config = config;
        this.lock = new LockImpl();
        this.sqliteStorageBean = sqliteStorageBean;
        this.storageRoot = this.sqliteStorageBean.getStorageRoot();
        this.networkMonitor = new NetworkMonitor();
        this.avatarHelper = new AvatarHelper(this.storageRoot);
        this.storageManager = new StorageManager(this);
        this.cheatManager = new CheatManager(this);
        this.userService = new UserService(sqliteStorageBean.getBadgeData(), sqliteStorageBean.getRecipientData(), sqliteStorageBean.getUserData(), this.avatarHelper);
        this.storyService = new StoryService(this, sqliteStorageBean.getMessageData());
        this.aciStore = new WaveStore(WaveStore.Type.ACI, sqliteStorageBean);
        this.pniStore = new WaveStore(WaveStore.Type.PNI, sqliteStorageBean);
        this.signalServiceDataStore = new SignalServiceDataStoreImpl(this.aciStore, this.pniStore);
        this.signalBridge = Boolean.TRUE.equals(config.get("testMode")) ? new DummySignalBridge(this, config, this.signalServiceDataStore, null, this.userService) : new SignalBridge(this, config, this.signalServiceDataStore, null, this.userService);
        this.waveCallManager = new WaveCallManager(this, sqliteStorageBean.getCallData(), this.userService, this.signalBridge);
        this.canvasService = new CanvasService(this, sqliteStorageBean);
        this.myAci = this.sqliteStorageBean.account().getAci();
        this.profileManager = new ProfileManager(this, sqliteStorageBean);
        this.syncMessageProcessor = new SyncMessageProcessor(this);
        LOG.info("myAci = " + String.valueOf(this.myAci));
        if (this.myAci != null) {
            Optional<UserRecord> meOpt = this.userService.getUserByAci(this.myAci);
            this.myUser = meOpt.orElseThrow(() -> new RuntimeException("We have an ACI but no user, fatal."));
            this.storageKey = sqliteStorageBean.storage().getStorageKey();
            LOG.info("StorageKey = " + String.valueOf(this.storageKey));
        } else {
            LOG.warning("Starting Equation without aci, we are not registered yet.");
        }
    }

    @Override
    public boolean initialize() {
        LOG.severe("Start initializing Equation");
        this.myAci = this.sqliteStorageBean.account().getAci();
        LOG.info("myAci = " + String.valueOf(this.myAci));
        this.credentialsProvider = this.aciStore.getCredentialsProvider();
        this.accountManager = new AccountManager(this.signalBridge.getNetworkConfiguration(), this.aciStore.getCredentialsProvider(), this.signalBridge.getNetworkAPI());
        this.mySignalServiceAddress = new SignalServiceAddress((ServiceId)this.credentialsProvider.getAci(), this.credentialsProvider.getE164());
        this.SIGNAL_FX_ATTACHMENT_DIR = this.storageRoot.resolve("attachments");
        this.SIGNAL_FX_ATTACHMENT_DIR.toFile().mkdirs();
        AttachmentUtil.deleteDownloadingFiles(this.SIGNAL_FX_ATTACHMENT_DIR.toFile());
        if (this.myUser == null) {
            LOG.severe("We don't have a user yet, so we can't initialize");
            return true;
        }
        LOG.info("Get our sendercertificate");
        try {
            byte[] senderCertificate = this.accountManager.getSenderCertificate();
            UnidentifiedAccessUtil.setSenderCertificate((byte[])senderCertificate);
            this.internalExecutor.submit(() -> this.syncStorage());
        }
        catch (IOException ex) {
            Logger.getLogger(EquationManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        return true;
    }

    public SqliteStorageBean getSqliteStorageBean() {
        return this.sqliteStorageBean;
    }

    public SignalServiceDataStore getSignalServiceDataStore() {
        return this.signalServiceDataStore;
    }

    public MessageCollector getMessageCollector() {
        return this.messageCollector;
    }

    void setSignalBridge(SignalBridge bridge) {
        this.signalBridge = bridge;
    }

    public SignalBridge getSignalBridge() {
        return this.signalBridge;
    }

    public WaveCallManager getWaveCallManager() {
        return this.waveCallManager;
    }

    public CheatManager getCheatManager() {
        return this.cheatManager;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public Map<String, Object> getConfiguration() {
        return this.config;
    }

    public NetworkMonitor getNetworkMonitor() {
        return this.networkMonitor;
    }

    @Override
    public boolean addNetworkListener(Consumer<Boolean> a) {
        return this.networkMonitor.addNetworkListener(a);
    }

    @Override
    public void setMessageListener(MessagingClient mc) {
        this.messageListener = mc;
        this.signalBridge.setMessagingClient(mc);
    }

    public MessagingClient getMessageListener() {
        return this.messageListener;
    }

    @Override
    public Path getStorageRoot() {
        return this.storageRoot;
    }

    protected MessageContentProcessor getMessageContentProcessor() {
        return this.signalBridge.getMessageContentProcessor();
    }

    @Override
    public void shutdown() {
        LOG.info("We should shutdown Equation");
        if (this.signalBridge != null) {
            this.signalBridge.shutdown();
        }
        if (this.lms != null) {
            this.lms.shutdown();
        }
        if (this.messageCollector != null) {
            this.messageCollector.shutdown();
        }
    }

    public void internalCreateAccount(WaveStore aciStore, WaveStore pniStore) throws IOException {
        ServiceId.Aci aci = new ServiceId.Aci(UUID.randomUUID());
        LOG.info("create ia " + String.valueOf(aci));
        ServiceId.Pni pni = new ServiceId.Pni(UUID.randomUUID());
        byte[] b = new byte[16];
        new SecureRandom().nextBytes(b);
        String password = new String(b, StandardCharsets.UTF_8);
        password = Base64.getEncoder().encodeToString(password.getBytes());
        password = password.substring(0, password.length() - 2);
        int registrationId = new SecureRandom().nextInt(16384) & 0x3FFF;
        int pniRegistrationId = new SecureRandom().nextInt(16384) & 0x3FFF;
        this.sqliteStorageBean.account().setAci(aci);
        this.sqliteStorageBean.account().setPni(pni);
        this.sqliteStorageBean.account().setServicePassword(password);
        this.sqliteStorageBean.account().setDeviceId(1);
        this.localDeviceId = 1;
        this.sqliteStorageBean.account().setRegistrationId(String.valueOf(registrationId));
        this.sqliteStorageBean.account().setPniRegistrationId(String.valueOf(pniRegistrationId));
        aciStore.reinitialize();
        pniStore.reinitialize();
        IdentityKeyPair aciKeyPair = KeyUtil.generateIdentityKeyPair();
        this.sqliteStorageBean.account().setAciIdentityPrivateKey(aciKeyPair.getPrivateKey().serialize());
        this.sqliteStorageBean.account().setAciIdentityPublicKey(aciKeyPair.getPublicKey().serialize());
        IdentityKeyPair pniKeyPair = KeyUtil.generateIdentityKeyPair();
        this.sqliteStorageBean.account().setPniIdentityPrivateKey(pniKeyPair.getPrivateKey().serialize());
        this.sqliteStorageBean.account().setPniIdentityPublicKey(pniKeyPair.getPublicKey().serialize());
        SignedPreKeyRecord aciPreKeyRecord = KeyUtil.generateSignedPreKey(aciKeyPair.getPrivateKey());
        System.err.println("acipk = " + String.valueOf(aciPreKeyRecord) + " with id " + aciPreKeyRecord.getId());
        aciStore.storeSignedPreKey(aciPreKeyRecord.getId(), aciPreKeyRecord);
        SignedPreKeyRecord pniPreKeyRecord = KeyUtil.generateSignedPreKey(pniKeyPair.getPrivateKey());
        System.err.println("pnipk = " + String.valueOf(pniPreKeyRecord) + " with id " + pniPreKeyRecord.getId());
        pniStore.storeSignedPreKey(pniPreKeyRecord.getId(), pniPreKeyRecord);
        KyberPreKeyRecord aciKyberPreKeyRecord = KeyUtil.generateKyberPreKey(aciKeyPair.getPrivateKey());
    }

    @Override
    public RegistrationResponse registerAccount(String number, String token, String transport) {
        try {
            this.internalCreateAccount(this.aciStore, this.pniStore);
            return this.signalBridge.registerAccount(number, token, transport, this.aciStore);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
            return new RegistrationResponse(ex.getMessage(), 600);
        }
    }

    @Override
    public RegistrationResponse confirmRegistrationCode(String code) {
        RegistrationResponse answer = this.signalBridge.confirmRegistrationCode(code);
        if (answer.getStatusCode() == 200) {
            this.initialize();
        }
        return answer;
    }

    @Override
    public boolean isProvisioned() {
        return this.aciStore.isInitialized();
    }

    @Override
    public UserRecord getSelf() {
        return this.myUser;
    }

    @Override
    public Account getAccount() {
        if (this.account == null) {
            this.account = this.retrieveAccount();
        }
        return this.account;
    }

    @Override
    public List<UserRecord> getAllUsers() {
        try {
            return this.sqliteStorageBean.getUserData().findAll().stream().map(this.userService::getUserRecordFromDb).toList();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public UserRecord getUserByRecipientKey(RecipientKey recipientKey) {
        return this.userService.getUserByRecipientKey(recipientKey);
    }

    public ServiceId getServiceId(RecipientKey recipientKey) {
        UserDbRecord user = this.sqliteStorageBean.getUserData().findByRecipientKey(recipientKey);
        return user.getServiceId().orElse(null);
    }

    private Account retrieveAccount() {
        Account me = new Account();
        AccountPart accountPart = this.sqliteStorageBean.getUserData().getAccountPart(this.myAci);
        me.fillFromAccountPart(accountPart);
        me.setAci(this.myUser.aci());
        me.setPni(this.myUser.pni());
        me.setE164(this.myUser.e164());
        Preferences preferences = this.sqliteStorageBean.preference().getPreferences();
        me.fillFromPreferences(preferences);
        me.setUsername(this.sqliteStorageBean.account().getUsername());
        me.setUsernameLink(this.sqliteStorageBean.account().getUsernameLink());
        if (me.getUsernameLink() != null) {
            LOG.info("Retrieving account with usernamelink = " + me.getUsernameLink().getLink());
        } else {
            LOG.info("No usernamelink for this account");
        }
        me.setAvatarPath(this.avatarHelper.getAvatarFile(accountPart.recipientKey()).toString());
        LOG.info("Got avatar path: " + me.getAvatarPath());
        return me;
    }

    @Override
    public Username reserveUsername(String nick) {
        LOG.info("Need to create a username");
        UsernameService us = new UsernameService(this.signalBridge.getNetworkAPI());
        Username answer = us.generateUsername(nick);
        return answer;
    }

    @Override
    public boolean confirmReservation(Username reservedUsername) {
        LOG.info("Need to confirm " + String.valueOf(reservedUsername));
        UsernameService us = new UsernameService(this.signalBridge.getNetworkAPI());
        UsernameLink link = us.confirmUsername(reservedUsername);
        this.storeUsernameForAccountKVS(reservedUsername, link);
        try {
            this.storageManager.updateStorageAccount(this.account);
        }
        catch (IOException | InvalidKeyException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        this.messageListener.updateAccount(this.retrieveAccount());
        return true;
    }

    @Override
    public void updateUsernameLink(UsernameLink link) {
        this.storeUsernameLinkForAccountKVS(link);
        this.account = this.retrieveAccount();
        try {
            this.storageManager.updateStorageAccount(this.account);
        }
        catch (IOException | InvalidKeyException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        this.messageListener.updateAccount(this.account);
    }

    @Override
    public String searchByUsername(String username) {
        LOG.info("Search for " + username);
        UsernameService us = new UsernameService(this.signalBridge.getNetworkAPI());
        return us.getAciByUsername(username);
    }

    private void storeUsernameForAccountKVS(Username username, UsernameLink link) {
        LOG.info("Storing usernameinfo into account kvs");
        this.sqliteStorageBean.account().setUsername(username.getUsername());
        this.storeUsernameLinkForAccountKVS(link);
    }

    private void storeUsernameLinkForAccountKVS(UsernameLink link) {
        if (link != null) {
            this.sqliteStorageBean.account().setUsernameLinkEntropy(link.getEntropy());
            this.sqliteStorageBean.account().setUsernameLinkServerId(link.getServerId());
            this.sqliteStorageBean.account().setUsernameLinkColor(link.getColor());
        }
    }

    public Optional<GroupRecord> getGroupByMasterKey(byte[] masterKeyBytes) {
        if (masterKeyBytes == null || masterKeyBytes.length == 0) {
            LOG.severe("Can not find a group without master key!");
            return null;
        }
        LOG.info("asked to find group with masterKeyBytes[0] = " + masterKeyBytes[0]);
        Optional answer = this.sqliteStorageBean.getGroupData().getGroupByMasterKeyBytes(masterKeyBytes);
        LOG.info("Will return " + String.valueOf(answer));
        return answer;
    }

    public Optional<RecipientRecord> getGroupRecipient(SignalServiceProtos.GroupContextV2 groupContextV2) {
        if (groupContextV2 != null) {
            Optional<RecipientRecord> answer = this.getGroupByMasterKey(groupContextV2.getMasterKey().toByteArray()).map(GroupRecord::recipient);
            System.err.println("GOT GG " + String.valueOf(answer));
            return answer;
        }
        return Optional.empty();
    }

    @Override
    public List<GroupRecord> getAllGroups() {
        try {
            return this.sqliteStorageBean.getGroupData().findAll();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public GroupRecord getGroupRecordByRecipientKey(RecipientKey recipientKey) {
        return this.sqliteStorageBean.getGroupData().getGroupByRecipientKey(recipientKey);
    }

    public Set<UserKey> getGroupUsers(GroupRecord group) {
        UserKey selfKey = this.sqliteStorageBean.getUserCache().getSelf().key();
        return group.members().stream().map(MembershipRecord::userKey).filter(memberUserKey -> !memberUserKey.equals((Object)selfKey)).collect(Collectors.toSet());
    }

    @Override
    public List<ChannelRecord> getAllChannels() {
        try {
            LOG.info("Need to retrieve all channels");
            List answer = this.sqliteStorageBean.getChannelData().findAll();
            LOG.info("Retrieved " + answer.size() + " channels");
            return answer;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Optional<DraftRecord> getDraftForChannel(ChannelKey channelKey) {
        return this.sqliteStorageBean.getDraftData().findDraftForChannel(channelKey);
    }

    @Override
    public void updateDraft(ChannelKey channelKey, UpdateDraftRequest updateDraftRequest) {
        this.sqliteStorageBean.getDraftData().updateDraft(channelKey, updateDraftRequest);
        this.sqliteStorageBean.getDraftData().findDraftForChannel(channelKey).ifPresent(this.messageListener::updatedDraft);
    }

    @Override
    public void clearDraft(ChannelKey channelKey) {
        LOG.info("Clear draft with sql bean = " + String.valueOf(this.sqliteStorageBean));
        this.sqliteStorageBean.getDraftData().clearDraft(channelKey);
        this.messageListener.clearedDraft(channelKey);
    }

    @Override
    public ChannelRecord getChannelByRecipientKey(RecipientKey recipientKey) {
        ChannelKey channelKey = this.sqliteStorageBean.getChannelData().findByRecipientKey(recipientKey);
        if (channelKey != null) {
            return (ChannelRecord)this.sqliteStorageBean.getChannelData().findByKey((EntityKey)channelKey);
        }
        LOG.info("Asked to find channel with recipient key " + String.valueOf(recipientKey) + ", but couldn't find it.");
        return null;
    }

    @Override
    public List<CanvasDbRecord> getCanvasListByChannel(ChannelKey channelKey) {
        return this.canvasService.getCanvasListByChannel(channelKey);
    }

    @Override
    public void updateCanvas(CanvasDbRecord record) {
        CanvasDbRecord storedRecord = this.canvasService.storeRecord(record);
        if (this.messageListener != null) {
            this.messageListener.gotCanvasUpdate(storedRecord);
        }
        try {
            this.signalBridge.sendCanvasMessage(storedRecord);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void ignoreCall() {
        this.waveCallManager.ignoreCall();
    }

    @Override
    public void hangupCall(Call call) {
        this.waveCallManager.hangupCall(call);
    }

    @Override
    public void acceptCall() {
        this.waveCallManager.acceptCall();
    }

    @Override
    public List<CallRecord> getAllCalls() {
        return this.waveCallManager.getAllCalls();
    }

    @Override
    public void sendCallHangupMessage(Call call) {
        Thread.dumpStack();
        throw new RuntimeException();
    }

    @Override
    public void enableVideoCall(Call call, boolean enable) {
        this.waveCallManager.enableVideoCall(call, enable);
    }

    @Override
    public Call startOutgoingCall(RecipientKey recipientKey, boolean enableVideo) {
        return this.waveCallManager.startOutgoingCall(recipientKey, enableVideo);
    }

    public MessageRecord getMessageRecordFromDb(MessageDbRecord db) {
        UserRecord sender = this.userService.getUserRecordFromDb((UserDbRecord)this.sqliteStorageBean.getUserData().findByKey((EntityKey)db.senderKey()));
        ChannelKey channelKey = this.sqliteStorageBean.getChannelData().findByRecipientKey(db.receiverKey());
        return new MessageRecord(db.key(), channelKey, sender, db.receiverKey(), db.body(), db.bodyRanges(), db.dateSent(), db.dateReceived(), db.receiptType(), db.receiptTimestamp(), db.expiresIn(), db.expireStarted(), db.storyType(), db.infoMessage(), db.read(), db.viewOnce(), db.flags(), db.originalMessageKey());
    }

    @Override
    public List<MessageRecord> getMessagesForRecipientKey(RecipientKey recipientKey) {
        LOG.info("Ready to retrieve messages from recipient " + String.valueOf(recipientKey));
        return this.sqliteStorageBean.getMessageData().getByToRecipientKey(recipientKey).stream().filter(r -> r.storyType() == StoryType.NONE).map(this::getMessageRecordFromDb).toList();
    }

    @Override
    public List<MessageRecord> getMessagesForRecipientKey(RecipientKey recipientKey, long endTime, int maxItems) {
        return this.sqliteStorageBean.getMessageData().getByToRecipientKeyBefore(recipientKey, endTime, maxItems).stream().filter(r -> r.storyType() == StoryType.NONE).filter(r -> r.storyType() == StoryType.NONE).map(this::getMessageRecordFromDb).toList();
    }

    @Override
    public FullQuoteRecord getQuoteByMessageKey(MessageKey messageKey) {
        QuoteRecord basis = this.sqliteStorageBean.getQuoteData().findQuoteByMessageKey(messageKey);
        if (basis == null) {
            return null;
        }
        MessageDbRecord messageRecord = (MessageDbRecord)this.sqliteStorageBean.getMessageData().findByKey((EntityKey)basis.quotedMessageKey());
        UserDbRecord userRecord = messageRecord == null ? null : (UserDbRecord)this.sqliteStorageBean.getUserData().findByKey((EntityKey)messageRecord.senderKey());
        return FullQuoteRecord.fromQuote(basis, userRecord == null ? null : this.userService.getNameForUser(userRecord));
    }

    @Override
    public List<ReactionRecord> getReactionsByMessageKey(MessageKey messageKey) {
        ReactionService rs = new ReactionService(this.sqliteStorageBean, this.messageListener);
        return this.sqliteStorageBean.getReactionData().findByMessageKey(messageKey).stream().map(rs::getReactionRecordFromDb).toList();
    }

    @Override
    public List<AttachmentRecord> getAttachmentsByMessageKey(MessageKey messageKey) {
        return this.sqliteStorageBean.getAttachmentData().findByMessageKey(messageKey);
    }

    public int checkUnreadMessagesForChannel(ChannelKey channelKey) {
        ChannelRecord channelRecord = (ChannelRecord)this.sqliteStorageBean.getChannelData().findByKey((EntityKey)channelKey);
        int unreadCount = this.sqliteStorageBean.getMessageData().getNumberOfMessagesAfter(channelRecord.recipient().key(), channelRecord.lastRead());
        LOG.info("check unread messages will return " + unreadCount);
        if (this.messageListener != null) {
            this.messageListener.gotReadUpdate(channelRecord.recipient().key(), channelRecord.lastRead(), unreadCount);
        }
        return unreadCount;
    }

    public void handleEditedMessage(long origTimestamp, RecipientKey recipientKey, InsertMessageRequest messageRequest) {
        MessageDbRecord originalMessage;
        if (origTimestamp > 0L && (originalMessage = this.sqliteStorageBean.getMessageData().getByFromRecipientKeyAndDateSent(recipientKey, origTimestamp)) != null) {
            messageRequest.setOriginalMessageKey(originalMessage.key());
        }
    }

    @Override
    public void clientRead(ChannelKey channelKey, long timestamp) {
        ChannelRecord channelRecord = (ChannelRecord)this.sqliteStorageBean.getChannelData().findByKey((EntityKey)channelKey);
        LOG.info("client has read channel " + String.valueOf(channelKey) + " up to " + timestamp + " and we had " + channelRecord.lastRead());
        if (timestamp > channelRecord.lastRead()) {
            List allRecords = this.sqliteStorageBean.getMessageData().getByToRecipientKeyInterval(channelRecord.recipient().key(), channelRecord.lastRead(), timestamp);
            LOG.finer("Lastread was " + channelRecord.lastRead() + " and raw = " + allRecords.size());
            List<MessageDbRecord> records = allRecords.stream().filter(record -> record.infoMessage() != null || !record.senderKey().equals((Object)this.sqliteStorageBean.getUserCache().getSelf().key())).toList();
            LOG.info("we need to send receipts for " + records.size() + " messages");
            if (records.size() > 0) {
                boolean notifyCollector = false;
                for (MessageDbRecord messageRecord : records) {
                    if (messageRecord.expireStarted() != 0L || messageRecord.expiresIn() <= 0) continue;
                    this.sqliteStorageBean.getMessageData().updateExpireStarted(messageRecord.key(), timestamp);
                    notifyCollector = true;
                    LOG.info("ExpireTimer started for msg with content = " + messageRecord.body());
                }
                if (notifyCollector) {
                    this.messageCollector.trigger();
                }
                LOG.info("Client asks to set lastread for channel " + String.valueOf(channelKey) + " to " + timestamp);
                this.sqliteStorageBean.getChannelData().updateLastRead(channelKey, timestamp);
                List<Long> timestamps = records.stream().map(record -> record.dateSent()).toList();
                UserDbRecord destUser = (UserDbRecord)this.sqliteStorageBean.getUserData().findByKey((EntityKey)records.get(0).senderKey());
                ServiceId dest = destUser.getServiceId().orElse(null);
                this.sendReadReceipt(timestamps, dest);
            }
        }
        this.checkUnreadMessagesForChannel(channelKey);
    }

    public void sendReadReceipt(List<Long> timestamps, ServiceId serviceId) {
        if (this.cheatManager.hasCheatFor(CheatManager.CHEAT_RECEIPT)) {
            LOG.info("Read receipt not sent to " + String.valueOf(serviceId) + " because we are cheating");
            return;
        }
        try {
            this.signalBridge.sendReadReceipt(timestamps, serviceId);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public CompletableFuture<InputStream> getAttachmentInputStream(AttachmentKey key) {
        CompletableFuture<InputStream> answer = new CompletableFuture<InputStream>();
        this.internalExecutor.submit(() -> {
            AttachmentRecord record = (AttachmentRecord)this.sqliteStorageBean.getAttachmentData().findByKey((EntityKey)key);
            LOG.info("Need to get inputstream for " + String.valueOf(record));
            try {
                InputStream is0 = AttachmentUtil.getInputStream(record);
                InputStream is = AttachmentUtil.getAvailableInputStream(is0);
                answer.complete(is);
            }
            catch (IOException | TimeoutException ex) {
                LOG.log(Level.SEVERE, null, ex);
                answer.completeExceptionally(ex);
            }
        });
        return answer;
    }

    List<StorageId> removeExisting(List<StorageId> remote, List<StorageId> local) {
        LOG.fine("#elements in local list = " + local.size());
        return remote.stream().filter(rem -> !local.contains(rem)).toList();
    }

    public void exportCloudBackup() {
        this.exportCloudBackup(new BackupStatus());
    }

    @Override
    public void exportCloudBackup(BackupStatus backupStatus) {
        Thread.dumpStack();
        throw new RuntimeException();
    }

    @Override
    public void exportFileBackup(BackupStatus backupStatus, Path path) {
        Thread.dumpStack();
        throw new RuntimeException();
    }

    @Override
    public long sendMessage(RecipientKey receiverKey, Message waveMessage, long timestamp, List<Attachment> attachment) throws IOException {
        return this.signalBridge.sendMessage(receiverKey, waveMessage, timestamp, attachment);
    }

    @Override
    public long sendGroupMessage(RecipientKey groupRecipientKey, Message message, List<Attachment> attachment) throws IOException, InvalidCertificateException, InvalidInputException, UntrustedIdentityException, NoSessionException, InvalidKeyException, InvalidRegistrationIdException {
        return this.signalBridge.sendGroupMessage(groupRecipientKey, message, System.currentTimeMillis(), attachment, null);
    }

    @Override
    public void startListening() {
        LOG.info("Start startlistening. From now on, Equation may call into Wave.");
        try {
            this.messageCollector = new MessageCollector(this.messageListener, this.sqliteStorageBean.getMessageData(), this.storyService, this::getMessageRecordFromDb);
            this.messageCollector.start();
            this.signalBridge.startListening();
            LOG.info("Done startListening");
        }
        catch (Exception ex) {
            LOG.info("We can't start listening due to " + String.valueOf(ex));
            ex.printStackTrace();
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public void storeQuoteInfo(MessageKey messageKey, MessageKey quotedMessageKey, SignalServiceProtos.DataMessage.Quote quote) {
        QuoteRecord qr = new QuoteRecord(new QuoteKey(), messageKey, quotedMessageKey, quote.getText(), List.of(), QuoteRecord.Type.NORMAL);
        this.sqliteStorageBean.getQuoteData().addQuote(qr);
    }

    @Override
    public long sendReaction(String emoji, MessageKey messageKey, boolean remove) throws IOException {
        RecipientKey myRecipientKey = this.getSelf().recipient().key();
        MessageDbRecord messageRecord = (MessageDbRecord)this.sqliteStorageBean.getMessageData().findByKey((EntityKey)messageKey);
        ReactionService rs = new ReactionService(this.sqliteStorageBean, this.messageListener);
        rs.storeAndNotifyReaction(emoji, remove, messageRecord.key(), messageRecord.receiverKey(), myRecipientKey, System.currentTimeMillis());
        return this.signalBridge.sendReaction(emoji, messageRecord, remove);
    }

    @Override
    public void startProvisioning(ProvisioningClient provisioningClient) {
        LOG.info("We are requested to start the provisioning flow");
        this.provisioningManager = new ProvisioningManager(this, this.sqliteStorageBean, provisioningClient, this.signalBridge.getNetworkAPI());
        this.provisioningManager.start();
    }

    @Override
    public void createAccount(ProvisioningProtos.ProvisionMessage pm, String deviceName, DeviceLinkOptions options, Consumer<String> updates) throws IOException {
        if (this.provisioningManager == null) {
            LOG.severe("We are asked to create an account, but there is no provisioningmanager yet. Aborting.");
            throw new IllegalArgumentException("No provisioningmanager created");
        }
        String nr = pm.getNumber();
        updates.accept("Creating local account");
        boolean cloudImport = options.isCloudImport();
        boolean fileImport = options.isFileImport();
        boolean transfer = options.isTransfer();
        Path backupPath = options.getBackupPath();
        this.account = this.provisioningManager.createAccount(nr, deviceName, this.aciStore, this.pniStore);
        ServiceId.Aci aci = (ServiceId.Aci)this.aciStore.getServiceId();
        ServiceId.Pni pni = (ServiceId.Pni)this.pniStore.getServiceId();
        UserKey userKey = this.sqliteStorageBean.getUserData().storePniVerified(aci, pni, nr);
        try {
            this.sqliteStorageBean.getUserData().setProfileKey(userKey, new ProfileKey(this.account.getProfileKey()));
        }
        catch (InvalidInputException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        LOG.info("Created aci: " + String.valueOf(aci) + " of class " + String.valueOf(aci.getClass()));
        LOG.info("Created pni: " + String.valueOf(pni) + " of class " + String.valueOf(pni.getClass()));
        UserDbRecord myDbRecord = this.sqliteStorageBean.getUserData().findByAci(aci);
        this.myUser = this.userService.getUserRecordFromDb(myDbRecord);
        this.myAci = aci;
        this.credentialsProvider = this.aciStore.getCredentialsProvider();
        this.mySignalServiceAddress = new SignalServiceAddress((ServiceId)this.credentialsProvider.getAci(), this.credentialsProvider.getE164());
        this.provisioningManager.stop();
    }

    @Override
    public CompletableFuture<Void> requestTransfer(Consumer<String> updates, byte[] ephemeralBackupKey, ServiceId.Aci aci) {
        return CompletableFuture.runAsync(() -> {
            this.signalBridge.requestTransfer(updates, ephemeralBackupKey, aci);
            LOG.info("Transfer ok, now create indexes");
            this.sqliteStorageBean.createIndexes();
            LOG.info("Indexes created");
            this.sqliteStorageBean.resetConnection();
            LOG.info("sqlitestoragebean has been reset");
        });
    }

    @Override
    public void unlink() {
        try {
            this.signalBridge.unlink();
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public WaveStore getWaveStore() {
        return this.aciStore;
    }

    public RecipientRecord createGroupRecipient(SignalServiceProtos.GroupContextV2 groupContextV2) {
        try {
            LOG.info("We need to create a new GroupRecipient");
            GroupRecord groupRecord = this.retrieveGroupFromMasterKeyBytes(groupContextV2.getMasterKey().toByteArray());
            LOG.info("Created a group: " + String.valueOf(groupRecord));
            return groupRecord.recipient();
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public SignalServiceCipherResult mydecrypt(SignalServiceEnvelope sse) throws Exception {
        LOG.info("Decrypt with acistore = " + String.valueOf(this.aciStore) + " with sid = " + String.valueOf(this.aciStore.getServiceId()));
        SignalServiceCipher cipher = new SignalServiceCipher(this.mySignalServiceAddress, this.localDeviceId, (SignalServiceAccountDataStore)this.aciStore, (SignalSessionLock)new LockImpl(), SignalBridge.getCertificateValidator());
        ServiceId.Aci aci = this.credentialsProvider.getAci();
        ServiceId.Pni pni = this.credentialsProvider.getPni();
        SignalServiceCipherResult answer = null;
        int myHash = Objects.hashCode(sse);
        try {
            int bl = sse.getContent().length;
            LOG.info("I need to decrypt envelope " + myHash + " with " + bl + " bytes and ts = " + sse.getTimestamp());
            SignalServiceProtos.Envelope envelope = sse.getEnvelope();
            ServiceId destination = envelope.hasDestinationServiceId() ? ServiceId.parseFromString((String)envelope.getDestinationServiceId()) : null;
            LOG.info("DESTID = " + destination.toServiceIdString() + " and aci = " + this.credentialsProvider.getAci().toServiceIdString());
            LOG.info("evenelope = " + String.valueOf(sse.getEnvelope()));
            if (destination == null) {
                LOG.log(Level.SEVERE, "Got envelope without destination address, ignore!");
                return null;
            }
            if (!aci.equals((Object)destination) && !pni.equals((Object)destination)) {
                LOG.log(Level.SEVERE, " Got envelope with destination that is not us: " + String.valueOf(destination));
                return null;
            }
            if (pni.equals((Object)destination) && envelope.hasSourceServiceId()) {
                LOG.info("Received a message at our PNI. Marking as needing a PNI signature");
                LOG.log(Level.SEVERE, "NOT SUPPORTED!");
                return null;
            }
            answer = cipher.decrypt(sse.getEnvelope(), sse.getServerDeliveredTimestamp());
            if (answer.getContent().hasSenderKeyDistributionMessage()) {
                this.handleSenderKeyDistributionMessage(envelope, answer.getMetadata().getSourceServiceId(), answer.getMetadata().getSourceDeviceId(), new SenderKeyDistributionMessage(answer.getContent().getSenderKeyDistributionMessage().toByteArray()), this.signalServiceDataStore.aci());
            }
            LOG.info("Decryption done.");
        }
        catch (ProtocolDuplicateMessageException pdme) {
            LOG.warning("We got a duplicate message, ignore this message. " + String.valueOf((Object)pdme));
        }
        LOG.finer("mydecrypt will return " + String.valueOf(answer));
        return answer;
    }

    public void processSyncMessage(SignalServiceProtos.Envelope envelope, SignalServiceProtos.SyncMessage sssm, UserDbRecord sender, RecipientRecord threadRecipient) throws InvalidMessageException, IOException {
        this.syncMessageProcessor.processSyncMessage(envelope, sssm, sender, threadRecipient);
    }

    public CompletableFuture<SignalServiceProfile> retrieveAndStoreProfile(ServiceId.Aci aci, byte[] profileKeyBytes) {
        if (aci == null) {
            throw new IllegalArgumentException("Empty ACI");
        }
        Optional<UserDbRecord> udb = this.userService.getDbUserByAci(aci);
        RecipientKey recipientKey = null;
        if (udb.isEmpty()) {
            LOG.severe("Can't find a record for a user which profile we have to retrieve!");
        } else {
            recipientKey = udb.get().recipientKey();
        }
        return this.retrieveAndStoreProfile(aci, profileKeyBytes, recipientKey);
    }

    private CompletableFuture<SignalServiceProfile> retrieveAndStoreProfile(ServiceId.Aci aci, byte[] profileKeyBytes, RecipientKey recipientKey) {
        return this.profileManager.retrieveAndStoreProfile(aci, profileKeyBytes, recipientKey);
    }

    private void processReadMessages(List<SignalServiceProtos.SyncMessage.Read> messages, long expireStarted) {
        HashMap<RecipientKey, Long> receiverKey_timestamp = new HashMap<RecipientKey, Long>();
        boolean notifyCollector = false;
        for (SignalServiceProtos.SyncMessage.Read read : messages) {
            Long v;
            ServiceId.Aci senderId = new ServiceId.Aci(UUID.fromString(read.getSenderAci()));
            UserDbRecord sender = this.sqliteStorageBean.getUserData().getUserForServiceId((ServiceId)senderId);
            MessageDbRecord message = this.sqliteStorageBean.getMessageData().getByFromRecipientKeyAndDateSent(sender.recipientKey(), read.getTimestamp());
            if (message == null) {
                LOG.info("Can't find message from read notification, might be expired and deleted");
                return;
            }
            LOG.info("Got read message for " + String.valueOf(message.receiverKey()) + " with expin = " + message.expiresIn() + " and started = " + message.expireStarted());
            if (message.expiresIn() > 0 && message.expireStarted() == 0L) {
                this.sqliteStorageBean.getMessageData().updateExpireStarted(message.key(), expireStarted);
                LOG.info("expireStarted = " + expireStarted + " and exp = " + message.expiresIn() + " for " + String.valueOf(message.key()));
                notifyCollector = true;
            }
            if ((v = (Long)receiverKey_timestamp.get(message.receiverKey())) != null && v >= read.getTimestamp()) continue;
            receiverKey_timestamp.put(message.receiverKey(), read.getTimestamp());
        }
        if (notifyCollector) {
            this.messageCollector.trigger();
        }
        for (Map.Entry entry : receiverKey_timestamp.entrySet()) {
            ChannelRecord channelRecord;
            RecipientKey receiverKey = (RecipientKey)entry.getKey();
            long time = (Long)entry.getValue();
            if (time <= (channelRecord = this.getChannelByRecipientKey(receiverKey)).lastRead()) continue;
            this.sqliteStorageBean.getChannelData().updateLastRead(channelRecord.key(), time);
            int unreadCount = this.sqliteStorageBean.getMessageData().getNumberOfMessagesAfter(receiverKey, time);
            LOG.info("check unread messages will return " + unreadCount);
            this.messageListener.gotReadUpdate(receiverKey, time, unreadCount);
        }
    }

    @Override
    public UserRecord getUserByUserKey(UserKey userKey) {
        return this.userService.getUserByUserKey(userKey);
    }

    @Override
    public List<ChannelRecord> searchChannels(String query, int limit, int offset) {
        return this.sqliteStorageBean.getChannelData().queryChannels(query, limit, offset);
    }

    @Override
    public void retrieveUserByUuidAndProfileKey(UUID uuid, byte[] pkb) {
        try {
            LOG.info("Trying to get profile for " + uuid.toString());
            ProfileKey profileKey = new ProfileKey(pkb);
            ServiceId.Aci aci = new ServiceId.Aci(uuid);
            CompletableFuture<SignalServiceProfile> fut = this.retrieveAndStoreProfile(aci, pkb);
            ((CompletableFuture)fut.thenAccept(ssp -> {
                LOG.info("Got new profile, notify client");
                this.messageListener.updateUser(this.userService.getUserRecordFromDb(this.sqliteStorageBean.getUserData().findByAci(aci)));
            })).exceptionally(ex -> {
                LOG.severe("Got exception! " + String.valueOf(ex));
                return null;
            });
        }
        catch (Exception ex2) {
            LOG.log(Level.SEVERE, null, ex2);
            ex2.printStackTrace();
        }
    }

    @Override
    public List<ReceiptDbRecord> getReceiptsByMessageKey(MessageKey messageKey) {
        return this.sqliteStorageBean.getReceiptData().findByMessageKey(messageKey);
    }

    public void processIncomingReaction(SignalServiceProtos.DataMessage.Reaction reaction, RecipientKey senderKey, long msgTimestamp) {
        UserDbRecord user = this.sqliteStorageBean.getUserData().getUserForServiceId((ServiceId)new ServiceId.Aci(UUID.fromString(reaction.getTargetAuthorAci())));
        MessageDbRecord originalMessage = this.sqliteStorageBean.getMessageData().getByFromRecipientKeyAndDateSent(user.recipientKey(), reaction.getTargetSentTimestamp());
        if (originalMessage == null) {
            throw new IllegalArgumentException("Could not find reaction with timestamp " + reaction.getTargetSentTimestamp() + " and userkey = " + user.recipientKey().serialize());
        }
        LOG.info("REACTION, senderKey = " + String.valueOf(senderKey) + ", targetauthoraci = " + reaction.getTargetAuthorAci());
        ReactionService rs = new ReactionService(this.sqliteStorageBean, this.messageListener);
        String emoji = reaction.getEmoji();
        if (this.hasCheatFor(CheatManager.CHEAT_INCOMING_THUMB_SWITCH)) {
            emoji = new String(CheatManager.flipThumbsUpDown(reaction.getEmojiBytes().toByteArray()));
        }
        rs.storeAndNotifyReaction(emoji, reaction.getRemove(), originalMessage.key(), originalMessage.receiverKey(), senderKey, msgTimestamp);
    }

    public void syncStorage() {
        LOG.info("SyncStorage");
        LOG.info("StorageKey = " + String.valueOf(this.storageKey));
        try {
            SignalStorageManifest storageManifest = this.accountManager.getStorageManifest(this.storageKey);
            LOG.info("StorageManifest = " + String.valueOf(storageManifest));
            this.messageListener.storeLocalManifest(storageManifest);
            List<StorageId> storageIds = storageManifest.getStorageIds();
            LOG.info("Got " + storageIds.size() + " storageIds and manifest version = " + storageManifest.getVersion());
            try {
                storageIds = this.removeByType(storageIds, 5);
                LOG.info("After removing distribution ids, we have " + storageIds.size() + " left.");
                storageIds = this.removeByType(storageIds, 6);
                LOG.info("After removing stickerpack ids, we have " + storageIds.size() + " left.");
                List<StorageId> localGroups = this.sqliteStorageBean.getRecipientData().getGroupV2StorageIds().stream().map(storageId -> StorageId.forGroupV2((byte[])storageId)).toList();
                storageIds = this.removeExisting(storageIds, localGroups);
                LOG.info("After removing exiting group ids (" + localGroups.size() + "), we have " + storageIds.size() + " left.");
                List<StorageId> localUsers = this.sqliteStorageBean.getRecipientData().getContactStorageIds().stream().map(storageId -> StorageId.forContact((byte[])storageId)).toList();
                LOG.info("We got local info about " + localUsers.size() + " contacts");
                storageIds = this.removeExisting(storageIds, localUsers);
                LOG.info("After removing exiting user ids, we have " + storageIds.size() + " left.");
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "(caught) error when trying to diff StorageIds", t);
            }
            Optional accountStorageId = storageManifest.getAccountStorageId();
            List<SignalStorageRecord> records = this.accountManager.readStorageRecords(this.storageKey, storageIds);
            ExecutorService syncStorageWorkerService = Executors.newFixedThreadPool(8);
            for (SignalStorageRecord record : records) {
                LOG.info("Record " + String.valueOf(record) + " with type " + record.getType());
                LOG.info("Record " + String.valueOf(record) + " with id " + String.valueOf(Base64.getEncoder().encode(record.getId().getRaw())) + " and type " + record.getType());
                try {
                    if (record.isGroupV2()) {
                        this.processGroup(record);
                    }
                    if (record.isContact()) {
                        this.processContact(record, syncStorageWorkerService);
                    }
                    if (!record.isAccount()) continue;
                    this.processAccount(record);
                }
                catch (Exception e) {
                    System.err.println("ERR!!! " + String.valueOf(e));
                    LOG.log(Level.SEVERE, "Major error parsing a storagerecord", e);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (InvalidKeyException ex) {
            ex.printStackTrace();
        }
    }

    List<StorageId> removeByType(List<StorageId> storageIds, int type) {
        return storageIds.stream().filter(sid -> sid.getType() != type).toList();
    }

    public GroupRecord getGroupByGroupIdentifier(byte[] groupIdentifierBytes) {
        try {
            return this.sqliteStorageBean.getGroupData().getGroupByGroupIdentifier(new GroupIdentifier(groupIdentifierBytes)).orElse(null);
        }
        catch (InvalidInputException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private void processGroup(SignalStorageRecord signalStorageRecord) {
        StorageRecord storageRecord = signalStorageRecord.getRecord();
        GroupV2Record groupV2Record = storageRecord.getGroupV2();
        try {
            GroupMasterKey groupMasterKey = new GroupMasterKey(groupV2Record.getMasterKey().toByteArray());
            GroupKey groupKey = this.sqliteStorageBean.getGroupData().createOrUpdate(signalStorageRecord.getId(), groupV2Record);
            GroupRecord group = this.retrieveGroupFromMasterKeyBytes(groupMasterKey.serialize());
            if (group == null) {
                LOG.info("Could not retrieve group from signalgrouprecord, maybe we left?");
                return;
            }
            this.messageListener.updateGroupRecord(group);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (InvalidInputException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private void processContact(SignalStorageRecord signalStorageRecord, ExecutorService workerService) {
        IdentityStoreRecord oldIdentity;
        StorageRecord storageRecord = signalStorageRecord.getRecord();
        LOG.info("Process signalSR = " + String.valueOf(signalStorageRecord));
        LOG.info("Process storageRecord = " + String.valueOf(storageRecord));
        ContactRecord scr = storageRecord.getContact();
        if (scr.getAci() == null || scr.getAci().isEmpty()) {
            LOG.warning("We have a contact without an ACI, which we don't add for now.");
            return;
        }
        String aciUuid = scr.getAci();
        LOG.info("processing " + aciUuid + " with pni = " + scr.getPni() + " and nr = " + scr.getE164() + " and hidden = " + scr.getHidden() + "and muteuntil = " + scr.getMutedUntilTimestamp() + " and uts = " + scr.getUnregisteredAtTimestamp());
        UserKey userKey = this.sqliteStorageBean.getUserData().storeContactRecord(signalStorageRecord.getId(), scr);
        UserDbRecord user = (UserDbRecord)this.sqliteStorageBean.getUserData().findByKey((EntityKey)userKey);
        byte[] pkb = scr.getProfileKey().toByteArray();
        LOG.info("We have a profile");
        if (scr.getAci() != null && scr.getUnregisteredAtTimestamp() == 0L) {
            LOG.info("Send a job to workerService from thread " + String.valueOf(Thread.currentThread()));
            workerService.submit(() -> {
                LOG.severe("SHOULD retrieving profile for " + aciUuid);
                this.retrieveAndStoreProfile(new ServiceId.Aci(UUID.fromString(aciUuid)), pkb, user.recipientKey());
                LOG.severe("DID NOT retrieving profile for " + aciUuid);
            });
        }
        if ((oldIdentity = this.sqliteStorageBean.getIdentityData().findByAddress(new SignalProtocolAddress(aciUuid, 1))) == null) {
            LOG.info("No identity key for " + scr.getAci());
        } else {
            byte[] newb = scr.getIdentityKey().toByteArray();
            if (Arrays.equals(newb, oldIdentity.identityKey().getPublicKey().serialize())) {
                LOG.info("IdentityKey for " + scr.getAci() + " did not change");
            } else {
                LOG.info("We have a new identityKey for " + scr.getAci());
            }
        }
        this.messageListener.updateUser(this.userService.getUserRecordFromDb((UserDbRecord)this.sqliteStorageBean.getUserData().findByKey((EntityKey)userKey)));
    }

    private void processAccount(SignalStorageRecord signalStorageRecord) {
        StorageId storageId = signalStorageRecord.getId();
        StorageRecord storageRecord = signalStorageRecord.getRecord();
        AccountRecord accountRecord = storageRecord.getAccount();
        try {
            LOG.info("Process account record");
            this.sqliteStorageBean.getUserData().storeAccountRecord(storageId, this.myAci, accountRecord);
            this.sqliteStorageBean.preference().storeAccountRecord(accountRecord);
            this.sqliteStorageBean.account().storeAccountRecord(accountRecord);
            String avatarUrl = accountRecord.getAvatarUrlPath();
            if (avatarUrl != null && !avatarUrl.isEmpty()) {
                LOG.info("Account has avatar");
                ProfileKey pk = new ProfileKey(accountRecord.getProfileKey().toByteArray());
                this.storeAvatar(avatarUrl, pk, this.myUser.recipient().key());
            }
            this.account = this.retrieveAccount();
            LOG.info("Inform messageListener about our account");
            if (this.messageListener != null) {
                LOG.severe("We should inform the app about a new account");
                this.messageListener.updateAccount(this.account);
            }
        }
        catch (InvalidInputException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "This is a real major error, please report.", ex);
        }
    }

    void storeAvatar(String urlPath, ProfileKey pk, RecipientKey recipientKey) throws IOException {
        File avatarFile = Files.createTempFile("avt", "prof", new FileAttribute[0]).toFile();
        this.signalBridge.getNetworkAPI().retrieveProfileAvatar(urlPath, avatarFile);
        ProfileCipherInputStream is = new ProfileCipherInputStream(new FileInputStream(avatarFile), pk);
        this.avatarHelper.setAvatar(recipientKey, is);
        avatarFile.delete();
    }

    Path storeGroupAvatar(String urlPath, GroupSecretParams gsp, RecipientKey recipientKey) throws IOException {
        InputStream is = this.signalBridge.storeGroupAvatar(urlPath, gsp, recipientKey);
        Path destination = this.avatarHelper.setAvatar(recipientKey, is);
        return destination;
    }

    public GroupRecord retrieveGroupFromMasterKeyBytes(byte[] masterKeyBytes) throws IOException {
        try {
            LOG.info("We will ask the server to retrieve a group with known master key");
            GroupMasterKey groupMasterKey = new GroupMasterKey(masterKeyBytes);
            DecryptedGroup decryptedGroup = this.requestDecryptedGroup(groupMasterKey);
            if (decryptedGroup == null) {
                LOG.warning("We can't get a decryptedgroup for these mkb, return null");
                return null;
            }
            GroupRecord group = this.sqliteStorageBean.getGroupData().getGroupByMasterKeyBytes(masterKeyBytes).orElse(null);
            if (group == null) {
                group = this.createNewGroup(masterKeyBytes);
            }
            String avatarPathString = null;
            if (decryptedGroup != null) {
                LOG.fine("We will update group named " + decryptedGroup.getTitle());
                String avatarUrl = decryptedGroup.getAvatar();
                LOG.info("finer for " + decryptedGroup.getTitle() + " = " + avatarUrl);
                if (!avatarUrl.isEmpty()) {
                    Path avatarPath = this.storeGroupAvatar(avatarUrl, GroupSecretParams.deriveFromMasterKey((GroupMasterKey)groupMasterKey), group.recipient().key());
                    avatarPathString = avatarPath.toString();
                }
                this.sqliteStorageBean.getGroupData().updateWithAvatar(groupMasterKey, decryptedGroup, avatarPathString);
                group = this.sqliteStorageBean.getGroupData().getGroupByMasterKeyBytes(masterKeyBytes).orElse(null);
            } else {
                LOG.info("No decrypted group could be obtained for this group. Return stored version.");
            }
            return group;
        }
        catch (InvalidInputException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
    }

    private GroupRecord createNewGroup(byte[] mkb) {
        byte[] idb = new byte[32];
        new SecureRandom().nextBytes(idb);
        StorageId id = StorageId.forGroupV2((byte[])idb);
        GroupV2Record.Builder builder = GroupV2Record.newBuilder();
        builder.setMasterKey(ByteString.copyFrom((byte[])mkb));
        GroupKey key = this.sqliteStorageBean.getGroupData().createOrUpdate(StorageId.forGroupV2((byte[])idb), builder.build());
        return (GroupRecord)this.sqliteStorageBean.getGroupData().findByKey((EntityKey)key);
    }

    private void handleSenderKeyDistributionMessage(SignalServiceProtos.Envelope envelope, ServiceId serviceId, int deviceId, SenderKeyDistributionMessage message, SignalServiceAccountDataStore senderKeyStore) {
        LOG.info("Handle SKDM for " + String.valueOf(serviceId));
        SignalProtocolAddress sender = new SignalProtocolAddress(serviceId.toServiceIdString(), deviceId);
        new SignalGroupSessionBuilder((SignalSessionLock)this.lock, new GroupSessionBuilder((SenderKeyStore)senderKeyStore)).process(sender, message);
    }

    private DecryptedGroup requestDecryptedGroup(GroupMasterKey groupMasterKey) {
        GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)groupMasterKey);
        int days = (int)LocalDate.now(ZoneId.of("UTC")).toEpochDay();
        GroupsV2AuthorizationString authorization = this.accountManager.getAuthorization(groupSecretParams);
        try {
            DecryptedGroup dgroup = this.accountManager.getGroupsV2Api().getGroup(groupSecretParams, authorization);
            return dgroup;
        }
        catch (NonSuccessfulResponseCodeException e) {
            int res = e.getCode();
            if (res == 403) {
                LOG.info("No permission to get this group info");
            }
            LOG.info("We were requested to decrypt a group that we're not a member of, return null");
            return null;
        }
        catch (IOException | VerificationFailedException | InvalidGroupStateException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static BodyRange.Style getStyleFromProto(int protoStyle) {
        LOG.finest("Need to process proto BodyRange with style = " + protoStyle);
        return switch (protoStyle) {
            case 1 -> BodyRange.Style.BOLD;
            case 2 -> BodyRange.Style.ITALIC;
            case 3 -> BodyRange.Style.SPOILER;
            case 4 -> BodyRange.Style.STRIKETHROUGH;
            case 5 -> BodyRange.Style.MONOSPACE;
            default -> {
                LOG.warning("Unrecognized style: " + protoStyle);
                yield BodyRange.Style.NONE;
            }
        };
    }

    @Override
    public boolean isUseQuic() {
        return this.sqliteStorageBean.preference().getBoolean("useQuic", false);
    }

    @Override
    public void setUseQuic(boolean v) {
        this.sqliteStorageBean.preference().putBoolean("useQuic", v);
    }

    @Override
    public ChannelRecord getChannelByKey(ChannelKey key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<SearchMessageRecord> searchMessages(String query) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<SearchMessageRecord> searchMessagesByRecipientKey(String query, RecipientKey recipientKey) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<StickerPackRecord, List<StickerRecord>> getStickerPacks() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void storeReactionRecord(CreateReactionRequest request) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void deleteMessage(MessageKey messageKey, boolean remote) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void sendReaction(RecipientKey destinationKey, RecipientKey authorKey, String emoji, MessageKey messageKey, boolean remove) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long sendGroupReaction(GroupRecord group, RecipientKey authorKey, String emoji, MessageKey messageKey, boolean remove) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MessageRecord sendExpireTimerMessage(RecipientKey receiverKey, int timer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long sendStickerMessage(RecipientKey receiverKey, SendStickerRequest stickerRequest) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DistributionListDbRecord createDistributionList(String name, Set<RecipientKey> recipients) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void processStoryMessage(SignalServiceProtos.Envelope envelope, UserDbRecord sender, SignalServiceProtos.StoryMessage msg) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

