/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.snl.doubt;

import com.gluonhq.snl.doubt.MediaType;
import com.gluonhq.snl.doubt.MultipartBodyPublisher;
import com.gluonhq.snl.doubt.RequestBody;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class MultipartBody {
    public static final MediaType FORM = MediaType.parse("multipart/form-data");

    public static class MultiPartRequestBody
    extends RequestBody {
        private List<Part> parts;
        String boundary;
        private MediaType contentType;

        public MultiPartRequestBody(List<Part> parts, MediaType mediaType, String boundary) {
            this.parts = parts;
            this.boundary = boundary;
            this.contentType = MediaType.parse(mediaType.getMediaType() + "; boundary=" + boundary);
        }

        @Override
        public long contentLength() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public MediaType contentType() {
            return this.contentType;
        }

        public MultipartBodyPublisher getBodyPublisher() {
            return new MultipartBodyPublisher(this.parts, this.boundary, Charset.defaultCharset());
        }
    }

    public static class Builder {
        public static final MediaType FORM = MediaType.parse("multipart/form-data");
        private MediaType mediaType;
        private final String boundary = UUID.randomUUID().toString();
        private final List<Part> parts = new ArrayList<Part>();

        public Builder setType(MediaType mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public Builder addFormDataPart(String name, String val) {
            this.parts.add(new DataPart(name, val, Charset.defaultCharset()));
            return this;
        }

        public Builder addFormDataPart(String name, String filename, RequestBody body) {
            this.parts.add(new RequestBodyPart(name, filename, body));
            return this;
        }

        public MultiPartRequestBody build() {
            return new MultiPartRequestBody(this.parts, this.mediaType, this.boundary);
        }
    }

    static class RequestBodyPart
    extends Part {
        String fileName;
        RequestBody fileBody;

        RequestBodyPart(String name, String fileName, RequestBody fileBody) {
            this.name = name;
            this.fileName = fileName;
            this.fileBody = fileBody;
        }

        @Override
        public ReadableByteChannel open() throws IOException {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.fileBody.getRawBytes());
            return Channels.newChannel(bais);
        }
    }

    static class FilePart
    extends Part {
        String fileName;
        RequestBody fileBody;

        FilePart(String name, String fileName, RequestBody fileBody) {
            this.name = name;
            this.fileName = fileName;
            this.fileBody = fileBody;
        }

        @Override
        public ReadableByteChannel open() throws IOException {
            return Files.newByteChannel(Paths.get(this.name, new String[0]), new OpenOption[0]);
        }
    }

    static class DataPart
    extends Part {
        String val;
        final Charset charset;

        DataPart(String name, String val, Charset charset) {
            this.name = name;
            this.val = val;
            this.charset = charset;
        }

        @Override
        public ReadableByteChannel open() throws IOException {
            ByteArrayInputStream input = new ByteArrayInputStream(this.val.getBytes(this.charset));
            return Channels.newChannel(input);
        }
    }

    static abstract class Part {
        String name;

        Part() {
        }

        String name() {
            return this.name;
        }

        Optional<String> filename() {
            return Optional.empty();
        }

        Optional<String> contentType() {
            return Optional.empty();
        }

        abstract ReadableByteChannel open() throws IOException;
    }
}

