/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.snl;

import com.gluonhq.snl.ConnectivityListener;
import com.gluonhq.snl.NetworkClient;
import com.gluonhq.snl.Response;
import com.gluonhq.snl.WebsocketResponse;
import io.privacyresearch.equation.NetworkMonitor;
import io.privacyresearch.equation.net.SignalUrl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.whispersystems.signalservice.api.push.OutgoingPushMessageList;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.internal.websocket.WebSocketProtos;

public class LegacyNetworkClient
extends NetworkClient {
    private static final Logger LOG = Logger.getLogger(LegacyNetworkClient.class.getName());
    private WebSocket webSocket;
    final HttpClient httpClient = this.buildClient();
    KeepAliveSender keepAliveSender;
    private static final int KEEPALIVE_TIMEOUT_SECONDS = 55;
    private WebSocket.Listener myListener;
    static final ExecutorService threadPool = Executors.newCachedThreadPool();

    public LegacyNetworkClient(NetworkMonitor monitor, SignalUrl url, Optional<CredentialsProvider> cp, String signalAgent, Optional<ConnectivityListener> connectivityListener, boolean allowStories) {
        super(monitor, url, cp, signalAgent, connectivityListener, allowStories);
    }

    @Override
    public boolean supportsJson() {
        return true;
    }

    private HttpClient buildClient() {
        HttpClient.Builder clientBuilder = HttpClient.newBuilder();
        HttpClient answer = clientBuilder.build();
        return answer;
    }

    @Override
    void implCreateWebSocket(String baseUrl, String auth) throws IOException {
        LOG.info("Creating websocket to " + baseUrl + " with auth? " + (auth != null));
        WebSocket.Builder wsBuilder = this.httpClient.newWebSocketBuilder();
        wsBuilder.header("X-Signal-Agent", this.signalAgent);
        wsBuilder.header("X-Signal-Receive-Stories", this.allowStories ? "true" : "false");
        if (auth != null) {
            wsBuilder.header("Authorization", auth);
        }
        URI uri = null;
        try {
            uri = new URI(baseUrl);
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IOException("Can not create websocket to wrong formatted url", ex);
        }
        if (uri == null) {
            throw new IOException("Can not create websocket to unexisting url");
        }
        this.myListener = new MyWebsocketListener(this);
        CompletableFuture<WebSocket> webSocketProcess = wsBuilder.buildAsync(uri, this.myListener);
        CountDownLatch cdl = new CountDownLatch(1);
        threadPool.submit(() -> {
            try {
                LOG.info("Joining ws...");
                this.webSocket = (WebSocket)webSocketProcess.join();
                LOG.info("Done joining ws");
                this.setWsStatus(NetworkClient.WsStatus.READY);
                this.websocketCreated = true;
                cdl.countDown();
            }
            catch (Throwable t) {
                LOG.severe("Websocket could not be created, this can be fatal.");
                t.printStackTrace();
                cdl.countDown();
            }
        });
        try {
            boolean res = cdl.await(10L, TimeUnit.SECONDS);
            if (!res) {
                LOG.severe("Failed to reconnect after 10 seconds!");
            }
        }
        catch (InterruptedException ex) {
            LOG.warning("Interrupted while waiting for websocket connection");
            LOG.log(Level.SEVERE, null, ex);
        }
        if (this.webSocket == null) {
            throw new IOException("Could not create a websocket");
        }
    }

    @Override
    protected CompletableFuture<Response> implAsyncSendRequest(HttpRequest request, byte[] raw) throws IOException {
        LOG.finer("Send request, not using kwik with method " + request.method() + " and address = " + String.valueOf(request.uri()));
        LOG.finer("Headers = " + String.valueOf(request.headers()) + " for url = " + String.valueOf(request.uri()));
        CompletableFuture<Response> response = CompletableFuture.completedFuture(this.getDirectResponse(request));
        LOG.finer("Got response, not using kwik: " + String.valueOf(response));
        return response;
    }

    @Override
    CompletableFuture<WebSocket> implSendToStream(WebSocketProtos.WebSocketMessage msg, OutgoingPushMessageList list) throws IOException {
        byte[] payload = msg.toByteArray();
        LOG.info("sending to stream on WebSocket " + String.valueOf(this.webSocket));
        CompletableFuture<WebSocket> answer = this.webSocket.sendBinary(ByteBuffer.wrap(payload), true);
        ((CompletableFuture)answer.thenAccept(result -> LOG.info("Got result: " + String.valueOf(result)))).exceptionally(ex -> {
            LOG.info("Got exception: " + String.valueOf(ex));
            return null;
        });
        return answer;
    }

    private Response getDirectResponse(HttpRequest request) throws IOException {
        HttpResponse httpResponse;
        try {
            LOG.info("Invoke send on httpClient " + String.valueOf(this.httpClient));
            LOG.fine("RequestBody = " + request.method() + " to " + String.valueOf(request.bodyPublisher()) + " and headers = " + String.valueOf(request.headers().map()));
            httpResponse = this.httpClient.send(request, this.createBodyHandler(request));
            LOG.fine("Response headers = " + String.valueOf(httpResponse.headers()));
            LOG.info("Did invoke send on httpClient, response = " + String.valueOf(httpResponse));
            LOG.finer("Statuscode = " + httpResponse.statusCode() + " and body = " + String.valueOf(httpResponse.body()));
        }
        catch (InterruptedException ex) {
            LOG.log(Level.SEVERE, "Error sending using httpClient " + String.valueOf(this.httpClient), ex);
            throw new IOException(ex);
        }
        return new Response(httpResponse);
    }

    private synchronized CompletableFuture<WebsocketResponse> sendKeepAlive() throws IOException {
        long kid = System.currentTimeMillis();
        LOG.fine("Send Keepalive");
        WebSocketProtos.WebSocketRequestMessage requestMessage = WebSocketProtos.WebSocketRequestMessage.newBuilder().setId(kid).setPath("/v1/keepalive").setVerb("GET").build();
        return this.sendRequest(requestMessage, null);
    }

    @Override
    protected CompletableFuture<Response> implAsyncSendRequest(URI uri, String method, byte[] body, Map<String, List<String>> headers) throws IOException {
        HttpRequest.Builder request = HttpRequest.newBuilder();
        String scheme = uri.getScheme();
        if (scheme.startsWith("x")) {
            try {
                uri = new URI(uri.toString().substring(1));
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
                throw new IOException(ex);
            }
        }
        request.uri(uri);
        if (body == null) {
            request.method(method, HttpRequest.BodyPublishers.noBody());
        } else {
            request.method(method, HttpRequest.BodyPublishers.ofByteArray(body));
        }
        if (headers != null) {
            for (Map.Entry<String, List<String>> header : headers.entrySet()) {
                request.header(header.getKey(), header.getValue().get(0));
            }
        }
        return this.implAsyncSendRequest(request.build(), body);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.keepAliveSender.shutdownKeepAlive();
        LOG.info("Abort websocket " + String.valueOf(this.webSocket));
        this.webSocket.abort();
    }

    class MyWebsocketListener
    implements WebSocket.Listener {
        private LegacyNetworkClient parent;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();

        MyWebsocketListener(LegacyNetworkClient parent) {
            this.parent = parent;
        }

        @Override
        public void onError(WebSocket webSocket, Throwable error) {
            LOG.log(Level.WARNING, "ERROR IN WEBSOCKET " + String.valueOf(webSocket) + ", do we have connectivityListener? " + String.valueOf(LegacyNetworkClient.this.connectivityListener) + ", err = " + String.valueOf(error));
            NetworkClient.WsStatus myStatus = LegacyNetworkClient.this.getWsStatus();
            LOG.info("Websocket " + String.valueOf(webSocket) + " ERROR and wsStatus " + String.valueOf((Object)myStatus));
            if (NetworkClient.WsStatus.READY == myStatus) {
                LOG.info("Closing networkclient " + String.valueOf(LegacyNetworkClient.this));
                LegacyNetworkClient.this.keepAliveSender.shutdownKeepAlive();
                LOG.info("Will now request to shutdown...");
                LegacyNetworkClient.this.requestWSShutdown();
                LOG.info("Closed networkclient " + String.valueOf(LegacyNetworkClient.this));
            }
        }

        @Override
        public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
            NetworkClient.WsStatus myStatus = LegacyNetworkClient.this.getWsStatus();
            LOG.info("Websocket " + String.valueOf(webSocket) + " closed with statusCode " + statusCode + " and reason " + reason + ". wsStatus " + String.valueOf((Object)myStatus));
            if (NetworkClient.WsStatus.READY == myStatus) {
                LOG.info("Closing networkclient " + String.valueOf(LegacyNetworkClient.this));
                LegacyNetworkClient.this.keepAliveSender.shutdownKeepAlive();
                LOG.info("Will now request to shutdown");
                LegacyNetworkClient.this.requestWSShutdown();
                LOG.info("Closed networkclient " + String.valueOf(LegacyNetworkClient.this));
            }
            return null;
        }

        @Override
        public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
            LOG.info("Websocket receives binary data on " + String.valueOf(Thread.currentThread()) + ", last = " + last + ", limit = " + data.limit() + ", remaining = " + data.remaining() + ", cap = " + data.capacity());
            webSocket.request(1L);
            byte[] buff = new byte[data.remaining()];
            data.get(buff);
            try {
                this.baos.write(buff);
                if (last) {
                    byte[] completed = this.baos.toByteArray();
                    this.baos = new ByteArrayOutputStream();
                    LOG.info("total size = " + completed.length);
                    LegacyNetworkClient.this.rawByteQueue.put(completed);
                    LOG.info("Moved bytes to rawByteQueue " + String.valueOf(LegacyNetworkClient.this.rawByteQueue));
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                LOG.log(Level.SEVERE, "error in receiving ws data", t);
            }
            return null;
        }

        @Override
        public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
            LOG.info("Websocket receives text");
            webSocket.request(1L);
            try {
                LegacyNetworkClient.this.rawByteQueue.put(data.toString().getBytes());
            }
            catch (Throwable t) {
                t.printStackTrace();
                LOG.log(Level.SEVERE, "error in receiving ws data", t);
            }
            return null;
        }

        @Override
        public void onOpen(WebSocket webSocket) {
            try {
                LOG.info("java.net ws is opened");
                LOG.info("notified listener1");
                WebSocket.Listener.super.onOpen(webSocket);
                System.err.println("notified listener2");
                LegacyNetworkClient.this.keepAliveSender = new KeepAliveSender();
                LOG.info("Created KeepAlive " + String.valueOf(LegacyNetworkClient.this.keepAliveSender) + " for networkclient " + String.valueOf(this));
                LegacyNetworkClient.this.keepAliveSender.start();
            }
            catch (Throwable e) {
                e.printStackTrace();
                LOG.log(Level.SEVERE, "error in onopen", e);
            }
            LOG.info("Ready to accept data");
        }
    }

    private class KeepAliveSender
    extends Thread {
        private AtomicBoolean stop = new AtomicBoolean(false);

        @Override
        public void run() {
            while (!this.stop.get()) {
                try {
                    LOG.info("Sending keep alive for " + String.valueOf(this));
                    CompletableFuture<WebsocketResponse> fut = LegacyNetworkClient.this.sendKeepAlive();
                    WebsocketResponse id = fut.get(10L, TimeUnit.SECONDS);
                    LOG.info("got keepalive for " + String.valueOf(id));
                    Thread.sleep(TimeUnit.SECONDS.toMillis(55L));
                }
                catch (Throwable e) {
                    NetworkClient.WsStatus myStatus = LegacyNetworkClient.this.getWsStatus();
                    LOG.info("FAILED Sending keep alive for " + String.valueOf(this) + " and status = " + String.valueOf((Object)myStatus));
                    if (NetworkClient.WsStatus.READY != myStatus) continue;
                    LOG.info("Closing networkclient " + String.valueOf(LegacyNetworkClient.this));
                    this.shutdownKeepAlive();
                    LOG.info("Will now request to shutdown");
                    LegacyNetworkClient.this.requestWSShutdown();
                    LOG.info("Closed networkclient " + String.valueOf(LegacyNetworkClient.this));
                }
            }
            LOG.info("No more keepalives for " + String.valueOf(this));
        }

        public void shutdownKeepAlive() {
            LOG.info("Requesting to stop keep alive for " + String.valueOf(this) + ", stop = " + String.valueOf(this.stop));
            this.stop.set(true);
        }
    }
}

