/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtcrime.securesms.groups;

import io.privacyresearch.equation.groups.GroupsV2Api;
import io.privacyresearch.equation.groups.GroupsV2AuthorizationString;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.auth.AuthCredentialWithPniResponse;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.whispersystems.signalservice.api.push.ServiceIds;

public class GroupsV2Authorization {
    private static final Logger LOG = Logger.getLogger(GroupsV2Authorization.class.getName());
    private final ValueCache authCache;
    private final GroupsV2Api groupsV2Api;

    public GroupsV2Authorization(GroupsV2Api groupsV2Api) {
        this.groupsV2Api = groupsV2Api;
        long today = GroupsV2Authorization.currentDaySeconds();
        this.authCache = new ValueCacheImpl();
        try {
            GroupsV2Api.CredentialResponseMaps credentials = groupsV2Api.getCredentials(today);
            this.authCache.write(credentials);
            LOG.info("Got and temp stored credentials " + String.valueOf(credentials));
        }
        catch (Throwable ex) {
            LOG.info("Exception creating groupsV2Authorization");
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public GroupsV2AuthorizationString getAuthorizationForToday(ServiceIds serviceIds, GroupSecretParams groupSecretParams) throws IOException, VerificationFailedException {
        long today = GroupsV2Authorization.currentDaySeconds();
        GroupsV2Api.CredentialResponseMaps credentials = this.authCache.read();
        try {
            return this.getAuthorization(serviceIds, groupSecretParams, credentials.getAuthCredentialWithPniResponseHashMap(), today);
        }
        catch (Exception e) {
            LOG.info("got exection: " + String.valueOf(e) + ", will update auth and try again");
            this.authCache.clear();
            LOG.info("Getting new auth credential responses");
            credentials = this.groupsV2Api.getCredentials(today);
            LOG.info("This time, we got " + String.valueOf(credentials));
            this.authCache.write(credentials);
            try {
                return this.getAuthorization(serviceIds, groupSecretParams, credentials.getAuthCredentialWithPniResponseHashMap(), today);
            }
            catch (Exception e2) {
                LOG.info("The credentials returned did not include the day requested");
                throw new IOException("Failed to get credentials");
            }
        }
    }

    private static long currentDaySeconds() {
        return TimeUnit.DAYS.toSeconds(TimeUnit.MILLISECONDS.toDays(System.currentTimeMillis()));
    }

    private GroupsV2AuthorizationString getAuthorization(ServiceIds serviceIds, GroupSecretParams groupSecretParams, Map<Long, AuthCredentialWithPniResponse> credentials, long todaySeconds) throws VerificationFailedException {
        LOG.info("get auth for todayseconds = " + todaySeconds);
        AuthCredentialWithPniResponse authCredentialWithPniResponse = credentials.get(todaySeconds);
        LOG.info("Got auth for " + todaySeconds + " : " + String.valueOf(authCredentialWithPniResponse));
        if (authCredentialWithPniResponse == null) {
            LOG.info("No credentials for " + todaySeconds);
            LOG.info("Credentials = " + String.valueOf(credentials));
            throw new IllegalArgumentException("No credential for time " + todaySeconds);
        }
        return this.groupsV2Api.getGroupsV2AuthorizationString(serviceIds.getAci(), serviceIds.requirePni(), todaySeconds, groupSecretParams, authCredentialWithPniResponse);
    }

    public static class ValueCacheImpl
    implements ValueCache {
        GroupsV2Api.CredentialResponseMaps crmap = null;

        @Override
        public void clear() {
            this.crmap = null;
        }

        @Override
        public GroupsV2Api.CredentialResponseMaps read() {
            return this.crmap;
        }

        @Override
        public void write(GroupsV2Api.CredentialResponseMaps values) {
            this.crmap = values;
        }
    }

    public static interface ValueCache {
        public void clear();

        public GroupsV2Api.CredentialResponseMaps read();

        public void write(GroupsV2Api.CredentialResponseMaps var1);
    }
}

