/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.util;

import io.privacyresearch.clientdata.user.UnidentifiedAccessMode;
import java.util.Base64;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.whispersystems.signalservice.api.crypto.ProfileCipher;
import org.whispersystems.signalservice.api.crypto.UnidentifiedAccess;
import org.whispersystems.signalservice.api.crypto.UnidentifiedAccessPair;
import org.whispersystems.signalservice.api.profiles.SignalServiceProfile;

public class UnidentifiedAccessUtil {
    private static final Logger LOG = Logger.getLogger(UnidentifiedAccessUtil.class.getName());
    private static byte[] senderCertificate;

    public static byte[] getSenderCertificate() {
        return senderCertificate;
    }

    public static void setSenderCertificate(byte[] v) {
        senderCertificate = v;
    }

    public static UnidentifiedAccessMode getUnidentifiedAccessMode(byte[] profileKeyBytes, SignalServiceProfile profile) {
        try {
            String unidentifiedAccessVerifier = profile.getUnidentifiedAccess();
            boolean unrestrictedUnidentifiedAccess = profile.isUnrestrictedUnidentifiedAccess();
            ProfileKey profileKey = new ProfileKey(profileKeyBytes);
            if (unrestrictedUnidentifiedAccess && unidentifiedAccessVerifier != null) {
                return UnidentifiedAccessMode.UNRESTRICTED;
            }
            if (profileKey == null || unidentifiedAccessVerifier == null) {
                return UnidentifiedAccessMode.DISABLED;
            }
            ProfileCipher profileCipher = new ProfileCipher(profileKey);
            boolean verifiedUnidentifiedAccess = profileCipher.verifyUnidentifiedAccess(Base64.getDecoder().decode(unidentifiedAccessVerifier));
            return verifiedUnidentifiedAccess ? UnidentifiedAccessMode.ENABLED : UnidentifiedAccessMode.DISABLED;
        }
        catch (InvalidInputException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    public static UnidentifiedAccessPair getUnidentifiedAccessPair(UnidentifiedAccessMode sealedSenderMode, byte[] userProfileKey, byte[] selfProfileKey) throws InvalidCertificateException, InvalidInputException {
        return new UnidentifiedAccessPair(UnidentifiedAccessUtil.getUnidentifiedAccess(sealedSenderMode, userProfileKey), UnidentifiedAccessUtil.getSelfUnidentifiedAccess(selfProfileKey));
    }

    private static UnidentifiedAccess getSelfUnidentifiedAccess(byte[] profileKeyBytes) throws InvalidCertificateException, InvalidInputException {
        if (senderCertificate == null) {
            throw new InvalidCertificateException("We don't have a sendercertificate for ourself!?");
        }
        byte[] ourUnidentifiedAccessKey = UnidentifiedAccess.deriveAccessKeyFrom((ProfileKey)new ProfileKey(profileKeyBytes));
        byte[] ourUnidentifiedAccessCertificate = senderCertificate;
        UnidentifiedAccess answer = new UnidentifiedAccess(ourUnidentifiedAccessKey, ourUnidentifiedAccessCertificate);
        return answer;
    }

    public static UnidentifiedAccess getUnidentifiedAccess(UnidentifiedAccessMode sealedSenderMode, byte[] profileKeyBytes) throws InvalidCertificateException, InvalidInputException {
        if (senderCertificate == null) {
            throw new InvalidCertificateException("We don't have a sendercertificate");
        }
        if (sealedSenderMode == UnidentifiedAccessMode.DISABLED) {
            LOG.finer("Disabled sealedsender! ");
            return null;
        }
        byte[] theirUnidentifiedAccessKey = new byte[16];
        if (sealedSenderMode != UnidentifiedAccessMode.UNRESTRICTED) {
            theirUnidentifiedAccessKey = UnidentifiedAccess.deriveAccessKeyFrom((ProfileKey)new ProfileKey(profileKeyBytes));
        }
        byte[] ourUnidentifiedAccessCertificate = senderCertificate;
        return new UnidentifiedAccess(theirUnidentifiedAccessKey, ourUnidentifiedAccessCertificate);
    }

    public static Optional<UnidentifiedAccessPair> getAccessForSync(byte[] profileKeyBytes) {
        try {
            byte[] ourUnidentifiedAccessKey = UnidentifiedAccess.deriveAccessKeyFrom((ProfileKey)new ProfileKey(profileKeyBytes));
            byte[] ourUnidentifiedAccessCertificate = senderCertificate;
            return Optional.of(new UnidentifiedAccessPair(new UnidentifiedAccess(ourUnidentifiedAccessKey, ourUnidentifiedAccessCertificate), new UnidentifiedAccess(ourUnidentifiedAccessKey, ourUnidentifiedAccessCertificate)));
        }
        catch (InvalidInputException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return Optional.empty();
        }
        catch (InvalidCertificateException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return Optional.empty();
        }
    }
}

