/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.signal;

import com.gluonhq.snl.NetworkClient;
import com.gluonhq.snl.Response;
import com.google.protobuf.ByteString;
import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.attachment.AttachmentKey;
import io.privacyresearch.clientdata.canvas.CanvasDbRecord;
import io.privacyresearch.clientdata.canvas.CanvasKey;
import io.privacyresearch.clientdata.canvas.CreateCanvasRequest;
import io.privacyresearch.clientdata.canvas.UpdateCanvasRequest;
import io.privacyresearch.clientdata.channel.ChannelKey;
import io.privacyresearch.clientdata.channel.ChannelRecord;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.message.BodyRange;
import io.privacyresearch.clientdata.message.InsertMessageRequest;
import io.privacyresearch.clientdata.message.MessageDbRecord;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.message.ReceiptType;
import io.privacyresearch.clientdata.proxy.ProxyRecord;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.clientdata.user.UnidentifiedAccessMode;
import io.privacyresearch.clientdata.user.UnidentifiedAccessUtil;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.clientdata.user.UserKey;
import io.privacyresearch.equation.AttachmentUtil;
import io.privacyresearch.equation.BackupImporter;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.MessageContentProcessor;
import io.privacyresearch.equation.NetworkMonitor;
import io.privacyresearch.equation.StoryService;
import io.privacyresearch.equation.WaveStore;
import io.privacyresearch.equation.attachment.SignalServiceAttachment;
import io.privacyresearch.equation.attachment.SignalServiceAttachmentPointer;
import io.privacyresearch.equation.attachment.SignalServiceAttachmentStream;
import io.privacyresearch.equation.groups.ClientZkOperations;
import io.privacyresearch.equation.groups.GroupsV2Operations;
import io.privacyresearch.equation.incoming.SyncMessageProcessor;
import io.privacyresearch.equation.internal.LockImpl;
import io.privacyresearch.equation.internal.TrustStoreImpl;
import io.privacyresearch.equation.message.MessagingClient;
import io.privacyresearch.equation.model.Attachment;
import io.privacyresearch.equation.model.Message;
import io.privacyresearch.equation.model.RegistrationResponse;
import io.privacyresearch.equation.net.NetworkAPI;
import io.privacyresearch.equation.net.NetworkConfiguration;
import io.privacyresearch.equation.net.SignalSender;
import io.privacyresearch.equation.proxy.QuicServerTransport;
import io.privacyresearch.equation.registration.AccountRegistration;
import io.privacyresearch.equation.user.UserRecord;
import io.privacyresearch.equation.user.UserService;
import io.privacyresearch.equation.util.SignalServiceProtoUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.http.HttpRequest;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.signal.libsignal.messagebackup.BackupKey;
import org.signal.libsignal.messagebackup.MessageBackupKey;
import org.signal.libsignal.metadata.certificate.CertificateValidator;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.InvalidRegistrationIdException;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.ecc.Curve;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupIdentifier;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.whispersystems.signalservice.api.SignalServiceDataStore;
import org.whispersystems.signalservice.api.crypto.ContentHint;
import org.whispersystems.signalservice.api.crypto.EnvelopeMetadata;
import org.whispersystems.signalservice.api.crypto.SignalServiceCipherResult;
import org.whispersystems.signalservice.api.crypto.UnidentifiedAccess;
import org.whispersystems.signalservice.api.crypto.UnidentifiedAccessPair;
import org.whispersystems.signalservice.api.crypto.UntrustedIdentityException;
import org.whispersystems.signalservice.api.messages.SendMessageResult;
import org.whispersystems.signalservice.api.messages.SignalServiceEnvelope;
import org.whispersystems.signalservice.api.messages.SignalServiceGroupV2;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.push.TrustStore;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public class SignalBridge {
    private static final Logger LOG = Logger.getLogger(SignalBridge.class.getName());
    public static String SIGNAL_USER_AGENT = "Signal-Desktop/5.30.0 Linux";
    static String UNIDENTIFIED_SENDER_TRUST_ROOT = "BXu6QIKVz5MA8gstzfOgRQGqyLqOwNKHL6INkv3IHWMF";
    public static String ZKGROUP_SERVER_PUBLIC_PARAMS = "AMhf5ywVwITZMsff/eCyudZx9JDmkkkbV6PInzG4p8x3VqVJSFiMvnvlEKWuRob/1eaIetR31IYeAbm0NdOuHH8Qi+Rexi1wLlpzIo1gstHWBfZzy1+qHRV5A4TqPp15YzBPm0WSggW6PbSn+F4lf57VCnHF7p8SvzAA2ZZJPYJURt8X7bbg+H3i+PEjH9DXItNEqs2sNcug37xZQDLm7X36nOoGPs54XsEGzPdEV+itQNGUFEjY6X9Uv+Acuks7NpyGvCoKxGwgKgE5XyJ+nNKlyHHOLb6N1NuHyBrZrgtY/JYJHRooo5CEqYKBqdFnmbTVGEkCvJKxLnjwKWf+fEPoWeQFj5ObDjcKMZf2Jm2Ae69x+ikU5gBXsRmoF94GXTLfN0/vLt98KDPnxwAQL9j5V1jGOY8jQl6MLxEs56cwXN0dqCnImzVH3TZT1cJ8SW1BRX6qIVxEzjsSGx3yxF3suAilPMqGRp4ffyopjMD1JXiKR2RwLKzizUe5e8XyGOy9fplzhw3jVzTRyUZTRSZKkMLWcQ/gv0E4aONNqs4P+NameAZYOD12qRkxosQQP5uux6B2nRyZ7sAV54DgFyLiRcq1FvwKw2EPQdk4HDoePrO/RNUbyNddnM/mMgj4FW65xCoT1LmjrIjsv/Ggdlx46ueczhMgtBunx1/w8k8V+l8LVZ8gAT6wkU5J+DPQalQguMg12Jzug3q4TbdHiGCmD9EunCwOmsLuLJkz6EcSYXtrlDEnAM+hicw7iergYLLlMXpfTdGxJCWJmP4zqUFeTTmsmhsjGBt7NiEB/9pFFEB3pSbf4iiUukw63Eo8Aqnf4iwob6X1QviCWuc8t0LUlT9vALgh/f2DPVOOmR0RW6bgRvc7DSF20V/omg+YBw==";
    private final EquationManager waveManager;
    private SignalSender sender;
    private NetworkClient authenticatedPipe;
    private NetworkClient unauthenticatedPipe;
    final TrustStore trustStore = new TrustStoreImpl();
    private CredentialsProvider credentialsProvider;
    private final LockImpl lock;
    private final SignalServiceDataStore rootStore;
    private final WaveStore aciStore;
    private final StoryService storyService;
    private final UserService userService;
    private final SqliteStorageBean sqliteStorageBean;
    private final MessageContentProcessor mcp;
    private final SyncMessageProcessor syncMessageProcessor;
    private NetworkConfiguration networkConfiguration;
    private final NetworkAPI networkAPI;
    private final GroupsV2Operations groupsV2Operations;
    private MessagingClient waveClient;
    final ExecutorService messageExecutorService = Executors.newFixedThreadPool(2);
    private final Map<String, Object> config;
    long networkLastTried = 0L;
    long lastKeysRequest = 0L;
    private AccountRegistration accountRegistration;

    public SignalBridge(EquationManager waveManager, Map<String, Object> config, SignalServiceDataStore rootStore, StoryService storyService, UserService userService) {
        this.waveManager = waveManager;
        this.rootStore = rootStore;
        this.storyService = storyService;
        this.userService = userService;
        this.config = config;
        LOG.info("Create SignalBridge with config " + String.valueOf(config));
        this.sqliteStorageBean = waveManager.getSqliteStorageBean();
        if (this.sqliteStorageBean.preference().getBoolean("proxyserver.enabled", false)) {
            QuicServerTransport quicServerTransport = new QuicServerTransport();
            try {
                quicServerTransport.startProcessing();
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            LOG.info("Proxy started, continue initializing SignalBridge");
        } else {
            LOG.info("No proxy, continue initializing SignalBridge");
        }
        this.aciStore = (WaveStore)rootStore.aci();
        this.credentialsProvider = this.aciStore.getCredentialsProvider();
        this.lock = new LockImpl();
        this.mcp = new MessageContentProcessor(this.sqliteStorageBean, waveManager, storyService, this);
        this.syncMessageProcessor = new SyncMessageProcessor(waveManager);
        this.networkConfiguration = this.createNetworkConfiguration();
        this.networkAPI = new NetworkAPI(Optional.of(this.credentialsProvider), this.networkConfiguration, waveManager.getNetworkMonitor());
        boolean allowStories = true;
        this.createMessagePipes();
        this.groupsV2Operations = new GroupsV2Operations(ClientZkOperations.create(this.networkConfiguration), 1000);
    }

    private CompletableFuture<Void> createMessagePipes() {
        if (System.currentTimeMillis() - this.networkLastTried < 1000L) {
            LOG.severe("Requested to recreate network, but we tried less than a second ago");
            Thread.dumpStack();
            return CompletableFuture.completedFuture(null);
        }
        this.networkLastTried = System.currentTimeMillis();
        return CompletableFuture.runAsync(() -> {
            NetworkMonitor networkMonitor = this.waveManager.getNetworkMonitor();
            if (!networkMonitor.networkStatus) {
                CountDownLatch cdl = new CountDownLatch(1);
                Consumer<Boolean> callback = a -> {
                    if (a.booleanValue()) {
                        cdl.countDown();
                    }
                };
                networkMonitor.addNetworkListener(callback);
                try {
                    cdl.await();
                    networkMonitor.removeNetworkListener(callback);
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
            this.authenticatedPipe = this.networkAPI.getIdentifiedClient();
            this.unauthenticatedPipe = this.networkAPI.getUnidentifiedClient();
            this.sender = new SignalSender(this.networkAPI, this.credentialsProvider, this.rootStore, this.authenticatedPipe, this.unauthenticatedPipe, this.lock);
        });
    }

    private NetworkConfiguration createNetworkConfiguration() {
        String customHost;
        String proxy = (String)this.config.get("proxy");
        boolean useQuic = Boolean.TRUE.equals(this.config.get("useQuic"));
        boolean useLibsignalNet = Boolean.TRUE.equals(this.waveManager.isUseLibsignalNet());
        NetworkConfiguration answer = new NetworkConfiguration(this.trustStore);
        answer.setUseQuic(useQuic);
        answer.setUseLibsignalNet(useLibsignalNet);
        if (Boolean.TRUE.equals(this.config.get("useStaging"))) {
            LOG.info("Staging requested");
            answer.setServerHost("https://chat.staging.signal.org");
        }
        if ((customHost = (String)this.config.get("serverHost")) != null) {
            LOG.info("Custom serverhost provided: " + customHost);
            answer.setServerHost(customHost);
        }
        return answer;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public String getServerAddress() {
        return this.networkAPI.getServerAddress();
    }

    public Response sendRequest(HttpRequest request, byte[] payload) throws IOException {
        return this.networkAPI.sendRequest(request, payload);
    }

    public void setMessagingClient(MessagingClient client) {
        this.waveClient = client;
        this.mcp.setMessagingClient(client);
    }

    public NetworkAPI getNetworkAPI() {
        return this.networkAPI;
    }

    public static CertificateValidator getCertificateValidator() {
        try {
            ECPublicKey unidentifiedSenderTrustRoot = Curve.decodePoint((byte[])Base64.getDecoder().decode(UNIDENTIFIED_SENDER_TRUST_ROOT), (int)0);
            return new CertificateValidator(unidentifiedSenderTrustRoot);
        }
        catch (org.signal.libsignal.protocol.InvalidKeyException e) {
            throw new RuntimeException("Error creating certificateValidator", e);
        }
    }

    public MessageContentProcessor getMessageContentProcessor() {
        return this.mcp;
    }

    public void startListening() {
        LOG.info("Start startlistening. From now on, Equation may call into Wave.");
        try {
            this.processMessagePipe(this.authenticatedPipe, "MessagePipeProcessor");
            this.processMessagePipe(this.unauthenticatedPipe, "UnidentifiedMessagePipeProcessor");
            LOG.info("Done startListening");
        }
        catch (IOException ex) {
            LOG.info("We can't start listening due to " + String.valueOf(ex));
            ex.printStackTrace();
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public void shutdown() {
        if (this.authenticatedPipe != null) {
            this.authenticatedPipe.halt();
        }
        if (this.unauthenticatedPipe != null) {
            this.unauthenticatedPipe.halt();
        }
    }

    public void requestStorageKey() throws IOException {
        if (System.currentTimeMillis() - this.lastKeysRequest < 10000L) {
            LOG.warning("We got a request to get Keys, but we ignore since we already tried at " + this.lastKeysRequest);
            return;
        }
        this.lastKeysRequest = System.currentTimeMillis();
        SignalServiceProtos.SyncMessage.Builder syncBuilder = SignalServiceProtos.SyncMessage.newBuilder();
        syncBuilder.setRequest(SignalServiceProtos.SyncMessage.Request.newBuilder().setType(SignalServiceProtos.SyncMessage.Request.Type.KEYS));
        LOG.info("Send syncMessage with a request for keys");
        SendMessageResult result = this.sender.sendSyncMessage(syncBuilder.build());
        LOG.info("Did send sendSyncMessage for keys, result = " + String.valueOf(result) + " and success = " + result.isSuccess());
    }

    void processMessagePipe(final NetworkClient pipe, final String name) throws IOException {
        LOG.info("Start processMessagePipe " + String.valueOf(pipe) + " named " + name);
        if (pipe == null) {
            throw new IOException("Should not start listening without valid pipe");
        }
        int messagesPerTransaction = 100;
        Thread t = new Thread(this, name){
            final /* synthetic */ SignalBridge this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void run() {
                boolean failures = false;
                long msgCount = 0L;
                boolean listen = true;
                boolean autoCommit = false;
                long startTime = System.currentTimeMillis();
                try {
                    this.this$0.sqliteStorageBean.getConnection().setAutoCommit(autoCommit);
                }
                catch (SQLException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
                while (listen) {
                    try {
                        LOG.info("[MessagePipe] waiting for envelope...");
                        SignalServiceEnvelope envelope = pipe.read(300L, TimeUnit.SECONDS);
                        LOG.info("Envelope = " + String.valueOf(envelope));
                        if (!autoCommit && ++msgCount % 100L == 0L) {
                            LOG.info("Still receiving past messages, commit now with " + msgCount + " messages");
                            this.this$0.sqliteStorageBean.getConnection().commit();
                        }
                        if (!autoCommit && System.currentTimeMillis() - startTime > 900000L) {
                            LOG.warning("After 15 minutes, we're still not in autoCommit, hard force, msgcount= " + msgCount);
                            autoCommit = true;
                            this.this$0.sqliteStorageBean.getConnection().setAutoCommit(autoCommit);
                        }
                        if (envelope == null) {
                            LOG.info("Got indication that queue is empty, we processed backlog with count = " + msgCount);
                            if (autoCommit) {
                                LOG.warning("We're already in autoCommit");
                                continue;
                            }
                            autoCommit = true;
                            this.this$0.sqliteStorageBean.getConnection().setAutoCommit(autoCommit);
                            LOG.info("DB is in autocommit now");
                            continue;
                        }
                        LOG.info(name + "[PMP] got envelope " + Objects.hashCode(envelope) + " with type = " + envelope.getType() + " and source =  " + envelope.getSourceIdentifier() + "or " + String.valueOf(envelope.getSourceUuid()) + ", will now decrypt");
                        long s0 = System.currentTimeMillis();
                        if (!envelope.isReceipt()) {
                            SignalServiceCipherResult cipherResult = this.this$0.waveManager.mydecrypt(envelope);
                            this.this$0.processIncomingMessage(cipherResult, envelope.getEnvelope());
                        }
                        long delta = System.currentTimeMillis() - s0;
                        LOG.info("[PMP] processed content in " + delta);
                    }
                    catch (Throwable ex) {
                        if (pipe.getWsStatus() == NetworkClient.WsStatus.HALT) {
                            listen = false;
                            LOG.info("NetworkClient used by " + String.valueOf(pipe) + " was closed. Stop processing this pipe.");
                            continue;
                        }
                        ex.printStackTrace();
                        System.err.println("Despite the above exception, we continue listening.");
                        LOG.log(Level.SEVERE, "THIS SHOULD NOT HAVE HAPPENED! Investigate logs", ex);
                    }
                }
                LOG.warning("We stopped listening for incoming messages.");
            }
        };
        t.start();
    }

    public void processIncomingMessage(SignalServiceCipherResult cipherResult, SignalServiceProtos.Envelope envelope) throws InvalidMessageException, IOException {
        if (cipherResult == null) {
            LOG.warning("We have a null cipherResult, could be a nosession exception which is handled. Just return now.");
            return;
        }
        SignalServiceProtos.Content content = cipherResult.getContent();
        EnvelopeMetadata metadata = cipherResult.getMetadata();
        LOG.info("Got cipherresult " + String.valueOf(cipherResult) + " with metadata = " + String.valueOf(metadata) + " and me164 = " + metadata.getSourceE164());
        LOG.info("servertimestamp = " + envelope.getServerTimestamp() + " and src timestamp = " + envelope.getTimestamp());
        LOG.finest("Content = " + String.valueOf(content));
        SignalServiceAddress address = new SignalServiceAddress(metadata.getSourceServiceId(), metadata.getSourceE164());
        if (content != null) {
            address.getServiceId().toString();
            LOG.info("Process Content " + String.valueOf(address.getServiceId()) + " and uuid = " + String.valueOf(address.getUuid()));
            String senderIdentifier = address.getServiceId().toString();
            UserDbRecord sender = this.sqliteStorageBean.getUserData().getUserForServiceId(metadata.getSourceServiceId());
            if (sender == null) {
                LOG.warning("We don't know sender yet " + String.valueOf(metadata.getSourceServiceId()) + ":" + metadata.getSourceDeviceId() + ":" + metadata.getSourceE164());
            }
            RecipientRecord channelRecipient = this.getMessageDestination(content, sender);
            LOG.info("Sender = " + String.valueOf(sender.key()) + ", channel = " + String.valueOf(channelRecipient));
            if (channelRecipient == null) {
                LOG.severe("Thread Recipient null! Ignore this message");
                return;
            }
            LOG.info("Got message for channelRecipientKey = " + String.valueOf(channelRecipient.key()));
            ChannelKey channelKey = this.sqliteStorageBean.getChannelData().findByRecipientKey(channelRecipient.key());
            LOG.info("channelKey = " + String.valueOf(channelKey));
            try {
                boolean ignoreMe = this.mcp.shouldIgnore(content, (RecipientRecord)this.sqliteStorageBean.getRecipientData().findByKey((EntityKey)sender.recipientKey()), channelRecipient);
                if (ignoreMe) {
                    LOG.warning("IGNORE message from " + String.valueOf(sender.aci()));
                    return;
                }
                LOG.info("dont ignore message from " + String.valueOf(sender.aci()));
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Error checking ignore rules", t);
                t.printStackTrace();
            }
            if (content.hasSyncMessage()) {
                LOG.info("[MessagePipe] envelope has syncmessage");
                SignalServiceProtos.SyncMessage syncMessage = content.getSyncMessage();
                this.waveManager.processSyncMessage(envelope, syncMessage, sender, channelRecipient);
            }
            if (content.hasDataMessage()) {
                SignalServiceProtos.DataMessage dataMessage = content.getDataMessage();
                if (dataMessage.hasCanvasMessage()) {
                    this.processCanvasMessage(channelRecipient.key(), sender, dataMessage);
                } else if (dataMessage.hasProxyMessage()) {
                    this.processProxyMessage(dataMessage);
                } else {
                    this.mcp.processDataMessage(envelope, content.getDataMessage(), sender, channelRecipient);
                }
            }
            if (content.hasTypingMessage()) {
                LOG.info("[MessagePipe] envelope has typingmessage");
                if (!this.waveManager.getAccount().getPreferences().typingIndicators()) {
                    LOG.info("We don't send typing indicators, so we shouldn't read them either.");
                    return;
                }
                this.mcp.processTypingMessage(content.getTypingMessage(), sender.recipientKey(), channelRecipient.key());
            }
            if (content.hasReceiptMessage()) {
                if (!this.isReadReceiptsEnabled()) {
                    LOG.info("We don't have readReceipts enabled, ignore this message.");
                    return;
                }
                LOG.info("[MessagePipe] envelope has receiptmessage.");
                this.mcp.processReceiptMessage(content.getReceiptMessage(), envelope.getTimestamp(), sender.recipientKey());
            }
            if (content.hasCallMessage()) {
                long timediff = System.currentTimeMillis() - envelope.getTimestamp();
                if (timediff > 60000L) {
                    LOG.info("Storing but not processing old call offer mesage, elapsed time = " + timediff);
                }
                this.waveManager.processCallMessage(content, sender, metadata.getSourceDeviceId(), envelope.getTimestamp());
            }
            if (content.hasEditMessage()) {
                LOG.info("We have an edit message");
                this.mcp.processDataMessage(envelope, content.getEditMessage().getDataMessage(), sender, channelRecipient, content.getEditMessage().getTargetSentTimestamp());
            }
        }
    }

    public void processCanvasMessage(RecipientKey rKey, UserDbRecord sender, SignalServiceProtos.DataMessage dataMessage) {
        LOG.info("Need to update canvas for recipient " + String.valueOf(rKey));
        ChannelKey channelKey = this.sqliteStorageBean.getChannelData().findByRecipientKey(rKey);
        SignalServiceProtos.DataMessage.CanvasMessage canvasMessage = dataMessage.getCanvasMessage();
        String body = canvasMessage.getContent();
        List bodyRangesList = canvasMessage.getBodyRangesList();
        ArrayList<BodyRange> bodyRanges = new ArrayList<BodyRange>();
        for (SignalServiceProtos.BodyRange bodyRange : bodyRangesList) {
            if (bodyRange.hasMentionAci()) {
                bodyRanges.add(BodyRange.fromMentionAci((String)bodyRange.getMentionAci(), (int)bodyRange.getStart(), (int)bodyRange.getLength()));
                continue;
            }
            BodyRange.Style style = EquationManager.getStyleFromProto(bodyRange.getStyle().getNumber());
            bodyRanges.add(BodyRange.fromStyle((BodyRange.Style)style, (int)bodyRange.getStart(), (int)bodyRange.getLength()));
        }
        List records = this.sqliteStorageBean.getCanvasData().getByChannel(channelKey);
        CanvasKey canvasKey = null;
        if (records.isEmpty()) {
            LOG.info("We don't have a canvas yet. New version = " + canvasMessage.getVersion());
            String id = UUID.randomUUID().toString();
            CreateCanvasRequest createCanvasRequest = new CreateCanvasRequest(channelKey, canvasMessage.getIdentifier(), sender.recipientKey(), canvasMessage.getContent(), bodyRanges, (int)canvasMessage.getVersion());
            canvasKey = this.sqliteStorageBean.getCanvasData().createCanvas(createCanvasRequest);
        } else {
            if (records.size() > 1) {
                LOG.severe("We have more than 1 canvas on channel " + String.valueOf(channelKey));
            }
            CanvasKey key = ((CanvasDbRecord)records.get(0)).key();
            LOG.info("our most recent version was " + ((CanvasDbRecord)records.get(0)).version() + " and new one = " + canvasMessage.getVersion());
            UpdateCanvasRequest updateCanvasRequest = new UpdateCanvasRequest(key, sender.recipientKey(), canvasMessage.getContent(), bodyRanges, (int)canvasMessage.getVersion());
            canvasKey = this.sqliteStorageBean.getCanvasData().updateCanvas(updateCanvasRequest);
        }
        if (canvasKey != null) {
            CanvasDbRecord canvasRecord = (CanvasDbRecord)this.sqliteStorageBean.getCanvasData().findByKey((EntityKey)canvasKey);
            this.waveClient.gotCanvasUpdate(canvasRecord);
        }
    }

    public void processProxyMessage(SignalServiceProtos.DataMessage dataMessage) {
        SignalServiceProtos.DataMessage.ProxyMessage msg = dataMessage.getProxyMessage();
        ProxyRecord pr = new ProxyRecord(null, msg.getHost(), msg.getPort(), msg.getIdentifier(), msg.getRemoteId());
        this.sqliteStorageBean.getProxyData().createProxy(pr);
        LOG.info("Added proxy: " + String.valueOf(pr));
    }

    public Attachment downloadAndStoreAttachmentMedia(SignalServiceAttachment ssa, Path destinationDir) {
        if (ssa.isStream()) {
            SignalServiceAttachmentStream stream = ssa.asStream();
            InputStream is = stream.getInputStream();
            try {
                LOG.severe("Stream attachemnt not supported!");
                int len = is.available();
                byte[] b = new byte[len];
                is.read(b);
                Path tf = Files.createTempFile("att", "", new FileAttribute[0]);
                Files.write(tf, b, new OpenOption[0]);
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        } else {
            Thread.dumpStack();
            throw new RuntimeException();
        }
        return null;
    }

    private RecipientRecord getMessageDestination(SignalServiceProtos.Content content, UserDbRecord sender) {
        if (content.hasStoryMessage() && content.getStoryMessage().hasGroup() && content.getStoryMessage().getGroup().hasMasterKey()) {
            return this.waveManager.getGroupRecipient(content.getStoryMessage().getGroup()).orElse((RecipientRecord)this.sqliteStorageBean.getRecipientData().findByKey((EntityKey)sender.recipientKey()));
        }
        if (SignalServiceProtoUtil.hasGroupContext(content.getDataMessage())) {
            SignalServiceProtos.GroupContextV2 groupV2 = content.getDataMessage().getGroupV2();
            LOG.info("We have a group context");
            return this.waveManager.getGroupRecipient(groupV2).orElseGet(() -> this.waveManager.createGroupRecipient(groupV2));
        }
        if (content.hasEditMessage() && SignalServiceProtoUtil.hasGroupContext(content.getEditMessage().getDataMessage())) {
            return this.waveManager.getGroupRecipient(content.getEditMessage().getDataMessage().getGroupV2()).orElseGet(() -> (RecipientRecord)this.sqliteStorageBean.getRecipientData().findByKey((EntityKey)sender.recipientKey()));
        }
        if (content.hasTypingMessage() && content.getTypingMessage().hasGroupId()) {
            GroupIdentifier groupIdentifier = null;
            ByteString groupId = content.getTypingMessage().getGroupId();
            try {
                groupIdentifier = new GroupIdentifier(groupId.toByteArray());
            }
            catch (InvalidInputException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            if (groupIdentifier != null) {
                Optional group = this.sqliteStorageBean.getGroupData().getGroupByGroupIdentifier(groupIdentifier);
                if (group.isEmpty() && group.isEmpty()) {
                    LOG.warning("Grouptypingmessage with unknown group, this can be null");
                    return null;
                }
                return ((GroupRecord)group.get()).recipient();
            }
        }
        LOG.info("return sender as destination: " + String.valueOf(sender.recipientKey()));
        return (RecipientRecord)this.sqliteStorageBean.getRecipientData().findByKey((EntityKey)sender.recipientKey());
    }

    public long sendSignalMessage(ServiceId serviceId, SignalServiceProtos.DataMessage message, MessageDbRecord messageDbRecord) throws IOException {
        LOG.info("msg timestamp = " + message.getTimestamp() + " with quote? " + message.hasQuote() + " to = " + String.valueOf(serviceId));
        SignalServiceAddress add = new SignalServiceAddress(serviceId);
        UserDbRecord user = this.sqliteStorageBean.getUserData().getUserForServiceId(serviceId);
        UserDbRecord self = this.sqliteStorageBean.getUserCache().getSelf();
        try {
            Optional<UnidentifiedAccessPair> uap = Optional.of(UnidentifiedAccessUtil.getUnidentifiedAccessPair((UnidentifiedAccessMode)user.sealedSenderMode(), (byte[])user.profileKey(), (byte[])self.profileKey()));
            long timestamp = message.getTimestamp();
            String destid = add.getServiceId().toString();
            Object res = null;
            if (((ServiceId)self.getServiceId().get()).toServiceIdString().equals(destid)) {
                throw new RuntimeException();
            }
            CompletableFuture<SendMessageResult> sendTask = CompletableFuture.supplyAsync(() -> {
                try {
                    LOG.info("Sending datamessage " + message.getTimestamp());
                    return this.sender.sendDataMessage(add, uap, ContentHint.RESENDABLE, message, true, false);
                }
                catch (IOException | UntrustedIdentityException ex) {
                    Logger.getLogger(EquationManager.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException(ex);
                }
            }, this.messageExecutorService);
            ((CompletableFuture)sendTask.exceptionally(exception -> {
                LOG.log(Level.SEVERE, "Error sending message", (Throwable)exception);
                return SendMessageResult.networkFailure((SignalServiceAddress)add);
            })).thenAccept(result -> {
                if (result.isSuccess()) {
                    LOG.info("Succeeded sending message");
                    if (messageDbRecord != null) {
                        this.sqliteStorageBean.getMessageData().updateReceiptStatus(messageDbRecord.key(), ReceiptType.SENT, timestamp);
                        this.waveClient.gotReceiptMessage(null, messageDbRecord.receiverKey(), ReceiptType.SENT.getV(), List.of(Long.valueOf(messageDbRecord.dateSent())), timestamp);
                    }
                } else {
                    LOG.warning("Result for sending message = " + String.valueOf(result));
                }
                LOG.info("Need to update receipt on client msg");
            });
        }
        catch (InvalidCertificateException | InvalidInputException ex) {
            LOG.log(Level.SEVERE, "UntrustedIdentityException!", ex);
            throw new IOException("Could not send message to " + String.valueOf(add), ex);
        }
        return message.getTimestamp();
    }

    public long sendSignalGroupMessage(SignalServiceProtos.DataMessage message, GroupRecord mygroup, long origTimestamp) throws IOException, InvalidCertificateException, InvalidInputException, UntrustedIdentityException, NoSessionException, org.signal.libsignal.protocol.InvalidKeyException, InvalidRegistrationIdException {
        boolean onlyTargetIsSelfWithLinkedDevice;
        boolean success = false;
        byte[] groupId = mygroup.getGroupIdentifier().serialize();
        Set<UserKey> groupUsers = this.waveManager.getGroupUsers(mygroup);
        UUID distribution = mygroup.distributionId();
        LinkedList<SignalServiceAddress> registered = new LinkedList<SignalServiceAddress>();
        LinkedList<SignalServiceAddress> unregistered = new LinkedList<SignalServiceAddress>();
        LinkedList<UnidentifiedAccess> registeredAccess = new LinkedList<UnidentifiedAccess>();
        LinkedList<Optional<UnidentifiedAccessPair>> unregisteredAccess = new LinkedList<Optional<UnidentifiedAccessPair>>();
        this.dispatchUsers(groupUsers, registered, unregistered, registeredAccess, unregisteredAccess);
        if (registered.size() > 0) {
            LOG.info("Sending to " + registered.size() + " registered members (senderkey) with distributionId = " + String.valueOf(distribution) + " and title = " + mygroup.title());
            try {
                SignalServiceProtos.EditMessage ssem = null;
                if (origTimestamp > 0L) {
                    ssem = SignalServiceProtos.EditMessage.newBuilder().setDataMessage(message).setTargetSentTimestamp(origTimestamp).build();
                }
                List<SendMessageResult> results = this.sender.sendGroupDataMessage(distribution, Optional.of(groupId), registered, registeredAccess, false, ContentHint.DEFAULT, message, true, false, ssem);
                LOG.info("Results = " + String.valueOf(results));
                this.handleSendResults(results);
                Iterator iterator = results.iterator();
                while (iterator.hasNext()) {
                    SendMessageResult srm = (SendMessageResult)iterator.next();
                    if (!srm.isSuccess()) {
                        LOG.info("networkfailure? " + srm.isNetworkFailure() + ", unreg? " + srm.isUnregisteredFailure());
                        unregistered.add(srm.getAddress());
                        LOG.info("Failed to send to " + String.valueOf(srm.getAddress()) + " using senderkey, try legacy");
                        continue;
                    }
                    success = true;
                }
            }
            catch (IOException | NoSessionException ioe) {
                ioe.printStackTrace();
                LOG.info("Got IOException trying to use senderkey, send all via legacy " + String.valueOf(ioe));
                for (SignalServiceAddress reg : registered) {
                    unregistered.add(reg);
                    unregisteredAccess.add(Optional.empty());
                }
            }
        } else {
            LOG.info("Sending to 0 registered senderkey members");
        }
        LOG.info("Sending to " + unregistered.size() + " unregistered members (legacy!) ");
        boolean bl = onlyTargetIsSelfWithLinkedDevice = unregistered.isEmpty() && registered.isEmpty();
        if (unregistered.size() > 0 || onlyTargetIsSelfWithLinkedDevice) {
            LOG.info("OnlyUs? " + onlyTargetIsSelfWithLinkedDevice);
            try {
                List<SendMessageResult> res = this.sender.sendDataMessage(Optional.of(groupId), unregistered, unregisteredAccess, false, ContentHint.DEFAULT, message, null, null, true);
                boolean proofRequired = false;
                for (SendMessageResult smr : res) {
                    if (!smr.isSuccess()) {
                        LOG.warning("Failure sending to = " + String.valueOf(smr.getAddress().getServiceId()));
                        throw new RuntimeException();
                    }
                    success = true;
                }
                if (proofRequired) {
                    throw new RuntimeException();
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "problem with unregisteredAccess", ex);
            }
        }
        LOG.info("Return id for message: " + message.getTimestamp());
        return success ? System.currentTimeMillis() : -1L;
    }

    private void handleSendResults(List<SendMessageResult> results) {
        results.stream().forEach(result -> {
            SendMessageResult.IdentityFailure identityFailure = result.getIdentityFailure();
            if (identityFailure != null) {
                LOG.warning("We need to handle identityFailyure for " + String.valueOf(result.getAddress()));
                throw new RuntimeException();
            }
        });
    }

    public Map<SignalServiceAttachment, Path> getUploadAttachmentsMap(List<Attachment> attachment) throws IOException {
        if (attachment == null) {
            return Map.of();
        }
        LOG.info("Will upload " + attachment.size() + " attachments.");
        HashMap<SignalServiceAttachment, Path> ssa = new HashMap<SignalServiceAttachment, Path>();
        for (Attachment att : attachment) {
            SignalServiceAttachmentStream stream = AttachmentUtil.createAttachmentStream(att, this.networkAPI);
            SignalServiceAttachmentPointer ptr = this.sender.uploadAttachment(stream);
            ssa.put(ptr, att.getPath());
        }
        return ssa;
    }

    public InputStream storeGroupAvatar(String urlPath, GroupSecretParams gsp, RecipientKey recipientKey) throws IOException {
        File avatarFile = Files.createTempFile("avt", "prof", new FileAttribute[0]).toFile();
        this.getNetworkAPI().retrieveProfileAvatar(urlPath, avatarFile);
        byte[] encryptedBytes = Files.readAllBytes(avatarFile.toPath());
        byte[] decryptedBytes = this.groupsV2Operations.forGroup(gsp).decryptAvatar(encryptedBytes);
        LOG.info("Store group avatar, encbsize = " + encryptedBytes.length + " and decbsize = " + decryptedBytes.length);
        avatarFile.delete();
        ByteArrayInputStream is = new ByteArrayInputStream(decryptedBytes);
        return is;
    }

    public long sendMessage(RecipientKey receiverKey, Message waveMessage, long timestamp, List<Attachment> attachment) throws IOException {
        LOG.info("Start sending direct message");
        if (timestamp == 0L) {
            timestamp = System.currentTimeMillis();
        }
        ServiceId serviceId = this.waveManager.getServiceId(receiverKey);
        RecipientRecord channelRecipient = (RecipientRecord)this.sqliteStorageBean.getRecipientData().findByKey((EntityKey)receiverKey);
        String text = waveMessage.getContent();
        waveMessage.senderKey(this.sqliteStorageBean.getUserCache().getSelf().key());
        waveMessage.receiverKey(receiverKey);
        InsertMessageRequest messageRequest = new InsertMessageRequest();
        messageRequest.setContent(waveMessage.getContent());
        messageRequest.setSenderKey(waveMessage.getSenderKey());
        messageRequest.setReceiverKey(waveMessage.getReceiverKey());
        messageRequest.setBodyRanges(waveMessage.getBodyRanges());
        this.waveManager.handleEditedMessage(waveMessage.getOrigTimestamp(), this.waveManager.getAccount().getUser().recipient().key(), messageRequest);
        SignalServiceProtos.Content.Builder contentBuilder = SignalServiceProtos.Content.newBuilder();
        SignalServiceProtos.DataMessage.Builder dataMessageBuilder = this.messageToDataMessageBuilder(waveMessage, timestamp, null, attachment);
        Map<SignalServiceAttachment, Path> signalAttachments = this.processSendingAttachments(dataMessageBuilder, attachment);
        int expiration = channelRecipient.expireMessages();
        int currentExpTimerVersion = channelRecipient.expireTimerVersion();
        if (expiration > 0) {
            dataMessageBuilder.setExpireTimer(expiration).setExpireTimerVersion(currentExpTimerVersion);
            messageRequest.setExpiration(expiration);
            messageRequest.setExpireTimestamp(timestamp);
            waveMessage.setExpiration(expiration);
            waveMessage.setExpireTimestamp(timestamp);
        }
        MessageKey quotedMessageKey = waveMessage.getQuotedMessageKey();
        LOG.fine("Need to send message with expiration = " + expiration + " and expversion = " + currentExpTimerVersion + "  and started = " + timestamp + " and quotedMessageKey = " + String.valueOf(quotedMessageKey));
        if (waveMessage.getQuotedMessageKey() != null) {
            MessageDbRecord quoteRecord = (MessageDbRecord)this.sqliteStorageBean.getMessageData().findByKey((EntityKey)waveMessage.getQuotedMessageKey());
            SignalServiceProtos.DataMessage.Quote quote = this.createQuote(quoteRecord);
            dataMessageBuilder.setQuote(quote);
        }
        LOG.info("Sending to " + String.valueOf(serviceId));
        SignalServiceProtos.DataMessage message = dataMessageBuilder.build();
        long sentTimestamp = message.getTimestamp();
        long origTimestamp = waveMessage.getOrigTimestamp();
        messageRequest.setTimestamp(sentTimestamp);
        waveMessage.timestamp(sentTimestamp);
        ChannelKey channelKey = this.sqliteStorageBean.getChannelData().findByRecipientKey(receiverKey);
        MessageKey messageKey = this.sqliteStorageBean.getMessageData().insertMessage(messageRequest);
        this.postProcessAttachments(messageKey, signalAttachments);
        ChannelRecord channelRecord = (ChannelRecord)this.sqliteStorageBean.getChannelData().findByKey((EntityKey)channelKey);
        if (timestamp > channelRecord.lastRead()) {
            this.sqliteStorageBean.getChannelData().updateLastRead(channelKey, timestamp);
        }
        if (quotedMessageKey != null) {
            this.waveManager.storeQuoteInfo(messageKey, quotedMessageKey, message.getQuote());
        }
        MessageDbRecord dbRecord = (MessageDbRecord)this.sqliteStorageBean.getMessageData().findByKey((EntityKey)messageKey);
        LOG.info("Informing client about stored message");
        this.waveClient.gotMessageRecord(this.waveManager.getMessageRecordFromDb(dbRecord));
        if (origTimestamp > 0L) {
            throw new RuntimeException("NYI");
        }
        sentTimestamp = this.sendSignalMessage(serviceId, message, dbRecord);
        return sentTimestamp;
    }

    public long sendGroupMessage(RecipientKey groupRecipientKey, Message waveMessage, long timestamp, List<Attachment> attachment, SignalServiceGroupV2 groupContext) throws IOException, InvalidCertificateException, InvalidInputException, UntrustedIdentityException, NoSessionException, org.signal.libsignal.protocol.InvalidKeyException, InvalidRegistrationIdException {
        LOG.info("Start sending groupMessage");
        InsertMessageRequest messageRequest = new InsertMessageRequest();
        messageRequest.setTimestamp(timestamp);
        messageRequest.setContent(waveMessage.getContent());
        messageRequest.setBodyRanges(waveMessage.getBodyRanges());
        waveMessage.timestamp(timestamp);
        long origTimestamp = waveMessage.getOrigTimestamp();
        String text = waveMessage.getContent();
        waveMessage.senderKey(this.waveManager.getAccount().getUser().key());
        waveMessage.receiverKey(groupRecipientKey);
        messageRequest.setSenderKey(waveMessage.getSenderKey());
        messageRequest.setReceiverKey(groupRecipientKey);
        this.waveManager.handleEditedMessage(waveMessage.getOrigTimestamp(), this.waveManager.getAccount().getUser().recipient().key(), messageRequest);
        ChannelKey channelKey = this.sqliteStorageBean.getChannelData().findByRecipientKey(groupRecipientKey);
        GroupRecord mygroup = this.sqliteStorageBean.getGroupData().getGroupByRecipientKey(groupRecipientKey);
        int exp = mygroup.disappearingTimer();
        LOG.finer("disappearingTimer in group = " + exp);
        messageRequest.setExpiration(exp);
        messageRequest.setExpireTimestamp(timestamp);
        waveMessage.setExpiration(exp);
        waveMessage.setExpireTimestamp(timestamp);
        LOG.info("Storing message in our db");
        MessageKey messageKey = this.sqliteStorageBean.getMessageData().insertMessage(messageRequest);
        MessageDbRecord messageRecord = (MessageDbRecord)this.sqliteStorageBean.getMessageData().findByKey((EntityKey)messageKey);
        ChannelRecord channelRecord = (ChannelRecord)this.sqliteStorageBean.getChannelData().findByKey((EntityKey)channelKey);
        if (timestamp > channelRecord.lastRead()) {
            this.sqliteStorageBean.getChannelData().updateLastRead(channelKey, messageRecord.dateSent());
        }
        LOG.info("send datamessage to group with recpientuuid " + String.valueOf(groupRecipientKey) + " and " + mygroup.members().size() + "senders and rev " + mygroup.revision());
        MessageKey quotedMessageKey = waveMessage.getQuotedMessageKey();
        if (quotedMessageKey != null) {
            // empty if block
        }
        this.waveClient.gotMessageRecord(this.waveManager.getMessageRecordFromDb(messageRecord));
        SignalServiceProtos.DataMessage message = this.messageToDataMessage(waveMessage, timestamp, mygroup, attachment);
        LOG.fine("origTimestamp = " + origTimestamp + ", mt = " + message.getTimestamp() + ", ts = " + timestamp);
        long sentTimestamp = this.sendSignalGroupMessage(message, mygroup, origTimestamp);
        LOG.info("Message is sent with timestamp " + sentTimestamp);
        if (sentTimestamp > 0L) {
            this.sqliteStorageBean.getMessageData().updateReceiptStatus(messageKey, ReceiptType.SENT, message.getTimestamp());
            this.waveClient.gotReceiptMessage(this.waveManager.getAccount().getUser().recipient().key(), groupRecipientKey, ReceiptType.SENT.getV(), List.of(Long.valueOf(timestamp)), sentTimestamp);
        }
        return message.getTimestamp();
    }

    protected SignalServiceProtos.DataMessage messageToDataMessage(Message message, long timestamp, GroupRecord mygroup, List<Attachment> attachment) throws IOException {
        return this.messageToDataMessageBuilder(message, timestamp, mygroup, attachment).build();
    }

    private SignalServiceProtos.DataMessage.Builder messageToDataMessageBuilder(Message message, long timestamp, GroupRecord mygroup, List<Attachment> attachment) throws IOException {
        SignalServiceProtos.DataMessage.Builder builder = SignalServiceProtos.DataMessage.newBuilder().setTimestamp(timestamp).setBody(message.getContent());
        if (mygroup != null) {
            builder.setGroupV2(SignalServiceProtos.GroupContextV2.newBuilder().setRevision(mygroup.revision()).setMasterKey(ByteString.copyFrom((byte[])mygroup.masterKeyBytes())));
            int exp = mygroup.disappearingTimer();
            if (exp > 0) {
                builder.setExpireTimer(exp);
            }
        }
        Map<SignalServiceAttachment, Path> signalAttachments = this.processSendingAttachments(builder, attachment);
        if (message.getBodyRanges() != null) {
            List<SignalServiceProtos.BodyRange> br = message.getBodyRanges().stream().map(bodyRange -> this.createBodyRange((BodyRange)bodyRange)).toList();
            builder.addAllBodyRanges(br);
        }
        return builder;
    }

    private Map<SignalServiceAttachment, Path> processSendingAttachments(SignalServiceProtos.DataMessage.Builder builder, List<Attachment> attachment) throws IOException {
        Map<SignalServiceAttachment, Path> ssa = this.getUploadAttachmentsMap(attachment);
        builder.addAllAttachments(ssa.entrySet().stream().map(entry -> ((SignalServiceAttachment)entry.getKey()).asPointer().toAttachmentPointerBuilder().build()).toList());
        return ssa;
    }

    private void postProcessAttachments(MessageKey messageKey, Map<SignalServiceAttachment, Path> signalAttachments) throws IOException {
        if (signalAttachments != null) {
            for (Map.Entry<SignalServiceAttachment, Path> entry : signalAttachments.entrySet()) {
                SignalServiceAttachment att = entry.getKey();
                Path path = entry.getValue();
                String name = att.asPointer().getFileName().orElse("rnd" + UUID.randomUUID().toString());
                Path destinationDir = this.waveManager.SIGNAL_FX_ATTACHMENT_DIR.resolve(this.waveManager.getAccount().getUser().recipient().key().serialize());
                Files.createDirectories(destinationDir, new FileAttribute[0]);
                Path destinationPath = destinationDir.resolve(name);
                Files.copy(path, destinationPath, new CopyOption[0]);
                LOG.info("PATH = " + String.valueOf(path) + " and dest = " + String.valueOf(destinationPath));
                AttachmentKey attachmentKey = this.sqliteStorageBean.getAttachmentData().addAttachment(messageKey, att.asPointer().toAttachmentPointerBuilder().build(), destinationPath.toString());
            }
        }
    }

    protected boolean isReadReceiptsEnabled() {
        return this.waveManager.getAccount().getPreferences().readReceipts();
    }

    public void sendReadReceipt(List<Long> timestamps, ServiceId serviceId) throws IOException {
        LOG.info("Need to send read receipt to " + String.valueOf(serviceId) + " for " + String.valueOf(timestamps));
        if (!this.isReadReceiptsEnabled()) {
            LOG.info("We have read receipts disabled! Don't send them.");
            return;
        }
        Optional<UnidentifiedAccessPair> uap = Optional.empty();
        try {
            UserDbRecord user = this.sqliteStorageBean.getUserData().getUserForServiceId(serviceId);
            UserDbRecord self = this.sqliteStorageBean.getUserCache().getSelf();
            uap = Optional.of(UnidentifiedAccessUtil.getUnidentifiedAccessPair((UnidentifiedAccessMode)user.sealedSenderMode(), (byte[])user.profileKey(), (byte[])self.profileKey()));
        }
        catch (InvalidCertificateException | InvalidInputException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        SignalServiceAddress add = new SignalServiceAddress(serviceId);
        SignalServiceProtos.ReceiptMessage.Builder builder = SignalServiceProtos.ReceiptMessage.newBuilder().setType(SignalServiceProtos.ReceiptMessage.Type.READ);
        SignalServiceProtos.SyncMessage.Builder syncBuilder = SignalServiceProtos.SyncMessage.newBuilder();
        timestamps.forEach(t -> {
            builder.addTimestamp(t.longValue());
            syncBuilder.addRead(SignalServiceProtos.SyncMessage.Read.newBuilder().setTimestamp(t.longValue()).setSenderAci(serviceId.toServiceIdString()));
        });
        this.sender.sendReceipt(add, uap, builder.build(), syncBuilder.build(), false);
    }

    public long sendReaction(String emoji, MessageDbRecord messageRecord, boolean remove) throws IOException {
        ServiceId origAuthorId = this.userService.getUserByUserKey(messageRecord.senderKey()).getServiceId().get();
        long timestamp = messageRecord.dateSent();
        SignalServiceProtos.DataMessage.Reaction reaction = SignalServiceProtos.DataMessage.Reaction.newBuilder().setEmoji(emoji).setRemove(remove).setTargetAuthorAci(origAuthorId.toServiceIdString()).setTargetSentTimestamp(timestamp).build();
        RecipientRecord groupOrUser = (RecipientRecord)this.waveManager.getSqliteStorageBean().getRecipientData().findByKey((EntityKey)messageRecord.receiverKey());
        SignalServiceProtos.DataMessage.Builder builder = SignalServiceProtos.DataMessage.newBuilder().setReaction(reaction).setTimestamp(System.currentTimeMillis());
        if (groupOrUser.isGroup()) {
            GroupRecord groupRecord = this.waveManager.getSqliteStorageBean().getGroupData().getGroupByRecipientKey(groupOrUser.key());
            builder.setGroupV2(SignalServiceProtos.GroupContextV2.newBuilder().setMasterKey(ByteString.copyFrom((byte[])groupRecord.getMasterKey().serialize())));
            LOG.log(Level.INFO, "send groupreactionmessage to group with key " + String.valueOf(groupRecord.key()) + ", and timestamp " + timestamp);
            try {
                return this.sendSignalGroupMessage(builder.build(), groupRecord, 0L);
            }
            catch (Throwable t) {
                LOG.severe("Problem sending reaction to a group");
                throw new IOException(t);
            }
        }
        UserRecord userRecord = this.userService.getUserByRecipientKey(groupOrUser.key());
        LOG.log(Level.INFO, "send groupreactionmessage to user with aci " + String.valueOf(userRecord.aci()) + ", and timestamp " + timestamp);
        return this.sendSignalMessage(userRecord.getServiceId().get(), builder.build(), null);
    }

    public void sendCanvasMessage(CanvasDbRecord canvasRecord) throws IOException {
        SignalServiceProtos.DataMessage.CanvasMessage.Builder builder = SignalServiceProtos.DataMessage.CanvasMessage.newBuilder();
        SignalServiceProtos.DataMessage.CanvasMessage canvasMessage = builder.setContent(canvasRecord.body()).setIdentifier(canvasRecord.identifier()).setVersion(canvasRecord.version()).build();
        SignalServiceProtos.DataMessage.Builder messageBuilder = SignalServiceProtos.DataMessage.newBuilder().setCanvasMessage(canvasMessage);
        ChannelKey channelKey = canvasRecord.channelKey();
        ChannelRecord channelRecord = (ChannelRecord)this.sqliteStorageBean.getChannelData().findByKey((EntityKey)channelKey);
        RecipientRecord recipient = channelRecord.recipient();
        LOG.info("will send canvas msg to " + String.valueOf(recipient) + " with channelkey = " + String.valueOf(channelKey));
        if (recipient.isGroup()) {
            GroupRecord groupRecord = this.sqliteStorageBean.getGroupData().getGroupByRecipientKey(recipient.key());
            messageBuilder.setGroupV2(SignalServiceProtos.GroupContextV2.newBuilder().setMasterKey(ByteString.copyFrom((byte[])groupRecord.masterKeyBytes())));
            try {
                this.sendSignalGroupMessage(messageBuilder.build(), groupRecord, 0L);
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        } else {
            UserDbRecord userRecord = this.sqliteStorageBean.getUserData().findByRecipientKey(recipient.key());
            this.sendSignalMessage((ServiceId)userRecord.getServiceId().get(), messageBuilder.build(), null);
        }
    }

    public void sendCallMessage(UserRecord recipient, SignalServiceProtos.CallMessage message) {
        ServiceId serviceId = recipient.getServiceId().get();
        Optional<UnidentifiedAccessPair> uap = Optional.empty();
        if (!this.waveManager.getAccount().getUser().aci().toServiceIdString().equals(serviceId.toString())) {
            try {
                uap = Optional.of(UnidentifiedAccessUtil.getUnidentifiedAccessPair((UnidentifiedAccessMode)recipient.sealedSenderMode(), (byte[])recipient.profileKey(), (byte[])this.waveManager.getAccount().getUser().profileKey()));
            }
            catch (InvalidCertificateException | InvalidInputException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
        SignalServiceAddress ssa = new SignalServiceAddress(serviceId);
        LOG.info("Sending call message to " + String.valueOf(ssa) + " and uap = " + String.valueOf(uap));
        try {
            this.sender.sendCallMessage(ssa, uap, message);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (UntrustedIdentityException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public SignalServiceProtos.BodyRange createBodyRange(BodyRange orig) {
        SignalServiceProtos.BodyRange.Builder builder = SignalServiceProtos.BodyRange.newBuilder().setStart(orig.start()).setLength(orig.length());
        if (orig.isStyled()) {
            switch (orig.style()) {
                case BOLD: {
                    builder.setStyle(SignalServiceProtos.BodyRange.Style.BOLD);
                    break;
                }
                case ITALIC: {
                    builder.setStyle(SignalServiceProtos.BodyRange.Style.ITALIC);
                    break;
                }
                case SPOILER: {
                    builder.setStyle(SignalServiceProtos.BodyRange.Style.SPOILER);
                    break;
                }
                case STRIKETHROUGH: {
                    builder.setStyle(SignalServiceProtos.BodyRange.Style.STRIKETHROUGH);
                    break;
                }
                case MONOSPACE: {
                    builder.setStyle(SignalServiceProtos.BodyRange.Style.MONOSPACE);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized style");
                }
            }
        }
        if (orig.isMention()) {
            builder.setMentionAci(orig.mentionAci());
        }
        return builder.build();
    }

    public SignalServiceProtos.DataMessage.Quote createQuote(MessageDbRecord quoteRecord) {
        UserKey senderKey = quoteRecord.senderKey();
        UserDbRecord senderRecord = (UserDbRecord)this.sqliteStorageBean.getUserData().findByKey((EntityKey)senderKey);
        long id = quoteRecord.dateSent();
        ServiceId author = (ServiceId)senderRecord.getServiceId().get();
        String text = quoteRecord.body();
        LinkedList<SignalServiceProtos.BodyRange> bodyRanges = new LinkedList<SignalServiceProtos.BodyRange>();
        for (BodyRange br : quoteRecord.bodyRanges()) {
            bodyRanges.add(this.createBodyRange(br));
        }
        return SignalServiceProtos.DataMessage.Quote.newBuilder().setId(id).setAuthorAci(author.toServiceIdString()).setText(text).addAllBodyRanges(bodyRanges).build();
    }

    public void processDataMessage(SignalServiceProtos.Envelope envelope, SignalServiceProtos.DataMessage message, UserDbRecord sender, RecipientRecord realDestination) {
        this.mcp.processDataMessage(envelope, message, sender, realDestination);
    }

    public void processDataMessage(SignalServiceProtos.Envelope envelope, SignalServiceProtos.DataMessage dataMessage, UserDbRecord sender, RecipientRecord realDestination, long targetSentTimestamp) {
        this.mcp.processDataMessage(envelope, dataMessage, sender, realDestination, targetSentTimestamp);
    }

    public void processStickerPackOperationMessage(List<SignalServiceProtos.SyncMessage.StickerPackOperation> msgs) {
        throw new RuntimeException();
    }

    private void dispatchUsers(Set<UserKey> userKeys, List<SignalServiceAddress> registered, List<SignalServiceAddress> unregistered, List<UnidentifiedAccess> registeredAccess, List<Optional<UnidentifiedAccessPair>> unregisteredAccess) {
        for (UserKey userKey : userKeys) {
            LOG.finer("consider " + String.valueOf(userKey));
            UserDbRecord user = (UserDbRecord)this.sqliteStorageBean.getUserData().findByKey((EntityKey)userKey);
            if (user == null) continue;
            try {
                SignalServiceAddress ssa = new SignalServiceAddress((ServiceId)user.getServiceId().get());
                UnidentifiedAccess unia = UnidentifiedAccessUtil.getUnidentifiedAccess((UnidentifiedAccessMode)user.sealedSenderMode(), (byte[])user.profileKey());
                if (unia != null) {
                    LOG.fine("adding address " + String.valueOf(userKey) + " and unia = " + String.valueOf(unia) + " with ssm = " + String.valueOf(user.sealedSenderMode()));
                    registered.add(ssa);
                    registeredAccess.add(unia);
                    continue;
                }
                unregistered.add(ssa);
                unregisteredAccess.add(Optional.empty());
            }
            catch (InvalidCertificateException | InvalidInputException ex) {
                LOG.log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
    }

    public RegistrationResponse registerAccount(String number, String token, String transport, WaveStore aciStore) {
        this.accountRegistration = new AccountRegistration(this.waveManager, this.sqliteStorageBean);
        return this.accountRegistration.registerAccount(number, token, transport, aciStore);
    }

    public RegistrationResponse confirmRegistrationCode(String code) {
        return this.accountRegistration.submitCode(code);
    }

    public void unlink() throws IOException {
        int myDevice = this.aciStore.getCredentialsProvider().getDeviceId();
        this.networkAPI.unlink(myDevice);
    }

    public void requestTransfer(Consumer<String> updates, byte[] ephemeral, ServiceId.Aci aci) {
        try {
            String transferUrl = this.networkAPI.requestTransfer(updates);
            Path destination = Files.createTempFile("backup", ".bck", new FileAttribute[0]);
            File gzip = destination.toFile();
            AttachmentUtil.storeAttachmentBackup(transferUrl, destination);
            LOG.info("Stored encrypted backup at " + String.valueOf(destination));
            LOG.info("Ephemeral key: " + Arrays.toString(ephemeral));
            BackupImporter backupImporter = new BackupImporter(this.sqliteStorageBean, ephemeral, aci);
            backupImporter.setMessageClient(this.waveClient);
            backupImporter.setEquation(this.waveManager);
            backupImporter.setUpdates(updates);
            backupImporter.importBackup(destination);
            LOG.info("Backup imported, now restore messagepipes");
            this.createMessagePipes();
            Optional<UserRecord> myUser = this.userService.getUserByAci(aci);
            LOG.info("My User = " + String.valueOf(myUser));
            if (this.waveClient != null) {
                myUser.ifPresent(user -> this.waveClient.updateUser((UserRecord)user));
            }
            LOG.info("Imported!!");
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public static InputStream getBackupInputStream(Path tmpPath, byte[] ephemeral, ServiceId.Aci aci) throws IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidInputException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        File tmp = tmpPath.toFile();
        RandomAccessFile raf = new RandomAccessFile(tmp, "r");
        raf.seek(tmp.length() - 32L);
        byte[] mac = new byte[32];
        raf.read(mac);
        File gzip = SignalBridge.copyFileWithoutMac(tmp);
        BackupKey backupKey = new BackupKey(ephemeral);
        LOG.info("Created backup key " + String.valueOf(backupKey));
        MessageBackupKey mbk = new MessageBackupKey(backupKey, backupKey.deriveBackupId(aci));
        byte[] calcmac = SignalBridge.getMacFromFile(gzip, mbk.getHmacKey());
        LOG.info("NEW: backupkey = " + Arrays.toString(backupKey.serialize()));
        LOG.info("NEW: mackey = " + Arrays.toString(mbk.getHmacKey()));
        LOG.info("NEW: aeskey = " + Arrays.toString(mbk.getAesKey()));
        LOG.info("OLD: mac = " + Arrays.toString(mac));
        LOG.info("OLD: calcmac = " + Arrays.toString(calcmac));
        if (!Arrays.equals(mac, calcmac)) {
            LOG.info("Mac is not ok");
            throw new IllegalArgumentException("Backup in wrong format, mac doesn't match");
        }
        LOG.info("Mac is ok");
        InputStream cis = SignalBridge.getCipherInputStream(gzip, mbk.getAesKey());
        GZIPInputStream gis = new GZIPInputStream(cis);
        System.err.println("GIS = " + String.valueOf(gis));
        return gis;
    }

    static File copyFileWithoutMac(File orig) throws IOException {
        Path targetPath = Files.createTempFile("backup", ".nomac", new FileAttribute[0]);
        File answer = targetPath.toFile();
        try (RandomAccessFile macFile = new RandomAccessFile(orig, "r");
             FileOutputStream newFile = new FileOutputStream(answer);){
            int read;
            long origSize = macFile.length();
            long targetSize = origSize - 32L;
            macFile.seek(0L);
            byte[] buffer = new byte[4096];
            for (long left = targetSize; left > 0L && (read = macFile.read(buffer, 0, (int)Math.min((long)buffer.length, left))) != -1; left -= (long)read) {
                newFile.write(buffer, 0, read);
            }
        }
        return answer;
    }

    static byte[] getMacFromFile(File f, byte[] mackey) throws NoSuchAlgorithmException, IOException, InvalidKeyException {
        try (FileInputStream fis = new FileInputStream(f);){
            int read;
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(mackey, "HmacSHA256"));
            byte[] buff = new byte[4096];
            while ((read = fis.read(buff)) != -1) {
                mac.update(buff, 0, read);
            }
            byte[] byArray = mac.doFinal();
            return byArray;
        }
    }

    public static InputStream getCipherInputStream(File encfile, byte[] aes) throws IOException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        FileInputStream is = new FileInputStream(encfile);
        byte[] iv = new byte[16];
        int read = is.read(iv);
        if (read < 16) {
            System.err.println("NOT ENOUGH IV");
        }
        LOG.info("IV = " + Arrays.toString(iv));
        Cipher cipher = SignalBridge.createCipherFromKeyMaterial(aes, iv, true);
        return new CipherInputStream(is, cipher);
    }

    static Cipher createCipherFromKeyMaterial(byte[] aes, byte[] iv, boolean decrypt) throws NoSuchPaddingException, InvalidAlgorithmParameterException {
        try {
            SecretKeySpec spec = new SecretKeySpec(aes, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            int mode = decrypt ? 2 : 1;
            cipher.init(mode, (Key)spec, ivSpec);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException("Wrong key material, couldn't create cipher", ex);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Security.setProperty("crypto.policy", "unlimited");
        try {
            Path target = Files.createTempFile("wwg", ".jks", new FileAttribute[0]);
            InputStream res = EquationManager.class.getResourceAsStream("/wwg.jks");
            Files.copy(res, target, StandardCopyOption.REPLACE_EXISTING);
            System.setProperty("javax.net.ssl.trustStore", target.toString());
            System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
            target.toFile().deleteOnExit();
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public record BackupKeyMaterialType(byte[] macKey, byte[] aesKey) {
    }
}

