/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.proxy;

import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import io.privacyresearch.equation.proxy.HttpBridge;
import io.privacyresearch.equation.proxy.ServerConversion;
import io.privacyresearch.equation.proxystub.SignalRpcMessage;
import io.privacyresearch.equation.proxystub.SignalRpcReply;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SignalHttpBridge
implements HttpBridge {
    private static final Logger LOG = Logger.getLogger(SignalHttpBridge.class.getName());

    @Override
    public byte[] sendRequestToSignalServer(byte[] rawMessage) throws URISyntaxException, IOException, InterruptedException {
        SignalRpcMessage message = SignalRpcMessage.parseFrom(rawMessage);
        SignalRpcReply reply = SignalHttpBridge.sendRequestToSignalServer(message);
        return reply.toByteArray();
    }

    private static SignalRpcReply sendRequestToSignalServer(SignalRpcMessage message) throws URISyntaxException, IOException, InterruptedException {
        LOG.info("received rpc message with method " + message.getMethod() + " and url = " + message.getUrlfragment());
        ProtocolStringList rawHeaders = message.getHeaderList();
        String url = message.getUrlfragment();
        boolean needsProcessing = false;
        if (url.startsWith("x")) {
            url = url.substring(1);
            needsProcessing = true;
        }
        String method = message.getMethod();
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest.Builder builder = HttpRequest.newBuilder(new URI(url));
        if ("PUT".equalsIgnoreCase(method)) {
            HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofByteArray(message.getBody().toByteArray());
            builder.method("PUT", bodyPublisher);
        }
        if ("GET".equalsIgnoreCase(method)) {
            builder.GET();
        }
        if ("POST".equalsIgnoreCase(method)) {
            builder.POST(HttpRequest.BodyPublishers.ofByteArray(message.getBody().toByteArray()));
        }
        if ("PATCH".equalsIgnoreCase(method)) {
            builder.method(method, HttpRequest.BodyPublishers.ofByteArray(message.getBody().toByteArray()));
        }
        rawHeaders.forEach(header -> {
            int sep = header.indexOf("=");
            String key = header.substring(0, sep);
            String val = header.substring(sep + 1);
            builder.header(key, val);
        });
        final HttpRequest request = builder.build();
        HttpResponse.BodyHandler mbh = new HttpResponse.BodyHandler(){

            public HttpResponse.BodySubscriber apply(HttpResponse.ResponseInfo responseInfo) {
                String ct = responseInfo.headers().firstValue("content-type").orElse("");
                LOG.info("response statuscode = " + responseInfo.statusCode() + ", content-type = " + ct);
                if (responseInfo.statusCode() == 428) {
                    LOG.info("Got 428 response! all headers = " + String.valueOf(responseInfo.headers().map()));
                }
                if (ct.isBlank() && !request.uri().getHost().contains("cdn")) {
                    LOG.info("Discard response");
                    return HttpResponse.BodySubscribers.discarding();
                }
                if (ct.equals("application/json") || ct.equals("application/xml")) {
                    return HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8);
                }
                return HttpResponse.BodySubscribers.ofByteArray();
            }
        };
        HttpResponse response = httpClient.send(request, mbh);
        LOG.info("Got response: " + response.statusCode());
        if (response.statusCode() != 200) {
            LOG.info("Got responsebody " + String.valueOf(response.body()));
        }
        byte[] rawBody = new byte[]{};
        if (response.body() != null) {
            Object t = response.body();
            if (t instanceof byte[]) {
                byte[] rb = (byte[])t;
                rawBody = rb;
            } else {
                t = response.body();
                if (t instanceof String) {
                    String rs = (String)t;
                    rawBody = rs.getBytes();
                } else {
                    throw new IOException("Unsupported response type!");
                }
            }
        }
        if (needsProcessing) {
            rawBody = SignalHttpBridge.processXRequest(url, rawBody);
        }
        SignalRpcReply reply = SignalRpcReply.newBuilder().setMessage(ByteString.copyFrom((byte[])rawBody)).setStatuscode(response.statusCode()).build();
        return reply;
    }

    static byte[] processXRequest(String urls, byte[] raw) {
        try {
            URL url = new URL(urls);
            String path = url.getPath();
            int origLength = raw.length;
            byte[] answer = ServerConversion.process(path, raw);
            LOG.info("x-converted #bytes from " + origLength + " to " + answer.length);
            return answer;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
            ex.printStackTrace();
            return raw;
        }
    }
}

