/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.proxy;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Date;
import java.util.logging.Logger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class CertificateUtils {
    private static final Logger LOG = Logger.getLogger(CertificateUtils.class.getName());

    public static void generateCertificate(Path certPath, Path keyPath) throws Exception {
        X500Name issuer;
        LOG.info("Need to generate a certificate and store it at " + String.valueOf(certPath) + " and store a key at " + String.valueOf(keyPath));
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        certPath.getParent().toFile().mkdirs();
        CertificateUtils.writePrivateKey(keyPair.getPrivate(), keyPath);
        X500Name subject = issuer = new X500Name("CN=WaveProxy Certificate");
        BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
        Date notBefore = new Date();
        Date notAfter = new Date(System.currentTimeMillis() + 31536000000L);
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuer, serial, notBefore, notAfter, subject, keyPair.getPublic());
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").build(keyPair.getPrivate());
        X509Certificate certificate = new JcaX509CertificateConverter().getCertificate(builder.build(signer));
        CertificateUtils.writeCertificate(certificate, certPath);
    }

    public static void writePrivateKey(PrivateKey privateKey, Path path) throws IOException {
        byte[] privateKeyBytes = privateKey.getEncoded();
        String base64EncodedKey = Base64.getMimeEncoder(64, new byte[]{10}).encodeToString(privateKeyBytes);
        String pemKey = "-----BEGIN PRIVATE KEY-----\n" + base64EncodedKey + "\n-----END PRIVATE KEY-----";
        Files.writeString(path, (CharSequence)pemKey, new OpenOption[0]);
    }

    public static void writeCertificate(Certificate certificate, Path path) throws IOException, CertificateEncodingException {
        String base64Endcodedcert = "-----BEGIN CERTIFICATE-----\n" + Base64.getMimeEncoder(64, new byte[]{10}).encodeToString(certificate.getEncoded()) + "\n-----END CERTIFICATE-----";
        Files.writeString(path, (CharSequence)base64Endcodedcert, new OpenOption[0]);
    }
}

